/* mergesort.c generated by valac 0.9.8.14-51a7, the Vala compiler
 * generated from mergesort.vala, do not modify */

/* mergesort.vala
 *
 * Copyright (C) 2009  Didier Villevalois
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Will <tcosprojects@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <gee-internals.h>
#include <gobject/gvaluecollector.h>


#define GEE_TYPE_MERGE_SORT (gee_merge_sort_get_type ())
#define GEE_MERGE_SORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_MERGE_SORT, GeeMergeSort))
#define GEE_MERGE_SORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_MERGE_SORT, GeeMergeSortClass))
#define GEE_IS_MERGE_SORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_MERGE_SORT))
#define GEE_IS_MERGE_SORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_MERGE_SORT))
#define GEE_MERGE_SORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_MERGE_SORT, GeeMergeSortClass))

typedef struct _GeeMergeSort GeeMergeSort;
typedef struct _GeeMergeSortClass GeeMergeSortClass;
typedef struct _GeeMergeSortPrivate GeeMergeSortPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_destroy_func0(var) (((var == NULL) || (g_destroy_func == NULL)) ? NULL : (var = (g_destroy_func (var), NULL)))
#define _gee_merge_sort_unref0(var) ((var == NULL) ? NULL : (var = (gee_merge_sort_unref (var), NULL)))
typedef struct _GeeParamSpecMergeSort GeeParamSpecMergeSort;

struct _GeeMergeSort {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GeeMergeSortPrivate * priv;
};

struct _GeeMergeSortClass {
	GTypeClass parent_class;
	void (*finalize) (GeeMergeSort *self);
};

struct _GeeMergeSortPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GeeList* list_collection;
	gpointer* array;
	gint array_length1;
	gint _array_size_;
	gpointer* list;
	gint list_length1;
	gint _list_size_;
	gint index;
	gint size;
	GCompareFunc compare;
};

struct _GeeParamSpecMergeSort {
	GParamSpec parent_instance;
};


static gpointer gee_merge_sort_parent_class = NULL;

gpointer gee_merge_sort_ref (gpointer instance);
void gee_merge_sort_unref (gpointer instance);
GParamSpec* gee_param_spec_merge_sort (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gee_value_set_merge_sort (GValue* value, gpointer v_object);
void gee_value_take_merge_sort (GValue* value, gpointer v_object);
gpointer gee_value_get_merge_sort (const GValue* value);
GType gee_merge_sort_get_type (void) G_GNUC_CONST;
#define GEE_MERGE_SORT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_TYPE_MERGE_SORT, GeeMergeSortPrivate))
enum  {
	GEE_MERGE_SORT_DUMMY_PROPERTY
};
void gee_merge_sort_sort (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeList* list, GCompareFunc compare);
void gee_merge_sort_sort_arraylist (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeArrayList* list, GCompareFunc compare);
void gee_merge_sort_sort_list (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeList* list, GCompareFunc compare);
GeeMergeSort* gee_merge_sort_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
GeeMergeSort* gee_merge_sort_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
static void gee_merge_sort_do_sort (GeeMergeSort* self);
static void gee_merge_sort_merge_sort_aux (GeeMergeSort* self, gint left, gint right, gpointer* work_area, int work_area_length1);
static void gee_merge_sort_finalize (GeeMergeSort* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);



void gee_merge_sort_sort (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeList* list, GCompareFunc compare) {
	g_return_if_fail (list != NULL);
	if (GEE_IS_ARRAY_LIST (list)) {
		gee_merge_sort_sort_arraylist (g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func, GEE_ARRAY_LIST (list), compare);
	} else {
		gee_merge_sort_sort_list (g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func, list, compare);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void gee_merge_sort_sort_list (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeList* list, GCompareFunc compare) {
	GeeMergeSort* helper;
	GeeList* _tmp0_;
	gint _tmp1_;
	gpointer* _tmp2_;
	gpointer* _tmp3_;
	g_return_if_fail (list != NULL);
	helper = gee_merge_sort_new (g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func);
	helper->priv->list_collection = (_tmp0_ = _g_object_ref0 (list), _g_object_unref0 (helper->priv->list_collection), _tmp0_);
	helper->priv->array = (_tmp2_ = gee_collection_to_array ((GeeCollection*) list, &_tmp1_), helper->priv->array = (_vala_array_free (helper->priv->array, helper->priv->array_length1, (GDestroyNotify) g_destroy_func), NULL), helper->priv->array_length1 = _tmp1_, helper->priv->_array_size_ = helper->priv->array_length1, _tmp2_);
	helper->priv->list = (_tmp3_ = helper->priv->array, helper->priv->list_length1 = helper->priv->array_length1, helper->priv->_list_size_ = helper->priv->list_length1, _tmp3_);
	helper->priv->index = 0;
	helper->priv->size = gee_collection_get_size ((GeeCollection*) list);
	helper->priv->compare = compare;
	gee_merge_sort_do_sort (helper);
	gee_collection_clear ((GeeCollection*) list);
	{
		gpointer* item_collection;
		int item_collection_length1;
		int item_it;
		item_collection = helper->priv->array;
		item_collection_length1 = helper->priv->array_length1;
		for (item_it = 0; item_it < helper->priv->array_length1; item_it = item_it + 1) {
			gconstpointer _tmp4_;
			gpointer item;
			item = (_tmp4_ = item_collection[item_it], ((_tmp4_ == NULL) || (g_dup_func == NULL)) ? ((gpointer) _tmp4_) : g_dup_func ((gpointer) _tmp4_));
			{
				gee_collection_add ((GeeCollection*) list, item);
				_g_destroy_func0 (item);
			}
		}
	}
	_gee_merge_sort_unref0 (helper);
}


void gee_merge_sort_sort_arraylist (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeArrayList* list, GCompareFunc compare) {
	GeeMergeSort* helper;
	GeeList* _tmp0_;
	gpointer* _tmp1_;
	g_return_if_fail (list != NULL);
	helper = gee_merge_sort_new (g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func);
	helper->priv->list_collection = (_tmp0_ = _g_object_ref0 ((GeeList*) list), _g_object_unref0 (helper->priv->list_collection), _tmp0_);
	helper->priv->list = (_tmp1_ = list->_items, helper->priv->list_length1 = list->_items_length1, helper->priv->_list_size_ = helper->priv->list_length1, _tmp1_);
	helper->priv->index = 0;
	helper->priv->size = list->_size;
	helper->priv->compare = compare;
	gee_merge_sort_do_sort (helper);
	_gee_merge_sort_unref0 (helper);
}


static void gee_merge_sort_do_sort (GeeMergeSort* self) {
	gint work_area_length1;
	gint _work_area_size_;
	gpointer* _tmp0_;
	gpointer* work_area;
	g_return_if_fail (self != NULL);
	if (self->priv->size <= 1) {
		return;
	}
	work_area = (_tmp0_ = g_new0 (gpointer, self->priv->size), work_area_length1 = self->priv->size, _work_area_size_ = work_area_length1, _tmp0_);
	gee_merge_sort_merge_sort_aux (self, self->priv->index, self->priv->size, work_area, work_area_length1);
	work_area = (_vala_array_free (work_area, work_area_length1, (GDestroyNotify) self->priv->g_destroy_func), NULL);
}


static void gee_merge_sort_merge_sort_aux (GeeMergeSort* self, gint left, gint right, gpointer* work_area, int work_area_length1) {
	g_return_if_fail (self != NULL);
	if (right == (left + 1)) {
		return;
	} else {
		gint size;
		gint middle;
		gint lbegin;
		gint rbegin;
		size = right - left;
		middle = size / 2;
		lbegin = left;
		rbegin = left + middle;
		gee_merge_sort_merge_sort_aux (self, left, left + middle, work_area, work_area_length1);
		gee_merge_sort_merge_sort_aux (self, left + middle, right, work_area, work_area_length1);
		{
			gint i;
			i = 0;
			{
				gboolean _tmp0_;
				_tmp0_ = TRUE;
				while (TRUE) {
					gboolean _tmp1_ = FALSE;
					if (!_tmp0_) {
						i++;
					}
					_tmp0_ = FALSE;
					if (!(i < size)) {
						break;
					}
					if (lbegin < (left + middle)) {
						gboolean _tmp2_ = FALSE;
						if (rbegin == right) {
							_tmp2_ = TRUE;
						} else {
							_tmp2_ = self->priv->compare (self->priv->list[lbegin], self->priv->list[rbegin]) <= 0;
						}
						_tmp1_ = _tmp2_;
					} else {
						_tmp1_ = FALSE;
					}
					if (_tmp1_) {
						gconstpointer _tmp3_;
						gpointer _tmp4_;
						work_area[i] = (_tmp4_ = (_tmp3_ = self->priv->list[lbegin], ((_tmp3_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp3_) : self->priv->g_dup_func ((gpointer) _tmp3_)), ((work_area[i] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (work_area[i] = (self->priv->g_destroy_func (work_area[i]), NULL)), _tmp4_);
						lbegin++;
					} else {
						gconstpointer _tmp5_;
						gpointer _tmp6_;
						work_area[i] = (_tmp6_ = (_tmp5_ = self->priv->list[rbegin], ((_tmp5_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp5_) : self->priv->g_dup_func ((gpointer) _tmp5_)), ((work_area[i] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (work_area[i] = (self->priv->g_destroy_func (work_area[i]), NULL)), _tmp6_);
						rbegin++;
					}
				}
			}
		}
		{
			gint i;
			i = left;
			{
				gboolean _tmp7_;
				_tmp7_ = TRUE;
				while (TRUE) {
					gconstpointer _tmp8_;
					gpointer _tmp9_;
					if (!_tmp7_) {
						i++;
					}
					_tmp7_ = FALSE;
					if (!(i < right)) {
						break;
					}
					self->priv->list[i] = (_tmp9_ = (_tmp8_ = work_area[i - left], ((_tmp8_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp8_) : self->priv->g_dup_func ((gpointer) _tmp8_)), ((self->priv->list[i] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (self->priv->list[i] = (self->priv->g_destroy_func (self->priv->list[i]), NULL)), _tmp9_);
				}
			}
		}
	}
}


GeeMergeSort* gee_merge_sort_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func) {
	GeeMergeSort* self;
	self = (GeeMergeSort*) g_type_create_instance (object_type);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	return self;
}


GeeMergeSort* gee_merge_sort_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func) {
	return gee_merge_sort_construct (GEE_TYPE_MERGE_SORT, g_type, g_dup_func, g_destroy_func);
}


static void gee_value_merge_sort_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void gee_value_merge_sort_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		gee_merge_sort_unref (value->data[0].v_pointer);
	}
}


static void gee_value_merge_sort_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gee_merge_sort_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer gee_value_merge_sort_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* gee_value_merge_sort_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		GeeMergeSort* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gee_merge_sort_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* gee_value_merge_sort_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	GeeMergeSort** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gee_merge_sort_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* gee_param_spec_merge_sort (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	GeeParamSpecMergeSort* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GEE_TYPE_MERGE_SORT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer gee_value_get_merge_sort (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEE_TYPE_MERGE_SORT), NULL);
	return value->data[0].v_pointer;
}


void gee_value_set_merge_sort (GValue* value, gpointer v_object) {
	GeeMergeSort* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEE_TYPE_MERGE_SORT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GEE_TYPE_MERGE_SORT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gee_merge_sort_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gee_merge_sort_unref (old);
	}
}


void gee_value_take_merge_sort (GValue* value, gpointer v_object) {
	GeeMergeSort* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEE_TYPE_MERGE_SORT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GEE_TYPE_MERGE_SORT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gee_merge_sort_unref (old);
	}
}


static void gee_merge_sort_class_init (GeeMergeSortClass * klass) {
	gee_merge_sort_parent_class = g_type_class_peek_parent (klass);
	GEE_MERGE_SORT_CLASS (klass)->finalize = gee_merge_sort_finalize;
	g_type_class_add_private (klass, sizeof (GeeMergeSortPrivate));
}


static void gee_merge_sort_instance_init (GeeMergeSort * self) {
	self->priv = GEE_MERGE_SORT_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void gee_merge_sort_finalize (GeeMergeSort* obj) {
	GeeMergeSort * self;
	self = GEE_MERGE_SORT (obj);
	_g_object_unref0 (self->priv->list_collection);
	self->priv->array = (_vala_array_free (self->priv->array, self->priv->array_length1, (GDestroyNotify) self->priv->g_destroy_func), NULL);
}


GType gee_merge_sort_get_type (void) {
	static volatile gsize gee_merge_sort_type_id__volatile = 0;
	if (g_once_init_enter (&gee_merge_sort_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { gee_value_merge_sort_init, gee_value_merge_sort_free_value, gee_value_merge_sort_copy_value, gee_value_merge_sort_peek_pointer, "p", gee_value_merge_sort_collect_value, "p", gee_value_merge_sort_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GeeMergeSortClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_merge_sort_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeMergeSort), 0, (GInstanceInitFunc) gee_merge_sort_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType gee_merge_sort_type_id;
		gee_merge_sort_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GeeMergeSort", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&gee_merge_sort_type_id__volatile, gee_merge_sort_type_id);
	}
	return gee_merge_sort_type_id__volatile;
}


gpointer gee_merge_sort_ref (gpointer instance) {
	GeeMergeSort* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void gee_merge_sort_unref (gpointer instance) {
	GeeMergeSort* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GEE_MERGE_SORT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}




