/* linkedlist.c generated by valac 0.10.0, the Vala compiler
 * generated from linkedlist.vala, do not modify */

/* linkedlist.vala
 *
 * Copyright (C) 2004-2005  Novell, Inc
 * Copyright (C) 2005  David Waite
 * Copyright (C) 2007-2008  Jürg Billeter
 * Copyright (C) 2009  Mark Lee, Didier Villevalois
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Mark Lee <marklee@src.gnome.org>
 * 	Didier 'Ptitjes Villevalois <ptitjes@free.fr>
 */

#include <glib.h>
#include <glib-object.h>


#define GEE_TYPE_ITERABLE (gee_iterable_get_type ())
#define GEE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERABLE, GeeIterable))
#define GEE_IS_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERABLE))
#define GEE_ITERABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERABLE, GeeIterableIface))

typedef struct _GeeIterable GeeIterable;
typedef struct _GeeIterableIface GeeIterableIface;

#define GEE_TYPE_ITERATOR (gee_iterator_get_type ())
#define GEE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERATOR, GeeIterator))
#define GEE_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERATOR))
#define GEE_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERATOR, GeeIteratorIface))

typedef struct _GeeIterator GeeIterator;
typedef struct _GeeIteratorIface GeeIteratorIface;

#define GEE_TYPE_COLLECTION (gee_collection_get_type ())
#define GEE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_COLLECTION, GeeCollection))
#define GEE_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_COLLECTION))
#define GEE_COLLECTION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_COLLECTION, GeeCollectionIface))

typedef struct _GeeCollection GeeCollection;
typedef struct _GeeCollectionIface GeeCollectionIface;

#define GEE_TYPE_ABSTRACT_COLLECTION (gee_abstract_collection_get_type ())
#define GEE_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection))
#define GEE_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))
#define GEE_IS_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_IS_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_ABSTRACT_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))

typedef struct _GeeAbstractCollection GeeAbstractCollection;
typedef struct _GeeAbstractCollectionClass GeeAbstractCollectionClass;
typedef struct _GeeAbstractCollectionPrivate GeeAbstractCollectionPrivate;

#define GEE_TYPE_LIST (gee_list_get_type ())
#define GEE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_LIST, GeeList))
#define GEE_IS_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_LIST))
#define GEE_LIST_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_LIST, GeeListIface))

typedef struct _GeeList GeeList;
typedef struct _GeeListIface GeeListIface;

#define GEE_TYPE_BIDIR_ITERATOR (gee_bidir_iterator_get_type ())
#define GEE_BIDIR_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_BIDIR_ITERATOR, GeeBidirIterator))
#define GEE_IS_BIDIR_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_BIDIR_ITERATOR))
#define GEE_BIDIR_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_BIDIR_ITERATOR, GeeBidirIteratorIface))

typedef struct _GeeBidirIterator GeeBidirIterator;
typedef struct _GeeBidirIteratorIface GeeBidirIteratorIface;

#define GEE_TYPE_LIST_ITERATOR (gee_list_iterator_get_type ())
#define GEE_LIST_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_LIST_ITERATOR, GeeListIterator))
#define GEE_IS_LIST_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_LIST_ITERATOR))
#define GEE_LIST_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_LIST_ITERATOR, GeeListIteratorIface))

typedef struct _GeeListIterator GeeListIterator;
typedef struct _GeeListIteratorIface GeeListIteratorIface;

#define GEE_TYPE_ABSTRACT_LIST (gee_abstract_list_get_type ())
#define GEE_ABSTRACT_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_LIST, GeeAbstractList))
#define GEE_ABSTRACT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_LIST, GeeAbstractListClass))
#define GEE_IS_ABSTRACT_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_LIST))
#define GEE_IS_ABSTRACT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_LIST))
#define GEE_ABSTRACT_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_LIST, GeeAbstractListClass))

typedef struct _GeeAbstractList GeeAbstractList;
typedef struct _GeeAbstractListClass GeeAbstractListClass;
typedef struct _GeeAbstractListPrivate GeeAbstractListPrivate;

#define GEE_TYPE_QUEUE (gee_queue_get_type ())
#define GEE_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_QUEUE, GeeQueue))
#define GEE_IS_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_QUEUE))
#define GEE_QUEUE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_QUEUE, GeeQueueIface))

typedef struct _GeeQueue GeeQueue;
typedef struct _GeeQueueIface GeeQueueIface;

#define GEE_TYPE_DEQUE (gee_deque_get_type ())
#define GEE_DEQUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_DEQUE, GeeDeque))
#define GEE_IS_DEQUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_DEQUE))
#define GEE_DEQUE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_DEQUE, GeeDequeIface))

typedef struct _GeeDeque GeeDeque;
typedef struct _GeeDequeIface GeeDequeIface;

#define GEE_TYPE_LINKED_LIST (gee_linked_list_get_type ())
#define GEE_LINKED_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_LINKED_LIST, GeeLinkedList))
#define GEE_LINKED_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_LINKED_LIST, GeeLinkedListClass))
#define GEE_IS_LINKED_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_LINKED_LIST))
#define GEE_IS_LINKED_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_LINKED_LIST))
#define GEE_LINKED_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_LINKED_LIST, GeeLinkedListClass))

typedef struct _GeeLinkedList GeeLinkedList;
typedef struct _GeeLinkedListClass GeeLinkedListClass;
typedef struct _GeeLinkedListPrivate GeeLinkedListPrivate;
typedef struct _GeeLinkedListNode GeeLinkedListNode;
#define _gee_linked_list_node_free0(var) ((var == NULL) ? NULL : (var = (gee_linked_list_node_free (var), NULL)))

#define GEE_LINKED_LIST_TYPE_ITERATOR (gee_linked_list_iterator_get_type ())
#define GEE_LINKED_LIST_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_LINKED_LIST_TYPE_ITERATOR, GeeLinkedListIterator))
#define GEE_LINKED_LIST_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_LINKED_LIST_TYPE_ITERATOR, GeeLinkedListIteratorClass))
#define GEE_LINKED_LIST_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_LINKED_LIST_TYPE_ITERATOR))
#define GEE_LINKED_LIST_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_LINKED_LIST_TYPE_ITERATOR))
#define GEE_LINKED_LIST_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_LINKED_LIST_TYPE_ITERATOR, GeeLinkedListIteratorClass))

typedef struct _GeeLinkedListIterator GeeLinkedListIterator;
typedef struct _GeeLinkedListIteratorClass GeeLinkedListIteratorClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _GeeLinkedListIteratorPrivate GeeLinkedListIteratorPrivate;

struct _GeeIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (GeeIterator* self);
	gboolean (*has_next) (GeeIterator* self);
	gboolean (*first) (GeeIterator* self);
	gpointer (*get) (GeeIterator* self);
	void (*remove) (GeeIterator* self);
};

struct _GeeIterableIface {
	GTypeInterface parent_iface;
	GeeIterator* (*iterator) (GeeIterable* self);
	GType (*get_element_type) (GeeIterable* self);
};

struct _GeeCollectionIface {
	GTypeInterface parent_iface;
	gboolean (*contains) (GeeCollection* self, gconstpointer item);
	gboolean (*add) (GeeCollection* self, gconstpointer item);
	gboolean (*remove) (GeeCollection* self, gconstpointer item);
	void (*clear) (GeeCollection* self);
	gboolean (*add_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeCollection* self, GeeCollection* collection);
	gpointer* (*to_array) (GeeCollection* self, int* result_length1);
	gint (*get_size) (GeeCollection* self);
	gboolean (*get_is_empty) (GeeCollection* self);
	GeeCollection* (*get_read_only_view) (GeeCollection* self);
};

struct _GeeAbstractCollection {
	GObject parent_instance;
	GeeAbstractCollectionPrivate * priv;
};

struct _GeeAbstractCollectionClass {
	GObjectClass parent_class;
	gboolean (*contains) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*add) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*remove) (GeeAbstractCollection* self, gconstpointer item);
	void (*clear) (GeeAbstractCollection* self);
	gpointer* (*to_array) (GeeAbstractCollection* self, int* result_length1);
	gboolean (*add_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeAbstractCollection* self, GeeCollection* collection);
	GeeIterator* (*iterator) (GeeAbstractCollection* self);
	gint (*get_size) (GeeAbstractCollection* self);
	gboolean (*get_is_empty) (GeeAbstractCollection* self);
	GeeCollection* (*get_read_only_view) (GeeAbstractCollection* self);
};

struct _GeeBidirIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*previous) (GeeBidirIterator* self);
	gboolean (*has_previous) (GeeBidirIterator* self);
	gboolean (*last) (GeeBidirIterator* self);
};

struct _GeeListIteratorIface {
	GTypeInterface parent_iface;
	void (*set) (GeeListIterator* self, gconstpointer item);
	void (*insert) (GeeListIterator* self, gconstpointer item);
	void (*add) (GeeListIterator* self, gconstpointer item);
	gint (*index) (GeeListIterator* self);
};

struct _GeeListIface {
	GTypeInterface parent_iface;
	GeeListIterator* (*list_iterator) (GeeList* self);
	gpointer (*get) (GeeList* self, gint index);
	void (*set) (GeeList* self, gint index, gconstpointer item);
	gint (*index_of) (GeeList* self, gconstpointer item);
	void (*insert) (GeeList* self, gint index, gconstpointer item);
	gpointer (*remove_at) (GeeList* self, gint index);
	GeeList* (*slice) (GeeList* self, gint start, gint stop);
	gpointer (*first) (GeeList* self);
	gpointer (*last) (GeeList* self);
	void (*insert_all) (GeeList* self, gint index, GeeCollection* collection);
	void (*sort) (GeeList* self, GCompareFunc compare_func);
	GeeList* (*get_read_only_view) (GeeList* self);
};

struct _GeeAbstractList {
	GeeAbstractCollection parent_instance;
	GeeAbstractListPrivate * priv;
};

struct _GeeAbstractListClass {
	GeeAbstractCollectionClass parent_class;
	GeeListIterator* (*list_iterator) (GeeAbstractList* self);
	gpointer (*get) (GeeAbstractList* self, gint index);
	void (*set) (GeeAbstractList* self, gint index, gconstpointer item);
	gint (*index_of) (GeeAbstractList* self, gconstpointer item);
	void (*insert) (GeeAbstractList* self, gint index, gconstpointer item);
	gpointer (*remove_at) (GeeAbstractList* self, gint index);
	GeeList* (*slice) (GeeAbstractList* self, gint start, gint stop);
	gpointer (*first) (GeeAbstractList* self);
	gpointer (*last) (GeeAbstractList* self);
	void (*insert_all) (GeeAbstractList* self, gint index, GeeCollection* collection);
	GeeList* (*get_read_only_view) (GeeAbstractList* self);
};

struct _GeeQueueIface {
	GTypeInterface parent_iface;
	gboolean (*offer) (GeeQueue* self, gconstpointer element);
	gpointer (*peek) (GeeQueue* self);
	gpointer (*poll) (GeeQueue* self);
	gint (*drain) (GeeQueue* self, GeeCollection* recipient, gint amount);
	gint (*get_capacity) (GeeQueue* self);
	gint (*get_remaining_capacity) (GeeQueue* self);
	gboolean (*get_is_full) (GeeQueue* self);
};

struct _GeeDequeIface {
	GTypeInterface parent_iface;
	gboolean (*offer_head) (GeeDeque* self, gconstpointer element);
	gpointer (*peek_head) (GeeDeque* self);
	gpointer (*poll_head) (GeeDeque* self);
	gint (*drain_head) (GeeDeque* self, GeeCollection* recipient, gint amount);
	gboolean (*offer_tail) (GeeDeque* self, gconstpointer element);
	gpointer (*peek_tail) (GeeDeque* self);
	gpointer (*poll_tail) (GeeDeque* self);
	gint (*drain_tail) (GeeDeque* self, GeeCollection* recipient, gint amount);
};

struct _GeeLinkedList {
	GeeAbstractList parent_instance;
	GeeLinkedListPrivate * priv;
};

struct _GeeLinkedListClass {
	GeeAbstractListClass parent_class;
};

struct _GeeLinkedListPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	gint _size;
	gint _stamp;
	GeeLinkedListNode* _head;
	GeeLinkedListNode* _tail;
	GEqualFunc _equal_func;
};

struct _GeeLinkedListNode {
	gpointer data;
	GeeLinkedListNode* prev;
	GeeLinkedListNode* next;
};

struct _GeeLinkedListIterator {
	GObject parent_instance;
	GeeLinkedListIteratorPrivate * priv;
};

struct _GeeLinkedListIteratorClass {
	GObjectClass parent_class;
};

struct _GeeLinkedListIteratorPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	gboolean started;
	gboolean removed;
	GeeLinkedListNode* position;
	gint _stamp;
	GeeLinkedList* _list;
	gint _index;
};


static gpointer gee_linked_list_iterator_parent_class = NULL;
static GeeIteratorIface* gee_linked_list_iterator_gee_iterator_parent_iface = NULL;
static GeeBidirIteratorIface* gee_linked_list_iterator_gee_bidir_iterator_parent_iface = NULL;
static GeeListIteratorIface* gee_linked_list_iterator_gee_list_iterator_parent_iface = NULL;
static gpointer gee_linked_list_parent_class = NULL;
static GeeQueueIface* gee_linked_list_gee_queue_parent_iface = NULL;
static GeeDequeIface* gee_linked_list_gee_deque_parent_iface = NULL;

GType gee_iterator_get_type (void) G_GNUC_CONST;
GType gee_iterable_get_type (void) G_GNUC_CONST;
GType gee_collection_get_type (void) G_GNUC_CONST;
GType gee_abstract_collection_get_type (void) G_GNUC_CONST;
GType gee_bidir_iterator_get_type (void) G_GNUC_CONST;
GType gee_list_iterator_get_type (void) G_GNUC_CONST;
GType gee_list_get_type (void) G_GNUC_CONST;
GType gee_abstract_list_get_type (void) G_GNUC_CONST;
GType gee_queue_get_type (void) G_GNUC_CONST;
GType gee_deque_get_type (void) G_GNUC_CONST;
GType gee_linked_list_get_type (void) G_GNUC_CONST;
static void gee_linked_list_node_free (GeeLinkedListNode* self);
#define GEE_LINKED_LIST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_TYPE_LINKED_LIST, GeeLinkedListPrivate))
enum  {
	GEE_LINKED_LIST_DUMMY_PROPERTY,
	GEE_LINKED_LIST_EQUAL_FUNC,
	GEE_LINKED_LIST_SIZE,
	GEE_LINKED_LIST_CAPACITY,
	GEE_LINKED_LIST_REMAINING_CAPACITY,
	GEE_LINKED_LIST_IS_FULL,
	GEE_LINKED_LIST_G_TYPE,
	GEE_LINKED_LIST_G_DUP_FUNC,
	GEE_LINKED_LIST_G_DESTROY_FUNC
};
GeeLinkedList* gee_linked_list_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GEqualFunc equal_func);
GeeLinkedList* gee_linked_list_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GEqualFunc equal_func);
GeeAbstractList* gee_abstract_list_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
GEqualFunc gee_functions_get_equal_func_for (GType t);
static void gee_linked_list_set_equal_func (GeeLinkedList* self, GEqualFunc value);
static GeeIterator* gee_linked_list_real_iterator (GeeAbstractCollection* base);
static GeeLinkedListIterator* gee_linked_list_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeLinkedList* list);
static GeeLinkedListIterator* gee_linked_list_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeLinkedList* list);
static GType gee_linked_list_iterator_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GeeListIterator* gee_linked_list_real_list_iterator (GeeAbstractList* base);
static gboolean gee_linked_list_real_contains (GeeAbstractCollection* base, gconstpointer item);
gint gee_abstract_list_index_of (GeeAbstractList* self, gconstpointer item);
static gboolean gee_linked_list_real_add (GeeAbstractCollection* base, gconstpointer item);
static GeeLinkedListNode* gee_linked_list_node_new (gpointer data);
static GeeLinkedListNode* gee_linked_list_node_new (gpointer data);
static gboolean gee_linked_list_real_remove (GeeAbstractCollection* base, gconstpointer item);
GEqualFunc gee_linked_list_get_equal_func (GeeLinkedList* self);
static void _gee_linked_list_remove_node (GeeLinkedList* self, GeeLinkedListNode* _n);
static void gee_linked_list_real_clear (GeeAbstractCollection* base);
static gpointer gee_linked_list_real_get (GeeAbstractList* base, gint index);
static GeeLinkedListNode* _gee_linked_list_get_node_at (GeeLinkedList* self, gint index);
static void gee_linked_list_real_set (GeeAbstractList* base, gint index, gconstpointer item);
static gint gee_linked_list_real_index_of (GeeAbstractList* base, gconstpointer item);
GeeIterator* gee_abstract_collection_iterator (GeeAbstractCollection* self);
gboolean gee_iterator_next (GeeIterator* self);
gpointer gee_iterator_get (GeeIterator* self);
static void gee_linked_list_real_insert (GeeAbstractList* base, gint index, gconstpointer item);
gboolean gee_abstract_collection_add (GeeAbstractCollection* self, gconstpointer item);
static gpointer gee_linked_list_real_remove_at (GeeAbstractList* base, gint index);
static GeeList* gee_linked_list_real_slice (GeeAbstractList* base, gint start, gint stop);
gboolean gee_collection_add (GeeCollection* self, gconstpointer item);
static gpointer gee_linked_list_real_first (GeeAbstractList* base);
static gpointer gee_linked_list_real_last (GeeAbstractList* base);
static gboolean gee_linked_list_real_offer (GeeQueue* base, gconstpointer element);
gboolean gee_deque_offer_tail (GeeDeque* self, gconstpointer element);
static gpointer gee_linked_list_real_peek (GeeQueue* base);
gpointer gee_deque_peek_head (GeeDeque* self);
static gpointer gee_linked_list_real_poll (GeeQueue* base);
gpointer gee_deque_poll_head (GeeDeque* self);
static gint gee_linked_list_real_drain (GeeQueue* base, GeeCollection* recipient, gint amount);
gint gee_deque_drain_head (GeeDeque* self, GeeCollection* recipient, gint amount);
static gboolean gee_linked_list_real_offer_head (GeeDeque* base, gconstpointer element);
void gee_abstract_list_insert (GeeAbstractList* self, gint index, gconstpointer item);
static gpointer gee_linked_list_real_peek_head (GeeDeque* base);
gpointer gee_abstract_list_get (GeeAbstractList* self, gint index);
static gpointer gee_linked_list_real_poll_head (GeeDeque* base);
gpointer gee_abstract_list_remove_at (GeeAbstractList* self, gint index);
static gint gee_linked_list_real_drain_head (GeeDeque* base, GeeCollection* recipient, gint amount);
static gboolean gee_linked_list_real_offer_tail (GeeDeque* base, gconstpointer element);
static gpointer gee_linked_list_real_peek_tail (GeeDeque* base);
static gpointer gee_linked_list_real_poll_tail (GeeDeque* base);
static gint gee_linked_list_real_drain_tail (GeeDeque* base, GeeCollection* recipient, gint amount);
#define GEE_QUEUE_UNBOUNDED_CAPACITY (-1)
static void gee_linked_list_node_instance_init (GeeLinkedListNode * self);
#define GEE_LINKED_LIST_ITERATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_LINKED_LIST_TYPE_ITERATOR, GeeLinkedListIteratorPrivate))
enum  {
	GEE_LINKED_LIST_ITERATOR_DUMMY_PROPERTY,
	GEE_LINKED_LIST_ITERATOR_G_TYPE,
	GEE_LINKED_LIST_ITERATOR_G_DUP_FUNC,
	GEE_LINKED_LIST_ITERATOR_G_DESTROY_FUNC
};
static gboolean gee_linked_list_iterator_real_next (GeeIterator* base);
static gboolean gee_linked_list_iterator_real_has_next (GeeIterator* base);
static gboolean gee_linked_list_iterator_real_first (GeeIterator* base);
gint gee_abstract_collection_get_size (GeeAbstractCollection* self);
static gpointer gee_linked_list_iterator_real_get (GeeIterator* base);
static void gee_linked_list_iterator_real_remove (GeeIterator* base);
static gboolean gee_linked_list_iterator_real_previous (GeeBidirIterator* base);
static gboolean gee_linked_list_iterator_real_has_previous (GeeBidirIterator* base);
static gboolean gee_linked_list_iterator_real_last (GeeBidirIterator* base);
static void gee_linked_list_iterator_real_set (GeeListIterator* base, gconstpointer item);
static void gee_linked_list_iterator_real_insert (GeeListIterator* base, gconstpointer item);
static void gee_linked_list_iterator_real_add (GeeListIterator* base, gconstpointer item);
static gint gee_linked_list_iterator_real_index (GeeListIterator* base);
static void gee_linked_list_iterator_finalize (GObject* obj);
static void gee_linked_list_iterator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void gee_linked_list_iterator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void gee_linked_list_finalize (GObject* obj);
gint gee_queue_get_capacity (GeeQueue* self);
gint gee_queue_get_remaining_capacity (GeeQueue* self);
gboolean gee_queue_get_is_full (GeeQueue* self);
static void gee_linked_list_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void gee_linked_list_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



/**
 * Constructs a new, empty linked list.
 *
 * If not provided, the function parameter is requested to the
 * {@link Functions} function factory methods.
 *
 * @param equal_func an optional element equality testing function
 */
GeeLinkedList* gee_linked_list_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GEqualFunc equal_func) {
	GeeLinkedList * self;
	self = (GeeLinkedList*) gee_abstract_list_construct (object_type, g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	if (equal_func == NULL) {
		equal_func = gee_functions_get_equal_func_for (g_type);
	}
	gee_linked_list_set_equal_func (self, equal_func);
	return self;
}


GeeLinkedList* gee_linked_list_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GEqualFunc equal_func) {
	return gee_linked_list_construct (GEE_TYPE_LINKED_LIST, g_type, g_dup_func, g_destroy_func, equal_func);
}


/**
 * {@inheritDoc}
 */
static GeeIterator* gee_linked_list_real_iterator (GeeAbstractCollection* base) {
	GeeLinkedList * self;
	GeeIterator* result = NULL;
	self = (GeeLinkedList*) base;
	result = (GeeIterator*) gee_linked_list_iterator_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self);
	return result;
}


/**
 * {@inheritDoc}
 */
static GeeListIterator* gee_linked_list_real_list_iterator (GeeAbstractList* base) {
	GeeLinkedList * self;
	GeeListIterator* result = NULL;
	self = (GeeLinkedList*) base;
	result = (GeeListIterator*) gee_linked_list_iterator_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self);
	return result;
}


/**
 * {@inheritDoc}
 */
static gboolean gee_linked_list_real_contains (GeeAbstractCollection* base, gconstpointer item) {
	GeeLinkedList * self;
	gboolean result = FALSE;
	self = (GeeLinkedList*) base;
	result = gee_abstract_list_index_of ((GeeAbstractList*) self, item) != (-1);
	return result;
}


/**
 * {@inheritDoc}
 */
static gboolean gee_linked_list_real_add (GeeAbstractCollection* base, gconstpointer item) {
	GeeLinkedList * self;
	gboolean result = FALSE;
	gconstpointer _tmp0_;
	GeeLinkedListNode* n;
	gboolean _tmp1_ = FALSE;
	self = (GeeLinkedList*) base;
	n = gee_linked_list_node_new ((_tmp0_ = item, ((_tmp0_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp0_) : self->priv->g_dup_func ((gpointer) _tmp0_)));
	if (self->priv->_head == NULL) {
		_tmp1_ = self->priv->_tail == NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GeeLinkedListNode* _tmp2_;
		GeeLinkedListNode* _tmp3_;
		self->priv->_tail = n;
		self->priv->_head = (_tmp3_ = (_tmp2_ = n, n = NULL, _tmp2_), _gee_linked_list_node_free0 (self->priv->_head), _tmp3_);
	} else {
		GeeLinkedListNode* _tmp4_;
		GeeLinkedListNode* _tmp5_;
		n->prev = self->priv->_tail;
		self->priv->_tail->next = (_tmp5_ = (_tmp4_ = n, n = NULL, _tmp4_), _gee_linked_list_node_free0 (self->priv->_tail->next), _tmp5_);
		self->priv->_tail = self->priv->_tail->next;
	}
	self->priv->_size++;
	result = TRUE;
	_gee_linked_list_node_free0 (n);
	return result;
}


/**
 * {@inheritDoc}
 */
static gboolean gee_linked_list_real_remove (GeeAbstractCollection* base, gconstpointer item) {
	GeeLinkedList * self;
	gboolean result = FALSE;
	self = (GeeLinkedList*) base;
	{
		GeeLinkedListNode* n;
		n = self->priv->_head;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					n = n->next;
				}
				_tmp0_ = FALSE;
				if (!(n != NULL)) {
					break;
				}
				if (gee_linked_list_get_equal_func (self) (item, n->data)) {
					_gee_linked_list_remove_node (self, n);
					result = TRUE;
					return result;
				}
			}
		}
	}
	result = FALSE;
	return result;
}


/**
 * {@inheritDoc}
 */
static void gee_linked_list_real_clear (GeeAbstractCollection* base) {
	GeeLinkedList * self;
	GeeLinkedListNode* _tmp0_;
	self = (GeeLinkedList*) base;
	self->priv->_stamp = self->priv->_stamp + 1;
	self->priv->_head = (_tmp0_ = NULL, _gee_linked_list_node_free0 (self->priv->_head), _tmp0_);
	self->priv->_tail = NULL;
	self->priv->_size = 0;
}


/**
 * {@inheritDoc}
 */
static gpointer gee_linked_list_real_get (GeeAbstractList* base, gint index) {
	GeeLinkedList * self;
	gpointer result = NULL;
	GeeLinkedListNode* n;
	gconstpointer _tmp0_;
	self = (GeeLinkedList*) base;
	g_assert (index >= 0);
	g_assert (index < self->priv->_size);
	n = _gee_linked_list_get_node_at (self, index);
	g_assert (n != NULL);
	result = (_tmp0_ = n->data, ((_tmp0_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp0_) : self->priv->g_dup_func ((gpointer) _tmp0_));
	return result;
}


/**
 * {@inheritDoc}
 */
static void gee_linked_list_real_set (GeeAbstractList* base, gint index, gconstpointer item) {
	GeeLinkedList * self;
	GeeLinkedListNode* n;
	gconstpointer _tmp0_;
	gpointer _tmp1_;
	self = (GeeLinkedList*) base;
	g_assert (index >= 0);
	g_assert (index < self->priv->_size);
	n = _gee_linked_list_get_node_at (self, index);
	g_return_if_fail (n != NULL);
	n->data = (_tmp1_ = (_tmp0_ = item, ((_tmp0_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp0_) : self->priv->g_dup_func ((gpointer) _tmp0_)), ((n->data == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (n->data = (self->priv->g_destroy_func (n->data), NULL)), _tmp1_);
}


/**
 * {@inheritDoc}
 */
static gint gee_linked_list_real_index_of (GeeAbstractList* base, gconstpointer item) {
	GeeLinkedList * self;
	gint result = 0;
	gint _result_;
	gint idx;
	self = (GeeLinkedList*) base;
	_result_ = -1;
	idx = 0;
	{
		GeeIterator* _node_item_it;
		_node_item_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self);
		while (TRUE) {
			gpointer node_item;
			if (!gee_iterator_next (_node_item_it)) {
				break;
			}
			node_item = gee_iterator_get (_node_item_it);
			if (gee_linked_list_get_equal_func (self) (item, node_item)) {
				_result_ = idx;
				((node_item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (node_item = (self->priv->g_destroy_func (node_item), NULL));
				break;
			} else {
				idx++;
			}
			((node_item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (node_item = (self->priv->g_destroy_func (node_item), NULL));
		}
		_g_object_unref0 (_node_item_it);
	}
	result = _result_;
	return result;
}


/**
 * {@inheritDoc}
 */
static void gee_linked_list_real_insert (GeeAbstractList* base, gint index, gconstpointer item) {
	GeeLinkedList * self;
	self = (GeeLinkedList*) base;
	g_assert (index >= 0);
	g_assert (index <= self->priv->_size);
	if (index == self->priv->_size) {
		gee_abstract_collection_add ((GeeAbstractCollection*) self, item);
	} else {
		gconstpointer _tmp0_;
		GeeLinkedListNode* n;
		n = gee_linked_list_node_new ((_tmp0_ = item, ((_tmp0_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp0_) : self->priv->g_dup_func ((gpointer) _tmp0_)));
		if (index == 0) {
			GeeLinkedListNode* _tmp1_;
			GeeLinkedListNode* _tmp2_;
			GeeLinkedListNode* _tmp3_;
			GeeLinkedListNode* _tmp4_;
			n->next = (_tmp2_ = (_tmp1_ = self->priv->_head, self->priv->_head = NULL, _tmp1_), _gee_linked_list_node_free0 (n->next), _tmp2_);
			n->next->prev = n;
			self->priv->_head = (_tmp4_ = (_tmp3_ = n, n = NULL, _tmp3_), _gee_linked_list_node_free0 (self->priv->_head), _tmp4_);
		} else {
			GeeLinkedListNode* prev;
			GeeLinkedListNode* _tmp6_;
			GeeLinkedListNode* _tmp7_;
			GeeLinkedListNode* _tmp8_;
			GeeLinkedListNode* _tmp9_;
			prev = self->priv->_head;
			{
				gint i;
				i = 0;
				{
					gboolean _tmp5_;
					_tmp5_ = TRUE;
					while (TRUE) {
						if (!_tmp5_) {
							i++;
						}
						_tmp5_ = FALSE;
						if (!(i < (index - 1))) {
							break;
						}
						prev = prev->next;
					}
				}
			}
			n->prev = prev;
			n->next = (_tmp7_ = (_tmp6_ = prev->next, prev->next = NULL, _tmp6_), _gee_linked_list_node_free0 (n->next), _tmp7_);
			n->next->prev = n;
			prev->next = (_tmp9_ = (_tmp8_ = n, n = NULL, _tmp8_), _gee_linked_list_node_free0 (prev->next), _tmp9_);
		}
		self->priv->_size++;
		_gee_linked_list_node_free0 (n);
	}
}


/**
 * {@inheritDoc}
 */
static gpointer gee_linked_list_real_remove_at (GeeAbstractList* base, gint index) {
	GeeLinkedList * self;
	gpointer result = NULL;
	GeeLinkedListNode* n;
	gconstpointer _tmp0_;
	gpointer element;
	self = (GeeLinkedList*) base;
	g_assert (index >= 0);
	g_assert (index < self->priv->_size);
	n = _gee_linked_list_get_node_at (self, index);
	g_assert (n != NULL);
	element = (_tmp0_ = n->data, ((_tmp0_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp0_) : self->priv->g_dup_func ((gpointer) _tmp0_));
	_gee_linked_list_remove_node (self, n);
	result = element;
	return result;
}


/**
 * {@inheritDoc}
 */
static GeeList* gee_linked_list_real_slice (GeeAbstractList* base, gint start, gint stop) {
	GeeLinkedList * self;
	GeeList* result = NULL;
	GeeList* slice;
	GeeLinkedListNode* n;
	self = (GeeLinkedList*) base;
	g_return_val_if_fail (start <= stop, NULL);
	g_return_val_if_fail (start >= 0, NULL);
	g_return_val_if_fail (stop <= self->priv->_size, NULL);
	slice = (GeeList*) gee_linked_list_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, gee_linked_list_get_equal_func (self));
	n = _gee_linked_list_get_node_at (self, start);
	{
		gint i;
		i = start;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i < stop)) {
					break;
				}
				gee_collection_add ((GeeCollection*) slice, n->data);
				n = n->next;
			}
		}
	}
	result = slice;
	return result;
}


/**
 * {@inheritDoc}
 */
static gpointer gee_linked_list_real_first (GeeAbstractList* base) {
	GeeLinkedList * self;
	gpointer result = NULL;
	gconstpointer _tmp0_;
	self = (GeeLinkedList*) base;
	g_assert (self->priv->_size > 0);
	result = (_tmp0_ = self->priv->_head->data, ((_tmp0_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp0_) : self->priv->g_dup_func ((gpointer) _tmp0_));
	return result;
}


/**
 * {@inheritDoc}
 */
static gpointer gee_linked_list_real_last (GeeAbstractList* base) {
	GeeLinkedList * self;
	gpointer result = NULL;
	gconstpointer _tmp0_;
	self = (GeeLinkedList*) base;
	g_assert (self->priv->_size > 0);
	result = (_tmp0_ = self->priv->_tail->data, ((_tmp0_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp0_) : self->priv->g_dup_func ((gpointer) _tmp0_));
	return result;
}


/**
 * {@inheritDoc}
 */
static gboolean gee_linked_list_real_offer (GeeQueue* base, gconstpointer element) {
	GeeLinkedList * self;
	gboolean result = FALSE;
	self = (GeeLinkedList*) base;
	result = gee_deque_offer_tail ((GeeDeque*) self, element);
	return result;
}


/**
 * {@inheritDoc}
 */
static gpointer gee_linked_list_real_peek (GeeQueue* base) {
	GeeLinkedList * self;
	gpointer result = NULL;
	self = (GeeLinkedList*) base;
	result = gee_deque_peek_head ((GeeDeque*) self);
	return result;
}


/**
 * {@inheritDoc}
 */
static gpointer gee_linked_list_real_poll (GeeQueue* base) {
	GeeLinkedList * self;
	gpointer result = NULL;
	self = (GeeLinkedList*) base;
	result = gee_deque_poll_head ((GeeDeque*) self);
	return result;
}


/**
 * {@inheritDoc}
 */
static gint gee_linked_list_real_drain (GeeQueue* base, GeeCollection* recipient, gint amount) {
	GeeLinkedList * self;
	gint result = 0;
	self = (GeeLinkedList*) base;
	g_return_val_if_fail (recipient != NULL, 0);
	result = gee_deque_drain_head ((GeeDeque*) self, recipient, amount);
	return result;
}


/**
 * {@inheritDoc}
 */
static gboolean gee_linked_list_real_offer_head (GeeDeque* base, gconstpointer element) {
	GeeLinkedList * self;
	gboolean result = FALSE;
	self = (GeeLinkedList*) base;
	gee_abstract_list_insert ((GeeAbstractList*) self, 0, element);
	result = TRUE;
	return result;
}


/**
 * {@inheritDoc}
 */
static gpointer gee_linked_list_real_peek_head (GeeDeque* base) {
	GeeLinkedList * self;
	gpointer result = NULL;
	self = (GeeLinkedList*) base;
	if (self->priv->_size == 0) {
		result = NULL;
		return result;
	}
	result = gee_abstract_list_get ((GeeAbstractList*) self, 0);
	return result;
}


/**
 * {@inheritDoc}
 */
static gpointer gee_linked_list_real_poll_head (GeeDeque* base) {
	GeeLinkedList * self;
	gpointer result = NULL;
	self = (GeeLinkedList*) base;
	if (self->priv->_size == 0) {
		result = NULL;
		return result;
	}
	result = gee_abstract_list_remove_at ((GeeAbstractList*) self, 0);
	return result;
}


/**
 * {@inheritDoc}
 */
static gint gee_linked_list_real_drain_head (GeeDeque* base, GeeCollection* recipient, gint amount) {
	GeeLinkedList * self;
	gint result = 0;
	self = (GeeLinkedList*) base;
	g_return_val_if_fail (recipient != NULL, 0);
	if (amount == (-1)) {
		amount = self->priv->_size;
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gpointer _tmp1_;
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i < amount)) {
					break;
				}
				if (self->priv->_size == 0) {
					result = i;
					return result;
				}
				gee_collection_add (recipient, _tmp1_ = gee_abstract_list_remove_at ((GeeAbstractList*) self, 0));
				((_tmp1_ == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp1_ = (self->priv->g_destroy_func (_tmp1_), NULL));
			}
		}
	}
	result = amount;
	return result;
}


/**
 * {@inheritDoc}
 */
static gboolean gee_linked_list_real_offer_tail (GeeDeque* base, gconstpointer element) {
	GeeLinkedList * self;
	gboolean result = FALSE;
	self = (GeeLinkedList*) base;
	result = gee_abstract_collection_add ((GeeAbstractCollection*) self, element);
	return result;
}


/**
 * {@inheritDoc}
 */
static gpointer gee_linked_list_real_peek_tail (GeeDeque* base) {
	GeeLinkedList * self;
	gpointer result = NULL;
	self = (GeeLinkedList*) base;
	if (self->priv->_size == 0) {
		result = NULL;
		return result;
	}
	result = gee_abstract_list_get ((GeeAbstractList*) self, self->priv->_size - 1);
	return result;
}


/**
 * {@inheritDoc}
 */
static gpointer gee_linked_list_real_poll_tail (GeeDeque* base) {
	GeeLinkedList * self;
	gpointer result = NULL;
	self = (GeeLinkedList*) base;
	if (self->priv->_size == 0) {
		result = NULL;
		return result;
	}
	result = gee_abstract_list_remove_at ((GeeAbstractList*) self, self->priv->_size - 1);
	return result;
}


/**
 * {@inheritDoc}
 */
static gint gee_linked_list_real_drain_tail (GeeDeque* base, GeeCollection* recipient, gint amount) {
	GeeLinkedList * self;
	gint result = 0;
	self = (GeeLinkedList*) base;
	g_return_val_if_fail (recipient != NULL, 0);
	if (amount == (-1)) {
		amount = self->priv->_size;
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gpointer _tmp1_;
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i < amount)) {
					break;
				}
				if (self->priv->_size == 0) {
					result = i;
					return result;
				}
				gee_collection_add (recipient, _tmp1_ = gee_abstract_list_remove_at ((GeeAbstractList*) self, self->priv->_size - 1));
				((_tmp1_ == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp1_ = (self->priv->g_destroy_func (_tmp1_), NULL));
			}
		}
	}
	result = amount;
	return result;
}


static GeeLinkedListNode* _gee_linked_list_get_node_at (GeeLinkedList* self, gint index) {
	GeeLinkedListNode* result = NULL;
	GeeLinkedListNode* n;
	g_return_val_if_fail (self != NULL, NULL);
	n = NULL;
	;
	if (index == 0) {
		n = self->priv->_head;
	} else {
		if (index == (self->priv->_size - 1)) {
			n = self->priv->_tail;
		} else {
			if (index <= (self->priv->_size / 2)) {
				n = self->priv->_head;
				{
					gint i;
					i = 0;
					{
						gboolean _tmp0_;
						_tmp0_ = TRUE;
						while (TRUE) {
							if (!_tmp0_) {
								i++;
							}
							_tmp0_ = FALSE;
							if (!(index != i)) {
								break;
							}
							n = n->next;
						}
					}
				}
			} else {
				n = self->priv->_tail;
				{
					gint i;
					i = self->priv->_size - 1;
					{
						gboolean _tmp1_;
						_tmp1_ = TRUE;
						while (TRUE) {
							if (!_tmp1_) {
								i--;
							}
							_tmp1_ = FALSE;
							if (!(index != i)) {
								break;
							}
							n = n->prev;
						}
					}
				}
			}
		}
	}
	result = n;
	return result;
}


static void _gee_linked_list_remove_node (GeeLinkedList* self, GeeLinkedListNode* _n) {
	GeeLinkedListNode* n;
	GeeLinkedListNode* next;
	GeeLinkedListNode* _tmp8_;
	gpointer _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_n != NULL);
	n = NULL;
	next = NULL;
	if (_n == self->priv->_head) {
		GeeLinkedListNode* _tmp0_;
		GeeLinkedListNode* _tmp1_;
		GeeLinkedListNode* _tmp2_;
		GeeLinkedListNode* _tmp3_;
		n = (_tmp1_ = (_tmp0_ = self->priv->_head, self->priv->_head = NULL, _tmp0_), _gee_linked_list_node_free0 (n), _tmp1_);
		next = self->priv->_head = (_tmp3_ = (_tmp2_ = n->next, n->next = NULL, _tmp2_), _gee_linked_list_node_free0 (self->priv->_head), _tmp3_);
	} else {
		GeeLinkedListNode* _tmp4_;
		GeeLinkedListNode* _tmp5_;
		GeeLinkedListNode* _tmp6_;
		GeeLinkedListNode* _tmp7_;
		n = (_tmp5_ = (_tmp4_ = _n->prev->next, _n->prev->next = NULL, _tmp4_), _gee_linked_list_node_free0 (n), _tmp5_);
		next = n->prev->next = (_tmp7_ = (_tmp6_ = n->next, n->next = NULL, _tmp6_), _gee_linked_list_node_free0 (n->prev->next), _tmp7_);
	}
	if (n == self->priv->_tail) {
		self->priv->_tail = n->prev;
	} else {
		next->prev = n->prev;
	}
	n->prev = NULL;
	n->next = (_tmp8_ = NULL, _gee_linked_list_node_free0 (n->next), _tmp8_);
	n->data = (_tmp9_ = NULL, ((n->data == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (n->data = (self->priv->g_destroy_func (n->data), NULL)), _tmp9_);
	self->priv->_stamp = self->priv->_stamp + 1;
	self->priv->_size--;
	_gee_linked_list_node_free0 (n);
}


GEqualFunc gee_linked_list_get_equal_func (GeeLinkedList* self) {
	GEqualFunc result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_equal_func;
	return result;
}


static void gee_linked_list_set_equal_func (GeeLinkedList* self, GEqualFunc value) {
	g_return_if_fail (self != NULL);
	self->priv->_equal_func = value;
	g_object_notify ((GObject *) self, "equal-func");
}


static gint gee_linked_list_real_get_size (GeeAbstractCollection* base) {
	gint result;
	GeeLinkedList* self;
	self = (GeeLinkedList*) base;
	result = self->priv->_size;
	return result;
}


static gint gee_linked_list_real_get_capacity (GeeQueue* base) {
	gint result;
	GeeLinkedList* self;
	self = (GeeLinkedList*) base;
	result = GEE_QUEUE_UNBOUNDED_CAPACITY;
	return result;
}


static gint gee_linked_list_real_get_remaining_capacity (GeeQueue* base) {
	gint result;
	GeeLinkedList* self;
	self = (GeeLinkedList*) base;
	result = GEE_QUEUE_UNBOUNDED_CAPACITY;
	return result;
}


static gboolean gee_linked_list_real_get_is_full (GeeQueue* base) {
	gboolean result;
	GeeLinkedList* self;
	self = (GeeLinkedList*) base;
	result = FALSE;
	return result;
}


static GeeLinkedListNode* gee_linked_list_node_new (gpointer data) {
	GeeLinkedListNode* self;
	self = g_slice_new0 (GeeLinkedListNode);
	gee_linked_list_node_instance_init (self);
	self->data = data;
	return self;
}


static void gee_linked_list_node_instance_init (GeeLinkedListNode * self) {
	self->prev = NULL;
	self->next = NULL;
}


static void gee_linked_list_node_free (GeeLinkedListNode* self) {
	_gee_linked_list_node_free0 (self->next);
	g_slice_free (GeeLinkedListNode, self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static GeeLinkedListIterator* gee_linked_list_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeLinkedList* list) {
	GeeLinkedListIterator * self;
	GeeLinkedList* _tmp0_;
	g_return_val_if_fail (list != NULL, NULL);
	self = (GeeLinkedListIterator*) g_object_new (object_type, NULL);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	self->priv->_list = (_tmp0_ = _g_object_ref0 (list), _g_object_unref0 (self->priv->_list), _tmp0_);
	self->priv->position = NULL;
	self->priv->_index = -1;
	self->priv->_stamp = list->priv->_stamp;
	return self;
}


static GeeLinkedListIterator* gee_linked_list_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeLinkedList* list) {
	return gee_linked_list_iterator_construct (GEE_LINKED_LIST_TYPE_ITERATOR, g_type, g_dup_func, g_destroy_func, list);
}


static gboolean gee_linked_list_iterator_real_next (GeeIterator* base) {
	GeeLinkedListIterator * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	self = (GeeLinkedListIterator*) base;
	g_assert (self->priv->_stamp == self->priv->_list->priv->_stamp);
	if (self->priv->removed) {
		_tmp0_ = self->priv->position != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		self->priv->removed = FALSE;
		result = TRUE;
		return result;
	} else {
		gboolean _tmp1_ = FALSE;
		if (!self->priv->started) {
			_tmp1_ = self->priv->_list->priv->_head != NULL;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			self->priv->started = TRUE;
			self->priv->position = self->priv->_list->priv->_head;
			self->priv->_index++;
			result = TRUE;
			return result;
		} else {
			gboolean _tmp2_ = FALSE;
			if (self->priv->position != NULL) {
				_tmp2_ = self->priv->position->next != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			if (_tmp2_) {
				self->priv->position = self->priv->position->next;
				self->priv->_index++;
				result = TRUE;
				return result;
			}
		}
	}
	result = FALSE;
	return result;
}


static gboolean gee_linked_list_iterator_real_has_next (GeeIterator* base) {
	GeeLinkedListIterator * self;
	gboolean result = FALSE;
	self = (GeeLinkedListIterator*) base;
	g_assert (self->priv->_stamp == self->priv->_list->priv->_stamp);
	if (self->priv->removed) {
		result = self->priv->position != NULL;
		return result;
	} else {
		if (!self->priv->started) {
			result = self->priv->_list->priv->_head != NULL;
			return result;
		} else {
			if (self->priv->position != NULL) {
				result = self->priv->position->next != NULL;
				return result;
			}
		}
	}
	result = FALSE;
	return result;
}


static gboolean gee_linked_list_iterator_real_first (GeeIterator* base) {
	GeeLinkedListIterator * self;
	gboolean result = FALSE;
	self = (GeeLinkedListIterator*) base;
	g_assert (self->priv->_stamp == self->priv->_list->priv->_stamp);
	if (gee_collection_get_size ((GeeCollection*) self->priv->_list) == 0) {
		result = FALSE;
		return result;
	}
	self->priv->position = self->priv->_list->priv->_head;
	self->priv->started = TRUE;
	self->priv->_index = 0;
	self->priv->removed = FALSE;
	result = self->priv->position != NULL;
	return result;
}


static gpointer gee_linked_list_iterator_real_get (GeeIterator* base) {
	GeeLinkedListIterator * self;
	gpointer result = NULL;
	gconstpointer _tmp0_;
	self = (GeeLinkedListIterator*) base;
	g_assert (self->priv->_stamp == self->priv->_list->priv->_stamp);
	g_assert (self->priv->position != NULL);
	result = (_tmp0_ = self->priv->position->data, ((_tmp0_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp0_) : self->priv->g_dup_func ((gpointer) _tmp0_));
	return result;
}


static void gee_linked_list_iterator_real_remove (GeeIterator* base) {
	GeeLinkedListIterator * self;
	GeeLinkedListNode* new_position;
	self = (GeeLinkedListIterator*) base;
	g_assert (self->priv->_stamp == self->priv->_list->priv->_stamp);
	g_assert (self->priv->position != NULL);
	new_position = self->priv->position->next;
	if (new_position == NULL) {
		self->priv->started = FALSE;
	}
	_gee_linked_list_remove_node (self->priv->_list, self->priv->position);
	self->priv->position = new_position;
	self->priv->removed = TRUE;
	self->priv->_stamp = self->priv->_list->priv->_stamp;
}


static gboolean gee_linked_list_iterator_real_previous (GeeBidirIterator* base) {
	GeeLinkedListIterator * self;
	gboolean result = FALSE;
	self = (GeeLinkedListIterator*) base;
	g_assert (self->priv->_stamp == self->priv->_list->priv->_stamp);
	if (!self->priv->started) {
		self->priv->position = NULL;
		result = FALSE;
		return result;
	} else {
		gboolean _tmp0_ = FALSE;
		if (self->priv->position != NULL) {
			_tmp0_ = self->priv->position->prev != NULL;
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			self->priv->position = self->priv->position->prev;
			self->priv->_index--;
			result = TRUE;
			return result;
		}
	}
	result = FALSE;
	return result;
}


static gboolean gee_linked_list_iterator_real_has_previous (GeeBidirIterator* base) {
	GeeLinkedListIterator * self;
	gboolean result = FALSE;
	self = (GeeLinkedListIterator*) base;
	g_assert (self->priv->_stamp == self->priv->_list->priv->_stamp);
	if (!self->priv->started) {
		result = FALSE;
		return result;
	} else {
		if (self->priv->position != NULL) {
			result = self->priv->position->prev != NULL;
			return result;
		}
	}
	result = FALSE;
	return result;
}


static gboolean gee_linked_list_iterator_real_last (GeeBidirIterator* base) {
	GeeLinkedListIterator * self;
	gboolean result = FALSE;
	self = (GeeLinkedListIterator*) base;
	g_assert (self->priv->_stamp == self->priv->_list->priv->_stamp);
	if (gee_collection_get_size ((GeeCollection*) self->priv->_list) == 0) {
		result = FALSE;
		return result;
	}
	self->priv->position = self->priv->_list->priv->_tail;
	self->priv->started = TRUE;
	self->priv->_index = self->priv->_list->priv->_size - 1;
	result = self->priv->position != NULL;
	return result;
}


static void gee_linked_list_iterator_real_set (GeeListIterator* base, gconstpointer item) {
	GeeLinkedListIterator * self;
	gconstpointer _tmp0_;
	gpointer _tmp1_;
	self = (GeeLinkedListIterator*) base;
	g_assert (self->priv->_stamp == self->priv->_list->priv->_stamp);
	g_assert (self->priv->position != NULL);
	self->priv->position->data = (_tmp1_ = (_tmp0_ = item, ((_tmp0_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp0_) : self->priv->g_dup_func ((gpointer) _tmp0_)), ((self->priv->position->data == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (self->priv->position->data = (self->priv->g_destroy_func (self->priv->position->data), NULL)), _tmp1_);
}


static void gee_linked_list_iterator_real_insert (GeeListIterator* base, gconstpointer item) {
	GeeLinkedListIterator * self;
	gconstpointer _tmp0_;
	GeeLinkedListNode* n;
	self = (GeeLinkedListIterator*) base;
	g_assert (self->priv->_stamp == self->priv->_list->priv->_stamp);
	g_assert (self->priv->position != NULL);
	n = gee_linked_list_node_new ((_tmp0_ = item, ((_tmp0_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp0_) : self->priv->g_dup_func ((gpointer) _tmp0_)));
	if (self->priv->position->prev != NULL) {
		GeeLinkedListNode* _tmp1_;
		GeeLinkedListNode* position;
		GeeLinkedListNode* _tmp2_;
		GeeLinkedListNode* _tmp3_;
		GeeLinkedListNode* _n;
		GeeLinkedListNode* _tmp4_;
		GeeLinkedListNode* _tmp5_;
		position = (_tmp1_ = self->priv->position->prev->next, self->priv->position->prev->next = NULL, _tmp1_);
		n->prev = position->prev;
		position->prev = n;
		n->next = (_tmp3_ = (_tmp2_ = position, position = NULL, _tmp2_), _gee_linked_list_node_free0 (n->next), _tmp3_);
		_n = n;
		_n->prev->next = (_tmp5_ = (_tmp4_ = n, n = NULL, _tmp4_), _gee_linked_list_node_free0 (_n->prev->next), _tmp5_);
		_gee_linked_list_node_free0 (position);
	} else {
		GeeLinkedListNode* _tmp6_;
		GeeLinkedListNode* position;
		GeeLinkedListNode* _tmp7_;
		GeeLinkedListNode* _tmp8_;
		GeeLinkedListNode* _tmp9_;
		GeeLinkedListNode* _tmp10_;
		position = (_tmp6_ = self->priv->_list->priv->_head, self->priv->_list->priv->_head = NULL, _tmp6_);
		position->prev = n;
		n->next = (_tmp8_ = (_tmp7_ = position, position = NULL, _tmp7_), _gee_linked_list_node_free0 (n->next), _tmp8_);
		self->priv->_list->priv->_head = (_tmp10_ = (_tmp9_ = n, n = NULL, _tmp9_), _gee_linked_list_node_free0 (self->priv->_list->priv->_head), _tmp10_);
		_gee_linked_list_node_free0 (position);
	}
	self->priv->_list->priv->_size++;
	self->priv->_index++;
	self->priv->_stamp = self->priv->_list->priv->_stamp;
	_gee_linked_list_node_free0 (n);
}


static void gee_linked_list_iterator_real_add (GeeListIterator* base, gconstpointer item) {
	GeeLinkedListIterator * self;
	gconstpointer _tmp0_;
	GeeLinkedListNode* n;
	GeeLinkedListNode* _tmp3_;
	GeeLinkedListNode* _tmp4_;
	self = (GeeLinkedListIterator*) base;
	g_assert (self->priv->_stamp == self->priv->_list->priv->_stamp);
	g_assert (self->priv->position != NULL);
	n = gee_linked_list_node_new ((_tmp0_ = item, ((_tmp0_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp0_) : self->priv->g_dup_func ((gpointer) _tmp0_)));
	if (self->priv->position->next != NULL) {
		GeeLinkedListNode* _tmp1_;
		GeeLinkedListNode* _tmp2_;
		self->priv->position->next->prev = n;
		n->next = (_tmp2_ = (_tmp1_ = self->priv->position->next, self->priv->position->next = NULL, _tmp1_), _gee_linked_list_node_free0 (n->next), _tmp2_);
	} else {
		self->priv->_list->priv->_tail = n;
	}
	self->priv->position->next = (_tmp4_ = (_tmp3_ = n, n = NULL, _tmp3_), _gee_linked_list_node_free0 (self->priv->position->next), _tmp4_);
	self->priv->position->next->prev = self->priv->position;
	self->priv->position = self->priv->position->next;
	self->priv->_list->priv->_size++;
	self->priv->_index++;
	self->priv->_stamp = self->priv->_list->priv->_stamp;
	_gee_linked_list_node_free0 (n);
}


static gint gee_linked_list_iterator_real_index (GeeListIterator* base) {
	GeeLinkedListIterator * self;
	gint result = 0;
	self = (GeeLinkedListIterator*) base;
	g_assert (self->priv->_stamp == self->priv->_list->priv->_stamp);
	g_assert (self->priv->position != NULL);
	result = self->priv->_index;
	return result;
}


static void gee_linked_list_iterator_class_init (GeeLinkedListIteratorClass * klass) {
	gee_linked_list_iterator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeeLinkedListIteratorPrivate));
	G_OBJECT_CLASS (klass)->get_property = gee_linked_list_iterator_get_property;
	G_OBJECT_CLASS (klass)->set_property = gee_linked_list_iterator_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_linked_list_iterator_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_LINKED_LIST_ITERATOR_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_LINKED_LIST_ITERATOR_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_LINKED_LIST_ITERATOR_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void gee_linked_list_iterator_gee_iterator_interface_init (GeeIteratorIface * iface) {
	gee_linked_list_iterator_gee_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->next = gee_linked_list_iterator_real_next;
	iface->has_next = gee_linked_list_iterator_real_has_next;
	iface->first = gee_linked_list_iterator_real_first;
	iface->get = gee_linked_list_iterator_real_get;
	iface->remove = gee_linked_list_iterator_real_remove;
}


static void gee_linked_list_iterator_gee_bidir_iterator_interface_init (GeeBidirIteratorIface * iface) {
	gee_linked_list_iterator_gee_bidir_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->previous = gee_linked_list_iterator_real_previous;
	iface->has_previous = gee_linked_list_iterator_real_has_previous;
	iface->last = gee_linked_list_iterator_real_last;
}


static void gee_linked_list_iterator_gee_list_iterator_interface_init (GeeListIteratorIface * iface) {
	gee_linked_list_iterator_gee_list_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->set = gee_linked_list_iterator_real_set;
	iface->insert = gee_linked_list_iterator_real_insert;
	iface->add = gee_linked_list_iterator_real_add;
	iface->index = gee_linked_list_iterator_real_index;
}


static void gee_linked_list_iterator_instance_init (GeeLinkedListIterator * self) {
	self->priv = GEE_LINKED_LIST_ITERATOR_GET_PRIVATE (self);
	self->priv->started = FALSE;
	self->priv->removed = FALSE;
}


static void gee_linked_list_iterator_finalize (GObject* obj) {
	GeeLinkedListIterator * self;
	self = GEE_LINKED_LIST_ITERATOR (obj);
	_g_object_unref0 (self->priv->_list);
	G_OBJECT_CLASS (gee_linked_list_iterator_parent_class)->finalize (obj);
}


static GType gee_linked_list_iterator_get_type (void) {
	static volatile gsize gee_linked_list_iterator_type_id__volatile = 0;
	if (g_once_init_enter (&gee_linked_list_iterator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeLinkedListIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_linked_list_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeLinkedListIterator), 0, (GInstanceInitFunc) gee_linked_list_iterator_instance_init, NULL };
		static const GInterfaceInfo gee_iterator_info = { (GInterfaceInitFunc) gee_linked_list_iterator_gee_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_bidir_iterator_info = { (GInterfaceInitFunc) gee_linked_list_iterator_gee_bidir_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_list_iterator_info = { (GInterfaceInitFunc) gee_linked_list_iterator_gee_list_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gee_linked_list_iterator_type_id;
		gee_linked_list_iterator_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeLinkedListIterator", &g_define_type_info, 0);
		g_type_add_interface_static (gee_linked_list_iterator_type_id, GEE_TYPE_ITERATOR, &gee_iterator_info);
		g_type_add_interface_static (gee_linked_list_iterator_type_id, GEE_TYPE_BIDIR_ITERATOR, &gee_bidir_iterator_info);
		g_type_add_interface_static (gee_linked_list_iterator_type_id, GEE_TYPE_LIST_ITERATOR, &gee_list_iterator_info);
		g_once_init_leave (&gee_linked_list_iterator_type_id__volatile, gee_linked_list_iterator_type_id);
	}
	return gee_linked_list_iterator_type_id__volatile;
}


static void gee_linked_list_iterator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeLinkedListIterator * self;
	self = GEE_LINKED_LIST_ITERATOR (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gee_linked_list_iterator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeLinkedListIterator * self;
	self = GEE_LINKED_LIST_ITERATOR (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
		case GEE_LINKED_LIST_ITERATOR_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_LINKED_LIST_ITERATOR_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_LINKED_LIST_ITERATOR_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
	}
}


static void gee_linked_list_class_init (GeeLinkedListClass * klass) {
	gee_linked_list_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeeLinkedListPrivate));
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->iterator = gee_linked_list_real_iterator;
	GEE_ABSTRACT_LIST_CLASS (klass)->list_iterator = gee_linked_list_real_list_iterator;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->contains = gee_linked_list_real_contains;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->add = gee_linked_list_real_add;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->remove = gee_linked_list_real_remove;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->clear = gee_linked_list_real_clear;
	GEE_ABSTRACT_LIST_CLASS (klass)->get = gee_linked_list_real_get;
	GEE_ABSTRACT_LIST_CLASS (klass)->set = gee_linked_list_real_set;
	GEE_ABSTRACT_LIST_CLASS (klass)->index_of = gee_linked_list_real_index_of;
	GEE_ABSTRACT_LIST_CLASS (klass)->insert = gee_linked_list_real_insert;
	GEE_ABSTRACT_LIST_CLASS (klass)->remove_at = gee_linked_list_real_remove_at;
	GEE_ABSTRACT_LIST_CLASS (klass)->slice = gee_linked_list_real_slice;
	GEE_ABSTRACT_LIST_CLASS (klass)->first = gee_linked_list_real_first;
	GEE_ABSTRACT_LIST_CLASS (klass)->last = gee_linked_list_real_last;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->get_size = gee_linked_list_real_get_size;
	G_OBJECT_CLASS (klass)->get_property = gee_linked_list_get_property;
	G_OBJECT_CLASS (klass)->set_property = gee_linked_list_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_linked_list_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_LINKED_LIST_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_LINKED_LIST_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_LINKED_LIST_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	 * The elements' equality testing function.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_LINKED_LIST_EQUAL_FUNC, g_param_spec_pointer ("equal-func", "equal-func", "equal-func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	 * {@inheritDoc}
	 */
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_LINKED_LIST_SIZE, "size");
	/**
	 * {@inheritDoc}
	 */
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_LINKED_LIST_CAPACITY, "capacity");
	/**
	 * {@inheritDoc}
	 */
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_LINKED_LIST_REMAINING_CAPACITY, "remaining-capacity");
	/**
	 * {@inheritDoc}
	 */
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_LINKED_LIST_IS_FULL, "is-full");
}


static void gee_linked_list_gee_queue_interface_init (GeeQueueIface * iface) {
	gee_linked_list_gee_queue_parent_iface = g_type_interface_peek_parent (iface);
	iface->offer = gee_linked_list_real_offer;
	iface->peek = gee_linked_list_real_peek;
	iface->poll = gee_linked_list_real_poll;
	iface->drain = gee_linked_list_real_drain;
	iface->get_capacity = gee_linked_list_real_get_capacity;
	iface->get_remaining_capacity = gee_linked_list_real_get_remaining_capacity;
	iface->get_is_full = gee_linked_list_real_get_is_full;
}


static void gee_linked_list_gee_deque_interface_init (GeeDequeIface * iface) {
	gee_linked_list_gee_deque_parent_iface = g_type_interface_peek_parent (iface);
	iface->offer_head = gee_linked_list_real_offer_head;
	iface->peek_head = gee_linked_list_real_peek_head;
	iface->poll_head = gee_linked_list_real_poll_head;
	iface->drain_head = gee_linked_list_real_drain_head;
	iface->offer_tail = gee_linked_list_real_offer_tail;
	iface->peek_tail = gee_linked_list_real_peek_tail;
	iface->poll_tail = gee_linked_list_real_poll_tail;
	iface->drain_tail = gee_linked_list_real_drain_tail;
}


static void gee_linked_list_instance_init (GeeLinkedList * self) {
	self->priv = GEE_LINKED_LIST_GET_PRIVATE (self);
	self->priv->_size = 0;
	self->priv->_stamp = 0;
	self->priv->_head = NULL;
	self->priv->_tail = NULL;
}


static void gee_linked_list_finalize (GObject* obj) {
	GeeLinkedList * self;
	self = GEE_LINKED_LIST (obj);
	_gee_linked_list_node_free0 (self->priv->_head);
	G_OBJECT_CLASS (gee_linked_list_parent_class)->finalize (obj);
}


/**
 * Doubly-linked list implementation of the {@link List} interface.
 *
 * This implementation is pretty well designed for highly mutable data. When
 * indexed access is privileged prefer using {@link ArrayList}.
 *
 * @see ArrayList
 */
GType gee_linked_list_get_type (void) {
	static volatile gsize gee_linked_list_type_id__volatile = 0;
	if (g_once_init_enter (&gee_linked_list_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeLinkedListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_linked_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeLinkedList), 0, (GInstanceInitFunc) gee_linked_list_instance_init, NULL };
		static const GInterfaceInfo gee_queue_info = { (GInterfaceInitFunc) gee_linked_list_gee_queue_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_deque_info = { (GInterfaceInitFunc) gee_linked_list_gee_deque_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gee_linked_list_type_id;
		gee_linked_list_type_id = g_type_register_static (GEE_TYPE_ABSTRACT_LIST, "GeeLinkedList", &g_define_type_info, 0);
		g_type_add_interface_static (gee_linked_list_type_id, GEE_TYPE_QUEUE, &gee_queue_info);
		g_type_add_interface_static (gee_linked_list_type_id, GEE_TYPE_DEQUE, &gee_deque_info);
		g_once_init_leave (&gee_linked_list_type_id__volatile, gee_linked_list_type_id);
	}
	return gee_linked_list_type_id__volatile;
}


static void gee_linked_list_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeLinkedList * self;
	self = GEE_LINKED_LIST (object);
	switch (property_id) {
		case GEE_LINKED_LIST_EQUAL_FUNC:
		g_value_set_pointer (value, gee_linked_list_get_equal_func (self));
		break;
		case GEE_LINKED_LIST_SIZE:
		g_value_set_int (value, gee_abstract_collection_get_size ((GeeAbstractCollection*) self));
		break;
		case GEE_LINKED_LIST_CAPACITY:
		g_value_set_int (value, gee_queue_get_capacity ((GeeQueue*) self));
		break;
		case GEE_LINKED_LIST_REMAINING_CAPACITY:
		g_value_set_int (value, gee_queue_get_remaining_capacity ((GeeQueue*) self));
		break;
		case GEE_LINKED_LIST_IS_FULL:
		g_value_set_boolean (value, gee_queue_get_is_full ((GeeQueue*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gee_linked_list_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeLinkedList * self;
	self = GEE_LINKED_LIST (object);
	switch (property_id) {
		case GEE_LINKED_LIST_EQUAL_FUNC:
		gee_linked_list_set_equal_func (self, g_value_get_pointer (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
		case GEE_LINKED_LIST_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_LINKED_LIST_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_LINKED_LIST_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
	}
}




