/* iterator.c generated by valac 0.15.0.90-e9553, the Vala compiler
 * generated from iterator.vala, do not modify */

/* iterator.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 * Copyright (C) 2009  Didier Villevalois, Maciej Piechotka
 * Copyright (C) 2010-2011  Maciej Piechotka
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Maciej Piechotka <uzytkownik2@gmail.com>
 * 	Didier 'Ptitjes Villevalois <ptitjes@free.fr>
 */

#include <glib.h>
#include <glib-object.h>


#define GEE_TYPE_TRAVERSABLE (gee_traversable_get_type ())
#define GEE_TRAVERSABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_TRAVERSABLE, GeeTraversable))
#define GEE_IS_TRAVERSABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_TRAVERSABLE))
#define GEE_TRAVERSABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_TRAVERSABLE, GeeTraversableIface))

typedef struct _GeeTraversable GeeTraversable;
typedef struct _GeeTraversableIface GeeTraversableIface;

#define GEE_TRAVERSABLE_TYPE_STREAM (gee_traversable_stream_get_type ())

#define GEE_TYPE_LAZY (gee_lazy_get_type ())
#define GEE_LAZY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_LAZY, GeeLazy))
#define GEE_LAZY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_LAZY, GeeLazyClass))
#define GEE_IS_LAZY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_LAZY))
#define GEE_IS_LAZY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_LAZY))
#define GEE_LAZY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_LAZY, GeeLazyClass))

typedef struct _GeeLazy GeeLazy;
typedef struct _GeeLazyClass GeeLazyClass;

#define GEE_TYPE_ITERATOR (gee_iterator_get_type ())
#define GEE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERATOR, GeeIterator))
#define GEE_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERATOR))
#define GEE_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERATOR, GeeIteratorIface))

typedef struct _GeeIterator GeeIterator;
typedef struct _GeeIteratorIface GeeIteratorIface;
typedef struct _Block2Data Block2Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _gee_lazy_unref0(var) ((var == NULL) ? NULL : (var = (gee_lazy_unref (var), NULL)))
typedef struct _Block3Data Block3Data;

#define GEE_TYPE_UNFOLD_ITERATOR (gee_unfold_iterator_get_type ())
#define GEE_UNFOLD_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_UNFOLD_ITERATOR, GeeUnfoldIterator))
#define GEE_UNFOLD_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_UNFOLD_ITERATOR, GeeUnfoldIteratorClass))
#define GEE_IS_UNFOLD_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_UNFOLD_ITERATOR))
#define GEE_IS_UNFOLD_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_UNFOLD_ITERATOR))
#define GEE_UNFOLD_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_UNFOLD_ITERATOR, GeeUnfoldIteratorClass))

typedef struct _GeeUnfoldIterator GeeUnfoldIterator;
typedef struct _GeeUnfoldIteratorClass GeeUnfoldIteratorClass;
typedef struct _Block4Data Block4Data;
#define _g_destroy_func0(var) (((var == NULL) || (g_destroy_func == NULL)) ? NULL : (var = (g_destroy_func (var), NULL)))

typedef void (*GeeForallFunc) (gpointer g, void* user_data);
typedef enum  {
	GEE_TRAVERSABLE_STREAM_YIELD,
	GEE_TRAVERSABLE_STREAM_CONTINUE,
	GEE_TRAVERSABLE_STREAM_END
} GeeTraversableStream;

typedef GeeTraversableStream (*GeeStreamFunc) (GeeTraversableStream state, GeeLazy* g, GeeLazy** lazy, void* user_data);
typedef gpointer (*GeeFoldFunc) (gpointer g, gpointer a, void* user_data);
typedef gpointer (*GeeMapFunc) (gpointer g, void* user_data);
typedef gboolean (*GeePredicate) (gconstpointer g, void* user_data);
struct _GeeTraversableIface {
	GTypeInterface parent_iface;
	void (*foreach) (GeeTraversable* self, GeeForallFunc f, void* f_target);
	GeeIterator* (*stream) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeStreamFunc f, void* f_target, GDestroyNotify f_target_destroy_notify);
	gpointer (*fold) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed);
	GeeIterator* (*map) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeMapFunc f, void* f_target);
	GeeIterator* (*scan) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed);
	GeeIterator* (*filter) (GeeTraversable* self, GeePredicate f, void* f_target, GDestroyNotify f_target_destroy_notify);
	GeeIterator* (*chop) (GeeTraversable* self, gint offset, gint length);
};

struct _GeeIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (GeeIterator* self);
	gboolean (*has_next) (GeeIterator* self);
	gpointer (*get) (GeeIterator* self);
	void (*remove) (GeeIterator* self);
	gboolean (*get_valid) (GeeIterator* self);
	gboolean (*get_read_only) (GeeIterator* self);
};

struct _Block2Data {
	int _ref_count_;
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	GeeTraversableStream str;
	gboolean need_next;
	GeeIterator* _self_;
	GeeStreamFunc f;
	gpointer f_target;
	GDestroyNotify f_target_destroy_notify;
};

typedef gpointer (*GeeLazyFunc) (void* user_data);
typedef GeeLazy* (*GeeUnfoldFunc) (void* user_data);
struct _Block3Data {
	int _ref_count_;
	Block2Data * _data2_;
};

struct _Block4Data {
	int _ref_count_;
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GeeIterator* current;
	GeeIterator* iters;
};



GType gee_traversable_stream_get_type (void) G_GNUC_CONST;
gpointer gee_lazy_ref (gpointer instance);
void gee_lazy_unref (gpointer instance);
GParamSpec* gee_param_spec_lazy (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gee_value_set_lazy (GValue* value, gpointer v_object);
void gee_value_take_lazy (GValue* value, gpointer v_object);
gpointer gee_value_get_lazy (const GValue* value);
GType gee_lazy_get_type (void) G_GNUC_CONST;
GType gee_traversable_get_type (void) G_GNUC_CONST;
GType gee_iterator_get_type (void) G_GNUC_CONST;
gboolean gee_iterator_next (GeeIterator* self);
gboolean gee_iterator_has_next (GeeIterator* self);
gpointer gee_iterator_get (GeeIterator* self);
void gee_iterator_remove (GeeIterator* self);
GeeIterator* gee_iterator_stream_impl (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeIterator* _self_, GeeStreamFunc f, void* f_target, GDestroyNotify f_target_destroy_notify);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
gboolean gee_iterator_get_valid (GeeIterator* self);
static gpointer ____lambda2_ (Block2Data* _data2_);
static gpointer _____lambda2__gee_lazy_func (gpointer self);
GeeLazy* gee_lazy_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeLazyFunc func, void* func_target, GDestroyNotify func_target_destroy_notify);
GeeLazy* gee_lazy_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeLazyFunc func, void* func_target, GDestroyNotify func_target_destroy_notify);
GeeIterator* gee_iterator_unfold (GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeUnfoldFunc f, void* f_target, GDestroyNotify f_target_destroy_notify, GeeLazy* current);
static GeeLazy* _____lambda5_ (Block2Data* _data2_);
static GeeLazy* ______lambda5__gee_unfold_func (gpointer self);
static GeeLazy* ___lambda6_ (Block2Data* _data2_);
static GeeLazy* ____lambda6__gee_unfold_func (gpointer self);
static GeeLazy* __lambda7_ (Block2Data* _data2_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (Block3Data* _data3_);
static gpointer ___lambda8_ (Block3Data* _data3_);
static gpointer ____lambda8__gee_lazy_func (gpointer self);
static GeeLazy* ___lambda7__gee_unfold_func (gpointer self);
GeeUnfoldIterator* gee_unfold_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeUnfoldFunc func, void* func_target, GDestroyNotify func_target_destroy_notify, GeeLazy* current);
GeeUnfoldIterator* gee_unfold_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeUnfoldFunc func, void* func_target, GDestroyNotify func_target_destroy_notify, GeeLazy* current);
GType gee_unfold_iterator_get_type (void) G_GNUC_CONST;
GeeIterator* gee_iterator_concat (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeIterator* iters);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (Block4Data* _data4_);
static GeeLazy* __lambda9_ (Block4Data* _data4_);
GeeLazy* gee_lazy_new_from_value (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer item);
GeeLazy* gee_lazy_construct_from_value (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer item);
static GeeLazy* ___lambda9__gee_unfold_func (gpointer self);
gboolean gee_iterator_get_read_only (GeeIterator* self);


/**
 * Advances to the next element in the iteration.
 *
 * @return ``true`` if the iterator has a next element
 */
gboolean gee_iterator_next (GeeIterator* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GEE_ITERATOR_GET_INTERFACE (self)->next (self);
}


/**
 * Checks whether there is a next element in the iteration.
 *
 * @return ``true`` if the iterator has a next element
 */
gboolean gee_iterator_has_next (GeeIterator* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GEE_ITERATOR_GET_INTERFACE (self)->has_next (self);
}


/**
 * Returns the current element in the iteration.
 *
 * @return the current element in the iteration
 */
gpointer gee_iterator_get (GeeIterator* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GEE_ITERATOR_GET_INTERFACE (self)->get (self);
}


/**
 * Removes the current element in the iteration. The cursor is set in an
 * in-between state. Both {@link get} and {@link remove} will fail until
 * the next move of the cursor (calling {@link next}).
 */
void gee_iterator_remove (GeeIterator* self) {
	g_return_if_fail (self != NULL);
	GEE_ITERATOR_GET_INTERFACE (self)->remove (self);
}


/**
 * Default implementation of {@link Iterator.stream}.
 *
 * @param self Current Iterator
 * @param f Stream function
 * @returns Transformed stream
 * @see stream
 */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		GType g_type;
		GBoxedCopyFunc g_dup_func;
		GDestroyNotify g_destroy_func;
		GType a_type;
		GBoxedCopyFunc a_dup_func;
		GDestroyNotify a_destroy_func;
		g_type = _data2_->g_type;
		g_dup_func = _data2_->g_dup_func;
		g_destroy_func = _data2_->g_destroy_func;
		a_type = _data2_->a_type;
		a_dup_func = _data2_->a_dup_func;
		a_destroy_func = _data2_->a_destroy_func;
		_g_object_unref0 (_data2_->_self_);
		(_data2_->f_target_destroy_notify == NULL) ? NULL : (_data2_->f_target_destroy_notify (_data2_->f_target), NULL);
		_data2_->f = NULL;
		_data2_->f_target = NULL;
		_data2_->f_target_destroy_notify = NULL;
		g_slice_free (Block2Data, _data2_);
	}
}


static gpointer ____lambda2_ (Block2Data* _data2_) {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	gpointer result = NULL;
	GeeIterator* _tmp0_;
	gpointer _tmp1_ = NULL;
	g_type = _data2_->g_type;
	g_dup_func = _data2_->g_dup_func;
	g_destroy_func = _data2_->g_destroy_func;
	a_type = _data2_->a_type;
	a_dup_func = _data2_->a_dup_func;
	a_destroy_func = _data2_->a_destroy_func;
	_tmp0_ = _data2_->_self_;
	_tmp1_ = gee_iterator_get (_tmp0_);
	result = _tmp1_;
	return result;
}


static gpointer _____lambda2__gee_lazy_func (gpointer self) {
	gpointer result;
	result = ____lambda2_ (self);
	return result;
}


static GeeLazy* _____lambda5_ (Block2Data* _data2_) {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	GeeLazy* result = NULL;
	g_type = _data2_->g_type;
	g_dup_func = _data2_->g_dup_func;
	g_destroy_func = _data2_->g_destroy_func;
	a_type = _data2_->a_type;
	a_dup_func = _data2_->a_dup_func;
	a_destroy_func = _data2_->a_destroy_func;
	result = NULL;
	return result;
}


static GeeLazy* ______lambda5__gee_unfold_func (gpointer self) {
	GeeLazy* result;
	result = _____lambda5_ (self);
	return result;
}


static GeeLazy* ___lambda6_ (Block2Data* _data2_) {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	GeeLazy* result = NULL;
	g_type = _data2_->g_type;
	g_dup_func = _data2_->g_dup_func;
	g_destroy_func = _data2_->g_destroy_func;
	a_type = _data2_->a_type;
	a_dup_func = _data2_->a_dup_func;
	a_destroy_func = _data2_->a_destroy_func;
	result = NULL;
	return result;
}


static GeeLazy* ____lambda6__gee_unfold_func (gpointer self) {
	GeeLazy* result;
	result = ___lambda6_ (self);
	return result;
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (Block3Data* _data3_) {
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		GType g_type;
		GBoxedCopyFunc g_dup_func;
		GDestroyNotify g_destroy_func;
		GType a_type;
		GBoxedCopyFunc a_dup_func;
		GDestroyNotify a_destroy_func;
		g_type = _data3_->_data2_->g_type;
		g_dup_func = _data3_->_data2_->g_dup_func;
		g_destroy_func = _data3_->_data2_->g_destroy_func;
		a_type = _data3_->_data2_->a_type;
		a_dup_func = _data3_->_data2_->a_dup_func;
		a_destroy_func = _data3_->_data2_->a_destroy_func;
		block2_data_unref (_data3_->_data2_);
		_data3_->_data2_ = NULL;
		g_slice_free (Block3Data, _data3_);
	}
}


static gpointer ___lambda8_ (Block3Data* _data3_) {
	Block2Data* _data2_;
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	gpointer result = NULL;
	GeeIterator* _tmp0_;
	gpointer _tmp1_ = NULL;
	_data2_ = _data3_->_data2_;
	g_type = _data2_->g_type;
	g_dup_func = _data2_->g_dup_func;
	g_destroy_func = _data2_->g_destroy_func;
	a_type = _data2_->a_type;
	a_dup_func = _data2_->a_dup_func;
	a_destroy_func = _data2_->a_destroy_func;
	_tmp0_ = _data2_->_self_;
	_tmp1_ = gee_iterator_get (_tmp0_);
	result = _tmp1_;
	return result;
}


static gpointer ____lambda8__gee_lazy_func (gpointer self) {
	gpointer result;
	result = ___lambda8_ (self);
	return result;
}


static GeeLazy* __lambda7_ (Block2Data* _data2_) {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	GeeLazy* result = NULL;
	Block3Data* _data3_;
	GeeLazy* val;
	GeeTraversableStream _tmp0_;
	GeeTraversableStream _tmp16_;
	g_type = _data2_->g_type;
	g_dup_func = _data2_->g_dup_func;
	g_destroy_func = _data2_->g_destroy_func;
	a_type = _data2_->a_type;
	a_dup_func = _data2_->a_dup_func;
	a_destroy_func = _data2_->a_destroy_func;
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->_data2_ = block2_data_ref (_data2_);
	val = NULL;
	_tmp0_ = _data2_->str;
	if (_tmp0_ != GEE_TRAVERSABLE_STREAM_CONTINUE) {
		GeeStreamFunc _tmp1_;
		void* _tmp1__target;
		GeeLazy* _tmp2_ = NULL;
		GeeTraversableStream _tmp3_ = 0;
		_tmp1_ = _data2_->f;
		_tmp1__target = _data2_->f_target;
		_tmp3_ = _tmp1_ (GEE_TRAVERSABLE_STREAM_YIELD, NULL, &_tmp2_, _tmp1__target);
		_gee_lazy_unref0 (val);
		val = _tmp2_;
		_data2_->str = _tmp3_;
	}
	while (TRUE) {
		GeeTraversableStream _tmp4_;
		gboolean _tmp5_;
		GeeStreamFunc _tmp12_;
		void* _tmp12__target;
		GeeLazy* _tmp13_;
		GeeLazy* _tmp14_ = NULL;
		GeeTraversableStream _tmp15_ = 0;
		_tmp4_ = _data2_->str;
		if (!(_tmp4_ == GEE_TRAVERSABLE_STREAM_CONTINUE)) {
			break;
		}
		_tmp5_ = _data2_->need_next;
		if (_tmp5_) {
			GeeIterator* _tmp6_;
			gboolean _tmp7_ = FALSE;
			_tmp6_ = _data2_->_self_;
			_tmp7_ = gee_iterator_next (_tmp6_);
			if (!_tmp7_) {
				GeeStreamFunc _tmp8_;
				void* _tmp8__target;
				GeeLazy* _tmp9_ = NULL;
				GeeTraversableStream _tmp10_ = 0;
				GeeTraversableStream _tmp11_;
				_tmp8_ = _data2_->f;
				_tmp8__target = _data2_->f_target;
				_tmp10_ = _tmp8_ (GEE_TRAVERSABLE_STREAM_END, NULL, &_tmp9_, _tmp8__target);
				_gee_lazy_unref0 (val);
				val = _tmp9_;
				_data2_->str = _tmp10_;
				_tmp11_ = _data2_->str;
				g_assert (_tmp11_ != GEE_TRAVERSABLE_STREAM_CONTINUE);
				break;
			}
		} else {
			_data2_->need_next = TRUE;
		}
		_tmp12_ = _data2_->f;
		_tmp12__target = _data2_->f_target;
		_tmp13_ = gee_lazy_new (g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func, ____lambda8__gee_lazy_func, block3_data_ref (_data3_), block3_data_unref);
		_tmp15_ = _tmp12_ (GEE_TRAVERSABLE_STREAM_CONTINUE, _tmp13_, &_tmp14_, _tmp12__target);
		_gee_lazy_unref0 (val);
		val = _tmp14_;
		_data2_->str = _tmp15_;
	}
	_tmp16_ = _data2_->str;
	switch (_tmp16_) {
		case GEE_TRAVERSABLE_STREAM_YIELD:
		{
			result = val;
			block3_data_unref (_data3_);
			_data3_ = NULL;
			return result;
		}
		case GEE_TRAVERSABLE_STREAM_END:
		{
			result = NULL;
			_gee_lazy_unref0 (val);
			block3_data_unref (_data3_);
			_data3_ = NULL;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_gee_lazy_unref0 (val);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}


static GeeLazy* ___lambda7__gee_unfold_func (gpointer self) {
	GeeLazy* result;
	result = __lambda7_ (self);
	return result;
}


static gpointer _gee_lazy_ref0 (gpointer self) {
	return self ? gee_lazy_ref (self) : NULL;
}


GeeIterator* gee_iterator_stream_impl (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeIterator* _self_, GeeStreamFunc f, void* f_target, GDestroyNotify f_target_destroy_notify) {
	GeeIterator* result = NULL;
	Block2Data* _data2_;
	GeeIterator* _tmp0_;
	GeeIterator* _tmp1_;
	GeeStreamFunc _tmp2_;
	void* _tmp2__target;
	GeeLazy* initial;
	GeeStreamFunc _tmp3_;
	void* _tmp3__target;
	GeeLazy* _tmp4_ = NULL;
	GeeTraversableStream _tmp5_ = 0;
	GeeTraversableStream _tmp6_;
	GeeLazy* _tmp20_;
	GeeLazy* _tmp21_;
	GeeIterator* _tmp22_ = NULL;
	g_return_val_if_fail (_self_ != NULL, NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->g_type = g_type;
	_data2_->g_dup_func = g_dup_func;
	_data2_->g_destroy_func = g_destroy_func;
	_data2_->a_type = a_type;
	_data2_->a_dup_func = a_dup_func;
	_data2_->a_destroy_func = a_destroy_func;
	_tmp0_ = _self_;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_data2_->_self_ = _tmp1_;
	_tmp2_ = f;
	_tmp2__target = f_target;
	(_data2_->f_target_destroy_notify == NULL) ? NULL : (_data2_->f_target_destroy_notify (_data2_->f_target), NULL);
	_data2_->f = NULL;
	_data2_->f_target = NULL;
	_data2_->f_target_destroy_notify = NULL;
	_data2_->f = _tmp2_;
	_data2_->f_target = _tmp2__target;
	_data2_->f_target_destroy_notify = f_target_destroy_notify;
	initial = NULL;
	_data2_->need_next = TRUE;
	_tmp3_ = _data2_->f;
	_tmp3__target = _data2_->f_target;
	_tmp5_ = _tmp3_ (GEE_TRAVERSABLE_STREAM_YIELD, NULL, &_tmp4_, _tmp3__target);
	_gee_lazy_unref0 (initial);
	initial = _tmp4_;
	_data2_->str = _tmp5_;
	_tmp6_ = _data2_->str;
	switch (_tmp6_) {
		case GEE_TRAVERSABLE_STREAM_CONTINUE:
		{
			GeeIterator* _tmp7_;
			gboolean _tmp8_;
			gboolean _tmp9_;
			_tmp7_ = _data2_->_self_;
			_tmp8_ = gee_iterator_get_valid (_tmp7_);
			_tmp9_ = _tmp8_;
			if (_tmp9_) {
				GeeStreamFunc _tmp10_;
				void* _tmp10__target;
				GeeLazy* _tmp11_;
				GeeLazy* _tmp12_ = NULL;
				GeeTraversableStream _tmp13_ = 0;
				GeeTraversableStream _tmp14_;
				_tmp10_ = _data2_->f;
				_tmp10__target = _data2_->f_target;
				_tmp11_ = gee_lazy_new (g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func, _____lambda2__gee_lazy_func, block2_data_ref (_data2_), block2_data_unref);
				_tmp13_ = _tmp10_ (GEE_TRAVERSABLE_STREAM_CONTINUE, _tmp11_, &_tmp12_, _tmp10__target);
				_gee_lazy_unref0 (initial);
				initial = _tmp12_;
				_data2_->str = _tmp13_;
				_tmp14_ = _data2_->str;
				switch (_tmp14_) {
					case GEE_TRAVERSABLE_STREAM_YIELD:
					case GEE_TRAVERSABLE_STREAM_CONTINUE:
					{
						break;
					}
					case GEE_TRAVERSABLE_STREAM_END:
					{
						GeeIterator* _tmp15_ = NULL;
						_tmp15_ = gee_iterator_unfold (a_type, (GBoxedCopyFunc) a_dup_func, a_destroy_func, ______lambda5__gee_unfold_func, block2_data_ref (_data2_), block2_data_unref, NULL);
						result = _tmp15_;
						_gee_lazy_unref0 (initial);
						block2_data_unref (_data2_);
						_data2_ = NULL;
						return result;
					}
					default:
					{
						g_assert_not_reached ();
					}
				}
			}
			break;
		}
		case GEE_TRAVERSABLE_STREAM_YIELD:
		{
			GeeIterator* _tmp16_;
			gboolean _tmp17_;
			gboolean _tmp18_;
			_tmp16_ = _data2_->_self_;
			_tmp17_ = gee_iterator_get_valid (_tmp16_);
			_tmp18_ = _tmp17_;
			if (_tmp18_) {
				_data2_->need_next = FALSE;
			}
			break;
		}
		case GEE_TRAVERSABLE_STREAM_END:
		{
			GeeIterator* _tmp19_ = NULL;
			_tmp19_ = gee_iterator_unfold (a_type, (GBoxedCopyFunc) a_dup_func, a_destroy_func, ____lambda6__gee_unfold_func, block2_data_ref (_data2_), block2_data_unref, NULL);
			result = _tmp19_;
			_gee_lazy_unref0 (initial);
			block2_data_unref (_data2_);
			_data2_ = NULL;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_tmp20_ = initial;
	_tmp21_ = _gee_lazy_ref0 (_tmp20_);
	_tmp22_ = gee_iterator_unfold (a_type, (GBoxedCopyFunc) a_dup_func, a_destroy_func, ___lambda7__gee_unfold_func, block2_data_ref (_data2_), block2_data_unref, _tmp21_);
	result = _tmp22_;
	_gee_lazy_unref0 (initial);
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return result;
}


/**
 * Create iterator from unfolding function. The lazy value is
         * force-evaluated before progressing to next element.
         *
         * @param f Unfolding function
         * @param current If iterator is to be valid it contains the current value of it
 */
GeeIterator* gee_iterator_unfold (GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeUnfoldFunc f, void* f_target, GDestroyNotify f_target_destroy_notify, GeeLazy* current) {
	GeeIterator* result = NULL;
	GeeUnfoldFunc _tmp0_;
	void* _tmp0__target;
	GDestroyNotify _tmp0__target_destroy_notify;
	GeeLazy* _tmp1_;
	GeeUnfoldIterator* _tmp2_;
	_tmp0_ = f;
	_tmp0__target = f_target;
	_tmp0__target_destroy_notify = f_target_destroy_notify;
	f_target_destroy_notify = NULL;
	_tmp1_ = current;
	current = NULL;
	_tmp2_ = gee_unfold_iterator_new (a_type, (GBoxedCopyFunc) a_dup_func, a_destroy_func, _tmp0_, _tmp0__target, _tmp0__target_destroy_notify, _tmp1_);
	result = (GeeIterator*) _tmp2_;
	(f_target_destroy_notify == NULL) ? NULL : (f_target_destroy_notify (f_target), NULL);
	f = NULL;
	f_target = NULL;
	f_target_destroy_notify = NULL;
	_gee_lazy_unref0 (current);
	return result;
}


/**
 * Concatinate iterators.
 *
 * @param iters Iterators of iterators
 * @return Iterator containg values of each iterator
 */
static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (Block4Data* _data4_) {
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		GType g_type;
		GBoxedCopyFunc g_dup_func;
		GDestroyNotify g_destroy_func;
		g_type = _data4_->g_type;
		g_dup_func = _data4_->g_dup_func;
		g_destroy_func = _data4_->g_destroy_func;
		_g_object_unref0 (_data4_->current);
		_g_object_unref0 (_data4_->iters);
		g_slice_free (Block4Data, _data4_);
	}
}


static GeeLazy* __lambda9_ (Block4Data* _data4_) {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GeeLazy* result = NULL;
	g_type = _data4_->g_type;
	g_dup_func = _data4_->g_dup_func;
	g_destroy_func = _data4_->g_destroy_func;
	while (TRUE) {
		GeeIterator* _tmp0_;
		_tmp0_ = _data4_->current;
		if (_tmp0_ == NULL) {
			GeeIterator* _tmp1_;
			gboolean _tmp2_ = FALSE;
			_tmp1_ = _data4_->iters;
			_tmp2_ = gee_iterator_next (_tmp1_);
			if (_tmp2_) {
				GeeIterator* _tmp3_;
				gpointer _tmp4_ = NULL;
				_tmp3_ = _data4_->iters;
				_tmp4_ = gee_iterator_get (_tmp3_);
				_g_object_unref0 (_data4_->current);
				_data4_->current = (GeeIterator*) _tmp4_;
			} else {
				result = NULL;
				return result;
			}
		} else {
			GeeIterator* _tmp5_;
			gboolean _tmp6_ = FALSE;
			_tmp5_ = _data4_->current;
			_tmp6_ = gee_iterator_next (_tmp5_);
			if (_tmp6_) {
				GeeIterator* _tmp7_;
				gpointer _tmp8_ = NULL;
				gpointer _tmp9_;
				GeeLazy* _tmp10_;
				GeeLazy* _tmp11_;
				_tmp7_ = _data4_->current;
				_tmp8_ = gee_iterator_get (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = gee_lazy_new_from_value (g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func, _tmp9_);
				_tmp11_ = _tmp10_;
				_g_destroy_func0 (_tmp9_);
				result = _tmp11_;
				return result;
			} else {
				_g_object_unref0 (_data4_->current);
				_data4_->current = NULL;
			}
		}
	}
}


static GeeLazy* ___lambda9__gee_unfold_func (gpointer self) {
	GeeLazy* result;
	result = __lambda9_ (self);
	return result;
}


GeeIterator* gee_iterator_concat (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeIterator* iters) {
	GeeIterator* result = NULL;
	Block4Data* _data4_;
	GeeIterator* _tmp0_;
	GeeIterator* _tmp1_;
	GeeIterator* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GeeIterator* _tmp7_ = NULL;
	g_return_val_if_fail (iters != NULL, NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->g_type = g_type;
	_data4_->g_dup_func = g_dup_func;
	_data4_->g_destroy_func = g_destroy_func;
	_tmp0_ = iters;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_data4_->iters = _tmp1_;
	_data4_->current = NULL;
	_tmp2_ = _data4_->iters;
	_tmp3_ = gee_iterator_get_valid (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		GeeIterator* _tmp5_;
		gpointer _tmp6_ = NULL;
		_tmp5_ = _data4_->iters;
		_tmp6_ = gee_iterator_get (_tmp5_);
		_g_object_unref0 (_data4_->current);
		_data4_->current = (GeeIterator*) _tmp6_;
	}
	_tmp7_ = gee_iterator_unfold (g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func, ___lambda9__gee_unfold_func, block4_data_ref (_data4_), block4_data_unref, NULL);
	result = _tmp7_;
	block4_data_unref (_data4_);
	_data4_ = NULL;
	return result;
}


gboolean gee_iterator_get_valid (GeeIterator* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GEE_ITERATOR_GET_INTERFACE (self)->get_valid (self);
}


gboolean gee_iterator_get_read_only (GeeIterator* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GEE_ITERATOR_GET_INTERFACE (self)->get_read_only (self);
}


static void gee_iterator_base_init (GeeIteratorIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		/**
		 * Determines wheather the call to {@link get} is legal. It is false at the
		 * beginning and after {@link remove} call and true otherwise.
		 */
		g_object_interface_install_property (iface, g_param_spec_boolean ("valid", "valid", "valid", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		/**
		 * Determines wheather the call to {@link remove} is legal assuming the
		 * iterator is valid. The value must not change in runtime hence the user
		 * of iterator may cache it.
		 */
		g_object_interface_install_property (iface, g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	}
}


/**
 * An iterator over a collection.
 *
 * Gee's iterators are "on-track" iterators. They always point to an item
 * except before the first call to {@link next}, or, when an
 * item has been removed, until the next call to {@link next}.
 *
 * Please note that when the iterator is out of track, neither {@link get} nor
 * {@link remove} are defined and both will fail. After the next call to
 * {@link next}, they will be defined again.
 */
GType gee_iterator_get_type (void) {
	static volatile gsize gee_iterator_type_id__volatile = 0;
	if (g_once_init_enter (&gee_iterator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeIteratorIface), (GBaseInitFunc) gee_iterator_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType gee_iterator_type_id;
		gee_iterator_type_id = g_type_register_static (G_TYPE_INTERFACE, "GeeIterator", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (gee_iterator_type_id, G_TYPE_OBJECT);
		g_type_interface_add_prerequisite (gee_iterator_type_id, GEE_TYPE_TRAVERSABLE);
		g_once_init_leave (&gee_iterator_type_id__volatile, gee_iterator_type_id);
	}
	return gee_iterator_type_id__volatile;
}



