/* timsort.c generated by valac 0.17.3.32-37ac, the Vala compiler
 * generated from timsort.vala, do not modify */

/* timsort.vala
 *
 * Copyright (C) 2009  Didier Villevalois
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Didier 'Ptitjes Villevalois <ptitjes@free.fr>
 */

#include <glib.h>
#include <glib-object.h>
#include <string.h>


#define GEE_TYPE_TIM_SORT (gee_tim_sort_get_type ())
#define GEE_TIM_SORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_TIM_SORT, GeeTimSort))
#define GEE_TIM_SORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_TIM_SORT, GeeTimSortClass))
#define GEE_IS_TIM_SORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_TIM_SORT))
#define GEE_IS_TIM_SORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_TIM_SORT))
#define GEE_TIM_SORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_TIM_SORT, GeeTimSortClass))

typedef struct _GeeTimSort GeeTimSort;
typedef struct _GeeTimSortClass GeeTimSortClass;
typedef struct _GeeTimSortPrivate GeeTimSortPrivate;

#define GEE_TYPE_TRAVERSABLE (gee_traversable_get_type ())
#define GEE_TRAVERSABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_TRAVERSABLE, GeeTraversable))
#define GEE_IS_TRAVERSABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_TRAVERSABLE))
#define GEE_TRAVERSABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_TRAVERSABLE, GeeTraversableIface))

typedef struct _GeeTraversable GeeTraversable;
typedef struct _GeeTraversableIface GeeTraversableIface;

#define GEE_TRAVERSABLE_TYPE_STREAM (gee_traversable_stream_get_type ())

#define GEE_TYPE_LAZY (gee_lazy_get_type ())
#define GEE_LAZY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_LAZY, GeeLazy))
#define GEE_LAZY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_LAZY, GeeLazyClass))
#define GEE_IS_LAZY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_LAZY))
#define GEE_IS_LAZY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_LAZY))
#define GEE_LAZY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_LAZY, GeeLazyClass))

typedef struct _GeeLazy GeeLazy;
typedef struct _GeeLazyClass GeeLazyClass;

#define GEE_TYPE_ITERATOR (gee_iterator_get_type ())
#define GEE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERATOR, GeeIterator))
#define GEE_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERATOR))
#define GEE_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERATOR, GeeIteratorIface))

typedef struct _GeeIterator GeeIterator;
typedef struct _GeeIteratorIface GeeIteratorIface;

#define GEE_TYPE_ITERABLE (gee_iterable_get_type ())
#define GEE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERABLE, GeeIterable))
#define GEE_IS_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERABLE))
#define GEE_ITERABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERABLE, GeeIterableIface))

typedef struct _GeeIterable GeeIterable;
typedef struct _GeeIterableIface GeeIterableIface;

#define GEE_TYPE_COLLECTION (gee_collection_get_type ())
#define GEE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_COLLECTION, GeeCollection))
#define GEE_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_COLLECTION))
#define GEE_COLLECTION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_COLLECTION, GeeCollectionIface))

typedef struct _GeeCollection GeeCollection;
typedef struct _GeeCollectionIface GeeCollectionIface;

#define GEE_TYPE_LIST (gee_list_get_type ())
#define GEE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_LIST, GeeList))
#define GEE_IS_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_LIST))
#define GEE_LIST_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_LIST, GeeListIface))

typedef struct _GeeList GeeList;
typedef struct _GeeListIface GeeListIface;

#define GEE_TYPE_LIST_ITERATOR (gee_list_iterator_get_type ())
#define GEE_LIST_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_LIST_ITERATOR, GeeListIterator))
#define GEE_IS_LIST_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_LIST_ITERATOR))
#define GEE_LIST_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_LIST_ITERATOR, GeeListIteratorIface))

typedef struct _GeeListIterator GeeListIterator;
typedef struct _GeeListIteratorIface GeeListIteratorIface;
typedef struct _GeeTimSortSlice GeeTimSortSlice;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GEE_TYPE_ABSTRACT_COLLECTION (gee_abstract_collection_get_type ())
#define GEE_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection))
#define GEE_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))
#define GEE_IS_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_IS_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_ABSTRACT_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))

typedef struct _GeeAbstractCollection GeeAbstractCollection;
typedef struct _GeeAbstractCollectionClass GeeAbstractCollectionClass;

#define GEE_TYPE_ABSTRACT_LIST (gee_abstract_list_get_type ())
#define GEE_ABSTRACT_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_LIST, GeeAbstractList))
#define GEE_ABSTRACT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_LIST, GeeAbstractListClass))
#define GEE_IS_ABSTRACT_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_LIST))
#define GEE_IS_ABSTRACT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_LIST))
#define GEE_ABSTRACT_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_LIST, GeeAbstractListClass))

typedef struct _GeeAbstractList GeeAbstractList;
typedef struct _GeeAbstractListClass GeeAbstractListClass;

#define GEE_TYPE_ABSTRACT_BIDIR_LIST (gee_abstract_bidir_list_get_type ())
#define GEE_ABSTRACT_BIDIR_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_BIDIR_LIST, GeeAbstractBidirList))
#define GEE_ABSTRACT_BIDIR_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_BIDIR_LIST, GeeAbstractBidirListClass))
#define GEE_IS_ABSTRACT_BIDIR_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_BIDIR_LIST))
#define GEE_IS_ABSTRACT_BIDIR_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_BIDIR_LIST))
#define GEE_ABSTRACT_BIDIR_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_BIDIR_LIST, GeeAbstractBidirListClass))

typedef struct _GeeAbstractBidirList GeeAbstractBidirList;
typedef struct _GeeAbstractBidirListClass GeeAbstractBidirListClass;

#define GEE_TYPE_ARRAY_LIST (gee_array_list_get_type ())
#define GEE_ARRAY_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ARRAY_LIST, GeeArrayList))
#define GEE_ARRAY_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ARRAY_LIST, GeeArrayListClass))
#define GEE_IS_ARRAY_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ARRAY_LIST))
#define GEE_IS_ARRAY_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ARRAY_LIST))
#define GEE_ARRAY_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ARRAY_LIST, GeeArrayListClass))

typedef struct _GeeArrayList GeeArrayList;
typedef struct _GeeArrayListClass GeeArrayListClass;
#define _g_destroy_func0(var) (((var == NULL) || (g_destroy_func == NULL)) ? NULL : (var = (g_destroy_func (var), NULL)))
typedef struct _GeeAbstractCollectionPrivate GeeAbstractCollectionPrivate;
typedef struct _GeeAbstractListPrivate GeeAbstractListPrivate;

#define GEE_TYPE_BIDIR_LIST (gee_bidir_list_get_type ())
#define GEE_BIDIR_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_BIDIR_LIST, GeeBidirList))
#define GEE_IS_BIDIR_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_BIDIR_LIST))
#define GEE_BIDIR_LIST_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_BIDIR_LIST, GeeBidirListIface))

typedef struct _GeeBidirList GeeBidirList;
typedef struct _GeeBidirListIface GeeBidirListIface;

#define GEE_TYPE_BIDIR_ITERATOR (gee_bidir_iterator_get_type ())
#define GEE_BIDIR_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_BIDIR_ITERATOR, GeeBidirIterator))
#define GEE_IS_BIDIR_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_BIDIR_ITERATOR))
#define GEE_BIDIR_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_BIDIR_ITERATOR, GeeBidirIteratorIface))

typedef struct _GeeBidirIterator GeeBidirIterator;
typedef struct _GeeBidirIteratorIface GeeBidirIteratorIface;

#define GEE_TYPE_BIDIR_LIST_ITERATOR (gee_bidir_list_iterator_get_type ())
#define GEE_BIDIR_LIST_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_BIDIR_LIST_ITERATOR, GeeBidirListIterator))
#define GEE_IS_BIDIR_LIST_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_BIDIR_LIST_ITERATOR))
#define GEE_BIDIR_LIST_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_BIDIR_LIST_ITERATOR, GeeBidirListIteratorIface))

typedef struct _GeeBidirListIterator GeeBidirListIterator;
typedef struct _GeeBidirListIteratorIface GeeBidirListIteratorIface;
typedef struct _GeeAbstractBidirListPrivate GeeAbstractBidirListPrivate;
typedef struct _GeeArrayListPrivate GeeArrayListPrivate;
#define _gee_tim_sort_slice_free0(var) ((var == NULL) ? NULL : (var = (gee_tim_sort_slice_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GeeTimSort {
	GObject parent_instance;
	GeeTimSortPrivate * priv;
};

struct _GeeTimSortClass {
	GObjectClass parent_class;
};

typedef void (*GeeForallFunc) (gpointer g, void* user_data);
typedef enum  {
	GEE_TRAVERSABLE_STREAM_YIELD,
	GEE_TRAVERSABLE_STREAM_CONTINUE,
	GEE_TRAVERSABLE_STREAM_END
} GeeTraversableStream;

typedef GeeTraversableStream (*GeeStreamFunc) (GeeTraversableStream state, GeeLazy* g, GeeLazy** lazy, void* user_data);
struct _GeeIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (GeeIterator* self);
	gboolean (*has_next) (GeeIterator* self);
	gpointer (*get) (GeeIterator* self);
	void (*remove) (GeeIterator* self);
	gboolean (*get_valid) (GeeIterator* self);
	gboolean (*get_read_only) (GeeIterator* self);
};

typedef gpointer (*GeeFoldFunc) (gpointer g, gpointer a, void* user_data);
typedef gpointer (*GeeMapFunc) (gpointer g, void* user_data);
typedef gboolean (*GeePredicate) (gconstpointer g, void* user_data);
struct _GeeTraversableIface {
	GTypeInterface parent_iface;
	void (*foreach) (GeeTraversable* self, GeeForallFunc f, void* f_target);
	GeeIterator* (*stream) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeStreamFunc f, void* f_target, GDestroyNotify f_target_destroy_notify);
	gpointer (*fold) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed);
	GeeIterator* (*map) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeMapFunc f, void* f_target);
	GeeIterator* (*scan) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed);
	GeeIterator* (*filter) (GeeTraversable* self, GeePredicate f, void* f_target, GDestroyNotify f_target_destroy_notify);
	GeeIterator* (*chop) (GeeTraversable* self, gint offset, gint length);
};

struct _GeeIterableIface {
	GTypeInterface parent_iface;
	GeeIterator* (*iterator) (GeeIterable* self);
	GType (*get_element_type) (GeeIterable* self);
};

struct _GeeCollectionIface {
	GTypeInterface parent_iface;
	gboolean (*contains) (GeeCollection* self, gconstpointer item);
	gboolean (*add) (GeeCollection* self, gconstpointer item);
	gboolean (*remove) (GeeCollection* self, gconstpointer item);
	void (*clear) (GeeCollection* self);
	gboolean (*add_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeCollection* self, GeeCollection* collection);
	gpointer* (*to_array) (GeeCollection* self, int* result_length1);
	gint (*get_size) (GeeCollection* self);
	gboolean (*get_is_empty) (GeeCollection* self);
	gboolean (*get_read_only) (GeeCollection* self);
	GeeCollection* (*get_read_only_view) (GeeCollection* self);
};

struct _GeeListIteratorIface {
	GTypeInterface parent_iface;
	void (*set) (GeeListIterator* self, gconstpointer item);
	void (*add) (GeeListIterator* self, gconstpointer item);
	gint (*index) (GeeListIterator* self);
};

struct _GeeListIface {
	GTypeInterface parent_iface;
	GeeListIterator* (*list_iterator) (GeeList* self);
	gpointer (*get) (GeeList* self, gint index);
	void (*set) (GeeList* self, gint index, gconstpointer item);
	gint (*index_of) (GeeList* self, gconstpointer item);
	void (*insert) (GeeList* self, gint index, gconstpointer item);
	gpointer (*remove_at) (GeeList* self, gint index);
	GeeList* (*slice) (GeeList* self, gint start, gint stop);
	gpointer (*first) (GeeList* self);
	gpointer (*last) (GeeList* self);
	void (*insert_all) (GeeList* self, gint index, GeeCollection* collection);
	void (*sort) (GeeList* self, GCompareDataFunc compare_func, void* compare_func_target, GDestroyNotify compare_func_target_destroy_notify);
	GeeList* (*get_read_only_view) (GeeList* self);
};

struct _GeeTimSortPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GeeList* list_collection;
	gpointer* array;
	gint array_length1;
	gint _array_size_;
	void** list;
	gint index;
	gint size;
	GeeTimSortSlice** pending;
	gint pending_length1;
	gint _pending_size_;
	gint minimum_gallop;
	GCompareDataFunc compare;
	gpointer compare_target;
	GDestroyNotify compare_target_destroy_notify;
};

struct _GeeAbstractCollection {
	GObject parent_instance;
	GeeAbstractCollectionPrivate * priv;
};

struct _GeeAbstractCollectionClass {
	GObjectClass parent_class;
	gboolean (*contains) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*add) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*remove) (GeeAbstractCollection* self, gconstpointer item);
	void (*clear) (GeeAbstractCollection* self);
	gpointer* (*to_array) (GeeAbstractCollection* self, int* result_length1);
	gboolean (*add_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeAbstractCollection* self, GeeCollection* collection);
	GeeIterator* (*iterator) (GeeAbstractCollection* self);
	void (*foreach) (GeeAbstractCollection* self, GeeForallFunc f, void* f_target);
	GeeIterator* (*stream) (GeeAbstractCollection* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeStreamFunc f, void* f_target, GDestroyNotify f_target_destroy_notify);
	GeeIterator* (*filter) (GeeAbstractCollection* self, GeePredicate f, void* f_target, GDestroyNotify f_target_destroy_notify);
	GeeIterator* (*chop) (GeeAbstractCollection* self, gint offset, gint length);
	gint (*get_size) (GeeAbstractCollection* self);
	gboolean (*get_is_empty) (GeeAbstractCollection* self);
	gboolean (*get_read_only) (GeeAbstractCollection* self);
	GeeCollection* (*get_read_only_view) (GeeAbstractCollection* self);
};

struct _GeeAbstractList {
	GeeAbstractCollection parent_instance;
	GeeAbstractListPrivate * priv;
};

struct _GeeAbstractListClass {
	GeeAbstractCollectionClass parent_class;
	GeeListIterator* (*list_iterator) (GeeAbstractList* self);
	gpointer (*get) (GeeAbstractList* self, gint index);
	void (*set) (GeeAbstractList* self, gint index, gconstpointer item);
	gint (*index_of) (GeeAbstractList* self, gconstpointer item);
	void (*insert) (GeeAbstractList* self, gint index, gconstpointer item);
	gpointer (*remove_at) (GeeAbstractList* self, gint index);
	GeeList* (*slice) (GeeAbstractList* self, gint start, gint stop);
	gpointer (*first) (GeeAbstractList* self);
	gpointer (*last) (GeeAbstractList* self);
	void (*insert_all) (GeeAbstractList* self, gint index, GeeCollection* collection);
	GeeList* (*get_read_only_view) (GeeAbstractList* self);
};

struct _GeeBidirIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*previous) (GeeBidirIterator* self);
	gboolean (*has_previous) (GeeBidirIterator* self);
	gboolean (*first) (GeeBidirIterator* self);
	gboolean (*last) (GeeBidirIterator* self);
};

struct _GeeBidirListIteratorIface {
	GTypeInterface parent_iface;
	void (*insert) (GeeBidirListIterator* self, gconstpointer item);
};

struct _GeeBidirListIface {
	GTypeInterface parent_iface;
	GeeBidirListIterator* (*bidir_list_iterator) (GeeBidirList* self);
	GeeBidirList* (*get_read_only_view) (GeeBidirList* self);
};

struct _GeeAbstractBidirList {
	GeeAbstractList parent_instance;
	GeeAbstractBidirListPrivate * priv;
};

struct _GeeAbstractBidirListClass {
	GeeAbstractListClass parent_class;
	GeeBidirListIterator* (*bidir_list_iterator) (GeeAbstractBidirList* self);
	GeeBidirList* (*get_read_only_view) (GeeAbstractBidirList* self);
};

struct _GeeArrayList {
	GeeAbstractBidirList parent_instance;
	GeeArrayListPrivate * priv;
	gpointer* _items;
	gint _items_length1;
	gint __items_size_;
	gint _size;
};

struct _GeeArrayListClass {
	GeeAbstractBidirListClass parent_class;
};

struct _GeeTimSortSlice {
	void** list;
	void** new_list;
	gint index;
	gint length;
};

typedef gboolean (*GeeTimSortLowerFunc) (gconstpointer left, gconstpointer right, void* user_data);

static gpointer gee_tim_sort_parent_class = NULL;

GType gee_tim_sort_get_type (void) G_GNUC_CONST;
GType gee_traversable_stream_get_type (void) G_GNUC_CONST;
gpointer gee_lazy_ref (gpointer instance);
void gee_lazy_unref (gpointer instance);
GParamSpec* gee_param_spec_lazy (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gee_value_set_lazy (GValue* value, gpointer v_object);
void gee_value_take_lazy (GValue* value, gpointer v_object);
gpointer gee_value_get_lazy (const GValue* value);
GType gee_lazy_get_type (void) G_GNUC_CONST;
GType gee_iterator_get_type (void) G_GNUC_CONST;
GType gee_traversable_get_type (void) G_GNUC_CONST;
GType gee_iterable_get_type (void) G_GNUC_CONST;
GType gee_collection_get_type (void) G_GNUC_CONST;
GType gee_list_iterator_get_type (void) G_GNUC_CONST;
GType gee_list_get_type (void) G_GNUC_CONST;
static void gee_tim_sort_slice_free (GeeTimSortSlice* self);
#define GEE_TIM_SORT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_TYPE_TIM_SORT, GeeTimSortPrivate))
enum  {
	GEE_TIM_SORT_DUMMY_PROPERTY,
	GEE_TIM_SORT_G_TYPE,
	GEE_TIM_SORT_G_DUP_FUNC,
	GEE_TIM_SORT_G_DESTROY_FUNC
};
#define GEE_TIM_SORT_MINIMUM_GALLOP 7
void gee_tim_sort_sort (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeList* list, GCompareDataFunc compare, void* compare_target);
GType gee_abstract_collection_get_type (void) G_GNUC_CONST;
GType gee_abstract_list_get_type (void) G_GNUC_CONST;
GType gee_abstract_bidir_list_get_type (void) G_GNUC_CONST;
GType gee_array_list_get_type (void) G_GNUC_CONST;
static void gee_tim_sort_sort_arraylist (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeArrayList* list, GCompareDataFunc compare, void* compare_target);
static void gee_tim_sort_sort_list (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeList* list, GCompareDataFunc compare, void* compare_target);
GeeTimSort* gee_tim_sort_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
GeeTimSort* gee_tim_sort_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
gpointer* gee_collection_to_array (GeeCollection* self, int* result_length1);
gint gee_collection_get_size (GeeCollection* self);
static void gee_tim_sort_do_sort (GeeTimSort* self);
void gee_collection_clear (GeeCollection* self);
gboolean gee_collection_add (GeeCollection* self, gconstpointer item);
GType gee_bidir_iterator_get_type (void) G_GNUC_CONST;
GType gee_bidir_list_iterator_get_type (void) G_GNUC_CONST;
GType gee_bidir_list_get_type (void) G_GNUC_CONST;
static GeeTimSortSlice* gee_tim_sort_slice_new (void** list, gint index, gint length);
static GeeTimSortSlice* gee_tim_sort_slice_new (void** list, gint index, gint length);
static gint gee_tim_sort_compute_minimum_run_length (GeeTimSort* self, gint length);
static GeeTimSortSlice* gee_tim_sort_compute_longest_run (GeeTimSort* self, GeeTimSortSlice* a, gboolean* descending);
static void gee_tim_sort_slice_reverse (GeeTimSortSlice* self);
static void gee_tim_sort_insertion_sort (GeeTimSort* self, GeeTimSortSlice* a, gint offset);
static inline void gee_tim_sort_slice_shorten_start (GeeTimSortSlice* self, gint n);
static void _vala_array_add1 (GeeTimSortSlice*** array, int* length, int* size, GeeTimSortSlice* value);
static void gee_tim_sort_merge_collapse (GeeTimSort* self);
static void gee_tim_sort_merge_force_collapse (GeeTimSort* self);
static inline gboolean gee_tim_sort_lower_than (GeeTimSort* self, gconstpointer left, gconstpointer right);
static inline gboolean gee_tim_sort_lower_than_or_equal_to (GeeTimSort* self, gconstpointer left, gconstpointer right);
static void gee_tim_sort_merge_at (GeeTimSort* self, gint index);
static gint gee_tim_sort_gallop_rightmost (GeeTimSort* self, gconstpointer key, GeeTimSortSlice* a, gint hint);
static inline void* gee_tim_sort_slice_peek_first (GeeTimSortSlice* self);
static gint gee_tim_sort_gallop_leftmost (GeeTimSort* self, gconstpointer key, GeeTimSortSlice* a, gint hint);
static inline void* gee_tim_sort_slice_peek_last (GeeTimSortSlice* self);
static void gee_tim_sort_merge_low (GeeTimSort* self, GeeTimSortSlice* a, GeeTimSortSlice* b);
static void gee_tim_sort_merge_high (GeeTimSort* self, GeeTimSortSlice* a, GeeTimSortSlice* b);
static void gee_tim_sort_slice_copy (GeeTimSortSlice* self);
static inline void* gee_tim_sort_slice_pop_first (GeeTimSortSlice* self);
static inline void gee_tim_sort_slice_merge_in (GeeTimSortSlice* self, void** dest_array, gint index, gint dest_index, gint count);
static inline void* gee_tim_sort_slice_pop_last (GeeTimSortSlice* self);
static inline void gee_tim_sort_slice_merge_in_reversed (GeeTimSortSlice* self, void** dest_array, gint index, gint dest_index, gint count);
static inline void gee_tim_sort_slice_shorten_end (GeeTimSortSlice* self, gint n);
static void gee_tim_sort_slice_instance_init (GeeTimSortSlice * self);
static inline void gee_tim_sort_slice_swap (GeeTimSortSlice* self, gint i, gint j);
static void gee_tim_sort_finalize (GObject* obj);
static void _vala_gee_tim_sort_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gee_tim_sort_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_move (gpointer array, gsize element_size, gint src, gint dest, gint length);


void gee_tim_sort_sort (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeList* list, GCompareDataFunc compare, void* compare_target) {
	GeeList* _tmp0_;
	g_return_if_fail (list != NULL);
	_tmp0_ = list;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GEE_TYPE_ARRAY_LIST)) {
		GeeList* _tmp1_;
		GCompareDataFunc _tmp2_;
		void* _tmp2__target;
		_tmp1_ = list;
		_tmp2_ = compare;
		_tmp2__target = compare_target;
		gee_tim_sort_sort_arraylist (g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func, G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ARRAY_LIST, GeeArrayList), _tmp2_, _tmp2__target);
	} else {
		GeeList* _tmp3_;
		GCompareDataFunc _tmp4_;
		void* _tmp4__target;
		_tmp3_ = list;
		_tmp4_ = compare;
		_tmp4__target = compare_target;
		gee_tim_sort_sort_list (g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func, _tmp3_, _tmp4_, _tmp4__target);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void gee_tim_sort_sort_list (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeList* list, GCompareDataFunc compare, void* compare_target) {
	GeeTimSort* _tmp0_;
	GeeTimSort* helper;
	GeeTimSort* _tmp1_;
	GeeList* _tmp2_;
	GeeList* _tmp3_;
	GeeTimSort* _tmp4_;
	GeeList* _tmp5_;
	gint _tmp6_ = 0;
	gpointer* _tmp7_ = NULL;
	GeeTimSort* _tmp8_;
	GeeTimSort* _tmp9_;
	gpointer* _tmp10_;
	gint _tmp10__length1;
	GeeTimSort* _tmp11_;
	GeeTimSort* _tmp12_;
	GeeList* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	GeeTimSort* _tmp16_;
	GCompareDataFunc _tmp17_;
	void* _tmp17__target;
	GeeTimSort* _tmp18_;
	GeeList* _tmp19_;
	GeeTimSort* _tmp20_;
	gpointer* _tmp21_;
	gint _tmp21__length1;
	g_return_if_fail (list != NULL);
	_tmp0_ = gee_tim_sort_new (g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func);
	helper = _tmp0_;
	_tmp1_ = helper;
	_tmp2_ = list;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (_tmp1_->priv->list_collection);
	_tmp1_->priv->list_collection = _tmp3_;
	_tmp4_ = helper;
	_tmp5_ = list;
	_tmp7_ = gee_collection_to_array ((GeeCollection*) _tmp5_, &_tmp6_);
	_tmp4_->priv->array = (_vala_array_free (_tmp4_->priv->array, _tmp4_->priv->array_length1, (GDestroyNotify) g_destroy_func), NULL);
	_tmp4_->priv->array = _tmp7_;
	_tmp4_->priv->array_length1 = _tmp6_;
	_tmp4_->priv->_array_size_ = _tmp4_->priv->array_length1;
	_tmp8_ = helper;
	_tmp9_ = helper;
	_tmp10_ = _tmp9_->priv->array;
	_tmp10__length1 = _tmp9_->priv->array_length1;
	_tmp8_->priv->list = _tmp10_;
	_tmp11_ = helper;
	_tmp11_->priv->index = 0;
	_tmp12_ = helper;
	_tmp13_ = list;
	_tmp14_ = gee_collection_get_size ((GeeCollection*) _tmp13_);
	_tmp15_ = _tmp14_;
	_tmp12_->priv->size = _tmp15_;
	_tmp16_ = helper;
	_tmp17_ = compare;
	_tmp17__target = compare_target;
	(_tmp16_->priv->compare_target_destroy_notify == NULL) ? NULL : (_tmp16_->priv->compare_target_destroy_notify (_tmp16_->priv->compare_target), NULL);
	_tmp16_->priv->compare = NULL;
	_tmp16_->priv->compare_target = NULL;
	_tmp16_->priv->compare_target_destroy_notify = NULL;
	_tmp16_->priv->compare = _tmp17_;
	_tmp16_->priv->compare_target = _tmp17__target;
	_tmp16_->priv->compare_target_destroy_notify = NULL;
	_tmp18_ = helper;
	gee_tim_sort_do_sort (_tmp18_);
	_tmp19_ = list;
	gee_collection_clear ((GeeCollection*) _tmp19_);
	_tmp20_ = helper;
	_tmp21_ = _tmp20_->priv->array;
	_tmp21__length1 = _tmp20_->priv->array_length1;
	{
		gpointer* item_collection = NULL;
		gint item_collection_length1 = 0;
		gint _item_collection_size_ = 0;
		gint item_it = 0;
		item_collection = _tmp21_;
		item_collection_length1 = _tmp21__length1;
		for (item_it = 0; item_it < _tmp21__length1; item_it = item_it + 1) {
			gpointer _tmp22_;
			gpointer item = NULL;
			_tmp22_ = ((item_collection[item_it] != NULL) && (g_dup_func != NULL)) ? g_dup_func ((gpointer) item_collection[item_it]) : ((gpointer) item_collection[item_it]);
			item = _tmp22_;
			{
				GeeList* _tmp23_;
				gconstpointer _tmp24_;
				_tmp23_ = list;
				_tmp24_ = item;
				gee_collection_add ((GeeCollection*) _tmp23_, _tmp24_);
				_g_destroy_func0 (item);
			}
		}
	}
	_g_object_unref0 (helper);
}


static void gee_tim_sort_sort_arraylist (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeArrayList* list, GCompareDataFunc compare, void* compare_target) {
	GeeTimSort* _tmp0_;
	GeeTimSort* helper;
	GeeArrayList* _tmp1_;
	GeeList* _tmp2_;
	GeeArrayList* _tmp3_;
	gpointer* _tmp4_;
	gint _tmp4__length1;
	GeeArrayList* _tmp5_;
	gint _tmp6_;
	GCompareDataFunc _tmp7_;
	void* _tmp7__target;
	g_return_if_fail (list != NULL);
	_tmp0_ = gee_tim_sort_new (g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func);
	helper = _tmp0_;
	_tmp1_ = list;
	_tmp2_ = _g_object_ref0 ((GeeList*) _tmp1_);
	_g_object_unref0 (helper->priv->list_collection);
	helper->priv->list_collection = _tmp2_;
	_tmp3_ = list;
	_tmp4_ = _tmp3_->_items;
	_tmp4__length1 = _tmp3_->_items_length1;
	helper->priv->list = _tmp4_;
	helper->priv->index = 0;
	_tmp5_ = list;
	_tmp6_ = _tmp5_->_size;
	helper->priv->size = _tmp6_;
	_tmp7_ = compare;
	_tmp7__target = compare_target;
	(helper->priv->compare_target_destroy_notify == NULL) ? NULL : (helper->priv->compare_target_destroy_notify (helper->priv->compare_target), NULL);
	helper->priv->compare = NULL;
	helper->priv->compare_target = NULL;
	helper->priv->compare_target_destroy_notify = NULL;
	helper->priv->compare = _tmp7_;
	helper->priv->compare_target = _tmp7__target;
	helper->priv->compare_target_destroy_notify = NULL;
	gee_tim_sort_do_sort (helper);
	_g_object_unref0 (helper);
}


static void _vala_array_add1 (GeeTimSortSlice*** array, int* length, int* size, GeeTimSortSlice* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GeeTimSortSlice*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void gee_tim_sort_do_sort (GeeTimSort* self) {
	gint _tmp0_;
	GeeTimSortSlice** _tmp1_ = NULL;
	void** _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GeeTimSortSlice* _tmp5_;
	GeeTimSortSlice* remaining;
	GeeTimSortSlice* _tmp6_;
	gint _tmp7_;
	gint _tmp8_ = 0;
	gint minimum_length;
	GeeTimSortSlice* _tmp33_;
	gint _tmp34_;
	gint _tmp35_;
	GeeTimSortSlice** _tmp36_;
	gint _tmp36__length1;
	GeeTimSortSlice** _tmp37_;
	gint _tmp37__length1;
	GeeTimSortSlice* _tmp38_;
	gint _tmp39_;
	GeeTimSortSlice** _tmp40_;
	gint _tmp40__length1;
	GeeTimSortSlice* _tmp41_;
	gint _tmp42_;
	gint _tmp43_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->size;
	if (_tmp0_ < 2) {
		return;
	}
	_tmp1_ = g_new0 (GeeTimSortSlice*, 0 + 1);
	self->priv->pending = (_vala_array_free (self->priv->pending, self->priv->pending_length1, (GDestroyNotify) gee_tim_sort_slice_free), NULL);
	self->priv->pending = _tmp1_;
	self->priv->pending_length1 = 0;
	self->priv->_pending_size_ = self->priv->pending_length1;
	self->priv->minimum_gallop = GEE_TIM_SORT_MINIMUM_GALLOP;
	_tmp2_ = self->priv->list;
	_tmp3_ = self->priv->index;
	_tmp4_ = self->priv->size;
	_tmp5_ = gee_tim_sort_slice_new (_tmp2_, _tmp3_, _tmp4_);
	remaining = _tmp5_;
	_tmp6_ = remaining;
	_tmp7_ = _tmp6_->length;
	_tmp8_ = gee_tim_sort_compute_minimum_run_length (self, _tmp7_);
	minimum_length = _tmp8_;
	while (TRUE) {
		GeeTimSortSlice* _tmp9_;
		gint _tmp10_;
		gboolean descending = FALSE;
		GeeTimSortSlice* _tmp11_;
		gboolean _tmp12_ = FALSE;
		GeeTimSortSlice* _tmp13_ = NULL;
		GeeTimSortSlice* run;
		gboolean _tmp14_;
		GeeTimSortSlice* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		GeeTimSortSlice* _tmp28_;
		GeeTimSortSlice* _tmp29_;
		gint _tmp30_;
		GeeTimSortSlice** _tmp31_;
		gint _tmp31__length1;
		GeeTimSortSlice* _tmp32_;
		_tmp9_ = remaining;
		_tmp10_ = _tmp9_->length;
		if (!(_tmp10_ > 0)) {
			break;
		}
		_tmp11_ = remaining;
		_tmp13_ = gee_tim_sort_compute_longest_run (self, _tmp11_, &_tmp12_);
		descending = _tmp12_;
		run = _tmp13_;
		_tmp14_ = descending;
		if (_tmp14_) {
			GeeTimSortSlice* _tmp15_;
			_tmp15_ = run;
			gee_tim_sort_slice_reverse (_tmp15_);
		}
		_tmp16_ = run;
		_tmp17_ = _tmp16_->length;
		_tmp18_ = minimum_length;
		if (_tmp17_ < _tmp18_) {
			GeeTimSortSlice* _tmp19_;
			gint _tmp20_;
			gint sorted_count;
			GeeTimSortSlice* _tmp21_;
			gint _tmp22_;
			GeeTimSortSlice* _tmp23_;
			gint _tmp24_;
			gint _tmp25_ = 0;
			GeeTimSortSlice* _tmp26_;
			gint _tmp27_;
			_tmp19_ = run;
			_tmp20_ = _tmp19_->length;
			sorted_count = _tmp20_;
			_tmp21_ = run;
			_tmp22_ = minimum_length;
			_tmp23_ = remaining;
			_tmp24_ = _tmp23_->length;
			_tmp25_ = MIN (_tmp22_, _tmp24_);
			_tmp21_->length = _tmp25_;
			_tmp26_ = run;
			_tmp27_ = sorted_count;
			gee_tim_sort_insertion_sort (self, _tmp26_, _tmp27_);
		}
		_tmp28_ = remaining;
		_tmp29_ = run;
		_tmp30_ = _tmp29_->length;
		gee_tim_sort_slice_shorten_start (_tmp28_, _tmp30_);
		_tmp31_ = self->priv->pending;
		_tmp31__length1 = self->priv->pending_length1;
		_tmp32_ = run;
		run = NULL;
		_vala_array_add1 (&self->priv->pending, &self->priv->pending_length1, &self->priv->_pending_size_, _tmp32_);
		gee_tim_sort_merge_collapse (self);
		_gee_tim_sort_slice_free0 (run);
	}
	_tmp33_ = remaining;
	_tmp34_ = _tmp33_->index;
	_tmp35_ = self->priv->size;
	_vala_assert (_tmp34_ == _tmp35_, "remaining.index == size");
	gee_tim_sort_merge_force_collapse (self);
	_tmp36_ = self->priv->pending;
	_tmp36__length1 = self->priv->pending_length1;
	_vala_assert (_tmp36__length1 == 1, "pending.length == 1");
	_tmp37_ = self->priv->pending;
	_tmp37__length1 = self->priv->pending_length1;
	_tmp38_ = _tmp37_[0];
	_tmp39_ = _tmp38_->index;
	_vala_assert (_tmp39_ == 0, "pending[0].index == 0");
	_tmp40_ = self->priv->pending;
	_tmp40__length1 = self->priv->pending_length1;
	_tmp41_ = _tmp40_[0];
	_tmp42_ = _tmp41_->length;
	_tmp43_ = self->priv->size;
	_vala_assert (_tmp42_ == _tmp43_, "pending[0].length == size");
	_gee_tim_sort_slice_free0 (remaining);
}


static inline gboolean gee_tim_sort_lower_than (GeeTimSort* self, gconstpointer left, gconstpointer right) {
	gboolean result = FALSE;
	GCompareDataFunc _tmp0_;
	void* _tmp0__target;
	gconstpointer _tmp1_;
	gconstpointer _tmp2_;
	gint _tmp3_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->compare;
	_tmp0__target = self->priv->compare_target;
	_tmp1_ = left;
	_tmp2_ = right;
	_tmp3_ = _tmp0_ (_tmp1_, _tmp2_, _tmp0__target);
	result = _tmp3_ < 0;
	return result;
}


static inline gboolean gee_tim_sort_lower_than_or_equal_to (GeeTimSort* self, gconstpointer left, gconstpointer right) {
	gboolean result = FALSE;
	GCompareDataFunc _tmp0_;
	void* _tmp0__target;
	gconstpointer _tmp1_;
	gconstpointer _tmp2_;
	gint _tmp3_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->compare;
	_tmp0__target = self->priv->compare_target;
	_tmp1_ = left;
	_tmp2_ = right;
	_tmp3_ = _tmp0_ (_tmp1_, _tmp2_, _tmp0__target);
	result = _tmp3_ <= 0;
	return result;
}


static gint gee_tim_sort_compute_minimum_run_length (GeeTimSort* self, gint length) {
	gint result = 0;
	gint run_length;
	gint _tmp4_;
	gint _tmp5_;
	g_return_val_if_fail (self != NULL, 0);
	run_length = 0;
	while (TRUE) {
		gint _tmp0_;
		gint _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		_tmp0_ = length;
		if (!(_tmp0_ >= 64)) {
			break;
		}
		_tmp1_ = run_length;
		_tmp2_ = length;
		run_length = _tmp1_ | (_tmp2_ & 1);
		_tmp3_ = length;
		length = _tmp3_ >> 1;
	}
	_tmp4_ = length;
	_tmp5_ = run_length;
	result = _tmp4_ + _tmp5_;
	return result;
}


static GeeTimSortSlice* gee_tim_sort_compute_longest_run (GeeTimSort* self, GeeTimSortSlice* a, gboolean* descending) {
	gboolean _vala_descending = FALSE;
	GeeTimSortSlice* result = NULL;
	gint run_length = 0;
	GeeTimSortSlice* _tmp0_;
	gint _tmp1_;
	GeeTimSortSlice* _tmp55_;
	void** _tmp56_;
	GeeTimSortSlice* _tmp57_;
	gint _tmp58_;
	gint _tmp59_;
	GeeTimSortSlice* _tmp60_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (a != NULL, NULL);
	_tmp0_ = a;
	_tmp1_ = _tmp0_->length;
	if (_tmp1_ <= 1) {
		GeeTimSortSlice* _tmp2_;
		gint _tmp3_;
		_tmp2_ = a;
		_tmp3_ = _tmp2_->length;
		run_length = _tmp3_;
		_vala_descending = FALSE;
	} else {
		GeeTimSortSlice* _tmp4_;
		void** _tmp5_;
		GeeTimSortSlice* _tmp6_;
		gint _tmp7_;
		void* _tmp8_;
		GeeTimSortSlice* _tmp9_;
		void** _tmp10_;
		GeeTimSortSlice* _tmp11_;
		gint _tmp12_;
		void* _tmp13_;
		gboolean _tmp14_ = FALSE;
		run_length = 2;
		_tmp4_ = a;
		_tmp5_ = _tmp4_->list;
		_tmp6_ = a;
		_tmp7_ = _tmp6_->index;
		_tmp8_ = _tmp5_[_tmp7_ + 1];
		_tmp9_ = a;
		_tmp10_ = _tmp9_->list;
		_tmp11_ = a;
		_tmp12_ = _tmp11_->index;
		_tmp13_ = _tmp10_[_tmp12_];
		_tmp14_ = gee_tim_sort_lower_than (self, _tmp8_, _tmp13_);
		if (_tmp14_) {
			_vala_descending = TRUE;
			{
				GeeTimSortSlice* _tmp15_;
				gint _tmp16_;
				gint i;
				_tmp15_ = a;
				_tmp16_ = _tmp15_->index;
				i = _tmp16_ + 2;
				{
					gboolean _tmp17_;
					_tmp17_ = TRUE;
					while (TRUE) {
						gboolean _tmp18_;
						gint _tmp20_;
						GeeTimSortSlice* _tmp21_;
						gint _tmp22_;
						GeeTimSortSlice* _tmp23_;
						gint _tmp24_;
						GeeTimSortSlice* _tmp25_;
						void** _tmp26_;
						gint _tmp27_;
						void* _tmp28_;
						GeeTimSortSlice* _tmp29_;
						void** _tmp30_;
						gint _tmp31_;
						void* _tmp32_;
						gboolean _tmp33_ = FALSE;
						_tmp18_ = _tmp17_;
						if (!_tmp18_) {
							gint _tmp19_;
							_tmp19_ = i;
							i = _tmp19_ + 1;
						}
						_tmp17_ = FALSE;
						_tmp20_ = i;
						_tmp21_ = a;
						_tmp22_ = _tmp21_->index;
						_tmp23_ = a;
						_tmp24_ = _tmp23_->length;
						if (!(_tmp20_ < (_tmp22_ + _tmp24_))) {
							break;
						}
						_tmp25_ = a;
						_tmp26_ = _tmp25_->list;
						_tmp27_ = i;
						_tmp28_ = _tmp26_[_tmp27_];
						_tmp29_ = a;
						_tmp30_ = _tmp29_->list;
						_tmp31_ = i;
						_tmp32_ = _tmp30_[_tmp31_ - 1];
						_tmp33_ = gee_tim_sort_lower_than (self, _tmp28_, _tmp32_);
						if (_tmp33_) {
							gint _tmp34_;
							_tmp34_ = run_length;
							run_length = _tmp34_ + 1;
						} else {
							break;
						}
					}
				}
			}
		} else {
			_vala_descending = FALSE;
			{
				GeeTimSortSlice* _tmp35_;
				gint _tmp36_;
				gint i;
				_tmp35_ = a;
				_tmp36_ = _tmp35_->index;
				i = _tmp36_ + 2;
				{
					gboolean _tmp37_;
					_tmp37_ = TRUE;
					while (TRUE) {
						gboolean _tmp38_;
						gint _tmp40_;
						GeeTimSortSlice* _tmp41_;
						gint _tmp42_;
						GeeTimSortSlice* _tmp43_;
						gint _tmp44_;
						GeeTimSortSlice* _tmp45_;
						void** _tmp46_;
						gint _tmp47_;
						void* _tmp48_;
						GeeTimSortSlice* _tmp49_;
						void** _tmp50_;
						gint _tmp51_;
						void* _tmp52_;
						gboolean _tmp53_ = FALSE;
						_tmp38_ = _tmp37_;
						if (!_tmp38_) {
							gint _tmp39_;
							_tmp39_ = i;
							i = _tmp39_ + 1;
						}
						_tmp37_ = FALSE;
						_tmp40_ = i;
						_tmp41_ = a;
						_tmp42_ = _tmp41_->index;
						_tmp43_ = a;
						_tmp44_ = _tmp43_->length;
						if (!(_tmp40_ < (_tmp42_ + _tmp44_))) {
							break;
						}
						_tmp45_ = a;
						_tmp46_ = _tmp45_->list;
						_tmp47_ = i;
						_tmp48_ = _tmp46_[_tmp47_];
						_tmp49_ = a;
						_tmp50_ = _tmp49_->list;
						_tmp51_ = i;
						_tmp52_ = _tmp50_[_tmp51_ - 1];
						_tmp53_ = gee_tim_sort_lower_than (self, _tmp48_, _tmp52_);
						if (_tmp53_) {
							break;
						} else {
							gint _tmp54_;
							_tmp54_ = run_length;
							run_length = _tmp54_ + 1;
						}
					}
				}
			}
		}
	}
	_tmp55_ = a;
	_tmp56_ = _tmp55_->list;
	_tmp57_ = a;
	_tmp58_ = _tmp57_->index;
	_tmp59_ = run_length;
	_tmp60_ = gee_tim_sort_slice_new (_tmp56_, _tmp58_, _tmp59_);
	result = _tmp60_;
	if (descending) {
		*descending = _vala_descending;
	}
	return result;
}


static void gee_tim_sort_insertion_sort (GeeTimSort* self, GeeTimSortSlice* a, gint offset) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (a != NULL);
	{
		GeeTimSortSlice* _tmp0_;
		gint _tmp1_;
		gint _tmp2_;
		gint start;
		_tmp0_ = a;
		_tmp1_ = _tmp0_->index;
		_tmp2_ = offset;
		start = _tmp1_ + _tmp2_;
		{
			gboolean _tmp3_;
			_tmp3_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_;
				gint _tmp6_;
				GeeTimSortSlice* _tmp7_;
				gint _tmp8_;
				GeeTimSortSlice* _tmp9_;
				gint _tmp10_;
				GeeTimSortSlice* _tmp11_;
				gint _tmp12_;
				gint left;
				gint _tmp13_;
				gint right;
				GeeTimSortSlice* _tmp14_;
				void** _tmp15_;
				gint _tmp16_;
				void* _tmp17_;
				void* pivot;
				gint _tmp31_;
				gint _tmp32_;
				GeeTimSortSlice* _tmp33_;
				void** _tmp34_;
				gint _tmp35_;
				GeeTimSortSlice* _tmp36_;
				void** _tmp37_;
				gint _tmp38_;
				gint _tmp39_;
				gint _tmp40_;
				GeeTimSortSlice* _tmp41_;
				void** _tmp42_;
				gint _tmp43_;
				void* _tmp44_;
				void* _tmp45_;
				_tmp4_ = _tmp3_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = start;
					start = _tmp5_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp6_ = start;
				_tmp7_ = a;
				_tmp8_ = _tmp7_->index;
				_tmp9_ = a;
				_tmp10_ = _tmp9_->length;
				if (!(_tmp6_ < (_tmp8_ + _tmp10_))) {
					break;
				}
				_tmp11_ = a;
				_tmp12_ = _tmp11_->index;
				left = _tmp12_;
				_tmp13_ = start;
				right = _tmp13_;
				_tmp14_ = a;
				_tmp15_ = _tmp14_->list;
				_tmp16_ = right;
				_tmp17_ = _tmp15_[_tmp16_];
				pivot = _tmp17_;
				while (TRUE) {
					gint _tmp18_;
					gint _tmp19_;
					gint _tmp20_;
					gint _tmp21_;
					gint _tmp22_;
					gint p;
					void* _tmp23_;
					GeeTimSortSlice* _tmp24_;
					void** _tmp25_;
					gint _tmp26_;
					void* _tmp27_;
					gboolean _tmp28_ = FALSE;
					_tmp18_ = left;
					_tmp19_ = right;
					if (!(_tmp18_ < _tmp19_)) {
						break;
					}
					_tmp20_ = left;
					_tmp21_ = right;
					_tmp22_ = left;
					p = _tmp20_ + ((_tmp21_ - _tmp22_) >> 1);
					_tmp23_ = pivot;
					_tmp24_ = a;
					_tmp25_ = _tmp24_->list;
					_tmp26_ = p;
					_tmp27_ = _tmp25_[_tmp26_];
					_tmp28_ = gee_tim_sort_lower_than (self, _tmp23_, _tmp27_);
					if (_tmp28_) {
						gint _tmp29_;
						_tmp29_ = p;
						right = _tmp29_;
					} else {
						gint _tmp30_;
						_tmp30_ = p;
						left = _tmp30_ + 1;
					}
				}
				_tmp31_ = left;
				_tmp32_ = right;
				_vala_assert (_tmp31_ == _tmp32_, "left == right");
				_tmp33_ = a;
				_tmp34_ = _tmp33_->list;
				_tmp35_ = left;
				_tmp36_ = a;
				_tmp37_ = _tmp36_->list;
				_tmp38_ = left;
				_tmp39_ = start;
				_tmp40_ = left;
				g_memmove (&_tmp34_[_tmp35_ + 1], &_tmp37_[_tmp38_], (gsize) (sizeof (gpointer) * (_tmp39_ - _tmp40_)));
				_tmp41_ = a;
				_tmp42_ = _tmp41_->list;
				_tmp43_ = left;
				_tmp44_ = pivot;
				_tmp42_[_tmp43_] = _tmp44_;
				_tmp45_ = _tmp42_[_tmp43_];
			}
		}
	}
}


static void gee_tim_sort_merge_collapse (GeeTimSort* self) {
	GeeTimSortSlice** _tmp0_;
	gint _tmp0__length1;
	gint count;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->pending;
	_tmp0__length1 = self->priv->pending_length1;
	count = _tmp0__length1;
	while (TRUE) {
		gint _tmp1_;
		gboolean _tmp2_ = FALSE;
		gint _tmp3_;
		gboolean _tmp16_;
		GeeTimSortSlice** _tmp36_;
		gint _tmp36__length1;
		_tmp1_ = count;
		if (!(_tmp1_ > 1)) {
			break;
		}
		_tmp3_ = count;
		if (_tmp3_ >= 3) {
			GeeTimSortSlice** _tmp4_;
			gint _tmp4__length1;
			gint _tmp5_;
			GeeTimSortSlice* _tmp6_;
			gint _tmp7_;
			GeeTimSortSlice** _tmp8_;
			gint _tmp8__length1;
			gint _tmp9_;
			GeeTimSortSlice* _tmp10_;
			gint _tmp11_;
			GeeTimSortSlice** _tmp12_;
			gint _tmp12__length1;
			gint _tmp13_;
			GeeTimSortSlice* _tmp14_;
			gint _tmp15_;
			_tmp4_ = self->priv->pending;
			_tmp4__length1 = self->priv->pending_length1;
			_tmp5_ = count;
			_tmp6_ = _tmp4_[_tmp5_ - 3];
			_tmp7_ = _tmp6_->length;
			_tmp8_ = self->priv->pending;
			_tmp8__length1 = self->priv->pending_length1;
			_tmp9_ = count;
			_tmp10_ = _tmp8_[_tmp9_ - 2];
			_tmp11_ = _tmp10_->length;
			_tmp12_ = self->priv->pending;
			_tmp12__length1 = self->priv->pending_length1;
			_tmp13_ = count;
			_tmp14_ = _tmp12_[_tmp13_ - 1];
			_tmp15_ = _tmp14_->length;
			_tmp2_ = _tmp7_ <= (_tmp11_ + _tmp15_);
		} else {
			_tmp2_ = FALSE;
		}
		_tmp16_ = _tmp2_;
		if (_tmp16_) {
			GeeTimSortSlice** _tmp17_;
			gint _tmp17__length1;
			gint _tmp18_;
			GeeTimSortSlice* _tmp19_;
			gint _tmp20_;
			GeeTimSortSlice** _tmp21_;
			gint _tmp21__length1;
			gint _tmp22_;
			GeeTimSortSlice* _tmp23_;
			gint _tmp24_;
			_tmp17_ = self->priv->pending;
			_tmp17__length1 = self->priv->pending_length1;
			_tmp18_ = count;
			_tmp19_ = _tmp17_[_tmp18_ - 3];
			_tmp20_ = _tmp19_->length;
			_tmp21_ = self->priv->pending;
			_tmp21__length1 = self->priv->pending_length1;
			_tmp22_ = count;
			_tmp23_ = _tmp21_[_tmp22_ - 1];
			_tmp24_ = _tmp23_->length;
			if (_tmp20_ < _tmp24_) {
				gint _tmp25_;
				_tmp25_ = count;
				gee_tim_sort_merge_at (self, _tmp25_ - 3);
			} else {
				gint _tmp26_;
				_tmp26_ = count;
				gee_tim_sort_merge_at (self, _tmp26_ - 2);
			}
		} else {
			GeeTimSortSlice** _tmp27_;
			gint _tmp27__length1;
			gint _tmp28_;
			GeeTimSortSlice* _tmp29_;
			gint _tmp30_;
			GeeTimSortSlice** _tmp31_;
			gint _tmp31__length1;
			gint _tmp32_;
			GeeTimSortSlice* _tmp33_;
			gint _tmp34_;
			_tmp27_ = self->priv->pending;
			_tmp27__length1 = self->priv->pending_length1;
			_tmp28_ = count;
			_tmp29_ = _tmp27_[_tmp28_ - 2];
			_tmp30_ = _tmp29_->length;
			_tmp31_ = self->priv->pending;
			_tmp31__length1 = self->priv->pending_length1;
			_tmp32_ = count;
			_tmp33_ = _tmp31_[_tmp32_ - 1];
			_tmp34_ = _tmp33_->length;
			if (_tmp30_ <= _tmp34_) {
				gint _tmp35_;
				_tmp35_ = count;
				gee_tim_sort_merge_at (self, _tmp35_ - 2);
			} else {
				break;
			}
		}
		_tmp36_ = self->priv->pending;
		_tmp36__length1 = self->priv->pending_length1;
		count = _tmp36__length1;
	}
}


static void gee_tim_sort_merge_force_collapse (GeeTimSort* self) {
	GeeTimSortSlice** _tmp0_;
	gint _tmp0__length1;
	gint count;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->pending;
	_tmp0__length1 = self->priv->pending_length1;
	count = _tmp0__length1;
	while (TRUE) {
		gint _tmp1_;
		gboolean _tmp2_ = FALSE;
		gint _tmp3_;
		gboolean _tmp12_;
		GeeTimSortSlice** _tmp15_;
		gint _tmp15__length1;
		_tmp1_ = count;
		if (!(_tmp1_ > 1)) {
			break;
		}
		_tmp3_ = count;
		if (_tmp3_ >= 3) {
			GeeTimSortSlice** _tmp4_;
			gint _tmp4__length1;
			gint _tmp5_;
			GeeTimSortSlice* _tmp6_;
			gint _tmp7_;
			GeeTimSortSlice** _tmp8_;
			gint _tmp8__length1;
			gint _tmp9_;
			GeeTimSortSlice* _tmp10_;
			gint _tmp11_;
			_tmp4_ = self->priv->pending;
			_tmp4__length1 = self->priv->pending_length1;
			_tmp5_ = count;
			_tmp6_ = _tmp4_[_tmp5_ - 3];
			_tmp7_ = _tmp6_->length;
			_tmp8_ = self->priv->pending;
			_tmp8__length1 = self->priv->pending_length1;
			_tmp9_ = count;
			_tmp10_ = _tmp8_[_tmp9_ - 1];
			_tmp11_ = _tmp10_->length;
			_tmp2_ = _tmp7_ < _tmp11_;
		} else {
			_tmp2_ = FALSE;
		}
		_tmp12_ = _tmp2_;
		if (_tmp12_) {
			gint _tmp13_;
			_tmp13_ = count;
			gee_tim_sort_merge_at (self, _tmp13_ - 3);
		} else {
			gint _tmp14_;
			_tmp14_ = count;
			gee_tim_sort_merge_at (self, _tmp14_ - 2);
		}
		_tmp15_ = self->priv->pending;
		_tmp15__length1 = self->priv->pending_length1;
		count = _tmp15__length1;
	}
}


static void gee_tim_sort_merge_at (GeeTimSort* self, gint index) {
	GeeTimSortSlice** _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_;
	GeeTimSortSlice* _tmp2_;
	GeeTimSortSlice* a;
	GeeTimSortSlice** _tmp3_;
	gint _tmp3__length1;
	gint _tmp4_;
	GeeTimSortSlice* _tmp5_;
	GeeTimSortSlice* b;
	GeeTimSortSlice* _tmp6_;
	gint _tmp7_;
	GeeTimSortSlice* _tmp8_;
	gint _tmp9_;
	GeeTimSortSlice* _tmp10_;
	gint _tmp11_;
	GeeTimSortSlice* _tmp12_;
	gint _tmp13_;
	GeeTimSortSlice* _tmp14_;
	gint _tmp15_;
	GeeTimSortSlice** _tmp16_;
	gint _tmp16__length1;
	gint _tmp17_;
	void** _tmp18_;
	GeeTimSortSlice* _tmp19_;
	gint _tmp20_;
	GeeTimSortSlice* _tmp21_;
	gint _tmp22_;
	GeeTimSortSlice* _tmp23_;
	gint _tmp24_;
	GeeTimSortSlice* _tmp25_;
	GeeTimSortSlice* _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	GeeTimSortSlice** _tmp29_;
	gint _tmp29__length1;
	gint _tmp30_;
	gint _tmp31_;
	GeeTimSortSlice* _tmp32_;
	void* _tmp33_ = NULL;
	GeeTimSortSlice* _tmp34_;
	gint _tmp35_ = 0;
	gint sorted_count;
	GeeTimSortSlice* _tmp36_;
	gint _tmp37_;
	GeeTimSortSlice* _tmp38_;
	gint _tmp39_;
	GeeTimSortSlice* _tmp40_;
	GeeTimSortSlice* _tmp41_;
	void* _tmp42_ = NULL;
	GeeTimSortSlice* _tmp43_;
	GeeTimSortSlice* _tmp44_;
	gint _tmp45_;
	gint _tmp46_ = 0;
	GeeTimSortSlice* _tmp47_;
	gint _tmp48_;
	GeeTimSortSlice* _tmp49_;
	gint _tmp50_;
	GeeTimSortSlice* _tmp51_;
	gint _tmp52_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->pending;
	_tmp0__length1 = self->priv->pending_length1;
	_tmp1_ = index;
	_tmp2_ = _tmp0_[_tmp1_];
	_tmp0_[_tmp1_] = NULL;
	a = _tmp2_;
	_tmp3_ = self->priv->pending;
	_tmp3__length1 = self->priv->pending_length1;
	_tmp4_ = index;
	_tmp5_ = _tmp3_[_tmp4_ + 1];
	_tmp3_[_tmp4_ + 1] = NULL;
	b = _tmp5_;
	_tmp6_ = a;
	_tmp7_ = _tmp6_->length;
	_vala_assert (_tmp7_ > 0, "a.length > 0");
	_tmp8_ = b;
	_tmp9_ = _tmp8_->length;
	_vala_assert (_tmp9_ > 0, "b.length > 0");
	_tmp10_ = a;
	_tmp11_ = _tmp10_->index;
	_tmp12_ = a;
	_tmp13_ = _tmp12_->length;
	_tmp14_ = b;
	_tmp15_ = _tmp14_->index;
	_vala_assert ((_tmp11_ + _tmp13_) == _tmp15_, "a.index + a.length == b.index");
	_tmp16_ = self->priv->pending;
	_tmp16__length1 = self->priv->pending_length1;
	_tmp17_ = index;
	_tmp18_ = self->priv->list;
	_tmp19_ = a;
	_tmp20_ = _tmp19_->index;
	_tmp21_ = a;
	_tmp22_ = _tmp21_->length;
	_tmp23_ = b;
	_tmp24_ = _tmp23_->length;
	_tmp25_ = gee_tim_sort_slice_new (_tmp18_, _tmp20_, _tmp22_ + _tmp24_);
	_gee_tim_sort_slice_free0 (_tmp16_[_tmp17_]);
	_tmp16_[_tmp17_] = _tmp25_;
	_tmp26_ = _tmp16_[_tmp17_];
	_tmp27_ = index;
	_tmp28_ = index;
	_tmp29_ = self->priv->pending;
	_tmp29__length1 = self->priv->pending_length1;
	_tmp30_ = index;
	_vala_array_move (self->priv->pending, sizeof (GeeTimSortSlice*), _tmp27_ + 2, _tmp28_ + 1, (_tmp29__length1 - _tmp30_) - 2);
	self->priv->pending_length1 = self->priv->pending_length1 - 1;
	_tmp31_ = self->priv->pending_length1;
	_tmp32_ = b;
	_tmp33_ = gee_tim_sort_slice_peek_first (_tmp32_);
	_tmp34_ = a;
	_tmp35_ = gee_tim_sort_gallop_rightmost (self, _tmp33_, _tmp34_, 0);
	sorted_count = _tmp35_;
	_tmp36_ = a;
	_tmp37_ = sorted_count;
	gee_tim_sort_slice_shorten_start (_tmp36_, _tmp37_);
	_tmp38_ = a;
	_tmp39_ = _tmp38_->length;
	if (_tmp39_ == 0) {
		_gee_tim_sort_slice_free0 (b);
		_gee_tim_sort_slice_free0 (a);
		return;
	}
	_tmp40_ = b;
	_tmp41_ = a;
	_tmp42_ = gee_tim_sort_slice_peek_last (_tmp41_);
	_tmp43_ = b;
	_tmp44_ = b;
	_tmp45_ = _tmp44_->length;
	_tmp46_ = gee_tim_sort_gallop_leftmost (self, _tmp42_, _tmp43_, _tmp45_ - 1);
	_tmp40_->length = _tmp46_;
	_tmp47_ = b;
	_tmp48_ = _tmp47_->length;
	if (_tmp48_ == 0) {
		_gee_tim_sort_slice_free0 (b);
		_gee_tim_sort_slice_free0 (a);
		return;
	}
	_tmp49_ = a;
	_tmp50_ = _tmp49_->length;
	_tmp51_ = b;
	_tmp52_ = _tmp51_->length;
	if (_tmp50_ <= _tmp52_) {
		GeeTimSortSlice* _tmp53_;
		GeeTimSortSlice* _tmp54_;
		_tmp53_ = a;
		a = NULL;
		_tmp54_ = b;
		b = NULL;
		gee_tim_sort_merge_low (self, _tmp53_, _tmp54_);
	} else {
		GeeTimSortSlice* _tmp55_;
		GeeTimSortSlice* _tmp56_;
		_tmp55_ = a;
		a = NULL;
		_tmp56_ = b;
		b = NULL;
		gee_tim_sort_merge_high (self, _tmp55_, _tmp56_);
	}
	_gee_tim_sort_slice_free0 (b);
	_gee_tim_sort_slice_free0 (a);
}


static gint gee_tim_sort_gallop_leftmost (GeeTimSort* self, gconstpointer key, GeeTimSortSlice* a, gint hint) {
	gint result = 0;
	gint _tmp0_;
	gint _tmp1_;
	GeeTimSortSlice* _tmp2_;
	gint _tmp3_;
	GeeTimSortSlice* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint p;
	gint last_offset;
	gint offset;
	GeeTimSortSlice* _tmp7_;
	void** _tmp8_;
	gint _tmp9_;
	void* _tmp10_;
	gconstpointer _tmp11_;
	gboolean _tmp12_ = FALSE;
	gint _tmp57_;
	gint _tmp58_;
	gint _tmp59_;
	gint _tmp60_;
	GeeTimSortSlice* _tmp61_;
	gint _tmp62_;
	gint _tmp63_;
	gint _tmp79_;
	gint _tmp80_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (a != NULL, 0);
	_tmp0_ = hint;
	_vala_assert (0 <= _tmp0_, "0 <= hint");
	_tmp1_ = hint;
	_tmp2_ = a;
	_tmp3_ = _tmp2_->length;
	_vala_assert (_tmp1_ < _tmp3_, "hint < a.length");
	_tmp4_ = a;
	_tmp5_ = _tmp4_->index;
	_tmp6_ = hint;
	p = _tmp5_ + _tmp6_;
	last_offset = 0;
	offset = 1;
	_tmp7_ = a;
	_tmp8_ = _tmp7_->list;
	_tmp9_ = p;
	_tmp10_ = _tmp8_[_tmp9_];
	_tmp11_ = key;
	_tmp12_ = gee_tim_sort_lower_than (self, _tmp10_, _tmp11_);
	if (_tmp12_) {
		GeeTimSortSlice* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint max_offset;
		gint _tmp28_;
		gint _tmp29_;
		gint _tmp31_;
		gint _tmp32_;
		gint _tmp33_;
		gint _tmp34_;
		_tmp13_ = a;
		_tmp14_ = _tmp13_->length;
		_tmp15_ = hint;
		max_offset = _tmp14_ - _tmp15_;
		while (TRUE) {
			gint _tmp16_;
			gint _tmp17_;
			GeeTimSortSlice* _tmp18_;
			void** _tmp19_;
			gint _tmp20_;
			gint _tmp21_;
			void* _tmp22_;
			gconstpointer _tmp23_;
			gboolean _tmp24_ = FALSE;
			_tmp16_ = offset;
			_tmp17_ = max_offset;
			if (!(_tmp16_ < _tmp17_)) {
				break;
			}
			_tmp18_ = a;
			_tmp19_ = _tmp18_->list;
			_tmp20_ = p;
			_tmp21_ = offset;
			_tmp22_ = _tmp19_[_tmp20_ + _tmp21_];
			_tmp23_ = key;
			_tmp24_ = gee_tim_sort_lower_than (self, _tmp22_, _tmp23_);
			if (_tmp24_) {
				gint _tmp25_;
				gint _tmp26_;
				gint _tmp27_;
				_tmp25_ = offset;
				last_offset = _tmp25_;
				_tmp26_ = offset;
				offset = _tmp26_ << 1;
				_tmp27_ = offset;
				offset = _tmp27_ + 1;
			} else {
				break;
			}
		}
		_tmp28_ = offset;
		_tmp29_ = max_offset;
		if (_tmp28_ > _tmp29_) {
			gint _tmp30_;
			_tmp30_ = max_offset;
			offset = _tmp30_;
		}
		_tmp31_ = hint;
		_tmp32_ = last_offset;
		last_offset = _tmp31_ + _tmp32_;
		_tmp33_ = hint;
		_tmp34_ = offset;
		offset = _tmp33_ + _tmp34_;
	} else {
		gint _tmp35_;
		gint max_offset;
		gint _tmp48_;
		gint _tmp49_;
		gint _tmp51_;
		gint temp_last_offset;
		gint _tmp52_;
		gint temp_offset;
		gint _tmp53_;
		gint _tmp54_;
		gint _tmp55_;
		gint _tmp56_;
		_tmp35_ = hint;
		max_offset = _tmp35_ + 1;
		while (TRUE) {
			gint _tmp36_;
			gint _tmp37_;
			GeeTimSortSlice* _tmp38_;
			void** _tmp39_;
			gint _tmp40_;
			gint _tmp41_;
			void* _tmp42_;
			gconstpointer _tmp43_;
			gboolean _tmp44_ = FALSE;
			_tmp36_ = offset;
			_tmp37_ = max_offset;
			if (!(_tmp36_ < _tmp37_)) {
				break;
			}
			_tmp38_ = a;
			_tmp39_ = _tmp38_->list;
			_tmp40_ = p;
			_tmp41_ = offset;
			_tmp42_ = _tmp39_[_tmp40_ - _tmp41_];
			_tmp43_ = key;
			_tmp44_ = gee_tim_sort_lower_than (self, _tmp42_, _tmp43_);
			if (_tmp44_) {
				break;
			} else {
				gint _tmp45_;
				gint _tmp46_;
				gint _tmp47_;
				_tmp45_ = offset;
				last_offset = _tmp45_;
				_tmp46_ = offset;
				offset = _tmp46_ << 1;
				_tmp47_ = offset;
				offset = _tmp47_ + 1;
			}
		}
		_tmp48_ = offset;
		_tmp49_ = max_offset;
		if (_tmp48_ > _tmp49_) {
			gint _tmp50_;
			_tmp50_ = max_offset;
			offset = _tmp50_;
		}
		_tmp51_ = last_offset;
		temp_last_offset = _tmp51_;
		_tmp52_ = offset;
		temp_offset = _tmp52_;
		_tmp53_ = hint;
		_tmp54_ = temp_offset;
		last_offset = _tmp53_ - _tmp54_;
		_tmp55_ = hint;
		_tmp56_ = temp_last_offset;
		offset = _tmp55_ - _tmp56_;
	}
	_tmp57_ = last_offset;
	_vala_assert ((-1) <= _tmp57_, "-1 <= last_offset");
	_tmp58_ = last_offset;
	_tmp59_ = offset;
	_vala_assert (_tmp58_ < _tmp59_, "last_offset < offset");
	_tmp60_ = offset;
	_tmp61_ = a;
	_tmp62_ = _tmp61_->length;
	_vala_assert (_tmp60_ <= _tmp62_, "offset <= a.length");
	_tmp63_ = last_offset;
	last_offset = _tmp63_ + 1;
	while (TRUE) {
		gint _tmp64_;
		gint _tmp65_;
		gint _tmp66_;
		gint _tmp67_;
		gint _tmp68_;
		gint m;
		GeeTimSortSlice* _tmp69_;
		void** _tmp70_;
		GeeTimSortSlice* _tmp71_;
		gint _tmp72_;
		gint _tmp73_;
		void* _tmp74_;
		gconstpointer _tmp75_;
		gboolean _tmp76_ = FALSE;
		_tmp64_ = last_offset;
		_tmp65_ = offset;
		if (!(_tmp64_ < _tmp65_)) {
			break;
		}
		_tmp66_ = last_offset;
		_tmp67_ = offset;
		_tmp68_ = last_offset;
		m = _tmp66_ + ((_tmp67_ - _tmp68_) >> 1);
		_tmp69_ = a;
		_tmp70_ = _tmp69_->list;
		_tmp71_ = a;
		_tmp72_ = _tmp71_->index;
		_tmp73_ = m;
		_tmp74_ = _tmp70_[_tmp72_ + _tmp73_];
		_tmp75_ = key;
		_tmp76_ = gee_tim_sort_lower_than (self, _tmp74_, _tmp75_);
		if (_tmp76_) {
			gint _tmp77_;
			_tmp77_ = m;
			last_offset = _tmp77_ + 1;
		} else {
			gint _tmp78_;
			_tmp78_ = m;
			offset = _tmp78_;
		}
	}
	_tmp79_ = last_offset;
	_tmp80_ = offset;
	_vala_assert (_tmp79_ == _tmp80_, "last_offset == offset");
	result = offset;
	return result;
}


static gint gee_tim_sort_gallop_rightmost (GeeTimSort* self, gconstpointer key, GeeTimSortSlice* a, gint hint) {
	gint result = 0;
	gint _tmp0_;
	gint _tmp1_;
	GeeTimSortSlice* _tmp2_;
	gint _tmp3_;
	GeeTimSortSlice* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint p;
	gint last_offset;
	gint offset;
	GeeTimSortSlice* _tmp7_;
	void** _tmp8_;
	gint _tmp9_;
	void* _tmp10_;
	gconstpointer _tmp11_;
	gboolean _tmp12_ = FALSE;
	gint _tmp57_;
	gint _tmp58_;
	gint _tmp59_;
	gint _tmp60_;
	GeeTimSortSlice* _tmp61_;
	gint _tmp62_;
	gint _tmp63_;
	gint _tmp79_;
	gint _tmp80_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (a != NULL, 0);
	_tmp0_ = hint;
	_vala_assert (0 <= _tmp0_, "0 <= hint");
	_tmp1_ = hint;
	_tmp2_ = a;
	_tmp3_ = _tmp2_->length;
	_vala_assert (_tmp1_ < _tmp3_, "hint < a.length");
	_tmp4_ = a;
	_tmp5_ = _tmp4_->index;
	_tmp6_ = hint;
	p = _tmp5_ + _tmp6_;
	last_offset = 0;
	offset = 1;
	_tmp7_ = a;
	_tmp8_ = _tmp7_->list;
	_tmp9_ = p;
	_tmp10_ = _tmp8_[_tmp9_];
	_tmp11_ = key;
	_tmp12_ = gee_tim_sort_lower_than_or_equal_to (self, _tmp10_, _tmp11_);
	if (_tmp12_) {
		GeeTimSortSlice* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint max_offset;
		gint _tmp28_;
		gint _tmp29_;
		gint _tmp31_;
		gint _tmp32_;
		gint _tmp33_;
		gint _tmp34_;
		_tmp13_ = a;
		_tmp14_ = _tmp13_->length;
		_tmp15_ = hint;
		max_offset = _tmp14_ - _tmp15_;
		while (TRUE) {
			gint _tmp16_;
			gint _tmp17_;
			GeeTimSortSlice* _tmp18_;
			void** _tmp19_;
			gint _tmp20_;
			gint _tmp21_;
			void* _tmp22_;
			gconstpointer _tmp23_;
			gboolean _tmp24_ = FALSE;
			_tmp16_ = offset;
			_tmp17_ = max_offset;
			if (!(_tmp16_ < _tmp17_)) {
				break;
			}
			_tmp18_ = a;
			_tmp19_ = _tmp18_->list;
			_tmp20_ = p;
			_tmp21_ = offset;
			_tmp22_ = _tmp19_[_tmp20_ + _tmp21_];
			_tmp23_ = key;
			_tmp24_ = gee_tim_sort_lower_than_or_equal_to (self, _tmp22_, _tmp23_);
			if (_tmp24_) {
				gint _tmp25_;
				gint _tmp26_;
				gint _tmp27_;
				_tmp25_ = offset;
				last_offset = _tmp25_;
				_tmp26_ = offset;
				offset = _tmp26_ << 1;
				_tmp27_ = offset;
				offset = _tmp27_ + 1;
			} else {
				break;
			}
		}
		_tmp28_ = offset;
		_tmp29_ = max_offset;
		if (_tmp28_ > _tmp29_) {
			gint _tmp30_;
			_tmp30_ = max_offset;
			offset = _tmp30_;
		}
		_tmp31_ = hint;
		_tmp32_ = last_offset;
		last_offset = _tmp31_ + _tmp32_;
		_tmp33_ = hint;
		_tmp34_ = offset;
		offset = _tmp33_ + _tmp34_;
	} else {
		gint _tmp35_;
		gint max_offset;
		gint _tmp48_;
		gint _tmp49_;
		gint _tmp51_;
		gint temp_last_offset;
		gint _tmp52_;
		gint temp_offset;
		gint _tmp53_;
		gint _tmp54_;
		gint _tmp55_;
		gint _tmp56_;
		_tmp35_ = hint;
		max_offset = _tmp35_ + 1;
		while (TRUE) {
			gint _tmp36_;
			gint _tmp37_;
			GeeTimSortSlice* _tmp38_;
			void** _tmp39_;
			gint _tmp40_;
			gint _tmp41_;
			void* _tmp42_;
			gconstpointer _tmp43_;
			gboolean _tmp44_ = FALSE;
			_tmp36_ = offset;
			_tmp37_ = max_offset;
			if (!(_tmp36_ < _tmp37_)) {
				break;
			}
			_tmp38_ = a;
			_tmp39_ = _tmp38_->list;
			_tmp40_ = p;
			_tmp41_ = offset;
			_tmp42_ = _tmp39_[_tmp40_ - _tmp41_];
			_tmp43_ = key;
			_tmp44_ = gee_tim_sort_lower_than_or_equal_to (self, _tmp42_, _tmp43_);
			if (_tmp44_) {
				break;
			} else {
				gint _tmp45_;
				gint _tmp46_;
				gint _tmp47_;
				_tmp45_ = offset;
				last_offset = _tmp45_;
				_tmp46_ = offset;
				offset = _tmp46_ << 1;
				_tmp47_ = offset;
				offset = _tmp47_ + 1;
			}
		}
		_tmp48_ = offset;
		_tmp49_ = max_offset;
		if (_tmp48_ > _tmp49_) {
			gint _tmp50_;
			_tmp50_ = max_offset;
			offset = _tmp50_;
		}
		_tmp51_ = last_offset;
		temp_last_offset = _tmp51_;
		_tmp52_ = offset;
		temp_offset = _tmp52_;
		_tmp53_ = hint;
		_tmp54_ = temp_offset;
		last_offset = _tmp53_ - _tmp54_;
		_tmp55_ = hint;
		_tmp56_ = temp_last_offset;
		offset = _tmp55_ - _tmp56_;
	}
	_tmp57_ = last_offset;
	_vala_assert ((-1) <= _tmp57_, "-1 <= last_offset");
	_tmp58_ = last_offset;
	_tmp59_ = offset;
	_vala_assert (_tmp58_ < _tmp59_, "last_offset < offset");
	_tmp60_ = offset;
	_tmp61_ = a;
	_tmp62_ = _tmp61_->length;
	_vala_assert (_tmp60_ <= _tmp62_, "offset <= a.length");
	_tmp63_ = last_offset;
	last_offset = _tmp63_ + 1;
	while (TRUE) {
		gint _tmp64_;
		gint _tmp65_;
		gint _tmp66_;
		gint _tmp67_;
		gint _tmp68_;
		gint m;
		GeeTimSortSlice* _tmp69_;
		void** _tmp70_;
		GeeTimSortSlice* _tmp71_;
		gint _tmp72_;
		gint _tmp73_;
		void* _tmp74_;
		gconstpointer _tmp75_;
		gboolean _tmp76_ = FALSE;
		_tmp64_ = last_offset;
		_tmp65_ = offset;
		if (!(_tmp64_ < _tmp65_)) {
			break;
		}
		_tmp66_ = last_offset;
		_tmp67_ = offset;
		_tmp68_ = last_offset;
		m = _tmp66_ + ((_tmp67_ - _tmp68_) >> 1);
		_tmp69_ = a;
		_tmp70_ = _tmp69_->list;
		_tmp71_ = a;
		_tmp72_ = _tmp71_->index;
		_tmp73_ = m;
		_tmp74_ = _tmp70_[_tmp72_ + _tmp73_];
		_tmp75_ = key;
		_tmp76_ = gee_tim_sort_lower_than_or_equal_to (self, _tmp74_, _tmp75_);
		if (_tmp76_) {
			gint _tmp77_;
			_tmp77_ = m;
			last_offset = _tmp77_ + 1;
		} else {
			gint _tmp78_;
			_tmp78_ = m;
			offset = _tmp78_;
		}
	}
	_tmp79_ = last_offset;
	_tmp80_ = offset;
	_vala_assert (_tmp79_ == _tmp80_, "last_offset == offset");
	result = offset;
	return result;
}


static void gee_tim_sort_merge_low (GeeTimSort* self, GeeTimSortSlice* a, GeeTimSortSlice* b) {
	GeeTimSortSlice* _tmp0_;
	gint _tmp1_;
	GeeTimSortSlice* _tmp2_;
	gint _tmp3_;
	GeeTimSortSlice* _tmp4_;
	gint _tmp5_;
	GeeTimSortSlice* _tmp6_;
	gint _tmp7_;
	GeeTimSortSlice* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gint minimum_gallop;
	GeeTimSortSlice* _tmp11_;
	gint _tmp12_;
	gint dest;
	GeeTimSortSlice* _tmp13_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (a != NULL);
	g_return_if_fail (b != NULL);
	_tmp0_ = a;
	_tmp1_ = _tmp0_->length;
	_vala_assert (_tmp1_ > 0, "a.length > 0");
	_tmp2_ = b;
	_tmp3_ = _tmp2_->length;
	_vala_assert (_tmp3_ > 0, "b.length > 0");
	_tmp4_ = a;
	_tmp5_ = _tmp4_->index;
	_tmp6_ = a;
	_tmp7_ = _tmp6_->length;
	_tmp8_ = b;
	_tmp9_ = _tmp8_->index;
	_vala_assert ((_tmp5_ + _tmp7_) == _tmp9_, "a.index + a.length == b.index");
	_tmp10_ = self->priv->minimum_gallop;
	minimum_gallop = _tmp10_;
	_tmp11_ = a;
	_tmp12_ = _tmp11_->index;
	dest = _tmp12_;
	_tmp13_ = a;
	gee_tim_sort_slice_copy (_tmp13_);
	{
		void** _tmp14_;
		gint _tmp15_;
		GeeTimSortSlice* _tmp16_;
		void* _tmp17_ = NULL;
		void* _tmp18_;
		gboolean _tmp19_ = FALSE;
		GeeTimSortSlice* _tmp20_;
		gint _tmp21_;
		gboolean _tmp24_;
		_tmp14_ = self->priv->list;
		_tmp15_ = dest;
		dest = _tmp15_ + 1;
		_tmp16_ = b;
		_tmp17_ = gee_tim_sort_slice_pop_first (_tmp16_);
		_tmp14_[_tmp15_] = _tmp17_;
		_tmp18_ = _tmp14_[_tmp15_];
		_tmp20_ = a;
		_tmp21_ = _tmp20_->length;
		if (_tmp21_ == 1) {
			_tmp19_ = TRUE;
		} else {
			GeeTimSortSlice* _tmp22_;
			gint _tmp23_;
			_tmp22_ = b;
			_tmp23_ = _tmp22_->length;
			_tmp19_ = _tmp23_ == 0;
		}
		_tmp24_ = _tmp19_;
		if (_tmp24_) {
			{
				GeeTimSortSlice* _tmp25_;
				gint _tmp26_;
				GeeTimSortSlice* _tmp27_;
				gint _tmp28_;
				GeeTimSortSlice* _tmp29_;
				void** _tmp30_;
				GeeTimSortSlice* _tmp31_;
				gint _tmp32_;
				gint _tmp33_;
				GeeTimSortSlice* _tmp34_;
				gint _tmp35_;
				GeeTimSortSlice* _tmp36_;
				void** _tmp37_;
				GeeTimSortSlice* _tmp38_;
				gint _tmp39_;
				gint _tmp40_;
				GeeTimSortSlice* _tmp41_;
				gint _tmp42_;
				GeeTimSortSlice* _tmp43_;
				gint _tmp44_;
				_tmp25_ = a;
				_tmp26_ = _tmp25_->length;
				_vala_assert (_tmp26_ >= 0, "a.length >= 0");
				_tmp27_ = b;
				_tmp28_ = _tmp27_->length;
				_vala_assert (_tmp28_ >= 0, "b.length >= 0");
				_tmp29_ = b;
				_tmp30_ = self->priv->list;
				_tmp31_ = b;
				_tmp32_ = _tmp31_->index;
				_tmp33_ = dest;
				_tmp34_ = b;
				_tmp35_ = _tmp34_->length;
				gee_tim_sort_slice_merge_in (_tmp29_, _tmp30_, _tmp32_, _tmp33_, _tmp35_);
				_tmp36_ = a;
				_tmp37_ = self->priv->list;
				_tmp38_ = a;
				_tmp39_ = _tmp38_->index;
				_tmp40_ = dest;
				_tmp41_ = b;
				_tmp42_ = _tmp41_->length;
				_tmp43_ = a;
				_tmp44_ = _tmp43_->length;
				gee_tim_sort_slice_merge_in (_tmp36_, _tmp37_, _tmp39_, _tmp40_ + _tmp42_, _tmp44_);
			}
			_gee_tim_sort_slice_free0 (a);
			_gee_tim_sort_slice_free0 (b);
			return;
		}
		while (TRUE) {
			gint a_count;
			gint b_count;
			gint _tmp110_;
			gint _tmp246_;
			gint _tmp247_;
			a_count = 0;
			b_count = 0;
			while (TRUE) {
				GeeTimSortSlice* _tmp45_;
				void* _tmp46_ = NULL;
				GeeTimSortSlice* _tmp47_;
				void* _tmp48_ = NULL;
				gboolean _tmp49_ = FALSE;
				_tmp45_ = b;
				_tmp46_ = gee_tim_sort_slice_peek_first (_tmp45_);
				_tmp47_ = a;
				_tmp48_ = gee_tim_sort_slice_peek_first (_tmp47_);
				_tmp49_ = gee_tim_sort_lower_than (self, _tmp46_, _tmp48_);
				if (_tmp49_) {
					void** _tmp50_;
					gint _tmp51_;
					GeeTimSortSlice* _tmp52_;
					void* _tmp53_ = NULL;
					void* _tmp54_;
					GeeTimSortSlice* _tmp55_;
					gint _tmp56_;
					gint _tmp77_;
					gint _tmp78_;
					gint _tmp79_;
					_tmp50_ = self->priv->list;
					_tmp51_ = dest;
					dest = _tmp51_ + 1;
					_tmp52_ = b;
					_tmp53_ = gee_tim_sort_slice_pop_first (_tmp52_);
					_tmp50_[_tmp51_] = _tmp53_;
					_tmp54_ = _tmp50_[_tmp51_];
					_tmp55_ = b;
					_tmp56_ = _tmp55_->length;
					if (_tmp56_ == 0) {
						{
							GeeTimSortSlice* _tmp57_;
							gint _tmp58_;
							GeeTimSortSlice* _tmp59_;
							gint _tmp60_;
							GeeTimSortSlice* _tmp61_;
							void** _tmp62_;
							GeeTimSortSlice* _tmp63_;
							gint _tmp64_;
							gint _tmp65_;
							GeeTimSortSlice* _tmp66_;
							gint _tmp67_;
							GeeTimSortSlice* _tmp68_;
							void** _tmp69_;
							GeeTimSortSlice* _tmp70_;
							gint _tmp71_;
							gint _tmp72_;
							GeeTimSortSlice* _tmp73_;
							gint _tmp74_;
							GeeTimSortSlice* _tmp75_;
							gint _tmp76_;
							_tmp57_ = a;
							_tmp58_ = _tmp57_->length;
							_vala_assert (_tmp58_ >= 0, "a.length >= 0");
							_tmp59_ = b;
							_tmp60_ = _tmp59_->length;
							_vala_assert (_tmp60_ >= 0, "b.length >= 0");
							_tmp61_ = b;
							_tmp62_ = self->priv->list;
							_tmp63_ = b;
							_tmp64_ = _tmp63_->index;
							_tmp65_ = dest;
							_tmp66_ = b;
							_tmp67_ = _tmp66_->length;
							gee_tim_sort_slice_merge_in (_tmp61_, _tmp62_, _tmp64_, _tmp65_, _tmp67_);
							_tmp68_ = a;
							_tmp69_ = self->priv->list;
							_tmp70_ = a;
							_tmp71_ = _tmp70_->index;
							_tmp72_ = dest;
							_tmp73_ = b;
							_tmp74_ = _tmp73_->length;
							_tmp75_ = a;
							_tmp76_ = _tmp75_->length;
							gee_tim_sort_slice_merge_in (_tmp68_, _tmp69_, _tmp71_, _tmp72_ + _tmp74_, _tmp76_);
						}
						_gee_tim_sort_slice_free0 (a);
						_gee_tim_sort_slice_free0 (b);
						return;
					}
					_tmp77_ = b_count;
					b_count = _tmp77_ + 1;
					a_count = 0;
					_tmp78_ = b_count;
					_tmp79_ = minimum_gallop;
					if (_tmp78_ >= _tmp79_) {
						break;
					}
				} else {
					void** _tmp80_;
					gint _tmp81_;
					GeeTimSortSlice* _tmp82_;
					void* _tmp83_ = NULL;
					void* _tmp84_;
					GeeTimSortSlice* _tmp85_;
					gint _tmp86_;
					gint _tmp107_;
					gint _tmp108_;
					gint _tmp109_;
					_tmp80_ = self->priv->list;
					_tmp81_ = dest;
					dest = _tmp81_ + 1;
					_tmp82_ = a;
					_tmp83_ = gee_tim_sort_slice_pop_first (_tmp82_);
					_tmp80_[_tmp81_] = _tmp83_;
					_tmp84_ = _tmp80_[_tmp81_];
					_tmp85_ = a;
					_tmp86_ = _tmp85_->length;
					if (_tmp86_ == 1) {
						{
							GeeTimSortSlice* _tmp87_;
							gint _tmp88_;
							GeeTimSortSlice* _tmp89_;
							gint _tmp90_;
							GeeTimSortSlice* _tmp91_;
							void** _tmp92_;
							GeeTimSortSlice* _tmp93_;
							gint _tmp94_;
							gint _tmp95_;
							GeeTimSortSlice* _tmp96_;
							gint _tmp97_;
							GeeTimSortSlice* _tmp98_;
							void** _tmp99_;
							GeeTimSortSlice* _tmp100_;
							gint _tmp101_;
							gint _tmp102_;
							GeeTimSortSlice* _tmp103_;
							gint _tmp104_;
							GeeTimSortSlice* _tmp105_;
							gint _tmp106_;
							_tmp87_ = a;
							_tmp88_ = _tmp87_->length;
							_vala_assert (_tmp88_ >= 0, "a.length >= 0");
							_tmp89_ = b;
							_tmp90_ = _tmp89_->length;
							_vala_assert (_tmp90_ >= 0, "b.length >= 0");
							_tmp91_ = b;
							_tmp92_ = self->priv->list;
							_tmp93_ = b;
							_tmp94_ = _tmp93_->index;
							_tmp95_ = dest;
							_tmp96_ = b;
							_tmp97_ = _tmp96_->length;
							gee_tim_sort_slice_merge_in (_tmp91_, _tmp92_, _tmp94_, _tmp95_, _tmp97_);
							_tmp98_ = a;
							_tmp99_ = self->priv->list;
							_tmp100_ = a;
							_tmp101_ = _tmp100_->index;
							_tmp102_ = dest;
							_tmp103_ = b;
							_tmp104_ = _tmp103_->length;
							_tmp105_ = a;
							_tmp106_ = _tmp105_->length;
							gee_tim_sort_slice_merge_in (_tmp98_, _tmp99_, _tmp101_, _tmp102_ + _tmp104_, _tmp106_);
						}
						_gee_tim_sort_slice_free0 (a);
						_gee_tim_sort_slice_free0 (b);
						return;
					}
					_tmp107_ = a_count;
					a_count = _tmp107_ + 1;
					b_count = 0;
					_tmp108_ = a_count;
					_tmp109_ = minimum_gallop;
					if (_tmp108_ >= _tmp109_) {
						break;
					}
				}
			}
			_tmp110_ = minimum_gallop;
			minimum_gallop = _tmp110_ + 1;
			while (TRUE) {
				gint _tmp111_ = 0;
				gint _tmp112_;
				gint _tmp113_;
				gint _tmp114_;
				gint _tmp115_;
				GeeTimSortSlice* _tmp116_;
				void* _tmp117_ = NULL;
				GeeTimSortSlice* _tmp118_;
				gint _tmp119_ = 0;
				GeeTimSortSlice* _tmp120_;
				void** _tmp121_;
				GeeTimSortSlice* _tmp122_;
				gint _tmp123_;
				gint _tmp124_;
				gint _tmp125_;
				gint _tmp126_;
				gint _tmp127_;
				GeeTimSortSlice* _tmp128_;
				gint _tmp129_;
				GeeTimSortSlice* _tmp130_;
				gint _tmp131_;
				void** _tmp152_;
				gint _tmp153_;
				GeeTimSortSlice* _tmp154_;
				void* _tmp155_ = NULL;
				void* _tmp156_;
				GeeTimSortSlice* _tmp157_;
				gint _tmp158_;
				GeeTimSortSlice* _tmp179_;
				void* _tmp180_ = NULL;
				GeeTimSortSlice* _tmp181_;
				gint _tmp182_ = 0;
				GeeTimSortSlice* _tmp183_;
				void** _tmp184_;
				GeeTimSortSlice* _tmp185_;
				gint _tmp186_;
				gint _tmp187_;
				gint _tmp188_;
				gint _tmp189_;
				gint _tmp190_;
				GeeTimSortSlice* _tmp191_;
				gint _tmp192_;
				GeeTimSortSlice* _tmp193_;
				gint _tmp194_;
				void** _tmp215_;
				gint _tmp216_;
				GeeTimSortSlice* _tmp217_;
				void* _tmp218_ = NULL;
				void* _tmp219_;
				GeeTimSortSlice* _tmp220_;
				gint _tmp221_;
				gboolean _tmp242_ = FALSE;
				gint _tmp243_;
				gboolean _tmp245_;
				_tmp112_ = minimum_gallop;
				if (_tmp112_ > 1) {
					_tmp111_ = 1;
				} else {
					_tmp111_ = 0;
				}
				_tmp113_ = minimum_gallop;
				_tmp114_ = _tmp111_;
				minimum_gallop = _tmp113_ - _tmp114_;
				_tmp115_ = minimum_gallop;
				self->priv->minimum_gallop = _tmp115_;
				_tmp116_ = b;
				_tmp117_ = gee_tim_sort_slice_peek_first (_tmp116_);
				_tmp118_ = a;
				_tmp119_ = gee_tim_sort_gallop_rightmost (self, _tmp117_, _tmp118_, 0);
				a_count = _tmp119_;
				_tmp120_ = a;
				_tmp121_ = self->priv->list;
				_tmp122_ = a;
				_tmp123_ = _tmp122_->index;
				_tmp124_ = dest;
				_tmp125_ = a_count;
				gee_tim_sort_slice_merge_in (_tmp120_, _tmp121_, _tmp123_, _tmp124_, _tmp125_);
				_tmp126_ = dest;
				_tmp127_ = a_count;
				dest = _tmp126_ + _tmp127_;
				_tmp128_ = a;
				_tmp129_ = a_count;
				gee_tim_sort_slice_shorten_start (_tmp128_, _tmp129_);
				_tmp130_ = a;
				_tmp131_ = _tmp130_->length;
				if (_tmp131_ <= 1) {
					{
						GeeTimSortSlice* _tmp132_;
						gint _tmp133_;
						GeeTimSortSlice* _tmp134_;
						gint _tmp135_;
						GeeTimSortSlice* _tmp136_;
						void** _tmp137_;
						GeeTimSortSlice* _tmp138_;
						gint _tmp139_;
						gint _tmp140_;
						GeeTimSortSlice* _tmp141_;
						gint _tmp142_;
						GeeTimSortSlice* _tmp143_;
						void** _tmp144_;
						GeeTimSortSlice* _tmp145_;
						gint _tmp146_;
						gint _tmp147_;
						GeeTimSortSlice* _tmp148_;
						gint _tmp149_;
						GeeTimSortSlice* _tmp150_;
						gint _tmp151_;
						_tmp132_ = a;
						_tmp133_ = _tmp132_->length;
						_vala_assert (_tmp133_ >= 0, "a.length >= 0");
						_tmp134_ = b;
						_tmp135_ = _tmp134_->length;
						_vala_assert (_tmp135_ >= 0, "b.length >= 0");
						_tmp136_ = b;
						_tmp137_ = self->priv->list;
						_tmp138_ = b;
						_tmp139_ = _tmp138_->index;
						_tmp140_ = dest;
						_tmp141_ = b;
						_tmp142_ = _tmp141_->length;
						gee_tim_sort_slice_merge_in (_tmp136_, _tmp137_, _tmp139_, _tmp140_, _tmp142_);
						_tmp143_ = a;
						_tmp144_ = self->priv->list;
						_tmp145_ = a;
						_tmp146_ = _tmp145_->index;
						_tmp147_ = dest;
						_tmp148_ = b;
						_tmp149_ = _tmp148_->length;
						_tmp150_ = a;
						_tmp151_ = _tmp150_->length;
						gee_tim_sort_slice_merge_in (_tmp143_, _tmp144_, _tmp146_, _tmp147_ + _tmp149_, _tmp151_);
					}
					_gee_tim_sort_slice_free0 (a);
					_gee_tim_sort_slice_free0 (b);
					return;
				}
				_tmp152_ = self->priv->list;
				_tmp153_ = dest;
				dest = _tmp153_ + 1;
				_tmp154_ = b;
				_tmp155_ = gee_tim_sort_slice_pop_first (_tmp154_);
				_tmp152_[_tmp153_] = _tmp155_;
				_tmp156_ = _tmp152_[_tmp153_];
				_tmp157_ = b;
				_tmp158_ = _tmp157_->length;
				if (_tmp158_ == 0) {
					{
						GeeTimSortSlice* _tmp159_;
						gint _tmp160_;
						GeeTimSortSlice* _tmp161_;
						gint _tmp162_;
						GeeTimSortSlice* _tmp163_;
						void** _tmp164_;
						GeeTimSortSlice* _tmp165_;
						gint _tmp166_;
						gint _tmp167_;
						GeeTimSortSlice* _tmp168_;
						gint _tmp169_;
						GeeTimSortSlice* _tmp170_;
						void** _tmp171_;
						GeeTimSortSlice* _tmp172_;
						gint _tmp173_;
						gint _tmp174_;
						GeeTimSortSlice* _tmp175_;
						gint _tmp176_;
						GeeTimSortSlice* _tmp177_;
						gint _tmp178_;
						_tmp159_ = a;
						_tmp160_ = _tmp159_->length;
						_vala_assert (_tmp160_ >= 0, "a.length >= 0");
						_tmp161_ = b;
						_tmp162_ = _tmp161_->length;
						_vala_assert (_tmp162_ >= 0, "b.length >= 0");
						_tmp163_ = b;
						_tmp164_ = self->priv->list;
						_tmp165_ = b;
						_tmp166_ = _tmp165_->index;
						_tmp167_ = dest;
						_tmp168_ = b;
						_tmp169_ = _tmp168_->length;
						gee_tim_sort_slice_merge_in (_tmp163_, _tmp164_, _tmp166_, _tmp167_, _tmp169_);
						_tmp170_ = a;
						_tmp171_ = self->priv->list;
						_tmp172_ = a;
						_tmp173_ = _tmp172_->index;
						_tmp174_ = dest;
						_tmp175_ = b;
						_tmp176_ = _tmp175_->length;
						_tmp177_ = a;
						_tmp178_ = _tmp177_->length;
						gee_tim_sort_slice_merge_in (_tmp170_, _tmp171_, _tmp173_, _tmp174_ + _tmp176_, _tmp178_);
					}
					_gee_tim_sort_slice_free0 (a);
					_gee_tim_sort_slice_free0 (b);
					return;
				}
				_tmp179_ = a;
				_tmp180_ = gee_tim_sort_slice_peek_first (_tmp179_);
				_tmp181_ = b;
				_tmp182_ = gee_tim_sort_gallop_leftmost (self, _tmp180_, _tmp181_, 0);
				b_count = _tmp182_;
				_tmp183_ = b;
				_tmp184_ = self->priv->list;
				_tmp185_ = b;
				_tmp186_ = _tmp185_->index;
				_tmp187_ = dest;
				_tmp188_ = b_count;
				gee_tim_sort_slice_merge_in (_tmp183_, _tmp184_, _tmp186_, _tmp187_, _tmp188_);
				_tmp189_ = dest;
				_tmp190_ = b_count;
				dest = _tmp189_ + _tmp190_;
				_tmp191_ = b;
				_tmp192_ = b_count;
				gee_tim_sort_slice_shorten_start (_tmp191_, _tmp192_);
				_tmp193_ = b;
				_tmp194_ = _tmp193_->length;
				if (_tmp194_ == 0) {
					{
						GeeTimSortSlice* _tmp195_;
						gint _tmp196_;
						GeeTimSortSlice* _tmp197_;
						gint _tmp198_;
						GeeTimSortSlice* _tmp199_;
						void** _tmp200_;
						GeeTimSortSlice* _tmp201_;
						gint _tmp202_;
						gint _tmp203_;
						GeeTimSortSlice* _tmp204_;
						gint _tmp205_;
						GeeTimSortSlice* _tmp206_;
						void** _tmp207_;
						GeeTimSortSlice* _tmp208_;
						gint _tmp209_;
						gint _tmp210_;
						GeeTimSortSlice* _tmp211_;
						gint _tmp212_;
						GeeTimSortSlice* _tmp213_;
						gint _tmp214_;
						_tmp195_ = a;
						_tmp196_ = _tmp195_->length;
						_vala_assert (_tmp196_ >= 0, "a.length >= 0");
						_tmp197_ = b;
						_tmp198_ = _tmp197_->length;
						_vala_assert (_tmp198_ >= 0, "b.length >= 0");
						_tmp199_ = b;
						_tmp200_ = self->priv->list;
						_tmp201_ = b;
						_tmp202_ = _tmp201_->index;
						_tmp203_ = dest;
						_tmp204_ = b;
						_tmp205_ = _tmp204_->length;
						gee_tim_sort_slice_merge_in (_tmp199_, _tmp200_, _tmp202_, _tmp203_, _tmp205_);
						_tmp206_ = a;
						_tmp207_ = self->priv->list;
						_tmp208_ = a;
						_tmp209_ = _tmp208_->index;
						_tmp210_ = dest;
						_tmp211_ = b;
						_tmp212_ = _tmp211_->length;
						_tmp213_ = a;
						_tmp214_ = _tmp213_->length;
						gee_tim_sort_slice_merge_in (_tmp206_, _tmp207_, _tmp209_, _tmp210_ + _tmp212_, _tmp214_);
					}
					_gee_tim_sort_slice_free0 (a);
					_gee_tim_sort_slice_free0 (b);
					return;
				}
				_tmp215_ = self->priv->list;
				_tmp216_ = dest;
				dest = _tmp216_ + 1;
				_tmp217_ = a;
				_tmp218_ = gee_tim_sort_slice_pop_first (_tmp217_);
				_tmp215_[_tmp216_] = _tmp218_;
				_tmp219_ = _tmp215_[_tmp216_];
				_tmp220_ = a;
				_tmp221_ = _tmp220_->length;
				if (_tmp221_ == 1) {
					{
						GeeTimSortSlice* _tmp222_;
						gint _tmp223_;
						GeeTimSortSlice* _tmp224_;
						gint _tmp225_;
						GeeTimSortSlice* _tmp226_;
						void** _tmp227_;
						GeeTimSortSlice* _tmp228_;
						gint _tmp229_;
						gint _tmp230_;
						GeeTimSortSlice* _tmp231_;
						gint _tmp232_;
						GeeTimSortSlice* _tmp233_;
						void** _tmp234_;
						GeeTimSortSlice* _tmp235_;
						gint _tmp236_;
						gint _tmp237_;
						GeeTimSortSlice* _tmp238_;
						gint _tmp239_;
						GeeTimSortSlice* _tmp240_;
						gint _tmp241_;
						_tmp222_ = a;
						_tmp223_ = _tmp222_->length;
						_vala_assert (_tmp223_ >= 0, "a.length >= 0");
						_tmp224_ = b;
						_tmp225_ = _tmp224_->length;
						_vala_assert (_tmp225_ >= 0, "b.length >= 0");
						_tmp226_ = b;
						_tmp227_ = self->priv->list;
						_tmp228_ = b;
						_tmp229_ = _tmp228_->index;
						_tmp230_ = dest;
						_tmp231_ = b;
						_tmp232_ = _tmp231_->length;
						gee_tim_sort_slice_merge_in (_tmp226_, _tmp227_, _tmp229_, _tmp230_, _tmp232_);
						_tmp233_ = a;
						_tmp234_ = self->priv->list;
						_tmp235_ = a;
						_tmp236_ = _tmp235_->index;
						_tmp237_ = dest;
						_tmp238_ = b;
						_tmp239_ = _tmp238_->length;
						_tmp240_ = a;
						_tmp241_ = _tmp240_->length;
						gee_tim_sort_slice_merge_in (_tmp233_, _tmp234_, _tmp236_, _tmp237_ + _tmp239_, _tmp241_);
					}
					_gee_tim_sort_slice_free0 (a);
					_gee_tim_sort_slice_free0 (b);
					return;
				}
				_tmp243_ = a_count;
				if (_tmp243_ < GEE_TIM_SORT_MINIMUM_GALLOP) {
					gint _tmp244_;
					_tmp244_ = b_count;
					_tmp242_ = _tmp244_ < GEE_TIM_SORT_MINIMUM_GALLOP;
				} else {
					_tmp242_ = FALSE;
				}
				_tmp245_ = _tmp242_;
				if (_tmp245_) {
					break;
				}
			}
			_tmp246_ = minimum_gallop;
			minimum_gallop = _tmp246_ + 1;
			_tmp247_ = minimum_gallop;
			self->priv->minimum_gallop = _tmp247_;
		}
	}
	__finally1:
	{
		GeeTimSortSlice* _tmp248_;
		gint _tmp249_;
		GeeTimSortSlice* _tmp250_;
		gint _tmp251_;
		GeeTimSortSlice* _tmp252_;
		void** _tmp253_;
		GeeTimSortSlice* _tmp254_;
		gint _tmp255_;
		gint _tmp256_;
		GeeTimSortSlice* _tmp257_;
		gint _tmp258_;
		GeeTimSortSlice* _tmp259_;
		void** _tmp260_;
		GeeTimSortSlice* _tmp261_;
		gint _tmp262_;
		gint _tmp263_;
		GeeTimSortSlice* _tmp264_;
		gint _tmp265_;
		GeeTimSortSlice* _tmp266_;
		gint _tmp267_;
		_tmp248_ = a;
		_tmp249_ = _tmp248_->length;
		_vala_assert (_tmp249_ >= 0, "a.length >= 0");
		_tmp250_ = b;
		_tmp251_ = _tmp250_->length;
		_vala_assert (_tmp251_ >= 0, "b.length >= 0");
		_tmp252_ = b;
		_tmp253_ = self->priv->list;
		_tmp254_ = b;
		_tmp255_ = _tmp254_->index;
		_tmp256_ = dest;
		_tmp257_ = b;
		_tmp258_ = _tmp257_->length;
		gee_tim_sort_slice_merge_in (_tmp252_, _tmp253_, _tmp255_, _tmp256_, _tmp258_);
		_tmp259_ = a;
		_tmp260_ = self->priv->list;
		_tmp261_ = a;
		_tmp262_ = _tmp261_->index;
		_tmp263_ = dest;
		_tmp264_ = b;
		_tmp265_ = _tmp264_->length;
		_tmp266_ = a;
		_tmp267_ = _tmp266_->length;
		gee_tim_sort_slice_merge_in (_tmp259_, _tmp260_, _tmp262_, _tmp263_ + _tmp265_, _tmp267_);
	}
	_gee_tim_sort_slice_free0 (a);
	_gee_tim_sort_slice_free0 (b);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return;
}


static void gee_tim_sort_merge_high (GeeTimSort* self, GeeTimSortSlice* a, GeeTimSortSlice* b) {
	GeeTimSortSlice* _tmp0_;
	gint _tmp1_;
	GeeTimSortSlice* _tmp2_;
	gint _tmp3_;
	GeeTimSortSlice* _tmp4_;
	gint _tmp5_;
	GeeTimSortSlice* _tmp6_;
	gint _tmp7_;
	GeeTimSortSlice* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gint minimum_gallop;
	GeeTimSortSlice* _tmp11_;
	gint _tmp12_;
	GeeTimSortSlice* _tmp13_;
	gint _tmp14_;
	gint dest;
	GeeTimSortSlice* _tmp15_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (a != NULL);
	g_return_if_fail (b != NULL);
	_tmp0_ = a;
	_tmp1_ = _tmp0_->length;
	_vala_assert (_tmp1_ > 0, "a.length > 0");
	_tmp2_ = b;
	_tmp3_ = _tmp2_->length;
	_vala_assert (_tmp3_ > 0, "b.length > 0");
	_tmp4_ = a;
	_tmp5_ = _tmp4_->index;
	_tmp6_ = a;
	_tmp7_ = _tmp6_->length;
	_tmp8_ = b;
	_tmp9_ = _tmp8_->index;
	_vala_assert ((_tmp5_ + _tmp7_) == _tmp9_, "a.index + a.length == b.index");
	_tmp10_ = self->priv->minimum_gallop;
	minimum_gallop = _tmp10_;
	_tmp11_ = b;
	_tmp12_ = _tmp11_->index;
	_tmp13_ = b;
	_tmp14_ = _tmp13_->length;
	dest = _tmp12_ + _tmp14_;
	_tmp15_ = b;
	gee_tim_sort_slice_copy (_tmp15_);
	{
		void** _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		GeeTimSortSlice* _tmp19_;
		void* _tmp20_ = NULL;
		void* _tmp21_;
		gboolean _tmp22_ = FALSE;
		GeeTimSortSlice* _tmp23_;
		gint _tmp24_;
		gboolean _tmp27_;
		_tmp16_ = self->priv->list;
		_tmp17_ = dest;
		dest = _tmp17_ - 1;
		_tmp18_ = dest;
		_tmp19_ = a;
		_tmp20_ = gee_tim_sort_slice_pop_last (_tmp19_);
		_tmp16_[_tmp18_] = _tmp20_;
		_tmp21_ = _tmp16_[_tmp18_];
		_tmp23_ = a;
		_tmp24_ = _tmp23_->length;
		if (_tmp24_ == 0) {
			_tmp22_ = TRUE;
		} else {
			GeeTimSortSlice* _tmp25_;
			gint _tmp26_;
			_tmp25_ = b;
			_tmp26_ = _tmp25_->length;
			_tmp22_ = _tmp26_ == 1;
		}
		_tmp27_ = _tmp22_;
		if (_tmp27_) {
			{
				GeeTimSortSlice* _tmp28_;
				gint _tmp29_;
				GeeTimSortSlice* _tmp30_;
				gint _tmp31_;
				GeeTimSortSlice* _tmp32_;
				void** _tmp33_;
				GeeTimSortSlice* _tmp34_;
				gint _tmp35_;
				gint _tmp36_;
				GeeTimSortSlice* _tmp37_;
				gint _tmp38_;
				GeeTimSortSlice* _tmp39_;
				gint _tmp40_;
				GeeTimSortSlice* _tmp41_;
				void** _tmp42_;
				GeeTimSortSlice* _tmp43_;
				gint _tmp44_;
				gint _tmp45_;
				GeeTimSortSlice* _tmp46_;
				gint _tmp47_;
				GeeTimSortSlice* _tmp48_;
				gint _tmp49_;
				GeeTimSortSlice* _tmp50_;
				gint _tmp51_;
				_tmp28_ = a;
				_tmp29_ = _tmp28_->length;
				_vala_assert (_tmp29_ >= 0, "a.length >= 0");
				_tmp30_ = b;
				_tmp31_ = _tmp30_->length;
				_vala_assert (_tmp31_ >= 0, "b.length >= 0");
				_tmp32_ = a;
				_tmp33_ = self->priv->list;
				_tmp34_ = a;
				_tmp35_ = _tmp34_->index;
				_tmp36_ = dest;
				_tmp37_ = a;
				_tmp38_ = _tmp37_->length;
				_tmp39_ = a;
				_tmp40_ = _tmp39_->length;
				gee_tim_sort_slice_merge_in_reversed (_tmp32_, _tmp33_, _tmp35_, _tmp36_ - _tmp38_, _tmp40_);
				_tmp41_ = b;
				_tmp42_ = self->priv->list;
				_tmp43_ = b;
				_tmp44_ = _tmp43_->index;
				_tmp45_ = dest;
				_tmp46_ = a;
				_tmp47_ = _tmp46_->length;
				_tmp48_ = b;
				_tmp49_ = _tmp48_->length;
				_tmp50_ = b;
				_tmp51_ = _tmp50_->length;
				gee_tim_sort_slice_merge_in_reversed (_tmp41_, _tmp42_, _tmp44_, (_tmp45_ - _tmp47_) - _tmp49_, _tmp51_);
			}
			_gee_tim_sort_slice_free0 (a);
			_gee_tim_sort_slice_free0 (b);
			return;
		}
		while (TRUE) {
			gint a_count;
			gint b_count;
			gint _tmp127_;
			gint _tmp295_;
			gint _tmp296_;
			a_count = 0;
			b_count = 0;
			while (TRUE) {
				GeeTimSortSlice* _tmp52_;
				void* _tmp53_ = NULL;
				GeeTimSortSlice* _tmp54_;
				void* _tmp55_ = NULL;
				gboolean _tmp56_ = FALSE;
				_tmp52_ = b;
				_tmp53_ = gee_tim_sort_slice_peek_last (_tmp52_);
				_tmp54_ = a;
				_tmp55_ = gee_tim_sort_slice_peek_last (_tmp54_);
				_tmp56_ = gee_tim_sort_lower_than (self, _tmp53_, _tmp55_);
				if (_tmp56_) {
					void** _tmp57_;
					gint _tmp58_;
					gint _tmp59_;
					GeeTimSortSlice* _tmp60_;
					void* _tmp61_ = NULL;
					void* _tmp62_;
					GeeTimSortSlice* _tmp63_;
					gint _tmp64_;
					gint _tmp89_;
					gint _tmp90_;
					gint _tmp91_;
					_tmp57_ = self->priv->list;
					_tmp58_ = dest;
					dest = _tmp58_ - 1;
					_tmp59_ = dest;
					_tmp60_ = a;
					_tmp61_ = gee_tim_sort_slice_pop_last (_tmp60_);
					_tmp57_[_tmp59_] = _tmp61_;
					_tmp62_ = _tmp57_[_tmp59_];
					_tmp63_ = a;
					_tmp64_ = _tmp63_->length;
					if (_tmp64_ == 0) {
						{
							GeeTimSortSlice* _tmp65_;
							gint _tmp66_;
							GeeTimSortSlice* _tmp67_;
							gint _tmp68_;
							GeeTimSortSlice* _tmp69_;
							void** _tmp70_;
							GeeTimSortSlice* _tmp71_;
							gint _tmp72_;
							gint _tmp73_;
							GeeTimSortSlice* _tmp74_;
							gint _tmp75_;
							GeeTimSortSlice* _tmp76_;
							gint _tmp77_;
							GeeTimSortSlice* _tmp78_;
							void** _tmp79_;
							GeeTimSortSlice* _tmp80_;
							gint _tmp81_;
							gint _tmp82_;
							GeeTimSortSlice* _tmp83_;
							gint _tmp84_;
							GeeTimSortSlice* _tmp85_;
							gint _tmp86_;
							GeeTimSortSlice* _tmp87_;
							gint _tmp88_;
							_tmp65_ = a;
							_tmp66_ = _tmp65_->length;
							_vala_assert (_tmp66_ >= 0, "a.length >= 0");
							_tmp67_ = b;
							_tmp68_ = _tmp67_->length;
							_vala_assert (_tmp68_ >= 0, "b.length >= 0");
							_tmp69_ = a;
							_tmp70_ = self->priv->list;
							_tmp71_ = a;
							_tmp72_ = _tmp71_->index;
							_tmp73_ = dest;
							_tmp74_ = a;
							_tmp75_ = _tmp74_->length;
							_tmp76_ = a;
							_tmp77_ = _tmp76_->length;
							gee_tim_sort_slice_merge_in_reversed (_tmp69_, _tmp70_, _tmp72_, _tmp73_ - _tmp75_, _tmp77_);
							_tmp78_ = b;
							_tmp79_ = self->priv->list;
							_tmp80_ = b;
							_tmp81_ = _tmp80_->index;
							_tmp82_ = dest;
							_tmp83_ = a;
							_tmp84_ = _tmp83_->length;
							_tmp85_ = b;
							_tmp86_ = _tmp85_->length;
							_tmp87_ = b;
							_tmp88_ = _tmp87_->length;
							gee_tim_sort_slice_merge_in_reversed (_tmp78_, _tmp79_, _tmp81_, (_tmp82_ - _tmp84_) - _tmp86_, _tmp88_);
						}
						_gee_tim_sort_slice_free0 (a);
						_gee_tim_sort_slice_free0 (b);
						return;
					}
					_tmp89_ = a_count;
					a_count = _tmp89_ + 1;
					b_count = 0;
					_tmp90_ = a_count;
					_tmp91_ = minimum_gallop;
					if (_tmp90_ >= _tmp91_) {
						break;
					}
				} else {
					void** _tmp92_;
					gint _tmp93_;
					gint _tmp94_;
					GeeTimSortSlice* _tmp95_;
					void* _tmp96_ = NULL;
					void* _tmp97_;
					GeeTimSortSlice* _tmp98_;
					gint _tmp99_;
					gint _tmp124_;
					gint _tmp125_;
					gint _tmp126_;
					_tmp92_ = self->priv->list;
					_tmp93_ = dest;
					dest = _tmp93_ - 1;
					_tmp94_ = dest;
					_tmp95_ = b;
					_tmp96_ = gee_tim_sort_slice_pop_last (_tmp95_);
					_tmp92_[_tmp94_] = _tmp96_;
					_tmp97_ = _tmp92_[_tmp94_];
					_tmp98_ = b;
					_tmp99_ = _tmp98_->length;
					if (_tmp99_ == 1) {
						{
							GeeTimSortSlice* _tmp100_;
							gint _tmp101_;
							GeeTimSortSlice* _tmp102_;
							gint _tmp103_;
							GeeTimSortSlice* _tmp104_;
							void** _tmp105_;
							GeeTimSortSlice* _tmp106_;
							gint _tmp107_;
							gint _tmp108_;
							GeeTimSortSlice* _tmp109_;
							gint _tmp110_;
							GeeTimSortSlice* _tmp111_;
							gint _tmp112_;
							GeeTimSortSlice* _tmp113_;
							void** _tmp114_;
							GeeTimSortSlice* _tmp115_;
							gint _tmp116_;
							gint _tmp117_;
							GeeTimSortSlice* _tmp118_;
							gint _tmp119_;
							GeeTimSortSlice* _tmp120_;
							gint _tmp121_;
							GeeTimSortSlice* _tmp122_;
							gint _tmp123_;
							_tmp100_ = a;
							_tmp101_ = _tmp100_->length;
							_vala_assert (_tmp101_ >= 0, "a.length >= 0");
							_tmp102_ = b;
							_tmp103_ = _tmp102_->length;
							_vala_assert (_tmp103_ >= 0, "b.length >= 0");
							_tmp104_ = a;
							_tmp105_ = self->priv->list;
							_tmp106_ = a;
							_tmp107_ = _tmp106_->index;
							_tmp108_ = dest;
							_tmp109_ = a;
							_tmp110_ = _tmp109_->length;
							_tmp111_ = a;
							_tmp112_ = _tmp111_->length;
							gee_tim_sort_slice_merge_in_reversed (_tmp104_, _tmp105_, _tmp107_, _tmp108_ - _tmp110_, _tmp112_);
							_tmp113_ = b;
							_tmp114_ = self->priv->list;
							_tmp115_ = b;
							_tmp116_ = _tmp115_->index;
							_tmp117_ = dest;
							_tmp118_ = a;
							_tmp119_ = _tmp118_->length;
							_tmp120_ = b;
							_tmp121_ = _tmp120_->length;
							_tmp122_ = b;
							_tmp123_ = _tmp122_->length;
							gee_tim_sort_slice_merge_in_reversed (_tmp113_, _tmp114_, _tmp116_, (_tmp117_ - _tmp119_) - _tmp121_, _tmp123_);
						}
						_gee_tim_sort_slice_free0 (a);
						_gee_tim_sort_slice_free0 (b);
						return;
					}
					_tmp124_ = b_count;
					b_count = _tmp124_ + 1;
					a_count = 0;
					_tmp125_ = b_count;
					_tmp126_ = minimum_gallop;
					if (_tmp125_ >= _tmp126_) {
						break;
					}
				}
			}
			_tmp127_ = minimum_gallop;
			minimum_gallop = _tmp127_ + 1;
			while (TRUE) {
				gint _tmp128_ = 0;
				gint _tmp129_;
				gint _tmp130_;
				gint _tmp131_;
				gint _tmp132_;
				GeeTimSortSlice* _tmp133_;
				void* _tmp134_ = NULL;
				GeeTimSortSlice* _tmp135_;
				GeeTimSortSlice* _tmp136_;
				gint _tmp137_;
				gint _tmp138_ = 0;
				gint k;
				GeeTimSortSlice* _tmp139_;
				gint _tmp140_;
				gint _tmp141_;
				GeeTimSortSlice* _tmp142_;
				void** _tmp143_;
				GeeTimSortSlice* _tmp144_;
				gint _tmp145_;
				gint _tmp146_;
				gint _tmp147_;
				gint _tmp148_;
				gint _tmp149_;
				gint _tmp150_;
				gint _tmp151_;
				GeeTimSortSlice* _tmp152_;
				gint _tmp153_;
				GeeTimSortSlice* _tmp154_;
				gint _tmp155_;
				void** _tmp180_;
				gint _tmp181_;
				gint _tmp182_;
				GeeTimSortSlice* _tmp183_;
				void* _tmp184_ = NULL;
				void* _tmp185_;
				GeeTimSortSlice* _tmp186_;
				gint _tmp187_;
				GeeTimSortSlice* _tmp212_;
				void* _tmp213_ = NULL;
				GeeTimSortSlice* _tmp214_;
				GeeTimSortSlice* _tmp215_;
				gint _tmp216_;
				gint _tmp217_ = 0;
				GeeTimSortSlice* _tmp218_;
				gint _tmp219_;
				gint _tmp220_;
				GeeTimSortSlice* _tmp221_;
				void** _tmp222_;
				GeeTimSortSlice* _tmp223_;
				gint _tmp224_;
				gint _tmp225_;
				gint _tmp226_;
				gint _tmp227_;
				gint _tmp228_;
				gint _tmp229_;
				gint _tmp230_;
				GeeTimSortSlice* _tmp231_;
				gint _tmp232_;
				GeeTimSortSlice* _tmp233_;
				gint _tmp234_;
				void** _tmp259_;
				gint _tmp260_;
				gint _tmp261_;
				GeeTimSortSlice* _tmp262_;
				void* _tmp263_ = NULL;
				void* _tmp264_;
				GeeTimSortSlice* _tmp265_;
				gint _tmp266_;
				gboolean _tmp291_ = FALSE;
				gint _tmp292_;
				gboolean _tmp294_;
				_tmp129_ = minimum_gallop;
				if (_tmp129_ > 1) {
					_tmp128_ = 1;
				} else {
					_tmp128_ = 0;
				}
				_tmp130_ = minimum_gallop;
				_tmp131_ = _tmp128_;
				minimum_gallop = _tmp130_ - _tmp131_;
				_tmp132_ = minimum_gallop;
				self->priv->minimum_gallop = _tmp132_;
				_tmp133_ = b;
				_tmp134_ = gee_tim_sort_slice_peek_last (_tmp133_);
				_tmp135_ = a;
				_tmp136_ = a;
				_tmp137_ = _tmp136_->length;
				_tmp138_ = gee_tim_sort_gallop_rightmost (self, _tmp134_, _tmp135_, _tmp137_ - 1);
				k = _tmp138_;
				_tmp139_ = a;
				_tmp140_ = _tmp139_->length;
				_tmp141_ = k;
				a_count = _tmp140_ - _tmp141_;
				_tmp142_ = a;
				_tmp143_ = self->priv->list;
				_tmp144_ = a;
				_tmp145_ = _tmp144_->index;
				_tmp146_ = k;
				_tmp147_ = dest;
				_tmp148_ = a_count;
				_tmp149_ = a_count;
				gee_tim_sort_slice_merge_in_reversed (_tmp142_, _tmp143_, _tmp145_ + _tmp146_, _tmp147_ - _tmp148_, _tmp149_);
				_tmp150_ = dest;
				_tmp151_ = a_count;
				dest = _tmp150_ - _tmp151_;
				_tmp152_ = a;
				_tmp153_ = a_count;
				gee_tim_sort_slice_shorten_end (_tmp152_, _tmp153_);
				_tmp154_ = a;
				_tmp155_ = _tmp154_->length;
				if (_tmp155_ == 0) {
					{
						GeeTimSortSlice* _tmp156_;
						gint _tmp157_;
						GeeTimSortSlice* _tmp158_;
						gint _tmp159_;
						GeeTimSortSlice* _tmp160_;
						void** _tmp161_;
						GeeTimSortSlice* _tmp162_;
						gint _tmp163_;
						gint _tmp164_;
						GeeTimSortSlice* _tmp165_;
						gint _tmp166_;
						GeeTimSortSlice* _tmp167_;
						gint _tmp168_;
						GeeTimSortSlice* _tmp169_;
						void** _tmp170_;
						GeeTimSortSlice* _tmp171_;
						gint _tmp172_;
						gint _tmp173_;
						GeeTimSortSlice* _tmp174_;
						gint _tmp175_;
						GeeTimSortSlice* _tmp176_;
						gint _tmp177_;
						GeeTimSortSlice* _tmp178_;
						gint _tmp179_;
						_tmp156_ = a;
						_tmp157_ = _tmp156_->length;
						_vala_assert (_tmp157_ >= 0, "a.length >= 0");
						_tmp158_ = b;
						_tmp159_ = _tmp158_->length;
						_vala_assert (_tmp159_ >= 0, "b.length >= 0");
						_tmp160_ = a;
						_tmp161_ = self->priv->list;
						_tmp162_ = a;
						_tmp163_ = _tmp162_->index;
						_tmp164_ = dest;
						_tmp165_ = a;
						_tmp166_ = _tmp165_->length;
						_tmp167_ = a;
						_tmp168_ = _tmp167_->length;
						gee_tim_sort_slice_merge_in_reversed (_tmp160_, _tmp161_, _tmp163_, _tmp164_ - _tmp166_, _tmp168_);
						_tmp169_ = b;
						_tmp170_ = self->priv->list;
						_tmp171_ = b;
						_tmp172_ = _tmp171_->index;
						_tmp173_ = dest;
						_tmp174_ = a;
						_tmp175_ = _tmp174_->length;
						_tmp176_ = b;
						_tmp177_ = _tmp176_->length;
						_tmp178_ = b;
						_tmp179_ = _tmp178_->length;
						gee_tim_sort_slice_merge_in_reversed (_tmp169_, _tmp170_, _tmp172_, (_tmp173_ - _tmp175_) - _tmp177_, _tmp179_);
					}
					_gee_tim_sort_slice_free0 (a);
					_gee_tim_sort_slice_free0 (b);
					return;
				}
				_tmp180_ = self->priv->list;
				_tmp181_ = dest;
				dest = _tmp181_ - 1;
				_tmp182_ = dest;
				_tmp183_ = b;
				_tmp184_ = gee_tim_sort_slice_pop_last (_tmp183_);
				_tmp180_[_tmp182_] = _tmp184_;
				_tmp185_ = _tmp180_[_tmp182_];
				_tmp186_ = b;
				_tmp187_ = _tmp186_->length;
				if (_tmp187_ == 1) {
					{
						GeeTimSortSlice* _tmp188_;
						gint _tmp189_;
						GeeTimSortSlice* _tmp190_;
						gint _tmp191_;
						GeeTimSortSlice* _tmp192_;
						void** _tmp193_;
						GeeTimSortSlice* _tmp194_;
						gint _tmp195_;
						gint _tmp196_;
						GeeTimSortSlice* _tmp197_;
						gint _tmp198_;
						GeeTimSortSlice* _tmp199_;
						gint _tmp200_;
						GeeTimSortSlice* _tmp201_;
						void** _tmp202_;
						GeeTimSortSlice* _tmp203_;
						gint _tmp204_;
						gint _tmp205_;
						GeeTimSortSlice* _tmp206_;
						gint _tmp207_;
						GeeTimSortSlice* _tmp208_;
						gint _tmp209_;
						GeeTimSortSlice* _tmp210_;
						gint _tmp211_;
						_tmp188_ = a;
						_tmp189_ = _tmp188_->length;
						_vala_assert (_tmp189_ >= 0, "a.length >= 0");
						_tmp190_ = b;
						_tmp191_ = _tmp190_->length;
						_vala_assert (_tmp191_ >= 0, "b.length >= 0");
						_tmp192_ = a;
						_tmp193_ = self->priv->list;
						_tmp194_ = a;
						_tmp195_ = _tmp194_->index;
						_tmp196_ = dest;
						_tmp197_ = a;
						_tmp198_ = _tmp197_->length;
						_tmp199_ = a;
						_tmp200_ = _tmp199_->length;
						gee_tim_sort_slice_merge_in_reversed (_tmp192_, _tmp193_, _tmp195_, _tmp196_ - _tmp198_, _tmp200_);
						_tmp201_ = b;
						_tmp202_ = self->priv->list;
						_tmp203_ = b;
						_tmp204_ = _tmp203_->index;
						_tmp205_ = dest;
						_tmp206_ = a;
						_tmp207_ = _tmp206_->length;
						_tmp208_ = b;
						_tmp209_ = _tmp208_->length;
						_tmp210_ = b;
						_tmp211_ = _tmp210_->length;
						gee_tim_sort_slice_merge_in_reversed (_tmp201_, _tmp202_, _tmp204_, (_tmp205_ - _tmp207_) - _tmp209_, _tmp211_);
					}
					_gee_tim_sort_slice_free0 (a);
					_gee_tim_sort_slice_free0 (b);
					return;
				}
				_tmp212_ = a;
				_tmp213_ = gee_tim_sort_slice_peek_last (_tmp212_);
				_tmp214_ = b;
				_tmp215_ = b;
				_tmp216_ = _tmp215_->length;
				_tmp217_ = gee_tim_sort_gallop_leftmost (self, _tmp213_, _tmp214_, _tmp216_ - 1);
				k = _tmp217_;
				_tmp218_ = b;
				_tmp219_ = _tmp218_->length;
				_tmp220_ = k;
				b_count = _tmp219_ - _tmp220_;
				_tmp221_ = b;
				_tmp222_ = self->priv->list;
				_tmp223_ = b;
				_tmp224_ = _tmp223_->index;
				_tmp225_ = k;
				_tmp226_ = dest;
				_tmp227_ = b_count;
				_tmp228_ = b_count;
				gee_tim_sort_slice_merge_in_reversed (_tmp221_, _tmp222_, _tmp224_ + _tmp225_, _tmp226_ - _tmp227_, _tmp228_);
				_tmp229_ = dest;
				_tmp230_ = b_count;
				dest = _tmp229_ - _tmp230_;
				_tmp231_ = b;
				_tmp232_ = b_count;
				gee_tim_sort_slice_shorten_end (_tmp231_, _tmp232_);
				_tmp233_ = b;
				_tmp234_ = _tmp233_->length;
				if (_tmp234_ <= 1) {
					{
						GeeTimSortSlice* _tmp235_;
						gint _tmp236_;
						GeeTimSortSlice* _tmp237_;
						gint _tmp238_;
						GeeTimSortSlice* _tmp239_;
						void** _tmp240_;
						GeeTimSortSlice* _tmp241_;
						gint _tmp242_;
						gint _tmp243_;
						GeeTimSortSlice* _tmp244_;
						gint _tmp245_;
						GeeTimSortSlice* _tmp246_;
						gint _tmp247_;
						GeeTimSortSlice* _tmp248_;
						void** _tmp249_;
						GeeTimSortSlice* _tmp250_;
						gint _tmp251_;
						gint _tmp252_;
						GeeTimSortSlice* _tmp253_;
						gint _tmp254_;
						GeeTimSortSlice* _tmp255_;
						gint _tmp256_;
						GeeTimSortSlice* _tmp257_;
						gint _tmp258_;
						_tmp235_ = a;
						_tmp236_ = _tmp235_->length;
						_vala_assert (_tmp236_ >= 0, "a.length >= 0");
						_tmp237_ = b;
						_tmp238_ = _tmp237_->length;
						_vala_assert (_tmp238_ >= 0, "b.length >= 0");
						_tmp239_ = a;
						_tmp240_ = self->priv->list;
						_tmp241_ = a;
						_tmp242_ = _tmp241_->index;
						_tmp243_ = dest;
						_tmp244_ = a;
						_tmp245_ = _tmp244_->length;
						_tmp246_ = a;
						_tmp247_ = _tmp246_->length;
						gee_tim_sort_slice_merge_in_reversed (_tmp239_, _tmp240_, _tmp242_, _tmp243_ - _tmp245_, _tmp247_);
						_tmp248_ = b;
						_tmp249_ = self->priv->list;
						_tmp250_ = b;
						_tmp251_ = _tmp250_->index;
						_tmp252_ = dest;
						_tmp253_ = a;
						_tmp254_ = _tmp253_->length;
						_tmp255_ = b;
						_tmp256_ = _tmp255_->length;
						_tmp257_ = b;
						_tmp258_ = _tmp257_->length;
						gee_tim_sort_slice_merge_in_reversed (_tmp248_, _tmp249_, _tmp251_, (_tmp252_ - _tmp254_) - _tmp256_, _tmp258_);
					}
					_gee_tim_sort_slice_free0 (a);
					_gee_tim_sort_slice_free0 (b);
					return;
				}
				_tmp259_ = self->priv->list;
				_tmp260_ = dest;
				dest = _tmp260_ - 1;
				_tmp261_ = dest;
				_tmp262_ = a;
				_tmp263_ = gee_tim_sort_slice_pop_last (_tmp262_);
				_tmp259_[_tmp261_] = _tmp263_;
				_tmp264_ = _tmp259_[_tmp261_];
				_tmp265_ = a;
				_tmp266_ = _tmp265_->length;
				if (_tmp266_ == 0) {
					{
						GeeTimSortSlice* _tmp267_;
						gint _tmp268_;
						GeeTimSortSlice* _tmp269_;
						gint _tmp270_;
						GeeTimSortSlice* _tmp271_;
						void** _tmp272_;
						GeeTimSortSlice* _tmp273_;
						gint _tmp274_;
						gint _tmp275_;
						GeeTimSortSlice* _tmp276_;
						gint _tmp277_;
						GeeTimSortSlice* _tmp278_;
						gint _tmp279_;
						GeeTimSortSlice* _tmp280_;
						void** _tmp281_;
						GeeTimSortSlice* _tmp282_;
						gint _tmp283_;
						gint _tmp284_;
						GeeTimSortSlice* _tmp285_;
						gint _tmp286_;
						GeeTimSortSlice* _tmp287_;
						gint _tmp288_;
						GeeTimSortSlice* _tmp289_;
						gint _tmp290_;
						_tmp267_ = a;
						_tmp268_ = _tmp267_->length;
						_vala_assert (_tmp268_ >= 0, "a.length >= 0");
						_tmp269_ = b;
						_tmp270_ = _tmp269_->length;
						_vala_assert (_tmp270_ >= 0, "b.length >= 0");
						_tmp271_ = a;
						_tmp272_ = self->priv->list;
						_tmp273_ = a;
						_tmp274_ = _tmp273_->index;
						_tmp275_ = dest;
						_tmp276_ = a;
						_tmp277_ = _tmp276_->length;
						_tmp278_ = a;
						_tmp279_ = _tmp278_->length;
						gee_tim_sort_slice_merge_in_reversed (_tmp271_, _tmp272_, _tmp274_, _tmp275_ - _tmp277_, _tmp279_);
						_tmp280_ = b;
						_tmp281_ = self->priv->list;
						_tmp282_ = b;
						_tmp283_ = _tmp282_->index;
						_tmp284_ = dest;
						_tmp285_ = a;
						_tmp286_ = _tmp285_->length;
						_tmp287_ = b;
						_tmp288_ = _tmp287_->length;
						_tmp289_ = b;
						_tmp290_ = _tmp289_->length;
						gee_tim_sort_slice_merge_in_reversed (_tmp280_, _tmp281_, _tmp283_, (_tmp284_ - _tmp286_) - _tmp288_, _tmp290_);
					}
					_gee_tim_sort_slice_free0 (a);
					_gee_tim_sort_slice_free0 (b);
					return;
				}
				_tmp292_ = a_count;
				if (_tmp292_ < GEE_TIM_SORT_MINIMUM_GALLOP) {
					gint _tmp293_;
					_tmp293_ = b_count;
					_tmp291_ = _tmp293_ < GEE_TIM_SORT_MINIMUM_GALLOP;
				} else {
					_tmp291_ = FALSE;
				}
				_tmp294_ = _tmp291_;
				if (_tmp294_) {
					break;
				}
			}
			_tmp295_ = minimum_gallop;
			minimum_gallop = _tmp295_ + 1;
			_tmp296_ = minimum_gallop;
			self->priv->minimum_gallop = _tmp296_;
		}
	}
	__finally2:
	{
		GeeTimSortSlice* _tmp297_;
		gint _tmp298_;
		GeeTimSortSlice* _tmp299_;
		gint _tmp300_;
		GeeTimSortSlice* _tmp301_;
		void** _tmp302_;
		GeeTimSortSlice* _tmp303_;
		gint _tmp304_;
		gint _tmp305_;
		GeeTimSortSlice* _tmp306_;
		gint _tmp307_;
		GeeTimSortSlice* _tmp308_;
		gint _tmp309_;
		GeeTimSortSlice* _tmp310_;
		void** _tmp311_;
		GeeTimSortSlice* _tmp312_;
		gint _tmp313_;
		gint _tmp314_;
		GeeTimSortSlice* _tmp315_;
		gint _tmp316_;
		GeeTimSortSlice* _tmp317_;
		gint _tmp318_;
		GeeTimSortSlice* _tmp319_;
		gint _tmp320_;
		_tmp297_ = a;
		_tmp298_ = _tmp297_->length;
		_vala_assert (_tmp298_ >= 0, "a.length >= 0");
		_tmp299_ = b;
		_tmp300_ = _tmp299_->length;
		_vala_assert (_tmp300_ >= 0, "b.length >= 0");
		_tmp301_ = a;
		_tmp302_ = self->priv->list;
		_tmp303_ = a;
		_tmp304_ = _tmp303_->index;
		_tmp305_ = dest;
		_tmp306_ = a;
		_tmp307_ = _tmp306_->length;
		_tmp308_ = a;
		_tmp309_ = _tmp308_->length;
		gee_tim_sort_slice_merge_in_reversed (_tmp301_, _tmp302_, _tmp304_, _tmp305_ - _tmp307_, _tmp309_);
		_tmp310_ = b;
		_tmp311_ = self->priv->list;
		_tmp312_ = b;
		_tmp313_ = _tmp312_->index;
		_tmp314_ = dest;
		_tmp315_ = a;
		_tmp316_ = _tmp315_->length;
		_tmp317_ = b;
		_tmp318_ = _tmp317_->length;
		_tmp319_ = b;
		_tmp320_ = _tmp319_->length;
		gee_tim_sort_slice_merge_in_reversed (_tmp310_, _tmp311_, _tmp313_, (_tmp314_ - _tmp316_) - _tmp318_, _tmp320_);
	}
	_gee_tim_sort_slice_free0 (a);
	_gee_tim_sort_slice_free0 (b);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return;
}


GeeTimSort* gee_tim_sort_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func) {
	GeeTimSort * self = NULL;
	self = (GeeTimSort*) g_object_new (object_type, NULL);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	return self;
}


GeeTimSort* gee_tim_sort_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func) {
	return gee_tim_sort_construct (GEE_TYPE_TIM_SORT, g_type, g_dup_func, g_destroy_func);
}


static GeeTimSortSlice* gee_tim_sort_slice_new (void** list, gint index, gint length) {
	GeeTimSortSlice* self;
	void** _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	self = g_slice_new0 (GeeTimSortSlice);
	gee_tim_sort_slice_instance_init (self);
	_tmp0_ = list;
	self->list = _tmp0_;
	_tmp1_ = index;
	self->index = _tmp1_;
	_tmp2_ = length;
	self->length = _tmp2_;
	return self;
}


static void gee_tim_sort_slice_copy (GeeTimSortSlice* self) {
	void** _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	void* _tmp3_ = NULL;
	void** _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->list;
	_tmp1_ = self->index;
	_tmp2_ = self->length;
	_tmp3_ = g_memdup (&_tmp0_[_tmp1_], ((guint) sizeof (gpointer)) * _tmp2_);
	self->new_list = _tmp3_;
	_tmp4_ = self->new_list;
	self->list = _tmp4_;
	self->index = 0;
}


static inline void gee_tim_sort_slice_merge_in (GeeTimSortSlice* self, void** dest_array, gint index, gint dest_index, gint count) {
	void** _tmp0_;
	gint _tmp1_;
	void** _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = dest_array;
	_tmp1_ = dest_index;
	_tmp2_ = self->list;
	_tmp3_ = index;
	_tmp4_ = count;
	g_memmove (&_tmp0_[_tmp1_], &_tmp2_[_tmp3_], (gsize) (sizeof (gpointer) * _tmp4_));
}


static inline void gee_tim_sort_slice_merge_in_reversed (GeeTimSortSlice* self, void** dest_array, gint index, gint dest_index, gint count) {
	void** _tmp0_;
	gint _tmp1_;
	void** _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = dest_array;
	_tmp1_ = dest_index;
	_tmp2_ = self->list;
	_tmp3_ = index;
	_tmp4_ = count;
	g_memmove (&_tmp0_[_tmp1_], &_tmp2_[_tmp3_], (gsize) (sizeof (gpointer) * _tmp4_));
}


static inline void gee_tim_sort_slice_shorten_start (GeeTimSortSlice* self, gint n) {
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->index;
	_tmp1_ = n;
	self->index = _tmp0_ + _tmp1_;
	_tmp2_ = self->length;
	_tmp3_ = n;
	self->length = _tmp2_ - _tmp3_;
}


static inline void gee_tim_sort_slice_shorten_end (GeeTimSortSlice* self, gint n) {
	gint _tmp0_;
	gint _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->length;
	_tmp1_ = n;
	self->length = _tmp0_ - _tmp1_;
}


static inline void* gee_tim_sort_slice_pop_first (GeeTimSortSlice* self) {
	void* result = NULL;
	gint _tmp0_;
	void** _tmp1_;
	gint _tmp2_;
	void* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->length;
	self->length = _tmp0_ - 1;
	_tmp1_ = self->list;
	_tmp2_ = self->index;
	self->index = _tmp2_ + 1;
	_tmp3_ = _tmp1_[_tmp2_];
	result = _tmp3_;
	return result;
}


static inline void* gee_tim_sort_slice_pop_last (GeeTimSortSlice* self) {
	void* result = NULL;
	gint _tmp0_;
	void** _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	void* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->length;
	self->length = _tmp0_ - 1;
	_tmp1_ = self->list;
	_tmp2_ = self->index;
	_tmp3_ = self->length;
	_tmp4_ = _tmp1_[_tmp2_ + _tmp3_];
	result = _tmp4_;
	return result;
}


static inline void* gee_tim_sort_slice_peek_first (GeeTimSortSlice* self) {
	void* result = NULL;
	void** _tmp0_;
	gint _tmp1_;
	void* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->list;
	_tmp1_ = self->index;
	_tmp2_ = _tmp0_[_tmp1_];
	result = _tmp2_;
	return result;
}


static inline void* gee_tim_sort_slice_peek_last (GeeTimSortSlice* self) {
	void* result = NULL;
	void** _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	void* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->list;
	_tmp1_ = self->index;
	_tmp2_ = self->length;
	_tmp3_ = _tmp0_[(_tmp1_ + _tmp2_) - 1];
	result = _tmp3_;
	return result;
}


static void gee_tim_sort_slice_reverse (GeeTimSortSlice* self) {
	gint _tmp0_;
	gint low;
	gint _tmp1_;
	gint _tmp2_;
	gint high;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->index;
	low = _tmp0_;
	_tmp1_ = self->index;
	_tmp2_ = self->length;
	high = (_tmp1_ + _tmp2_) - 1;
	while (TRUE) {
		gint _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		_tmp3_ = low;
		_tmp4_ = high;
		if (!(_tmp3_ < _tmp4_)) {
			break;
		}
		_tmp5_ = low;
		low = _tmp5_ + 1;
		_tmp6_ = high;
		high = _tmp6_ - 1;
		gee_tim_sort_slice_swap (self, _tmp5_, _tmp6_);
	}
}


static inline void gee_tim_sort_slice_swap (GeeTimSortSlice* self, gint i, gint j) {
	void** _tmp0_;
	gint _tmp1_;
	void* _tmp2_;
	void* temp;
	void** _tmp3_;
	gint _tmp4_;
	void** _tmp5_;
	gint _tmp6_;
	void* _tmp7_;
	void* _tmp8_;
	void** _tmp9_;
	gint _tmp10_;
	void* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->list;
	_tmp1_ = i;
	_tmp2_ = _tmp0_[_tmp1_];
	temp = _tmp2_;
	_tmp3_ = self->list;
	_tmp4_ = i;
	_tmp5_ = self->list;
	_tmp6_ = j;
	_tmp7_ = _tmp5_[_tmp6_];
	_tmp3_[_tmp4_] = _tmp7_;
	_tmp8_ = _tmp3_[_tmp4_];
	_tmp9_ = self->list;
	_tmp10_ = j;
	_tmp9_[_tmp10_] = temp;
	_tmp11_ = _tmp9_[_tmp10_];
}


static void gee_tim_sort_slice_instance_init (GeeTimSortSlice * self) {
}


static void gee_tim_sort_slice_free (GeeTimSortSlice* self) {
	void** _tmp0_;
	_tmp0_ = self->new_list;
	if (_tmp0_ != NULL) {
		void** _tmp1_;
		_tmp1_ = self->new_list;
		g_free (_tmp1_);
	}
	g_slice_free (GeeTimSortSlice, self);
}


static void gee_tim_sort_class_init (GeeTimSortClass * klass) {
	gee_tim_sort_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeeTimSortPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_gee_tim_sort_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gee_tim_sort_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_tim_sort_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_TIM_SORT_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_TIM_SORT_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_TIM_SORT_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void gee_tim_sort_instance_init (GeeTimSort * self) {
	self->priv = GEE_TIM_SORT_GET_PRIVATE (self);
}


static void gee_tim_sort_finalize (GObject* obj) {
	GeeTimSort * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEE_TYPE_TIM_SORT, GeeTimSort);
	_g_object_unref0 (self->priv->list_collection);
	self->priv->array = (_vala_array_free (self->priv->array, self->priv->array_length1, (GDestroyNotify) self->priv->g_destroy_func), NULL);
	self->priv->pending = (_vala_array_free (self->priv->pending, self->priv->pending_length1, (GDestroyNotify) gee_tim_sort_slice_free), NULL);
	(self->priv->compare_target_destroy_notify == NULL) ? NULL : (self->priv->compare_target_destroy_notify (self->priv->compare_target), NULL);
	self->priv->compare = NULL;
	self->priv->compare_target = NULL;
	self->priv->compare_target_destroy_notify = NULL;
	G_OBJECT_CLASS (gee_tim_sort_parent_class)->finalize (obj);
}


/**
 * A stable, adaptive, iterative mergesort that requires far fewer than n*lg(n)
 * comparisons when running on partially sorted arrays, while offering
 * performance comparable to a traditional mergesort when run on random arrays.
 * Like all proper mergesorts, this sort is stable and runs O(n*log(n)) time
 * (worst case). In the worst case, this sort requires temporary storage space
 * for n/2 object references; in the best case, it requires only a small
 * constant amount of space.
 *
 * This implementation was adapted from Tim Peters's list sort for Python,
 * which is described in detail here:
 *   [[http://svn.python.org/projects/python/trunk/Objects/listsort.txt]]
 *
 * Tim's C code may be found here:
 *   [[http://svn.python.org/projects/python/trunk/Objects/listobject.c]]
 *
 * The underlying techniques are described in this paper (and may have even
 * earlier origins):
 *
 *   "Optimistic Sorting and Information Theoretic Complexity"
 *   Peter McIlroy
 *   SODA (Fourth Annual ACM-SIAM Symposium on Discrete Algorithms), pp
 *   467-474, Austin, Texas, 25-27 January 1993.
 */
GType gee_tim_sort_get_type (void) {
	static volatile gsize gee_tim_sort_type_id__volatile = 0;
	if (g_once_init_enter (&gee_tim_sort_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeTimSortClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_tim_sort_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeTimSort), 0, (GInstanceInitFunc) gee_tim_sort_instance_init, NULL };
		GType gee_tim_sort_type_id;
		gee_tim_sort_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeTimSort", &g_define_type_info, 0);
		g_once_init_leave (&gee_tim_sort_type_id__volatile, gee_tim_sort_type_id);
	}
	return gee_tim_sort_type_id__volatile;
}


static void _vala_gee_tim_sort_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeTimSort * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_TYPE_TIM_SORT, GeeTimSort);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gee_tim_sort_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeTimSort * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_TYPE_TIM_SORT, GeeTimSort);
	switch (property_id) {
		case GEE_TIM_SORT_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_TIM_SORT_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_TIM_SORT_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static void _vala_array_move (gpointer array, gsize element_size, gint src, gint dest, gint length) {
	g_memmove (((char*) array) + (dest * element_size), ((char*) array) + (src * element_size), length * element_size);
	if ((src < dest) && ((src + length) > dest)) {
		memset (((char*) array) + (src * element_size), 0, (dest - src) * element_size);
	} else if ((src > dest) && (src < (dest + length))) {
		memset (((char*) array) + ((dest + length) * element_size), 0, (src - dest) * element_size);
	} else if (src != dest) {
		memset (((char*) array) + (src * element_size), 0, length * element_size);
	}
}



