/* testcollection.c generated by valac 0.21.1.22-31ca, the Vala compiler
 * generated from testcollection.vala, do not modify */

/* testcollection.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 * Copyright (C) 2009  Didier Villevalois, Julien Peeters
 * Copyright (C) 2011  Maciej Piechotka
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Didier 'Ptitjes' Villevalois <ptitjes@free.fr>
 * 	Julien Peeters <contact@julienpeeters.fr>
 *      Maciej Piechotka <uzytkownik2@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>


#define GEE_TYPE_TEST_CASE (gee_test_case_get_type ())
#define GEE_TEST_CASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_TEST_CASE, GeeTestCase))
#define GEE_TEST_CASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_TEST_CASE, GeeTestCaseClass))
#define GEE_IS_TEST_CASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_TEST_CASE))
#define GEE_IS_TEST_CASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_TEST_CASE))
#define GEE_TEST_CASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_TEST_CASE, GeeTestCaseClass))

typedef struct _GeeTestCase GeeTestCase;
typedef struct _GeeTestCaseClass GeeTestCaseClass;
typedef struct _GeeTestCasePrivate GeeTestCasePrivate;

#define TYPE_COLLECTION_TESTS (collection_tests_get_type ())
#define COLLECTION_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COLLECTION_TESTS, CollectionTests))
#define COLLECTION_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COLLECTION_TESTS, CollectionTestsClass))
#define IS_COLLECTION_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COLLECTION_TESTS))
#define IS_COLLECTION_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COLLECTION_TESTS))
#define COLLECTION_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COLLECTION_TESTS, CollectionTestsClass))

typedef struct _CollectionTests CollectionTests;
typedef struct _CollectionTestsClass CollectionTestsClass;
typedef struct _CollectionTestsPrivate CollectionTestsPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
typedef struct _Block4Data Block4Data;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GeeTestCase {
	GObject parent_instance;
	GeeTestCasePrivate * priv;
};

struct _GeeTestCaseClass {
	GObjectClass parent_class;
	void (*set_up) (GeeTestCase* self);
	void (*tear_down) (GeeTestCase* self);
};

struct _CollectionTests {
	GeeTestCase parent_instance;
	CollectionTestsPrivate * priv;
	GeeCollection* test_collection;
};

struct _CollectionTestsClass {
	GeeTestCaseClass parent_class;
};

typedef void (*GeeTestCaseTestMethod) (void* user_data);
struct _Block1Data {
	int _ref_count_;
	CollectionTests * self;
	gint count;
};

struct _Block2Data {
	int _ref_count_;
	CollectionTests * self;
	gboolean one;
	gboolean two;
	gboolean three;
	gint i;
};

struct _Block3Data {
	int _ref_count_;
	CollectionTests * self;
	gboolean one;
	gboolean two;
	gboolean three;
};

struct _Block4Data {
	int _ref_count_;
	CollectionTests * self;
	gboolean one;
	gboolean two;
	gboolean three;
};


static gpointer collection_tests_parent_class = NULL;

GType gee_test_case_get_type (void) G_GNUC_CONST;
GType collection_tests_get_type (void) G_GNUC_CONST;
enum  {
	COLLECTION_TESTS_DUMMY_PROPERTY
};
CollectionTests* collection_tests_construct (GType object_type, const gchar* name);
GeeTestCase* gee_test_case_construct (GType object_type, const gchar* name);
void gee_test_case_add_test (GeeTestCase* self, const gchar* name, GeeTestCaseTestMethod test, void* test_target, GDestroyNotify test_target_destroy_notify);
void collection_tests_test_type_correctness (CollectionTests* self);
static void _collection_tests_test_type_correctness_gee_test_case_test_method (gpointer self);
void collection_tests_test_iterator_returns_all_elements_once (CollectionTests* self);
static void _collection_tests_test_iterator_returns_all_elements_once_gee_test_case_test_method (gpointer self);
void collection_tests_test_mutable_iterator (CollectionTests* self);
static void _collection_tests_test_mutable_iterator_gee_test_case_test_method (gpointer self);
void collection_tests_test_contains_size_and_is_empty (CollectionTests* self);
static void _collection_tests_test_contains_size_and_is_empty_gee_test_case_test_method (gpointer self);
void collection_tests_test_add_remove (CollectionTests* self);
static void _collection_tests_test_add_remove_gee_test_case_test_method (gpointer self);
void collection_tests_test_clear (CollectionTests* self);
static void _collection_tests_test_clear_gee_test_case_test_method (gpointer self);
void collection_tests_test_add_all (CollectionTests* self);
static void _collection_tests_test_add_all_gee_test_case_test_method (gpointer self);
void collection_tests_test_contains_all (CollectionTests* self);
static void _collection_tests_test_contains_all_gee_test_case_test_method (gpointer self);
void collection_tests_test_remove_all (CollectionTests* self);
static void _collection_tests_test_remove_all_gee_test_case_test_method (gpointer self);
void collection_tests_test_retain_all (CollectionTests* self);
static void _collection_tests_test_retain_all_gee_test_case_test_method (gpointer self);
void collection_tests_test_to_array (CollectionTests* self);
static void _collection_tests_test_to_array_gee_test_case_test_method (gpointer self);
void collection_tests_test_gobject_properties (CollectionTests* self);
static void _collection_tests_test_gobject_properties_gee_test_case_test_method (gpointer self);
void collection_tests_test_fold (CollectionTests* self);
static void _collection_tests_test_fold_gee_test_case_test_method (gpointer self);
void collection_tests_test_foreach (CollectionTests* self);
static void _collection_tests_test_foreach_gee_test_case_test_method (gpointer self);
void collection_tests_test_map (CollectionTests* self);
static void _collection_tests_test_map_gee_test_case_test_method (gpointer self);
void collection_tests_test_scan (CollectionTests* self);
static void _collection_tests_test_scan_gee_test_case_test_method (gpointer self);
void collection_tests_test_filter (CollectionTests* self);
static void _collection_tests_test_filter_gee_test_case_test_method (gpointer self);
void collection_tests_test_chop (CollectionTests* self);
static void _collection_tests_test_chop_gee_test_case_test_method (gpointer self);
static gint __lambda2_ (CollectionTests* self, gchar* x, gint y);
static gpointer ___lambda2__gee_fold_func (gpointer g, gpointer a, gpointer self);
static gint __lambda3_ (CollectionTests* self, gchar* x, gint y);
static gpointer ___lambda3__gee_fold_func (gpointer g, gpointer a, gpointer self);
static gint __lambda4_ (CollectionTests* self, gchar* x, gint y);
static gpointer ___lambda4__gee_fold_func (gpointer g, gpointer a, gpointer self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean __lambda5_ (Block1Data* _data1_, gchar* x);
static gboolean ___lambda5__gee_forall_func (gpointer g, gpointer self);
static gboolean __lambda6_ (Block1Data* _data1_, gchar* x);
static gboolean ___lambda6__gee_forall_func (gpointer g, gpointer self);
static gboolean __lambda7_ (Block1Data* _data1_, gchar* x);
static gboolean ___lambda7__gee_forall_func (gpointer g, gpointer self);
static gboolean __lambda8_ (Block1Data* _data1_, gchar* x);
static gboolean ___lambda8__gee_forall_func (gpointer g, gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gint __lambda9_ (Block2Data* _data2_, gchar* str);
static gpointer ___lambda9__gee_map_func (gpointer g, gpointer self);
static gint __lambda10_ (Block2Data* _data2_, gchar* str);
static gpointer ___lambda10__gee_map_func (gpointer g, gpointer self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static gint __lambda11_ (Block3Data* _data3_, gchar* str, gint cur);
static gpointer ___lambda11__gee_fold_func (gpointer g, gpointer a, gpointer self);
static gint __lambda12_ (Block3Data* _data3_, gchar* str, gint cur);
static gpointer ___lambda12__gee_fold_func (gpointer g, gpointer a, gpointer self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static gboolean __lambda13_ (Block4Data* _data4_, const gchar* str);
static gboolean ___lambda13__gee_predicate (gconstpointer g, gpointer self);
static gboolean __lambda14_ (Block4Data* _data4_, const gchar* str);
static gboolean ___lambda14__gee_predicate (gconstpointer g, gpointer self);
static void collection_tests_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void _collection_tests_test_type_correctness_gee_test_case_test_method (gpointer self) {
	collection_tests_test_type_correctness (self);
}


static void _collection_tests_test_iterator_returns_all_elements_once_gee_test_case_test_method (gpointer self) {
	collection_tests_test_iterator_returns_all_elements_once (self);
}


static void _collection_tests_test_mutable_iterator_gee_test_case_test_method (gpointer self) {
	collection_tests_test_mutable_iterator (self);
}


static void _collection_tests_test_contains_size_and_is_empty_gee_test_case_test_method (gpointer self) {
	collection_tests_test_contains_size_and_is_empty (self);
}


static void _collection_tests_test_add_remove_gee_test_case_test_method (gpointer self) {
	collection_tests_test_add_remove (self);
}


static void _collection_tests_test_clear_gee_test_case_test_method (gpointer self) {
	collection_tests_test_clear (self);
}


static void _collection_tests_test_add_all_gee_test_case_test_method (gpointer self) {
	collection_tests_test_add_all (self);
}


static void _collection_tests_test_contains_all_gee_test_case_test_method (gpointer self) {
	collection_tests_test_contains_all (self);
}


static void _collection_tests_test_remove_all_gee_test_case_test_method (gpointer self) {
	collection_tests_test_remove_all (self);
}


static void _collection_tests_test_retain_all_gee_test_case_test_method (gpointer self) {
	collection_tests_test_retain_all (self);
}


static void _collection_tests_test_to_array_gee_test_case_test_method (gpointer self) {
	collection_tests_test_to_array (self);
}


static void _collection_tests_test_gobject_properties_gee_test_case_test_method (gpointer self) {
	collection_tests_test_gobject_properties (self);
}


static void _collection_tests_test_fold_gee_test_case_test_method (gpointer self) {
	collection_tests_test_fold (self);
}


static void _collection_tests_test_foreach_gee_test_case_test_method (gpointer self) {
	collection_tests_test_foreach (self);
}


static void _collection_tests_test_map_gee_test_case_test_method (gpointer self) {
	collection_tests_test_map (self);
}


static void _collection_tests_test_scan_gee_test_case_test_method (gpointer self) {
	collection_tests_test_scan (self);
}


static void _collection_tests_test_filter_gee_test_case_test_method (gpointer self) {
	collection_tests_test_filter (self);
}


static void _collection_tests_test_chop_gee_test_case_test_method (gpointer self) {
	collection_tests_test_chop (self);
}


CollectionTests* collection_tests_construct (GType object_type, const gchar* name) {
	CollectionTests * self = NULL;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = name;
	self = (CollectionTests*) gee_test_case_construct (object_type, _tmp0_);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] type correctness", _collection_tests_test_type_correctness_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] iterator returns all elements once", _collection_tests_test_iterator_returns_all_elements_once_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] mutable iterator", _collection_tests_test_mutable_iterator_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] contains, size and is_empty", _collection_tests_test_contains_size_and_is_empty_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] add and remove", _collection_tests_test_add_remove_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] clear", _collection_tests_test_clear_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] add_all", _collection_tests_test_add_all_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] contains_all", _collection_tests_test_contains_all_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] remove_all", _collection_tests_test_remove_all_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] retain_all", _collection_tests_test_retain_all_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] to_array", _collection_tests_test_to_array_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] GObject properties", _collection_tests_test_gobject_properties_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] fold", _collection_tests_test_fold_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] foreach", _collection_tests_test_foreach_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] map", _collection_tests_test_map_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] scan", _collection_tests_test_scan_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] filter", _collection_tests_test_filter_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] chop", _collection_tests_test_chop_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	return self;
}


void collection_tests_test_type_correctness (CollectionTests* self) {
	GeeCollection* _tmp0_ = NULL;
	GeeCollection* _tmp1_ = NULL;
	GType _tmp2_ = 0UL;
	GType _tmp3_ = 0UL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->test_collection;
	_vala_assert (_tmp0_ != NULL, "test_collection != null");
	_tmp1_ = self->test_collection;
	_tmp2_ = gee_traversable_get_element_type ((GeeTraversable*) _tmp1_);
	_tmp3_ = _tmp2_;
	_vala_assert (_tmp3_ == G_TYPE_STRING, "test_collection.element_type == typeof (string)");
}


void collection_tests_test_iterator_returns_all_elements_once (CollectionTests* self) {
	GeeCollection* _tmp0_ = NULL;
	gboolean has_next = FALSE;
	GeeIterator* iterator = NULL;
	GeeCollection* _tmp1_ = NULL;
	GeeIterator* _tmp2_ = NULL;
	GeeIterator* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	GeeIterator* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	GeeCollection* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	GeeCollection* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	GeeCollection* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	gboolean one_found = FALSE;
	gboolean two_found = FALSE;
	gboolean three_found = FALSE;
	gboolean one_found_once = FALSE;
	gboolean two_found_once = FALSE;
	gboolean three_found_once = FALSE;
	GeeCollection* _tmp13_ = NULL;
	GeeIterator* _tmp14_ = NULL;
	gboolean valid = FALSE;
	GeeIterator* _tmp15_ = NULL;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	GeeIterator* _tmp44_ = NULL;
	gboolean _tmp45_ = FALSE;
	gboolean _tmp46_ = FALSE;
	GeeIterator* _tmp47_ = NULL;
	gboolean _tmp48_ = FALSE;
	gboolean _tmp49_ = FALSE;
	gboolean _tmp50_ = FALSE;
	GeeIterator* _tmp51_ = NULL;
	gboolean _tmp52_ = FALSE;
	GeeIterator* _tmp53_ = NULL;
	gboolean _tmp54_ = FALSE;
	gboolean _tmp55_ = FALSE;
	gboolean _tmp56_ = FALSE;
	gboolean _tmp57_ = FALSE;
	gboolean _tmp58_ = FALSE;
	gboolean _tmp59_ = FALSE;
	gboolean _tmp60_ = FALSE;
	gboolean _tmp61_ = FALSE;
	GeeCollection* _tmp62_ = NULL;
	GeeIterator* _tmp63_ = NULL;
	GeeIterator* _tmp64_ = NULL;
	gboolean _tmp65_ = FALSE;
	GeeIterator* _tmp66_ = NULL;
	gboolean _tmp67_ = FALSE;
	gboolean _tmp68_ = FALSE;
	GeeIterator* _tmp69_ = NULL;
	gboolean _tmp70_ = FALSE;
	GeeIterator* _tmp85_ = NULL;
	gboolean _tmp86_ = FALSE;
	gboolean _tmp87_ = FALSE;
	gboolean _tmp88_ = FALSE;
	GeeIterator* _tmp89_ = NULL;
	gboolean _tmp90_ = FALSE;
	gboolean _tmp91_ = FALSE;
	gboolean _tmp92_ = FALSE;
	gboolean _tmp93_ = FALSE;
	gboolean _tmp94_ = FALSE;
	gboolean _tmp95_ = FALSE;
	gboolean _tmp96_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->test_collection;
	_vala_assert (_tmp0_ != NULL, "test_collection != null");
	_tmp1_ = self->test_collection;
	_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
	iterator = _tmp2_;
	_tmp3_ = iterator;
	_tmp4_ = gee_iterator_has_next (_tmp3_);
	_vala_assert (!_tmp4_, "! iterator.has_next ()");
	_tmp5_ = iterator;
	_tmp6_ = gee_iterator_next (_tmp5_);
	_vala_assert (!_tmp6_, "! iterator.next ()");
	_tmp7_ = self->test_collection;
	_tmp8_ = gee_collection_add (_tmp7_, "one");
	_vala_assert (_tmp8_, "test_collection.add (\"one\")");
	_tmp9_ = self->test_collection;
	_tmp10_ = gee_collection_add (_tmp9_, "two");
	_vala_assert (_tmp10_, "test_collection.add (\"two\")");
	_tmp11_ = self->test_collection;
	_tmp12_ = gee_collection_add (_tmp11_, "three");
	_vala_assert (_tmp12_, "test_collection.add (\"three\")");
	one_found = FALSE;
	two_found = FALSE;
	three_found = FALSE;
	one_found_once = TRUE;
	two_found_once = TRUE;
	three_found_once = TRUE;
	_tmp13_ = self->test_collection;
	_tmp14_ = gee_iterable_iterator ((GeeIterable*) _tmp13_);
	_g_object_unref0 (iterator);
	iterator = _tmp14_;
	_tmp15_ = iterator;
	_tmp16_ = gee_iterator_get_valid (_tmp15_);
	_tmp17_ = _tmp16_;
	valid = _tmp17_;
	_tmp18_ = valid;
	_vala_assert (!_tmp18_, "! valid");
	while (TRUE) {
		GeeIterator* _tmp19_ = NULL;
		gboolean _tmp20_ = FALSE;
		gboolean _tmp21_ = FALSE;
		GeeIterator* _tmp22_ = NULL;
		gboolean _tmp23_ = FALSE;
		gboolean _tmp24_ = FALSE;
		gboolean _tmp25_ = FALSE;
		GeeIterator* _tmp26_ = NULL;
		gboolean _tmp27_ = FALSE;
		GeeIterator* _tmp28_ = NULL;
		gboolean _tmp29_ = FALSE;
		gboolean _tmp30_ = FALSE;
		gboolean _tmp31_ = FALSE;
		gboolean _tmp32_ = FALSE;
		gchar* element = NULL;
		GeeIterator* _tmp33_ = NULL;
		gpointer _tmp34_ = NULL;
		GeeIterator* _tmp35_ = NULL;
		gboolean _tmp36_ = FALSE;
		gboolean _tmp37_ = FALSE;
		const gchar* _tmp38_ = NULL;
		_tmp19_ = iterator;
		_tmp20_ = gee_iterator_has_next (_tmp19_);
		has_next = _tmp20_;
		_tmp21_ = valid;
		_tmp22_ = iterator;
		_tmp23_ = gee_iterator_get_valid (_tmp22_);
		_tmp24_ = _tmp23_;
		_vala_assert (_tmp21_ == _tmp24_, "valid == iterator.valid");
		_tmp25_ = has_next;
		_tmp26_ = iterator;
		_tmp27_ = gee_iterator_next (_tmp26_);
		_vala_assert (_tmp25_ == _tmp27_, "has_next == iterator.next ()");
		_tmp28_ = iterator;
		_tmp29_ = gee_iterator_get_valid (_tmp28_);
		_tmp30_ = _tmp29_;
		valid = _tmp30_;
		_tmp31_ = valid;
		_vala_assert (_tmp31_, "valid = iterator.valid");
		_tmp32_ = has_next;
		if (!_tmp32_) {
			break;
		}
		_tmp33_ = iterator;
		_tmp34_ = gee_iterator_get (_tmp33_);
		element = (gchar*) _tmp34_;
		_tmp35_ = iterator;
		_tmp36_ = gee_iterator_get_valid (_tmp35_);
		_tmp37_ = _tmp36_;
		_vala_assert (_tmp37_, "iterator.valid");
		_tmp38_ = element;
		if (g_strcmp0 (_tmp38_, "one") == 0) {
			gboolean _tmp39_ = FALSE;
			_tmp39_ = one_found;
			if (_tmp39_) {
				one_found_once = FALSE;
			}
			one_found = TRUE;
		} else {
			const gchar* _tmp40_ = NULL;
			_tmp40_ = element;
			if (g_strcmp0 (_tmp40_, "two") == 0) {
				gboolean _tmp41_ = FALSE;
				_tmp41_ = two_found;
				if (_tmp41_) {
					two_found_once = FALSE;
				}
				two_found = TRUE;
			} else {
				const gchar* _tmp42_ = NULL;
				_tmp42_ = element;
				if (g_strcmp0 (_tmp42_, "three") == 0) {
					gboolean _tmp43_ = FALSE;
					_tmp43_ = three_found;
					if (_tmp43_) {
						three_found_once = FALSE;
					}
					three_found = TRUE;
				}
			}
		}
		_g_free0 (element);
	}
	_tmp44_ = iterator;
	_tmp45_ = gee_iterator_has_next (_tmp44_);
	has_next = _tmp45_;
	_tmp46_ = has_next;
	_vala_assert (!_tmp46_, "! has_next");
	_tmp47_ = iterator;
	_tmp48_ = gee_iterator_get_valid (_tmp47_);
	_tmp49_ = _tmp48_;
	_vala_assert (_tmp49_, "iterator.valid");
	_tmp50_ = has_next;
	_tmp51_ = iterator;
	_tmp52_ = gee_iterator_next (_tmp51_);
	_vala_assert (_tmp50_ == _tmp52_, "has_next == iterator.next ()");
	_tmp53_ = iterator;
	_tmp54_ = gee_iterator_get_valid (_tmp53_);
	_tmp55_ = _tmp54_;
	_vala_assert (_tmp55_, "iterator.valid");
	_tmp56_ = one_found;
	_vala_assert (_tmp56_, "one_found");
	_tmp57_ = one_found_once;
	_vala_assert (_tmp57_, "one_found_once");
	_tmp58_ = two_found;
	_vala_assert (_tmp58_, "two_found");
	_tmp59_ = two_found_once;
	_vala_assert (_tmp59_, "two_found_once");
	_tmp60_ = three_found;
	_vala_assert (_tmp60_, "three_found");
	_tmp61_ = three_found_once;
	_vala_assert (_tmp61_, "three_found_once");
	_tmp62_ = self->test_collection;
	_tmp63_ = gee_iterable_iterator ((GeeIterable*) _tmp62_);
	_g_object_unref0 (iterator);
	iterator = _tmp63_;
	_tmp64_ = iterator;
	_tmp65_ = gee_iterator_has_next (_tmp64_);
	_vala_assert (_tmp65_, "iterator.has_next ()");
	_tmp66_ = iterator;
	_tmp67_ = gee_iterator_get_valid (_tmp66_);
	_tmp68_ = _tmp67_;
	_vala_assert (!_tmp68_, "! iterator.valid");
	_tmp69_ = iterator;
	_tmp70_ = gee_iterator_next (_tmp69_);
	_vala_assert (_tmp70_, "iterator.next ()");
	one_found = FALSE;
	two_found = FALSE;
	three_found = FALSE;
	one_found_once = TRUE;
	two_found_once = TRUE;
	three_found_once = TRUE;
	while (TRUE) {
		gchar* element = NULL;
		GeeIterator* _tmp71_ = NULL;
		gpointer _tmp72_ = NULL;
		const gchar* _tmp73_ = NULL;
		GeeIterator* _tmp79_ = NULL;
		gboolean _tmp80_ = FALSE;
		gboolean _tmp81_ = FALSE;
		GeeIterator* _tmp82_ = NULL;
		gboolean _tmp83_ = FALSE;
		gboolean _tmp84_ = FALSE;
		_tmp71_ = iterator;
		_tmp72_ = gee_iterator_get (_tmp71_);
		element = (gchar*) _tmp72_;
		_tmp73_ = element;
		if (g_strcmp0 (_tmp73_, "one") == 0) {
			gboolean _tmp74_ = FALSE;
			_tmp74_ = one_found;
			if (_tmp74_) {
				one_found_once = FALSE;
			}
			one_found = TRUE;
		} else {
			const gchar* _tmp75_ = NULL;
			_tmp75_ = element;
			if (g_strcmp0 (_tmp75_, "two") == 0) {
				gboolean _tmp76_ = FALSE;
				_tmp76_ = two_found;
				if (_tmp76_) {
					two_found_once = FALSE;
				}
				two_found = TRUE;
			} else {
				const gchar* _tmp77_ = NULL;
				_tmp77_ = element;
				if (g_strcmp0 (_tmp77_, "three") == 0) {
					gboolean _tmp78_ = FALSE;
					_tmp78_ = three_found;
					if (_tmp78_) {
						three_found_once = FALSE;
					}
					three_found = TRUE;
				}
			}
		}
		_tmp79_ = iterator;
		_tmp80_ = gee_iterator_has_next (_tmp79_);
		has_next = _tmp80_;
		_tmp81_ = has_next;
		_tmp82_ = iterator;
		_tmp83_ = gee_iterator_next (_tmp82_);
		_vala_assert (_tmp81_ == _tmp83_, "has_next == iterator.next ()");
		_tmp84_ = has_next;
		if (!_tmp84_) {
			_g_free0 (element);
			break;
		}
		_g_free0 (element);
	}
	_tmp85_ = iterator;
	_tmp86_ = gee_iterator_has_next (_tmp85_);
	has_next = _tmp86_;
	_tmp87_ = has_next;
	_vala_assert (!_tmp87_, "! has_next");
	_tmp88_ = has_next;
	_tmp89_ = iterator;
	_tmp90_ = gee_iterator_next (_tmp89_);
	_vala_assert (_tmp88_ == _tmp90_, "has_next == iterator.next ()");
	_tmp91_ = one_found;
	_vala_assert (_tmp91_, "one_found");
	_tmp92_ = one_found_once;
	_vala_assert (_tmp92_, "one_found_once");
	_tmp93_ = two_found;
	_vala_assert (_tmp93_, "two_found");
	_tmp94_ = two_found_once;
	_vala_assert (_tmp94_, "two_found_once");
	_tmp95_ = three_found;
	_vala_assert (_tmp95_, "three_found");
	_tmp96_ = three_found_once;
	_vala_assert (_tmp96_, "three_found_once");
	_g_object_unref0 (iterator);
}


void collection_tests_test_mutable_iterator (CollectionTests* self) {
	GeeCollection* _tmp0_ = NULL;
	gboolean has_next = FALSE;
	GeeIterator* iterator = NULL;
	GeeCollection* _tmp1_ = NULL;
	GeeIterator* _tmp2_ = NULL;
	GeeCollection* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	GeeCollection* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	GeeCollection* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	gboolean one_found = FALSE;
	gboolean two_found = FALSE;
	gboolean three_found = FALSE;
	gboolean one_found_once = FALSE;
	gboolean two_found_once = FALSE;
	gboolean three_found_once = FALSE;
	GeeCollection* _tmp9_ = NULL;
	GeeIterator* _tmp10_ = NULL;
	GeeIterator* _tmp35_ = NULL;
	gboolean _tmp36_ = FALSE;
	gboolean _tmp37_ = FALSE;
	gboolean _tmp38_ = FALSE;
	GeeIterator* _tmp39_ = NULL;
	gboolean _tmp40_ = FALSE;
	gboolean _tmp41_ = FALSE;
	gboolean _tmp42_ = FALSE;
	gboolean _tmp43_ = FALSE;
	gboolean _tmp44_ = FALSE;
	gboolean _tmp45_ = FALSE;
	gboolean _tmp46_ = FALSE;
	GeeCollection* _tmp47_ = NULL;
	GeeIterator* _tmp48_ = NULL;
	GeeIterator* _tmp49_ = NULL;
	gboolean _tmp50_ = FALSE;
	GeeIterator* _tmp51_ = NULL;
	gboolean _tmp52_ = FALSE;
	GeeIterator* _tmp66_ = NULL;
	gboolean _tmp67_ = FALSE;
	gboolean _tmp68_ = FALSE;
	gboolean _tmp69_ = FALSE;
	GeeIterator* _tmp70_ = NULL;
	gboolean _tmp71_ = FALSE;
	gboolean _tmp72_ = FALSE;
	gboolean _tmp73_ = FALSE;
	gboolean _tmp74_ = FALSE;
	gboolean _tmp75_ = FALSE;
	gboolean _tmp76_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->test_collection;
	_vala_assert (_tmp0_ != NULL, "test_collection != null");
	_tmp1_ = self->test_collection;
	_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
	iterator = _tmp2_;
	_tmp3_ = self->test_collection;
	_tmp4_ = gee_collection_add (_tmp3_, "one");
	_vala_assert (_tmp4_, "test_collection.add (\"one\")");
	_tmp5_ = self->test_collection;
	_tmp6_ = gee_collection_add (_tmp5_, "two");
	_vala_assert (_tmp6_, "test_collection.add (\"two\")");
	_tmp7_ = self->test_collection;
	_tmp8_ = gee_collection_add (_tmp7_, "three");
	_vala_assert (_tmp8_, "test_collection.add (\"three\")");
	one_found = FALSE;
	two_found = FALSE;
	three_found = FALSE;
	one_found_once = TRUE;
	two_found_once = TRUE;
	three_found_once = TRUE;
	_tmp9_ = self->test_collection;
	_tmp10_ = gee_iterable_iterator ((GeeIterable*) _tmp9_);
	_g_object_unref0 (iterator);
	iterator = _tmp10_;
	while (TRUE) {
		GeeIterator* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
		GeeIterator* _tmp14_ = NULL;
		gboolean _tmp15_ = FALSE;
		gboolean _tmp16_ = FALSE;
		GeeIterator* _tmp17_ = NULL;
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_ = FALSE;
		gchar* element = NULL;
		GeeIterator* _tmp20_ = NULL;
		gpointer _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
		_tmp11_ = iterator;
		_tmp12_ = gee_iterator_has_next (_tmp11_);
		has_next = _tmp12_;
		_tmp13_ = has_next;
		_tmp14_ = iterator;
		_tmp15_ = gee_iterator_next (_tmp14_);
		_vala_assert (_tmp13_ == _tmp15_, "has_next == iterator.next ()");
		_tmp16_ = has_next;
		if (!_tmp16_) {
			break;
		}
		_tmp17_ = iterator;
		_tmp18_ = gee_iterator_get_valid (_tmp17_);
		_tmp19_ = _tmp18_;
		_vala_assert (_tmp19_, "iterator.valid");
		_tmp20_ = iterator;
		_tmp21_ = gee_iterator_get (_tmp20_);
		element = (gchar*) _tmp21_;
		_tmp22_ = element;
		if (g_strcmp0 (_tmp22_, "one") == 0) {
			gboolean _tmp23_ = FALSE;
			_tmp23_ = one_found;
			if (_tmp23_) {
				one_found_once = FALSE;
			}
			one_found = TRUE;
		} else {
			const gchar* _tmp24_ = NULL;
			_tmp24_ = element;
			if (g_strcmp0 (_tmp24_, "two") == 0) {
				gboolean _tmp25_ = FALSE;
				GeeIterator* _tmp26_ = NULL;
				gboolean _tmp27_ = FALSE;
				gboolean _tmp28_ = FALSE;
				GeeIterator* _tmp29_ = NULL;
				GeeIterator* _tmp30_ = NULL;
				gboolean _tmp31_ = FALSE;
				gboolean _tmp32_ = FALSE;
				_tmp25_ = two_found;
				if (_tmp25_) {
					two_found_once = FALSE;
				}
				two_found = TRUE;
				_tmp26_ = iterator;
				_tmp27_ = gee_iterator_get_read_only (_tmp26_);
				_tmp28_ = _tmp27_;
				_vala_assert (!_tmp28_, "! iterator.read_only");
				_tmp29_ = iterator;
				gee_iterator_remove (_tmp29_);
				_tmp30_ = iterator;
				_tmp31_ = gee_iterator_get_valid (_tmp30_);
				_tmp32_ = _tmp31_;
				_vala_assert (!_tmp32_, "! iterator.valid");
			} else {
				const gchar* _tmp33_ = NULL;
				_tmp33_ = element;
				if (g_strcmp0 (_tmp33_, "three") == 0) {
					gboolean _tmp34_ = FALSE;
					_tmp34_ = three_found;
					if (_tmp34_) {
						three_found_once = FALSE;
					}
					three_found = TRUE;
				}
			}
		}
		_g_free0 (element);
	}
	_tmp35_ = iterator;
	_tmp36_ = gee_iterator_has_next (_tmp35_);
	has_next = _tmp36_;
	_tmp37_ = has_next;
	_vala_assert (!_tmp37_, "! has_next");
	_tmp38_ = has_next;
	_tmp39_ = iterator;
	_tmp40_ = gee_iterator_next (_tmp39_);
	_vala_assert (_tmp38_ == _tmp40_, "has_next == iterator.next ()");
	_tmp41_ = one_found;
	_vala_assert (_tmp41_, "one_found");
	_tmp42_ = one_found_once;
	_vala_assert (_tmp42_, "one_found_once");
	_tmp43_ = two_found;
	_vala_assert (_tmp43_, "two_found");
	_tmp44_ = two_found_once;
	_vala_assert (_tmp44_, "two_found_once");
	_tmp45_ = three_found;
	_vala_assert (_tmp45_, "three_found");
	_tmp46_ = three_found_once;
	_vala_assert (_tmp46_, "three_found_once");
	_tmp47_ = self->test_collection;
	_tmp48_ = gee_iterable_iterator ((GeeIterable*) _tmp47_);
	_g_object_unref0 (iterator);
	iterator = _tmp48_;
	_tmp49_ = iterator;
	_tmp50_ = gee_iterator_has_next (_tmp49_);
	_vala_assert (_tmp50_, "iterator.has_next ()");
	_tmp51_ = iterator;
	_tmp52_ = gee_iterator_next (_tmp51_);
	_vala_assert (_tmp52_, "iterator.next ()");
	one_found = FALSE;
	two_found = FALSE;
	three_found = FALSE;
	one_found_once = TRUE;
	two_found_once = TRUE;
	three_found_once = TRUE;
	while (TRUE) {
		gchar* element = NULL;
		GeeIterator* _tmp53_ = NULL;
		gpointer _tmp54_ = NULL;
		const gchar* _tmp55_ = NULL;
		GeeIterator* _tmp60_ = NULL;
		gboolean _tmp61_ = FALSE;
		gboolean _tmp62_ = FALSE;
		GeeIterator* _tmp63_ = NULL;
		gboolean _tmp64_ = FALSE;
		gboolean _tmp65_ = FALSE;
		_tmp53_ = iterator;
		_tmp54_ = gee_iterator_get (_tmp53_);
		element = (gchar*) _tmp54_;
		_tmp55_ = element;
		if (g_strcmp0 (_tmp55_, "one") == 0) {
			gboolean _tmp56_ = FALSE;
			_tmp56_ = one_found;
			if (_tmp56_) {
				one_found_once = FALSE;
			}
			one_found = TRUE;
		} else {
			const gchar* _tmp57_ = NULL;
			_tmp57_ = element;
			if (g_strcmp0 (_tmp57_, "two") == 0) {
				two_found = TRUE;
			} else {
				const gchar* _tmp58_ = NULL;
				_tmp58_ = element;
				if (g_strcmp0 (_tmp58_, "three") == 0) {
					gboolean _tmp59_ = FALSE;
					_tmp59_ = three_found;
					if (_tmp59_) {
						three_found_once = FALSE;
					}
					three_found = TRUE;
				}
			}
		}
		_tmp60_ = iterator;
		_tmp61_ = gee_iterator_has_next (_tmp60_);
		has_next = _tmp61_;
		_tmp62_ = has_next;
		_tmp63_ = iterator;
		_tmp64_ = gee_iterator_next (_tmp63_);
		_vala_assert (_tmp62_ == _tmp64_, "has_next == iterator.next ()");
		_tmp65_ = has_next;
		if (!_tmp65_) {
			_g_free0 (element);
			break;
		}
		_g_free0 (element);
	}
	_tmp66_ = iterator;
	_tmp67_ = gee_iterator_has_next (_tmp66_);
	has_next = _tmp67_;
	_tmp68_ = has_next;
	_vala_assert (!_tmp68_, "! has_next");
	_tmp69_ = has_next;
	_tmp70_ = iterator;
	_tmp71_ = gee_iterator_next (_tmp70_);
	_vala_assert (_tmp69_ == _tmp71_, "has_next == iterator.next ()");
	_tmp72_ = one_found;
	_vala_assert (_tmp72_, "one_found");
	_tmp73_ = one_found_once;
	_vala_assert (_tmp73_, "one_found_once");
	_tmp74_ = two_found;
	_vala_assert (!_tmp74_, "!two_found");
	_tmp75_ = three_found;
	_vala_assert (_tmp75_, "three_found");
	_tmp76_ = three_found_once;
	_vala_assert (_tmp76_, "three_found_once");
	_g_object_unref0 (iterator);
}


void collection_tests_test_contains_size_and_is_empty (CollectionTests* self) {
	GeeCollection* _tmp0_ = NULL;
	GeeCollection* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GeeCollection* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	GeeCollection* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	GeeCollection* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	GeeCollection* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	GeeCollection* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
	GeeCollection* _tmp15_ = NULL;
	gboolean _tmp16_ = FALSE;
	GeeCollection* _tmp17_ = NULL;
	gboolean _tmp18_ = FALSE;
	GeeCollection* _tmp19_ = NULL;
	gboolean _tmp20_ = FALSE;
	GeeCollection* _tmp21_ = NULL;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	GeeCollection* _tmp24_ = NULL;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp26_ = FALSE;
	GeeCollection* _tmp27_ = NULL;
	gboolean _tmp28_ = FALSE;
	GeeCollection* _tmp29_ = NULL;
	gboolean _tmp30_ = FALSE;
	GeeCollection* _tmp31_ = NULL;
	gboolean _tmp32_ = FALSE;
	GeeCollection* _tmp33_ = NULL;
	gboolean _tmp34_ = FALSE;
	GeeCollection* _tmp35_ = NULL;
	gint _tmp36_ = 0;
	gint _tmp37_ = 0;
	GeeCollection* _tmp38_ = NULL;
	gboolean _tmp39_ = FALSE;
	gboolean _tmp40_ = FALSE;
	GeeCollection* _tmp41_ = NULL;
	gboolean _tmp42_ = FALSE;
	GeeCollection* _tmp43_ = NULL;
	gboolean _tmp44_ = FALSE;
	GeeCollection* _tmp45_ = NULL;
	gboolean _tmp46_ = FALSE;
	GeeCollection* _tmp47_ = NULL;
	gboolean _tmp48_ = FALSE;
	GeeCollection* _tmp49_ = NULL;
	gint _tmp50_ = 0;
	gint _tmp51_ = 0;
	GeeCollection* _tmp52_ = NULL;
	gboolean _tmp53_ = FALSE;
	gboolean _tmp54_ = FALSE;
	GeeCollection* _tmp55_ = NULL;
	gboolean _tmp56_ = FALSE;
	GeeCollection* _tmp57_ = NULL;
	gboolean _tmp58_ = FALSE;
	GeeCollection* _tmp59_ = NULL;
	gboolean _tmp60_ = FALSE;
	GeeCollection* _tmp61_ = NULL;
	gboolean _tmp62_ = FALSE;
	GeeCollection* _tmp63_ = NULL;
	gint _tmp64_ = 0;
	gint _tmp65_ = 0;
	GeeCollection* _tmp66_ = NULL;
	gboolean _tmp67_ = FALSE;
	gboolean _tmp68_ = FALSE;
	GeeCollection* _tmp69_ = NULL;
	gboolean _tmp70_ = FALSE;
	GeeCollection* _tmp71_ = NULL;
	gboolean _tmp72_ = FALSE;
	GeeCollection* _tmp73_ = NULL;
	gboolean _tmp74_ = FALSE;
	GeeCollection* _tmp75_ = NULL;
	gboolean _tmp76_ = FALSE;
	GeeCollection* _tmp77_ = NULL;
	gint _tmp78_ = 0;
	gint _tmp79_ = 0;
	GeeCollection* _tmp80_ = NULL;
	gboolean _tmp81_ = FALSE;
	gboolean _tmp82_ = FALSE;
	GeeCollection* _tmp83_ = NULL;
	gboolean _tmp84_ = FALSE;
	GeeCollection* _tmp85_ = NULL;
	gboolean _tmp86_ = FALSE;
	GeeCollection* _tmp87_ = NULL;
	gboolean _tmp88_ = FALSE;
	GeeCollection* _tmp89_ = NULL;
	gboolean _tmp90_ = FALSE;
	GeeCollection* _tmp91_ = NULL;
	gint _tmp92_ = 0;
	gint _tmp93_ = 0;
	GeeCollection* _tmp94_ = NULL;
	gboolean _tmp95_ = FALSE;
	gboolean _tmp96_ = FALSE;
	GeeCollection* _tmp97_ = NULL;
	gboolean _tmp98_ = FALSE;
	GeeCollection* _tmp99_ = NULL;
	gboolean _tmp100_ = FALSE;
	GeeCollection* _tmp101_ = NULL;
	gboolean _tmp102_ = FALSE;
	GeeCollection* _tmp103_ = NULL;
	gboolean _tmp104_ = FALSE;
	GeeCollection* _tmp105_ = NULL;
	gint _tmp106_ = 0;
	gint _tmp107_ = 0;
	GeeCollection* _tmp108_ = NULL;
	gboolean _tmp109_ = FALSE;
	gboolean _tmp110_ = FALSE;
	GeeCollection* _tmp111_ = NULL;
	GeeCollection* _tmp112_ = NULL;
	gboolean _tmp113_ = FALSE;
	GeeCollection* _tmp114_ = NULL;
	gboolean _tmp115_ = FALSE;
	GeeCollection* _tmp116_ = NULL;
	gboolean _tmp117_ = FALSE;
	GeeCollection* _tmp118_ = NULL;
	gint _tmp119_ = 0;
	gint _tmp120_ = 0;
	GeeCollection* _tmp121_ = NULL;
	gboolean _tmp122_ = FALSE;
	gboolean _tmp123_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->test_collection;
	_vala_assert (_tmp0_ != NULL, "test_collection != null");
	_tmp1_ = self->test_collection;
	_tmp2_ = gee_collection_contains (_tmp1_, "one");
	_vala_assert (!_tmp2_, "! test_collection.contains (\"one\")");
	_tmp3_ = self->test_collection;
	_tmp4_ = gee_collection_contains (_tmp3_, "two");
	_vala_assert (!_tmp4_, "! test_collection.contains (\"two\")");
	_tmp5_ = self->test_collection;
	_tmp6_ = gee_collection_contains (_tmp5_, "three");
	_vala_assert (!_tmp6_, "! test_collection.contains (\"three\")");
	_tmp7_ = self->test_collection;
	_tmp8_ = gee_collection_get_size (_tmp7_);
	_tmp9_ = _tmp8_;
	_vala_assert (_tmp9_ == 0, "test_collection.size == 0");
	_tmp10_ = self->test_collection;
	_tmp11_ = gee_collection_get_is_empty (_tmp10_);
	_tmp12_ = _tmp11_;
	_vala_assert (_tmp12_, "test_collection.is_empty");
	_tmp13_ = self->test_collection;
	_tmp14_ = gee_collection_add (_tmp13_, "one");
	_vala_assert (_tmp14_, "test_collection.add (\"one\")");
	_tmp15_ = self->test_collection;
	_tmp16_ = gee_collection_contains (_tmp15_, "one");
	_vala_assert (_tmp16_, "test_collection.contains (\"one\")");
	_tmp17_ = self->test_collection;
	_tmp18_ = gee_collection_contains (_tmp17_, "two");
	_vala_assert (!_tmp18_, "! test_collection.contains (\"two\")");
	_tmp19_ = self->test_collection;
	_tmp20_ = gee_collection_contains (_tmp19_, "three");
	_vala_assert (!_tmp20_, "! test_collection.contains (\"three\")");
	_tmp21_ = self->test_collection;
	_tmp22_ = gee_collection_get_size (_tmp21_);
	_tmp23_ = _tmp22_;
	_vala_assert (_tmp23_ == 1, "test_collection.size == 1");
	_tmp24_ = self->test_collection;
	_tmp25_ = gee_collection_get_is_empty (_tmp24_);
	_tmp26_ = _tmp25_;
	_vala_assert (!_tmp26_, "! test_collection.is_empty");
	_tmp27_ = self->test_collection;
	_tmp28_ = gee_collection_remove (_tmp27_, "one");
	_vala_assert (_tmp28_, "test_collection.remove (\"one\")");
	_tmp29_ = self->test_collection;
	_tmp30_ = gee_collection_contains (_tmp29_, "one");
	_vala_assert (!_tmp30_, "! test_collection.contains (\"one\")");
	_tmp31_ = self->test_collection;
	_tmp32_ = gee_collection_contains (_tmp31_, "two");
	_vala_assert (!_tmp32_, "! test_collection.contains (\"two\")");
	_tmp33_ = self->test_collection;
	_tmp34_ = gee_collection_contains (_tmp33_, "three");
	_vala_assert (!_tmp34_, "! test_collection.contains (\"three\")");
	_tmp35_ = self->test_collection;
	_tmp36_ = gee_collection_get_size (_tmp35_);
	_tmp37_ = _tmp36_;
	_vala_assert (_tmp37_ == 0, "test_collection.size == 0");
	_tmp38_ = self->test_collection;
	_tmp39_ = gee_collection_get_is_empty (_tmp38_);
	_tmp40_ = _tmp39_;
	_vala_assert (_tmp40_, "test_collection.is_empty");
	_tmp41_ = self->test_collection;
	_tmp42_ = gee_collection_add (_tmp41_, "one");
	_vala_assert (_tmp42_, "test_collection.add (\"one\")");
	_tmp43_ = self->test_collection;
	_tmp44_ = gee_collection_contains (_tmp43_, "one");
	_vala_assert (_tmp44_, "test_collection.contains (\"one\")");
	_tmp45_ = self->test_collection;
	_tmp46_ = gee_collection_contains (_tmp45_, "two");
	_vala_assert (!_tmp46_, "! test_collection.contains (\"two\")");
	_tmp47_ = self->test_collection;
	_tmp48_ = gee_collection_contains (_tmp47_, "three");
	_vala_assert (!_tmp48_, "! test_collection.contains (\"three\")");
	_tmp49_ = self->test_collection;
	_tmp50_ = gee_collection_get_size (_tmp49_);
	_tmp51_ = _tmp50_;
	_vala_assert (_tmp51_ == 1, "test_collection.size == 1");
	_tmp52_ = self->test_collection;
	_tmp53_ = gee_collection_get_is_empty (_tmp52_);
	_tmp54_ = _tmp53_;
	_vala_assert (!_tmp54_, "! test_collection.is_empty");
	_tmp55_ = self->test_collection;
	_tmp56_ = gee_collection_add (_tmp55_, "two");
	_vala_assert (_tmp56_, "test_collection.add (\"two\")");
	_tmp57_ = self->test_collection;
	_tmp58_ = gee_collection_contains (_tmp57_, "one");
	_vala_assert (_tmp58_, "test_collection.contains (\"one\")");
	_tmp59_ = self->test_collection;
	_tmp60_ = gee_collection_contains (_tmp59_, "two");
	_vala_assert (_tmp60_, "test_collection.contains (\"two\")");
	_tmp61_ = self->test_collection;
	_tmp62_ = gee_collection_contains (_tmp61_, "three");
	_vala_assert (!_tmp62_, "! test_collection.contains (\"three\")");
	_tmp63_ = self->test_collection;
	_tmp64_ = gee_collection_get_size (_tmp63_);
	_tmp65_ = _tmp64_;
	_vala_assert (_tmp65_ == 2, "test_collection.size == 2");
	_tmp66_ = self->test_collection;
	_tmp67_ = gee_collection_get_is_empty (_tmp66_);
	_tmp68_ = _tmp67_;
	_vala_assert (!_tmp68_, "! test_collection.is_empty");
	_tmp69_ = self->test_collection;
	_tmp70_ = gee_collection_add (_tmp69_, "three");
	_vala_assert (_tmp70_, "test_collection.add (\"three\")");
	_tmp71_ = self->test_collection;
	_tmp72_ = gee_collection_contains (_tmp71_, "one");
	_vala_assert (_tmp72_, "test_collection.contains (\"one\")");
	_tmp73_ = self->test_collection;
	_tmp74_ = gee_collection_contains (_tmp73_, "two");
	_vala_assert (_tmp74_, "test_collection.contains (\"two\")");
	_tmp75_ = self->test_collection;
	_tmp76_ = gee_collection_contains (_tmp75_, "three");
	_vala_assert (_tmp76_, "test_collection.contains (\"three\")");
	_tmp77_ = self->test_collection;
	_tmp78_ = gee_collection_get_size (_tmp77_);
	_tmp79_ = _tmp78_;
	_vala_assert (_tmp79_ == 3, "test_collection.size == 3");
	_tmp80_ = self->test_collection;
	_tmp81_ = gee_collection_get_is_empty (_tmp80_);
	_tmp82_ = _tmp81_;
	_vala_assert (!_tmp82_, "! test_collection.is_empty");
	_tmp83_ = self->test_collection;
	_tmp84_ = gee_collection_remove (_tmp83_, "two");
	_vala_assert (_tmp84_, "test_collection.remove (\"two\")");
	_tmp85_ = self->test_collection;
	_tmp86_ = gee_collection_contains (_tmp85_, "one");
	_vala_assert (_tmp86_, "test_collection.contains (\"one\")");
	_tmp87_ = self->test_collection;
	_tmp88_ = gee_collection_contains (_tmp87_, "two");
	_vala_assert (!_tmp88_, "! test_collection.contains (\"two\")");
	_tmp89_ = self->test_collection;
	_tmp90_ = gee_collection_contains (_tmp89_, "three");
	_vala_assert (_tmp90_, "test_collection.contains (\"three\")");
	_tmp91_ = self->test_collection;
	_tmp92_ = gee_collection_get_size (_tmp91_);
	_tmp93_ = _tmp92_;
	_vala_assert (_tmp93_ == 2, "test_collection.size == 2");
	_tmp94_ = self->test_collection;
	_tmp95_ = gee_collection_get_is_empty (_tmp94_);
	_tmp96_ = _tmp95_;
	_vala_assert (!_tmp96_, "! test_collection.is_empty");
	_tmp97_ = self->test_collection;
	_tmp98_ = gee_collection_remove (_tmp97_, "two");
	_vala_assert (!_tmp98_, "! test_collection.remove (\"two\")");
	_tmp99_ = self->test_collection;
	_tmp100_ = gee_collection_contains (_tmp99_, "one");
	_vala_assert (_tmp100_, "test_collection.contains (\"one\")");
	_tmp101_ = self->test_collection;
	_tmp102_ = gee_collection_contains (_tmp101_, "two");
	_vala_assert (!_tmp102_, "! test_collection.contains (\"two\")");
	_tmp103_ = self->test_collection;
	_tmp104_ = gee_collection_contains (_tmp103_, "three");
	_vala_assert (_tmp104_, "test_collection.contains (\"three\")");
	_tmp105_ = self->test_collection;
	_tmp106_ = gee_collection_get_size (_tmp105_);
	_tmp107_ = _tmp106_;
	_vala_assert (_tmp107_ == 2, "test_collection.size == 2");
	_tmp108_ = self->test_collection;
	_tmp109_ = gee_collection_get_is_empty (_tmp108_);
	_tmp110_ = _tmp109_;
	_vala_assert (!_tmp110_, "! test_collection.is_empty");
	_tmp111_ = self->test_collection;
	gee_collection_clear (_tmp111_);
	_tmp112_ = self->test_collection;
	_tmp113_ = gee_collection_contains (_tmp112_, "one");
	_vala_assert (!_tmp113_, "! test_collection.contains (\"one\")");
	_tmp114_ = self->test_collection;
	_tmp115_ = gee_collection_contains (_tmp114_, "two");
	_vala_assert (!_tmp115_, "! test_collection.contains (\"two\")");
	_tmp116_ = self->test_collection;
	_tmp117_ = gee_collection_contains (_tmp116_, "three");
	_vala_assert (!_tmp117_, "! test_collection.contains (\"three\")");
	_tmp118_ = self->test_collection;
	_tmp119_ = gee_collection_get_size (_tmp118_);
	_tmp120_ = _tmp119_;
	_vala_assert (_tmp120_ == 0, "test_collection.size == 0");
	_tmp121_ = self->test_collection;
	_tmp122_ = gee_collection_get_is_empty (_tmp121_);
	_tmp123_ = _tmp122_;
	_vala_assert (_tmp123_, "test_collection.is_empty");
}


void collection_tests_test_add_remove (CollectionTests* self) {
	GeeCollection* _tmp0_ = NULL;
	gchar** to_add = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	gchar* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	gchar* _tmp30_ = NULL;
	gchar* _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	gchar* _tmp33_ = NULL;
	gchar* _tmp34_ = NULL;
	gchar* _tmp35_ = NULL;
	gchar* _tmp36_ = NULL;
	gchar* _tmp37_ = NULL;
	gchar* _tmp38_ = NULL;
	gchar* _tmp39_ = NULL;
	gchar** _tmp40_ = NULL;
	gint to_add_length1 = 0;
	gint _to_add_size_ = 0;
	gint expected_size = 0;
	gchar** _tmp41_ = NULL;
	gint _tmp41__length1 = 0;
	GeeCollection* _tmp56_ = NULL;
	gint _tmp57_ = 0;
	gint _tmp58_ = 0;
	gchar** _tmp59_ = NULL;
	gint _tmp59__length1 = 0;
	gchar** _tmp60_ = NULL;
	gint _tmp60__length1 = 0;
	gchar** _tmp65_ = NULL;
	gint _tmp65__length1 = 0;
	GeeCollection* _tmp80_ = NULL;
	gint _tmp81_ = 0;
	gint _tmp82_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->test_collection;
	_vala_assert (_tmp0_ != NULL, "test_collection != null");
	_tmp1_ = g_strdup ("one");
	_tmp2_ = g_strdup ("two");
	_tmp3_ = g_strdup ("three");
	_tmp4_ = g_strdup ("four");
	_tmp5_ = g_strdup ("five");
	_tmp6_ = g_strdup ("six");
	_tmp7_ = g_strdup ("seven");
	_tmp8_ = g_strdup ("eight");
	_tmp9_ = g_strdup ("nine");
	_tmp10_ = g_strdup ("ten");
	_tmp11_ = g_strdup ("eleven");
	_tmp12_ = g_strdup ("twelve");
	_tmp13_ = g_strdup ("thirteen");
	_tmp14_ = g_strdup ("fourteen");
	_tmp15_ = g_strdup ("fifteen");
	_tmp16_ = g_strdup ("sixteen");
	_tmp17_ = g_strdup ("seventeen");
	_tmp18_ = g_strdup ("eighteen");
	_tmp19_ = g_strdup ("nineteen");
	_tmp20_ = g_strdup ("twenty");
	_tmp21_ = g_strdup ("twenty one");
	_tmp22_ = g_strdup ("twenty two");
	_tmp23_ = g_strdup ("twenty three");
	_tmp24_ = g_strdup ("twenty four");
	_tmp25_ = g_strdup ("twenty five");
	_tmp26_ = g_strdup ("twenty six");
	_tmp27_ = g_strdup ("twenty seven");
	_tmp28_ = g_strdup ("twenty eight");
	_tmp29_ = g_strdup ("twenty nine");
	_tmp30_ = g_strdup ("thirty");
	_tmp31_ = g_strdup ("thirty one");
	_tmp32_ = g_strdup ("thirty two");
	_tmp33_ = g_strdup ("thirty four");
	_tmp34_ = g_strdup ("thirty five");
	_tmp35_ = g_strdup ("thirty six");
	_tmp36_ = g_strdup ("thirty seven");
	_tmp37_ = g_strdup ("thirty eight");
	_tmp38_ = g_strdup ("thirty nine");
	_tmp39_ = g_strdup ("fourty");
	_tmp40_ = g_new0 (gchar*, 39 + 1);
	_tmp40_[0] = _tmp1_;
	_tmp40_[1] = _tmp2_;
	_tmp40_[2] = _tmp3_;
	_tmp40_[3] = _tmp4_;
	_tmp40_[4] = _tmp5_;
	_tmp40_[5] = _tmp6_;
	_tmp40_[6] = _tmp7_;
	_tmp40_[7] = _tmp8_;
	_tmp40_[8] = _tmp9_;
	_tmp40_[9] = _tmp10_;
	_tmp40_[10] = _tmp11_;
	_tmp40_[11] = _tmp12_;
	_tmp40_[12] = _tmp13_;
	_tmp40_[13] = _tmp14_;
	_tmp40_[14] = _tmp15_;
	_tmp40_[15] = _tmp16_;
	_tmp40_[16] = _tmp17_;
	_tmp40_[17] = _tmp18_;
	_tmp40_[18] = _tmp19_;
	_tmp40_[19] = _tmp20_;
	_tmp40_[20] = _tmp21_;
	_tmp40_[21] = _tmp22_;
	_tmp40_[22] = _tmp23_;
	_tmp40_[23] = _tmp24_;
	_tmp40_[24] = _tmp25_;
	_tmp40_[25] = _tmp26_;
	_tmp40_[26] = _tmp27_;
	_tmp40_[27] = _tmp28_;
	_tmp40_[28] = _tmp29_;
	_tmp40_[29] = _tmp30_;
	_tmp40_[30] = _tmp31_;
	_tmp40_[31] = _tmp32_;
	_tmp40_[32] = _tmp33_;
	_tmp40_[33] = _tmp34_;
	_tmp40_[34] = _tmp35_;
	_tmp40_[35] = _tmp36_;
	_tmp40_[36] = _tmp37_;
	_tmp40_[37] = _tmp38_;
	_tmp40_[38] = _tmp39_;
	to_add = _tmp40_;
	to_add_length1 = 39;
	_to_add_size_ = to_add_length1;
	expected_size = 0;
	_tmp41_ = to_add;
	_tmp41__length1 = to_add_length1;
	{
		gchar** a_collection = NULL;
		gint a_collection_length1 = 0;
		gint _a_collection_size_ = 0;
		gint a_it = 0;
		a_collection = _tmp41_;
		a_collection_length1 = _tmp41__length1;
		for (a_it = 0; a_it < _tmp41__length1; a_it = a_it + 1) {
			gchar* _tmp42_ = NULL;
			gchar* a = NULL;
			_tmp42_ = g_strdup (a_collection[a_it]);
			a = _tmp42_;
			{
				GeeCollection* _tmp43_ = NULL;
				const gchar* _tmp44_ = NULL;
				gboolean _tmp45_ = FALSE;
				GeeCollection* _tmp46_ = NULL;
				gint _tmp47_ = 0;
				gint _tmp48_ = 0;
				gint _tmp49_ = 0;
				GeeCollection* _tmp50_ = NULL;
				const gchar* _tmp51_ = NULL;
				gboolean _tmp52_ = FALSE;
				GeeCollection* _tmp53_ = NULL;
				const gchar* _tmp54_ = NULL;
				gboolean _tmp55_ = FALSE;
				_tmp43_ = self->test_collection;
				_tmp44_ = a;
				_tmp45_ = gee_collection_contains (_tmp43_, _tmp44_);
				_vala_assert (!_tmp45_, "!test_collection.contains (a)");
				_tmp46_ = self->test_collection;
				_tmp47_ = gee_collection_get_size (_tmp46_);
				_tmp48_ = _tmp47_;
				_tmp49_ = expected_size;
				expected_size = _tmp49_ + 1;
				_vala_assert (_tmp48_ == _tmp49_, "test_collection.size == expected_size++");
				_tmp50_ = self->test_collection;
				_tmp51_ = a;
				_tmp52_ = gee_collection_add (_tmp50_, _tmp51_);
				_vala_assert (_tmp52_, "test_collection.add (a)");
				_tmp53_ = self->test_collection;
				_tmp54_ = a;
				_tmp55_ = gee_collection_contains (_tmp53_, _tmp54_);
				_vala_assert (_tmp55_, "test_collection.contains (a)");
				_g_free0 (a);
			}
		}
	}
	_tmp56_ = self->test_collection;
	_tmp57_ = gee_collection_get_size (_tmp56_);
	_tmp58_ = _tmp57_;
	_tmp59_ = to_add;
	_tmp59__length1 = to_add_length1;
	_vala_assert (_tmp58_ == _tmp59__length1, "test_collection.size == to_add.length");
	_tmp60_ = to_add;
	_tmp60__length1 = to_add_length1;
	{
		gchar** a_collection = NULL;
		gint a_collection_length1 = 0;
		gint _a_collection_size_ = 0;
		gint a_it = 0;
		a_collection = _tmp60_;
		a_collection_length1 = _tmp60__length1;
		for (a_it = 0; a_it < _tmp60__length1; a_it = a_it + 1) {
			gchar* _tmp61_ = NULL;
			gchar* a = NULL;
			_tmp61_ = g_strdup (a_collection[a_it]);
			a = _tmp61_;
			{
				GeeCollection* _tmp62_ = NULL;
				const gchar* _tmp63_ = NULL;
				gboolean _tmp64_ = FALSE;
				_tmp62_ = self->test_collection;
				_tmp63_ = a;
				_tmp64_ = gee_collection_contains (_tmp62_, _tmp63_);
				_vala_assert (_tmp64_, "test_collection.contains (a)");
				_g_free0 (a);
			}
		}
	}
	_tmp65_ = to_add;
	_tmp65__length1 = to_add_length1;
	{
		gchar** a_collection = NULL;
		gint a_collection_length1 = 0;
		gint _a_collection_size_ = 0;
		gint a_it = 0;
		a_collection = _tmp65_;
		a_collection_length1 = _tmp65__length1;
		for (a_it = 0; a_it < _tmp65__length1; a_it = a_it + 1) {
			gchar* _tmp66_ = NULL;
			gchar* a = NULL;
			_tmp66_ = g_strdup (a_collection[a_it]);
			a = _tmp66_;
			{
				GeeCollection* _tmp67_ = NULL;
				const gchar* _tmp68_ = NULL;
				gboolean _tmp69_ = FALSE;
				GeeCollection* _tmp70_ = NULL;
				gint _tmp71_ = 0;
				gint _tmp72_ = 0;
				gint _tmp73_ = 0;
				GeeCollection* _tmp74_ = NULL;
				const gchar* _tmp75_ = NULL;
				gboolean _tmp76_ = FALSE;
				GeeCollection* _tmp77_ = NULL;
				const gchar* _tmp78_ = NULL;
				gboolean _tmp79_ = FALSE;
				_tmp67_ = self->test_collection;
				_tmp68_ = a;
				_tmp69_ = gee_collection_contains (_tmp67_, _tmp68_);
				_vala_assert (_tmp69_, "test_collection.contains (a)");
				_tmp70_ = self->test_collection;
				_tmp71_ = gee_collection_get_size (_tmp70_);
				_tmp72_ = _tmp71_;
				_tmp73_ = expected_size;
				expected_size = _tmp73_ - 1;
				_vala_assert (_tmp72_ == _tmp73_, "test_collection.size == expected_size--");
				_tmp74_ = self->test_collection;
				_tmp75_ = a;
				_tmp76_ = gee_collection_remove (_tmp74_, _tmp75_);
				_vala_assert (_tmp76_, "test_collection.remove (a)");
				_tmp77_ = self->test_collection;
				_tmp78_ = a;
				_tmp79_ = gee_collection_contains (_tmp77_, _tmp78_);
				_vala_assert (!_tmp79_, "!test_collection.contains (a)");
				_g_free0 (a);
			}
		}
	}
	_tmp80_ = self->test_collection;
	_tmp81_ = gee_collection_get_size (_tmp80_);
	_tmp82_ = _tmp81_;
	_vala_assert (_tmp82_ == 0, "test_collection.size == 0");
	to_add = (_vala_array_free (to_add, to_add_length1, (GDestroyNotify) g_free), NULL);
}


void collection_tests_test_clear (CollectionTests* self) {
	GeeCollection* _tmp0_ = NULL;
	gchar** to_add = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	gchar* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	gchar* _tmp30_ = NULL;
	gchar* _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	gchar* _tmp33_ = NULL;
	gchar* _tmp34_ = NULL;
	gchar* _tmp35_ = NULL;
	gchar* _tmp36_ = NULL;
	gchar* _tmp37_ = NULL;
	gchar* _tmp38_ = NULL;
	gchar* _tmp39_ = NULL;
	gchar** _tmp40_ = NULL;
	gint to_add_length1 = 0;
	gint _to_add_size_ = 0;
	gint expected_size = 0;
	gchar** _tmp41_ = NULL;
	gint _tmp41__length1 = 0;
	GeeCollection* _tmp56_ = NULL;
	gint _tmp57_ = 0;
	gint _tmp58_ = 0;
	gchar** _tmp59_ = NULL;
	gint _tmp59__length1 = 0;
	GeeCollection* _tmp60_ = NULL;
	GeeCollection* _tmp61_ = NULL;
	gint _tmp62_ = 0;
	gint _tmp63_ = 0;
	GeeIterator* iter = NULL;
	GeeCollection* _tmp64_ = NULL;
	GeeIterator* _tmp65_ = NULL;
	gboolean _tmp66_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->test_collection;
	_vala_assert (_tmp0_ != NULL, "test_collection != null");
	_tmp1_ = g_strdup ("one");
	_tmp2_ = g_strdup ("two");
	_tmp3_ = g_strdup ("three");
	_tmp4_ = g_strdup ("four");
	_tmp5_ = g_strdup ("five");
	_tmp6_ = g_strdup ("six");
	_tmp7_ = g_strdup ("seven");
	_tmp8_ = g_strdup ("eight");
	_tmp9_ = g_strdup ("nine");
	_tmp10_ = g_strdup ("ten");
	_tmp11_ = g_strdup ("eleven");
	_tmp12_ = g_strdup ("twelve");
	_tmp13_ = g_strdup ("thirteen");
	_tmp14_ = g_strdup ("fourteen");
	_tmp15_ = g_strdup ("fifteen");
	_tmp16_ = g_strdup ("sixteen");
	_tmp17_ = g_strdup ("seventeen");
	_tmp18_ = g_strdup ("eighteen");
	_tmp19_ = g_strdup ("nineteen");
	_tmp20_ = g_strdup ("twenty");
	_tmp21_ = g_strdup ("twenty one");
	_tmp22_ = g_strdup ("twenty two");
	_tmp23_ = g_strdup ("twenty three");
	_tmp24_ = g_strdup ("twenty four");
	_tmp25_ = g_strdup ("twenty five");
	_tmp26_ = g_strdup ("twenty six");
	_tmp27_ = g_strdup ("twenty seven");
	_tmp28_ = g_strdup ("twenty eight");
	_tmp29_ = g_strdup ("twenty nine");
	_tmp30_ = g_strdup ("thirty");
	_tmp31_ = g_strdup ("thirty one");
	_tmp32_ = g_strdup ("thirty two");
	_tmp33_ = g_strdup ("thirty four");
	_tmp34_ = g_strdup ("thirty five");
	_tmp35_ = g_strdup ("thirty six");
	_tmp36_ = g_strdup ("thirty seven");
	_tmp37_ = g_strdup ("thirty eight");
	_tmp38_ = g_strdup ("thirty nine");
	_tmp39_ = g_strdup ("fourty");
	_tmp40_ = g_new0 (gchar*, 39 + 1);
	_tmp40_[0] = _tmp1_;
	_tmp40_[1] = _tmp2_;
	_tmp40_[2] = _tmp3_;
	_tmp40_[3] = _tmp4_;
	_tmp40_[4] = _tmp5_;
	_tmp40_[5] = _tmp6_;
	_tmp40_[6] = _tmp7_;
	_tmp40_[7] = _tmp8_;
	_tmp40_[8] = _tmp9_;
	_tmp40_[9] = _tmp10_;
	_tmp40_[10] = _tmp11_;
	_tmp40_[11] = _tmp12_;
	_tmp40_[12] = _tmp13_;
	_tmp40_[13] = _tmp14_;
	_tmp40_[14] = _tmp15_;
	_tmp40_[15] = _tmp16_;
	_tmp40_[16] = _tmp17_;
	_tmp40_[17] = _tmp18_;
	_tmp40_[18] = _tmp19_;
	_tmp40_[19] = _tmp20_;
	_tmp40_[20] = _tmp21_;
	_tmp40_[21] = _tmp22_;
	_tmp40_[22] = _tmp23_;
	_tmp40_[23] = _tmp24_;
	_tmp40_[24] = _tmp25_;
	_tmp40_[25] = _tmp26_;
	_tmp40_[26] = _tmp27_;
	_tmp40_[27] = _tmp28_;
	_tmp40_[28] = _tmp29_;
	_tmp40_[29] = _tmp30_;
	_tmp40_[30] = _tmp31_;
	_tmp40_[31] = _tmp32_;
	_tmp40_[32] = _tmp33_;
	_tmp40_[33] = _tmp34_;
	_tmp40_[34] = _tmp35_;
	_tmp40_[35] = _tmp36_;
	_tmp40_[36] = _tmp37_;
	_tmp40_[37] = _tmp38_;
	_tmp40_[38] = _tmp39_;
	to_add = _tmp40_;
	to_add_length1 = 39;
	_to_add_size_ = to_add_length1;
	expected_size = 0;
	_tmp41_ = to_add;
	_tmp41__length1 = to_add_length1;
	{
		gchar** a_collection = NULL;
		gint a_collection_length1 = 0;
		gint _a_collection_size_ = 0;
		gint a_it = 0;
		a_collection = _tmp41_;
		a_collection_length1 = _tmp41__length1;
		for (a_it = 0; a_it < _tmp41__length1; a_it = a_it + 1) {
			gchar* _tmp42_ = NULL;
			gchar* a = NULL;
			_tmp42_ = g_strdup (a_collection[a_it]);
			a = _tmp42_;
			{
				GeeCollection* _tmp43_ = NULL;
				const gchar* _tmp44_ = NULL;
				gboolean _tmp45_ = FALSE;
				GeeCollection* _tmp46_ = NULL;
				gint _tmp47_ = 0;
				gint _tmp48_ = 0;
				gint _tmp49_ = 0;
				GeeCollection* _tmp50_ = NULL;
				const gchar* _tmp51_ = NULL;
				gboolean _tmp52_ = FALSE;
				GeeCollection* _tmp53_ = NULL;
				const gchar* _tmp54_ = NULL;
				gboolean _tmp55_ = FALSE;
				_tmp43_ = self->test_collection;
				_tmp44_ = a;
				_tmp45_ = gee_collection_contains (_tmp43_, _tmp44_);
				_vala_assert (!_tmp45_, "!test_collection.contains (a)");
				_tmp46_ = self->test_collection;
				_tmp47_ = gee_collection_get_size (_tmp46_);
				_tmp48_ = _tmp47_;
				_tmp49_ = expected_size;
				expected_size = _tmp49_ + 1;
				_vala_assert (_tmp48_ == _tmp49_, "test_collection.size == expected_size++");
				_tmp50_ = self->test_collection;
				_tmp51_ = a;
				_tmp52_ = gee_collection_add (_tmp50_, _tmp51_);
				_vala_assert (_tmp52_, "test_collection.add (a)");
				_tmp53_ = self->test_collection;
				_tmp54_ = a;
				_tmp55_ = gee_collection_contains (_tmp53_, _tmp54_);
				_vala_assert (_tmp55_, "test_collection.contains (a)");
				_g_free0 (a);
			}
		}
	}
	_tmp56_ = self->test_collection;
	_tmp57_ = gee_collection_get_size (_tmp56_);
	_tmp58_ = _tmp57_;
	_tmp59_ = to_add;
	_tmp59__length1 = to_add_length1;
	_vala_assert (_tmp58_ == _tmp59__length1, "test_collection.size == to_add.length");
	_tmp60_ = self->test_collection;
	gee_collection_clear (_tmp60_);
	_tmp61_ = self->test_collection;
	_tmp62_ = gee_collection_get_size (_tmp61_);
	_tmp63_ = _tmp62_;
	_vala_assert (_tmp63_ == 0, "test_collection.size == 0");
	_tmp64_ = self->test_collection;
	_tmp65_ = gee_iterable_iterator ((GeeIterable*) _tmp64_);
	iter = _tmp65_;
	_vala_assert (iter != NULL, "iter != null");
	_tmp66_ = gee_iterator_has_next (iter);
	_vala_assert (!_tmp66_, "!iter.has_next ()");
	_g_object_unref0 (iter);
	to_add = (_vala_array_free (to_add, to_add_length1, (GDestroyNotify) g_free), NULL);
}


void collection_tests_test_add_all (CollectionTests* self) {
	GeeCollection* _tmp0_ = NULL;
	GeeArrayList* dummy = NULL;
	GeeArrayList* _tmp1_ = NULL;
	GeeCollection* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GeeCollection* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	GeeCollection* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	GeeCollection* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	GeeCollection* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	GeeCollection* _tmp16_ = NULL;
	gboolean _tmp17_ = FALSE;
	GeeCollection* _tmp18_ = NULL;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp20_ = FALSE;
	gboolean _tmp21_ = FALSE;
	GeeCollection* _tmp22_ = NULL;
	gboolean _tmp23_ = FALSE;
	GeeCollection* _tmp24_ = NULL;
	gint _tmp25_ = 0;
	gint _tmp26_ = 0;
	GeeCollection* _tmp27_ = NULL;
	gboolean _tmp28_ = FALSE;
	GeeCollection* _tmp29_ = NULL;
	gboolean _tmp30_ = FALSE;
	GeeCollection* _tmp31_ = NULL;
	gboolean _tmp32_ = FALSE;
	gint _tmp33_ = 0;
	gint _tmp34_ = 0;
	gboolean _tmp35_ = FALSE;
	gboolean _tmp36_ = FALSE;
	gboolean _tmp37_ = FALSE;
	GeeCollection* _tmp38_ = NULL;
	gboolean _tmp39_ = FALSE;
	gboolean _tmp40_ = FALSE;
	gboolean _tmp41_ = FALSE;
	GeeCollection* _tmp42_ = NULL;
	gboolean _tmp43_ = FALSE;
	GeeCollection* _tmp44_ = NULL;
	gboolean _tmp45_ = FALSE;
	GeeCollection* _tmp46_ = NULL;
	gint _tmp47_ = 0;
	gint _tmp48_ = 0;
	GeeCollection* _tmp49_ = NULL;
	gboolean _tmp50_ = FALSE;
	GeeCollection* _tmp51_ = NULL;
	gboolean _tmp52_ = FALSE;
	GeeCollection* _tmp53_ = NULL;
	gboolean _tmp54_ = FALSE;
	GeeCollection* _tmp55_ = NULL;
	gboolean _tmp56_ = FALSE;
	gint _tmp57_ = 0;
	gint _tmp58_ = 0;
	gboolean _tmp59_ = FALSE;
	gboolean _tmp60_ = FALSE;
	gboolean _tmp61_ = FALSE;
	GeeCollection* _tmp62_ = NULL;
	gboolean _tmp63_ = FALSE;
	gboolean _tmp64_ = FALSE;
	gboolean _tmp65_ = FALSE;
	GeeCollection* _tmp66_ = NULL;
	gboolean _tmp67_ = FALSE;
	GeeCollection* _tmp68_ = NULL;
	gboolean _tmp69_ = FALSE;
	GeeCollection* _tmp70_ = NULL;
	gint _tmp71_ = 0;
	gint _tmp72_ = 0;
	GeeCollection* _tmp73_ = NULL;
	gboolean _tmp74_ = FALSE;
	GeeCollection* _tmp75_ = NULL;
	gboolean _tmp76_ = FALSE;
	GeeCollection* _tmp77_ = NULL;
	gboolean _tmp78_ = FALSE;
	gint _tmp79_ = 0;
	gint _tmp80_ = 0;
	gboolean _tmp81_ = FALSE;
	gboolean _tmp82_ = FALSE;
	gboolean _tmp83_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->test_collection;
	_vala_assert (_tmp0_ != NULL, "test_collection != null");
	_tmp1_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	dummy = _tmp1_;
	_tmp2_ = self->test_collection;
	_tmp3_ = gee_collection_add_all (_tmp2_, (GeeCollection*) dummy);
	_vala_assert (!_tmp3_, "! test_collection.add_all (dummy)");
	_tmp4_ = self->test_collection;
	_tmp5_ = gee_collection_get_is_empty (_tmp4_);
	_tmp6_ = _tmp5_;
	_vala_assert (_tmp6_, "test_collection.is_empty");
	_tmp7_ = gee_collection_get_is_empty ((GeeCollection*) dummy);
	_tmp8_ = _tmp7_;
	_vala_assert (_tmp8_, "dummy.is_empty");
	_tmp9_ = self->test_collection;
	_tmp10_ = gee_collection_add (_tmp9_, "hello");
	_vala_assert (_tmp10_, "test_collection.add (\"hello\")");
	_tmp11_ = self->test_collection;
	_tmp12_ = gee_collection_add_all (_tmp11_, (GeeCollection*) dummy);
	_vala_assert (!_tmp12_, "! test_collection.add_all (dummy)");
	_tmp13_ = self->test_collection;
	_tmp14_ = gee_collection_get_size (_tmp13_);
	_tmp15_ = _tmp14_;
	_vala_assert (_tmp15_ == 1, "test_collection.size == 1");
	_tmp16_ = self->test_collection;
	_tmp17_ = gee_collection_contains (_tmp16_, "hello");
	_vala_assert (_tmp17_, "test_collection.contains (\"hello\")");
	_tmp18_ = self->test_collection;
	gee_collection_clear (_tmp18_);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	_tmp19_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello1");
	_vala_assert (_tmp19_, "dummy.add (\"hello1\")");
	_tmp20_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello2");
	_vala_assert (_tmp20_, "dummy.add (\"hello2\")");
	_tmp21_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello3");
	_vala_assert (_tmp21_, "dummy.add (\"hello3\")");
	_tmp22_ = self->test_collection;
	_tmp23_ = gee_collection_add_all (_tmp22_, (GeeCollection*) dummy);
	_vala_assert (_tmp23_, "test_collection.add_all (dummy)");
	_tmp24_ = self->test_collection;
	_tmp25_ = gee_collection_get_size (_tmp24_);
	_tmp26_ = _tmp25_;
	_vala_assert (_tmp26_ == 3, "test_collection.size == 3");
	_tmp27_ = self->test_collection;
	_tmp28_ = gee_collection_contains (_tmp27_, "hello1");
	_vala_assert (_tmp28_, "test_collection.contains (\"hello1\")");
	_tmp29_ = self->test_collection;
	_tmp30_ = gee_collection_contains (_tmp29_, "hello2");
	_vala_assert (_tmp30_, "test_collection.contains (\"hello2\")");
	_tmp31_ = self->test_collection;
	_tmp32_ = gee_collection_contains (_tmp31_, "hello3");
	_vala_assert (_tmp32_, "test_collection.contains (\"hello3\")");
	_tmp33_ = gee_abstract_collection_get_size ((GeeCollection*) dummy);
	_tmp34_ = _tmp33_;
	_vala_assert (_tmp34_ == 3, "dummy.size == 3");
	_tmp35_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello1");
	_vala_assert (_tmp35_, "dummy.contains (\"hello1\")");
	_tmp36_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello2");
	_vala_assert (_tmp36_, "dummy.contains (\"hello2\")");
	_tmp37_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello3");
	_vala_assert (_tmp37_, "dummy.contains (\"hello3\")");
	_tmp38_ = self->test_collection;
	gee_collection_clear (_tmp38_);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	_tmp39_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello1");
	_vala_assert (_tmp39_, "dummy.add (\"hello1\")");
	_tmp40_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello2");
	_vala_assert (_tmp40_, "dummy.add (\"hello2\")");
	_tmp41_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello3");
	_vala_assert (_tmp41_, "dummy.add (\"hello3\")");
	_tmp42_ = self->test_collection;
	_tmp43_ = gee_collection_add (_tmp42_, "hello");
	_vala_assert (_tmp43_, "test_collection.add (\"hello\")");
	_tmp44_ = self->test_collection;
	_tmp45_ = gee_collection_add_all (_tmp44_, (GeeCollection*) dummy);
	_vala_assert (_tmp45_, "test_collection.add_all (dummy)");
	_tmp46_ = self->test_collection;
	_tmp47_ = gee_collection_get_size (_tmp46_);
	_tmp48_ = _tmp47_;
	_vala_assert (_tmp48_ == 4, "test_collection.size == 4");
	_tmp49_ = self->test_collection;
	_tmp50_ = gee_collection_contains (_tmp49_, "hello");
	_vala_assert (_tmp50_, "test_collection.contains (\"hello\")");
	_tmp51_ = self->test_collection;
	_tmp52_ = gee_collection_contains (_tmp51_, "hello1");
	_vala_assert (_tmp52_, "test_collection.contains (\"hello1\")");
	_tmp53_ = self->test_collection;
	_tmp54_ = gee_collection_contains (_tmp53_, "hello2");
	_vala_assert (_tmp54_, "test_collection.contains (\"hello2\")");
	_tmp55_ = self->test_collection;
	_tmp56_ = gee_collection_contains (_tmp55_, "hello3");
	_vala_assert (_tmp56_, "test_collection.contains (\"hello3\")");
	_tmp57_ = gee_abstract_collection_get_size ((GeeCollection*) dummy);
	_tmp58_ = _tmp57_;
	_vala_assert (_tmp58_ == 3, "dummy.size == 3");
	_tmp59_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello1");
	_vala_assert (_tmp59_, "dummy.contains (\"hello1\")");
	_tmp60_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello2");
	_vala_assert (_tmp60_, "dummy.contains (\"hello2\")");
	_tmp61_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello3");
	_vala_assert (_tmp61_, "dummy.contains (\"hello3\")");
	_tmp62_ = self->test_collection;
	gee_collection_clear (_tmp62_);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	_tmp63_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello1");
	_vala_assert (_tmp63_, "dummy.add (\"hello1\")");
	_tmp64_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello2");
	_vala_assert (_tmp64_, "dummy.add (\"hello2\")");
	_tmp65_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello3");
	_vala_assert (_tmp65_, "dummy.add (\"hello3\")");
	_tmp66_ = self->test_collection;
	_tmp67_ = gee_collection_add (_tmp66_, "hello1");
	_vala_assert (_tmp67_, "test_collection.add (\"hello1\")");
	_tmp68_ = self->test_collection;
	_tmp69_ = gee_collection_add_all (_tmp68_, (GeeCollection*) dummy);
	_vala_assert (_tmp69_, "test_collection.add_all (dummy)");
	_tmp70_ = self->test_collection;
	_tmp71_ = gee_collection_get_size (_tmp70_);
	_tmp72_ = _tmp71_;
	_vala_assert (_tmp72_ >= 3, "test_collection.size >= 3");
	_tmp73_ = self->test_collection;
	_tmp74_ = gee_collection_contains (_tmp73_, "hello1");
	_vala_assert (_tmp74_, "test_collection.contains (\"hello1\")");
	_tmp75_ = self->test_collection;
	_tmp76_ = gee_collection_contains (_tmp75_, "hello2");
	_vala_assert (_tmp76_, "test_collection.contains (\"hello2\")");
	_tmp77_ = self->test_collection;
	_tmp78_ = gee_collection_contains (_tmp77_, "hello3");
	_vala_assert (_tmp78_, "test_collection.contains (\"hello3\")");
	_tmp79_ = gee_abstract_collection_get_size ((GeeCollection*) dummy);
	_tmp80_ = _tmp79_;
	_vala_assert (_tmp80_ == 3, "dummy.size == 3");
	_tmp81_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello1");
	_vala_assert (_tmp81_, "dummy.contains (\"hello1\")");
	_tmp82_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello2");
	_vala_assert (_tmp82_, "dummy.contains (\"hello2\")");
	_tmp83_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello3");
	_vala_assert (_tmp83_, "dummy.contains (\"hello3\")");
	_g_object_unref0 (dummy);
}


void collection_tests_test_contains_all (CollectionTests* self) {
	GeeCollection* _tmp0_ = NULL;
	GeeArrayList* dummy = NULL;
	GeeArrayList* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	GeeCollection* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	GeeCollection* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	GeeCollection* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	GeeCollection* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	GeeCollection* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
	GeeCollection* _tmp16_ = NULL;
	gboolean _tmp17_ = FALSE;
	GeeCollection* _tmp18_ = NULL;
	gboolean _tmp19_ = FALSE;
	GeeCollection* _tmp20_ = NULL;
	gboolean _tmp21_ = FALSE;
	GeeCollection* _tmp22_ = NULL;
	gboolean _tmp23_ = FALSE;
	GeeCollection* _tmp24_ = NULL;
	gboolean _tmp25_ = FALSE;
	GeeCollection* _tmp26_ = NULL;
	gboolean _tmp27_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->test_collection;
	_vala_assert (_tmp0_ != NULL, "test_collection != null");
	_tmp1_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	dummy = _tmp1_;
	_tmp2_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello1");
	_vala_assert (_tmp2_, "dummy.add (\"hello1\")");
	_tmp3_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello2");
	_vala_assert (_tmp3_, "dummy.add (\"hello2\")");
	_tmp4_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello3");
	_vala_assert (_tmp4_, "dummy.add (\"hello3\")");
	_tmp5_ = self->test_collection;
	_tmp6_ = gee_collection_get_is_empty (_tmp5_);
	_tmp7_ = _tmp6_;
	_vala_assert (_tmp7_, "test_collection.is_empty");
	_tmp8_ = self->test_collection;
	_tmp9_ = gee_collection_contains_all (_tmp8_, (GeeCollection*) dummy);
	_vala_assert (!_tmp9_, "! test_collection.contains_all (dummy)");
	_tmp10_ = self->test_collection;
	_tmp11_ = gee_collection_add (_tmp10_, "hello4");
	_vala_assert (_tmp11_, "test_collection.add (\"hello4\")");
	_tmp12_ = self->test_collection;
	_tmp13_ = gee_collection_add (_tmp12_, "hello5");
	_vala_assert (_tmp13_, "test_collection.add (\"hello5\")");
	_tmp14_ = self->test_collection;
	_tmp15_ = gee_collection_contains_all (_tmp14_, (GeeCollection*) dummy);
	_vala_assert (!_tmp15_, "! test_collection.contains_all (dummy)");
	_tmp16_ = self->test_collection;
	_tmp17_ = gee_collection_add (_tmp16_, "hello1");
	_vala_assert (_tmp17_, "test_collection.add (\"hello1\")");
	_tmp18_ = self->test_collection;
	_tmp19_ = gee_collection_add (_tmp18_, "hello2");
	_vala_assert (_tmp19_, "test_collection.add (\"hello2\")");
	_tmp20_ = self->test_collection;
	_tmp21_ = gee_collection_contains_all (_tmp20_, (GeeCollection*) dummy);
	_vala_assert (!_tmp21_, "! test_collection.contains_all (dummy)");
	_tmp22_ = self->test_collection;
	_tmp23_ = gee_collection_add (_tmp22_, "hello3");
	_vala_assert (_tmp23_, "test_collection.add (\"hello3\")");
	_tmp24_ = self->test_collection;
	_tmp25_ = gee_collection_contains_all (_tmp24_, (GeeCollection*) dummy);
	_vala_assert (_tmp25_, "test_collection.contains_all (dummy)");
	_tmp26_ = self->test_collection;
	_tmp27_ = gee_collection_contains_all ((GeeCollection*) dummy, _tmp26_);
	_vala_assert (!_tmp27_, "! dummy.contains_all (test_collection)");
	_g_object_unref0 (dummy);
}


void collection_tests_test_remove_all (CollectionTests* self) {
	GeeCollection* _tmp0_ = NULL;
	GeeArrayList* dummy = NULL;
	GeeArrayList* _tmp1_ = NULL;
	GeeCollection* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GeeCollection* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	GeeCollection* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	GeeCollection* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	GeeCollection* _tmp17_ = NULL;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp20_ = FALSE;
	GeeCollection* _tmp21_ = NULL;
	gboolean _tmp22_ = FALSE;
	GeeCollection* _tmp23_ = NULL;
	gboolean _tmp24_ = FALSE;
	GeeCollection* _tmp25_ = NULL;
	gboolean _tmp26_ = FALSE;
	GeeCollection* _tmp27_ = NULL;
	gint _tmp28_ = 0;
	gint _tmp29_ = 0;
	gint _tmp30_ = 0;
	gint _tmp31_ = 0;
	GeeCollection* _tmp32_ = NULL;
	gboolean _tmp33_ = FALSE;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp35_ = FALSE;
	GeeCollection* _tmp36_ = NULL;
	gboolean _tmp37_ = FALSE;
	GeeCollection* _tmp38_ = NULL;
	gboolean _tmp39_ = FALSE;
	GeeCollection* _tmp40_ = NULL;
	gboolean _tmp41_ = FALSE;
	GeeCollection* _tmp42_ = NULL;
	gboolean _tmp43_ = FALSE;
	GeeCollection* _tmp44_ = NULL;
	gboolean _tmp45_ = FALSE;
	gboolean _tmp46_ = FALSE;
	gint _tmp47_ = 0;
	gint _tmp48_ = 0;
	GeeCollection* _tmp49_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->test_collection;
	_vala_assert (_tmp0_ != NULL, "test_collection != null");
	_tmp1_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	dummy = _tmp1_;
	_tmp2_ = self->test_collection;
	_tmp3_ = gee_collection_remove_all (_tmp2_, (GeeCollection*) dummy);
	_vala_assert (!_tmp3_, "! test_collection.remove_all (dummy)");
	_tmp4_ = self->test_collection;
	_tmp5_ = gee_collection_get_is_empty (_tmp4_);
	_tmp6_ = _tmp5_;
	_vala_assert (_tmp6_, "test_collection.is_empty");
	_tmp7_ = gee_collection_get_is_empty ((GeeCollection*) dummy);
	_tmp8_ = _tmp7_;
	_vala_assert (_tmp8_, "dummy.is_empty");
	_tmp9_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello1");
	_vala_assert (_tmp9_, "dummy.add (\"hello1\")");
	_tmp10_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello2");
	_vala_assert (_tmp10_, "dummy.add (\"hello2\")");
	_tmp11_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello3");
	_vala_assert (_tmp11_, "dummy.add (\"hello3\")");
	_tmp12_ = self->test_collection;
	_tmp13_ = gee_collection_remove_all (_tmp12_, (GeeCollection*) dummy);
	_vala_assert (!_tmp13_, "! test_collection.remove_all (dummy)");
	_tmp14_ = self->test_collection;
	_tmp15_ = gee_collection_get_is_empty (_tmp14_);
	_tmp16_ = _tmp15_;
	_vala_assert (_tmp16_, "test_collection.is_empty");
	_tmp17_ = self->test_collection;
	gee_collection_clear (_tmp17_);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	_tmp18_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello1");
	_vala_assert (_tmp18_, "dummy.add (\"hello1\")");
	_tmp19_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello2");
	_vala_assert (_tmp19_, "dummy.add (\"hello2\")");
	_tmp20_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello3");
	_vala_assert (_tmp20_, "dummy.add (\"hello3\")");
	_tmp21_ = self->test_collection;
	_tmp22_ = gee_collection_add (_tmp21_, "hello4");
	_vala_assert (_tmp22_, "test_collection.add (\"hello4\")");
	_tmp23_ = self->test_collection;
	_tmp24_ = gee_collection_add (_tmp23_, "hello5");
	_vala_assert (_tmp24_, "test_collection.add (\"hello5\")");
	_tmp25_ = self->test_collection;
	_tmp26_ = gee_collection_remove_all (_tmp25_, (GeeCollection*) dummy);
	_vala_assert (!_tmp26_, "! test_collection.remove_all (dummy)");
	_tmp27_ = self->test_collection;
	_tmp28_ = gee_collection_get_size (_tmp27_);
	_tmp29_ = _tmp28_;
	_vala_assert (_tmp29_ == 2, "test_collection.size == 2");
	_tmp30_ = gee_abstract_collection_get_size ((GeeCollection*) dummy);
	_tmp31_ = _tmp30_;
	_vala_assert (_tmp31_ == 3, "dummy.size == 3");
	_tmp32_ = self->test_collection;
	gee_collection_clear (_tmp32_);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	_tmp33_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello1");
	_vala_assert (_tmp33_, "dummy.add (\"hello1\")");
	_tmp34_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello2");
	_vala_assert (_tmp34_, "dummy.add (\"hello2\")");
	_tmp35_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello3");
	_vala_assert (_tmp35_, "dummy.add (\"hello3\")");
	_tmp36_ = self->test_collection;
	_tmp37_ = gee_collection_add (_tmp36_, "hello1");
	_vala_assert (_tmp37_, "test_collection.add (\"hello1\")");
	_tmp38_ = self->test_collection;
	_tmp39_ = gee_collection_add (_tmp38_, "hello2");
	_vala_assert (_tmp39_, "test_collection.add (\"hello2\")");
	_tmp40_ = self->test_collection;
	_tmp41_ = gee_collection_add (_tmp40_, "hello3");
	_vala_assert (_tmp41_, "test_collection.add (\"hello3\")");
	_tmp42_ = self->test_collection;
	_tmp43_ = gee_collection_remove_all (_tmp42_, (GeeCollection*) dummy);
	_vala_assert (_tmp43_, "test_collection.remove_all (dummy)");
	_tmp44_ = self->test_collection;
	_tmp45_ = gee_collection_get_is_empty (_tmp44_);
	_tmp46_ = _tmp45_;
	_vala_assert (_tmp46_, "test_collection.is_empty");
	_tmp47_ = gee_abstract_collection_get_size ((GeeCollection*) dummy);
	_tmp48_ = _tmp47_;
	_vala_assert (_tmp48_ == 3, "dummy.size == 3");
	_tmp49_ = self->test_collection;
	gee_collection_clear (_tmp49_);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	_g_object_unref0 (dummy);
}


void collection_tests_test_retain_all (CollectionTests* self) {
	GeeCollection* _tmp0_ = NULL;
	GeeArrayList* dummy = NULL;
	GeeArrayList* _tmp1_ = NULL;
	GeeCollection* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GeeCollection* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	GeeCollection* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	GeeCollection* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	GeeCollection* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
	GeeCollection* _tmp15_ = NULL;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	GeeCollection* _tmp20_ = NULL;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp22_ = FALSE;
	gboolean _tmp23_ = FALSE;
	GeeCollection* _tmp24_ = NULL;
	gboolean _tmp25_ = FALSE;
	GeeCollection* _tmp26_ = NULL;
	gboolean _tmp27_ = FALSE;
	gboolean _tmp28_ = FALSE;
	gint _tmp29_ = 0;
	gint _tmp30_ = 0;
	gboolean _tmp31_ = FALSE;
	gboolean _tmp32_ = FALSE;
	gboolean _tmp33_ = FALSE;
	GeeCollection* _tmp34_ = NULL;
	gboolean _tmp35_ = FALSE;
	gboolean _tmp36_ = FALSE;
	gboolean _tmp37_ = FALSE;
	GeeCollection* _tmp38_ = NULL;
	gboolean _tmp39_ = FALSE;
	GeeCollection* _tmp40_ = NULL;
	gboolean _tmp41_ = FALSE;
	GeeCollection* _tmp42_ = NULL;
	gboolean _tmp43_ = FALSE;
	GeeCollection* _tmp44_ = NULL;
	gboolean _tmp45_ = FALSE;
	gboolean _tmp46_ = FALSE;
	gint _tmp47_ = 0;
	gint _tmp48_ = 0;
	gboolean _tmp49_ = FALSE;
	gboolean _tmp50_ = FALSE;
	gboolean _tmp51_ = FALSE;
	GeeCollection* _tmp52_ = NULL;
	gboolean _tmp53_ = FALSE;
	gboolean _tmp54_ = FALSE;
	gboolean _tmp55_ = FALSE;
	GeeCollection* _tmp56_ = NULL;
	gboolean _tmp57_ = FALSE;
	GeeCollection* _tmp58_ = NULL;
	gboolean _tmp59_ = FALSE;
	GeeCollection* _tmp60_ = NULL;
	gboolean _tmp61_ = FALSE;
	GeeCollection* _tmp62_ = NULL;
	gboolean _tmp63_ = FALSE;
	GeeCollection* _tmp64_ = NULL;
	gint _tmp65_ = 0;
	gint _tmp66_ = 0;
	GeeCollection* _tmp67_ = NULL;
	gboolean _tmp68_ = FALSE;
	GeeCollection* _tmp69_ = NULL;
	gboolean _tmp70_ = FALSE;
	GeeCollection* _tmp71_ = NULL;
	gboolean _tmp72_ = FALSE;
	gint _tmp73_ = 0;
	gint _tmp74_ = 0;
	gboolean _tmp75_ = FALSE;
	gboolean _tmp76_ = FALSE;
	gboolean _tmp77_ = FALSE;
	GeeCollection* _tmp78_ = NULL;
	gboolean _tmp79_ = FALSE;
	gboolean _tmp80_ = FALSE;
	gboolean _tmp81_ = FALSE;
	GeeCollection* _tmp82_ = NULL;
	gboolean _tmp83_ = FALSE;
	GeeCollection* _tmp84_ = NULL;
	gboolean _tmp85_ = FALSE;
	GeeCollection* _tmp86_ = NULL;
	gboolean _tmp87_ = FALSE;
	GeeCollection* _tmp88_ = NULL;
	gboolean _tmp89_ = FALSE;
	GeeCollection* _tmp90_ = NULL;
	gint _tmp91_ = 0;
	gint _tmp92_ = 0;
	GeeCollection* _tmp93_ = NULL;
	gboolean _tmp94_ = FALSE;
	GeeCollection* _tmp95_ = NULL;
	gboolean _tmp96_ = FALSE;
	gint _tmp97_ = 0;
	gint _tmp98_ = 0;
	gboolean _tmp99_ = FALSE;
	gboolean _tmp100_ = FALSE;
	gboolean _tmp101_ = FALSE;
	GeeCollection* _tmp102_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->test_collection;
	_vala_assert (_tmp0_ != NULL, "test_collection != null");
	_tmp1_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	dummy = _tmp1_;
	_tmp2_ = self->test_collection;
	_tmp3_ = gee_collection_retain_all (_tmp2_, (GeeCollection*) dummy);
	_vala_assert (!_tmp3_, "! test_collection.retain_all (dummy)");
	_tmp4_ = self->test_collection;
	_tmp5_ = gee_collection_get_is_empty (_tmp4_);
	_tmp6_ = _tmp5_;
	_vala_assert (_tmp6_, "test_collection.is_empty");
	_tmp7_ = gee_collection_get_is_empty ((GeeCollection*) dummy);
	_tmp8_ = _tmp7_;
	_vala_assert (_tmp8_, "dummy.is_empty");
	_tmp9_ = self->test_collection;
	_tmp10_ = gee_collection_add (_tmp9_, "hello1");
	_vala_assert (_tmp10_, "test_collection.add (\"hello1\")");
	_tmp11_ = self->test_collection;
	_tmp12_ = gee_collection_add (_tmp11_, "hello2");
	_vala_assert (_tmp12_, "test_collection.add (\"hello2\")");
	_tmp13_ = self->test_collection;
	_tmp14_ = gee_collection_retain_all (_tmp13_, (GeeCollection*) dummy);
	_vala_assert (_tmp14_, "test_collection.retain_all (dummy)");
	_tmp15_ = self->test_collection;
	_tmp16_ = gee_collection_get_is_empty (_tmp15_);
	_tmp17_ = _tmp16_;
	_vala_assert (_tmp17_, "test_collection.is_empty");
	_tmp18_ = gee_collection_get_is_empty ((GeeCollection*) dummy);
	_tmp19_ = _tmp18_;
	_vala_assert (_tmp19_, "dummy.is_empty");
	_tmp20_ = self->test_collection;
	gee_collection_clear (_tmp20_);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	_tmp21_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello1");
	_vala_assert (_tmp21_, "dummy.add (\"hello1\")");
	_tmp22_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello2");
	_vala_assert (_tmp22_, "dummy.add (\"hello2\")");
	_tmp23_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello3");
	_vala_assert (_tmp23_, "dummy.add (\"hello3\")");
	_tmp24_ = self->test_collection;
	_tmp25_ = gee_collection_retain_all (_tmp24_, (GeeCollection*) dummy);
	_vala_assert (!_tmp25_, "! test_collection.retain_all (dummy)");
	_tmp26_ = self->test_collection;
	_tmp27_ = gee_collection_get_is_empty (_tmp26_);
	_tmp28_ = _tmp27_;
	_vala_assert (_tmp28_, "test_collection.is_empty");
	_tmp29_ = gee_abstract_collection_get_size ((GeeCollection*) dummy);
	_tmp30_ = _tmp29_;
	_vala_assert (_tmp30_ == 3, "dummy.size == 3");
	_tmp31_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello1");
	_vala_assert (_tmp31_, "dummy.contains (\"hello1\")");
	_tmp32_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello2");
	_vala_assert (_tmp32_, "dummy.contains (\"hello2\")");
	_tmp33_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello3");
	_vala_assert (_tmp33_, "dummy.contains (\"hello3\")");
	_tmp34_ = self->test_collection;
	gee_collection_clear (_tmp34_);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	_tmp35_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello1");
	_vala_assert (_tmp35_, "dummy.add (\"hello1\")");
	_tmp36_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello2");
	_vala_assert (_tmp36_, "dummy.add (\"hello2\")");
	_tmp37_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello3");
	_vala_assert (_tmp37_, "dummy.add (\"hello3\")");
	_tmp38_ = self->test_collection;
	_tmp39_ = gee_collection_add (_tmp38_, "hello4");
	_vala_assert (_tmp39_, "test_collection.add (\"hello4\")");
	_tmp40_ = self->test_collection;
	_tmp41_ = gee_collection_add (_tmp40_, "hello5");
	_vala_assert (_tmp41_, "test_collection.add (\"hello5\")");
	_tmp42_ = self->test_collection;
	_tmp43_ = gee_collection_retain_all (_tmp42_, (GeeCollection*) dummy);
	_vala_assert (_tmp43_, "test_collection.retain_all (dummy)");
	_tmp44_ = self->test_collection;
	_tmp45_ = gee_collection_get_is_empty (_tmp44_);
	_tmp46_ = _tmp45_;
	_vala_assert (_tmp46_, "test_collection.is_empty");
	_tmp47_ = gee_abstract_collection_get_size ((GeeCollection*) dummy);
	_tmp48_ = _tmp47_;
	_vala_assert (_tmp48_ == 3, "dummy.size == 3");
	_tmp49_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello1");
	_vala_assert (_tmp49_, "dummy.contains (\"hello1\")");
	_tmp50_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello2");
	_vala_assert (_tmp50_, "dummy.contains (\"hello2\")");
	_tmp51_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello3");
	_vala_assert (_tmp51_, "dummy.contains (\"hello3\")");
	_tmp52_ = self->test_collection;
	gee_collection_clear (_tmp52_);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	_tmp53_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello1");
	_vala_assert (_tmp53_, "dummy.add (\"hello1\")");
	_tmp54_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello2");
	_vala_assert (_tmp54_, "dummy.add (\"hello2\")");
	_tmp55_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello3");
	_vala_assert (_tmp55_, "dummy.add (\"hello3\")");
	_tmp56_ = self->test_collection;
	_tmp57_ = gee_collection_add (_tmp56_, "hello1");
	_vala_assert (_tmp57_, "test_collection.add (\"hello1\")");
	_tmp58_ = self->test_collection;
	_tmp59_ = gee_collection_add (_tmp58_, "hello2");
	_vala_assert (_tmp59_, "test_collection.add (\"hello2\")");
	_tmp60_ = self->test_collection;
	_tmp61_ = gee_collection_add (_tmp60_, "hello3");
	_vala_assert (_tmp61_, "test_collection.add (\"hello3\")");
	_tmp62_ = self->test_collection;
	_tmp63_ = gee_collection_retain_all (_tmp62_, (GeeCollection*) dummy);
	_vala_assert (!_tmp63_, "! test_collection.retain_all (dummy)");
	_tmp64_ = self->test_collection;
	_tmp65_ = gee_collection_get_size (_tmp64_);
	_tmp66_ = _tmp65_;
	_vala_assert (_tmp66_ == 3, "test_collection.size == 3");
	_tmp67_ = self->test_collection;
	_tmp68_ = gee_collection_contains (_tmp67_, "hello1");
	_vala_assert (_tmp68_, "test_collection.contains (\"hello1\")");
	_tmp69_ = self->test_collection;
	_tmp70_ = gee_collection_contains (_tmp69_, "hello2");
	_vala_assert (_tmp70_, "test_collection.contains (\"hello2\")");
	_tmp71_ = self->test_collection;
	_tmp72_ = gee_collection_contains (_tmp71_, "hello3");
	_vala_assert (_tmp72_, "test_collection.contains (\"hello3\")");
	_tmp73_ = gee_abstract_collection_get_size ((GeeCollection*) dummy);
	_tmp74_ = _tmp73_;
	_vala_assert (_tmp74_ == 3, "dummy.size == 3");
	_tmp75_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello1");
	_vala_assert (_tmp75_, "dummy.contains (\"hello1\")");
	_tmp76_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello2");
	_vala_assert (_tmp76_, "dummy.contains (\"hello2\")");
	_tmp77_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello3");
	_vala_assert (_tmp77_, "dummy.contains (\"hello3\")");
	_tmp78_ = self->test_collection;
	gee_collection_clear (_tmp78_);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	_tmp79_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello1");
	_vala_assert (_tmp79_, "dummy.add (\"hello1\")");
	_tmp80_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello2");
	_vala_assert (_tmp80_, "dummy.add (\"hello2\")");
	_tmp81_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello3");
	_vala_assert (_tmp81_, "dummy.add (\"hello3\")");
	_tmp82_ = self->test_collection;
	_tmp83_ = gee_collection_add (_tmp82_, "hello2");
	_vala_assert (_tmp83_, "test_collection.add (\"hello2\")");
	_tmp84_ = self->test_collection;
	_tmp85_ = gee_collection_add (_tmp84_, "hello3");
	_vala_assert (_tmp85_, "test_collection.add (\"hello3\")");
	_tmp86_ = self->test_collection;
	_tmp87_ = gee_collection_add (_tmp86_, "hello4");
	_vala_assert (_tmp87_, "test_collection.add (\"hello4\")");
	_tmp88_ = self->test_collection;
	_tmp89_ = gee_collection_retain_all (_tmp88_, (GeeCollection*) dummy);
	_vala_assert (_tmp89_, "test_collection.retain_all (dummy)");
	_tmp90_ = self->test_collection;
	_tmp91_ = gee_collection_get_size (_tmp90_);
	_tmp92_ = _tmp91_;
	_vala_assert (_tmp92_ == 2, "test_collection.size == 2");
	_tmp93_ = self->test_collection;
	_tmp94_ = gee_collection_contains (_tmp93_, "hello2");
	_vala_assert (_tmp94_, "test_collection.contains (\"hello2\")");
	_tmp95_ = self->test_collection;
	_tmp96_ = gee_collection_contains (_tmp95_, "hello3");
	_vala_assert (_tmp96_, "test_collection.contains (\"hello3\")");
	_tmp97_ = gee_abstract_collection_get_size ((GeeCollection*) dummy);
	_tmp98_ = _tmp97_;
	_vala_assert (_tmp98_ == 3, "dummy.size == 3");
	_tmp99_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello1");
	_vala_assert (_tmp99_, "dummy.contains (\"hello1\")");
	_tmp100_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello2");
	_vala_assert (_tmp100_, "dummy.contains (\"hello2\")");
	_tmp101_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello3");
	_vala_assert (_tmp101_, "dummy.contains (\"hello3\")");
	_tmp102_ = self->test_collection;
	gee_collection_clear (_tmp102_);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	_g_object_unref0 (dummy);
}


void collection_tests_test_to_array (CollectionTests* self) {
	GeeCollection* _tmp0_ = NULL;
	GeeCollection* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	GeeCollection* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	GeeCollection* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	GeeCollection* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	gchar** array = NULL;
	GeeCollection* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gpointer* _tmp12_ = NULL;
	gint array_length1 = 0;
	gint _array_size_ = 0;
	gint index = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->test_collection;
	_vala_assert (_tmp0_ != NULL, "test_collection != null");
	_tmp1_ = self->test_collection;
	_tmp2_ = gee_collection_get_is_empty (_tmp1_);
	_tmp3_ = _tmp2_;
	_vala_assert (_tmp3_, "test_collection.is_empty");
	_tmp4_ = self->test_collection;
	_tmp5_ = gee_collection_add (_tmp4_, "hello1");
	_vala_assert (_tmp5_, "test_collection.add (\"hello1\")");
	_tmp6_ = self->test_collection;
	_tmp7_ = gee_collection_add (_tmp6_, "hello2");
	_vala_assert (_tmp7_, "test_collection.add (\"hello2\")");
	_tmp8_ = self->test_collection;
	_tmp9_ = gee_collection_add (_tmp8_, "hello3");
	_vala_assert (_tmp9_, "test_collection.add (\"hello3\")");
	_tmp10_ = self->test_collection;
	_tmp12_ = gee_collection_to_array (_tmp10_, &_tmp11_);
	array = (gchar**) _tmp12_;
	array_length1 = (_tmp11_ * sizeof (gchar*)) / sizeof (gchar*);
	_array_size_ = array_length1;
	index = 0;
	{
		GeeIterator* _element_it = NULL;
		GeeCollection* _tmp13_ = NULL;
		GeeIterator* _tmp14_ = NULL;
		_tmp13_ = self->test_collection;
		_tmp14_ = gee_iterable_iterator ((GeeIterable*) _tmp13_);
		_element_it = _tmp14_;
		while (TRUE) {
			GeeIterator* _tmp15_ = NULL;
			gboolean _tmp16_ = FALSE;
			gchar* element = NULL;
			GeeIterator* _tmp17_ = NULL;
			gpointer _tmp18_ = NULL;
			const gchar* _tmp19_ = NULL;
			gchar** _tmp20_ = NULL;
			gint _tmp20__length1 = 0;
			gint _tmp21_ = 0;
			const gchar* _tmp22_ = NULL;
			_tmp15_ = _element_it;
			_tmp16_ = gee_iterator_next (_tmp15_);
			if (!_tmp16_) {
				break;
			}
			_tmp17_ = _element_it;
			_tmp18_ = gee_iterator_get (_tmp17_);
			element = (gchar*) _tmp18_;
			_tmp19_ = element;
			_tmp20_ = array;
			_tmp20__length1 = array_length1;
			_tmp21_ = index;
			index = _tmp21_ + 1;
			_tmp22_ = _tmp20_[_tmp21_];
			_vala_assert (g_strcmp0 (_tmp19_, _tmp22_) == 0, "element == array[index++]");
			_g_free0 (element);
		}
		_g_object_unref0 (_element_it);
	}
	array = (_vala_array_free (array, array_length1, (GDestroyNotify) g_free), NULL);
}


void collection_tests_test_gobject_properties (CollectionTests* self) {
	GeeCollection* _tmp0_ = NULL;
	GValue value = {0};
	GValue _tmp1_ = {0};
	GValue _tmp2_ = {0};
	GeeCollection* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	GeeCollection* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->test_collection;
	_vala_assert (_tmp0_ != NULL, "test_collection != null");
	g_value_init (&_tmp1_, G_TYPE_INT);
	G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
	value = _tmp1_;
	_tmp2_ = value;
	_tmp3_ = self->test_collection;
	g_object_get_property ((GObject*) _tmp3_, "size", &value);
	_tmp4_ = g_value_get_int (&value);
	_tmp5_ = self->test_collection;
	_tmp6_ = gee_collection_get_size (_tmp5_);
	_tmp7_ = _tmp6_;
	_vala_assert (_tmp4_ == _tmp7_, "value.get_int () == test_collection.size");
	g_value_unset (&value);
	G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
}


static gint __lambda2_ (CollectionTests* self, gchar* x, gint y) {
	gint result = 0;
	gint _tmp0_ = 0;
	g_return_val_if_fail (x != NULL, 0);
	_tmp0_ = y;
	result = _tmp0_ + 1;
	_g_free0 (x);
	return result;
}


static gpointer ___lambda2__gee_fold_func (gpointer g, gpointer a, gpointer self) {
	gpointer result;
	result = __lambda2_ (self, g, a);
	return result;
}


static gint __lambda3_ (CollectionTests* self, gchar* x, gint y) {
	gint result = 0;
	gint _tmp0_ = 0;
	g_return_val_if_fail (x != NULL, 0);
	_tmp0_ = y;
	result = _tmp0_ + 1;
	_g_free0 (x);
	return result;
}


static gpointer ___lambda3__gee_fold_func (gpointer g, gpointer a, gpointer self) {
	gpointer result;
	result = __lambda3_ (self, g, a);
	return result;
}


static gint __lambda4_ (CollectionTests* self, gchar* x, gint y) {
	gint result = 0;
	gint _tmp0_ = 0;
	g_return_val_if_fail (x != NULL, 0);
	_tmp0_ = y;
	result = _tmp0_ + 1;
	_g_free0 (x);
	return result;
}


static gpointer ___lambda4__gee_fold_func (gpointer g, gpointer a, gpointer self) {
	gpointer result;
	result = __lambda4_ (self, g, a);
	return result;
}


void collection_tests_test_fold (CollectionTests* self) {
	GeeCollection* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GeeCollection* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GeeCollection* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gint count = 0;
	GeeCollection* _tmp6_ = NULL;
	gpointer _tmp7_ = NULL;
	gint _tmp8_ = 0;
	GeeCollection* _tmp9_ = NULL;
	GeeIterator* _tmp10_ = NULL;
	GeeIterator* _tmp11_ = NULL;
	gpointer _tmp12_ = NULL;
	gint _tmp13_ = 0;
	GeeIterator* iter = NULL;
	GeeCollection* _tmp14_ = NULL;
	GeeIterator* _tmp15_ = NULL;
	gboolean _tmp16_ = FALSE;
	gpointer _tmp17_ = NULL;
	gint _tmp18_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->test_collection;
	_tmp1_ = gee_collection_add (_tmp0_, "one");
	_vala_assert (_tmp1_, "test_collection.add (\"one\")");
	_tmp2_ = self->test_collection;
	_tmp3_ = gee_collection_add (_tmp2_, "two");
	_vala_assert (_tmp3_, "test_collection.add (\"two\")");
	_tmp4_ = self->test_collection;
	_tmp5_ = gee_collection_add (_tmp4_, "three");
	_vala_assert (_tmp5_, "test_collection.add (\"three\")");
	_tmp6_ = self->test_collection;
	_tmp7_ = gee_traversable_fold ((GeeTraversable*) _tmp6_, G_TYPE_INT, NULL, NULL, ___lambda2__gee_fold_func, self, (gpointer) ((gintptr) 0));
	count = (gint) ((gintptr) _tmp7_);
	_tmp8_ = count;
	_vala_assert (_tmp8_ == 3, "count == 3");
	_tmp9_ = self->test_collection;
	_tmp10_ = gee_iterable_iterator ((GeeIterable*) _tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = gee_traversable_fold ((GeeTraversable*) _tmp11_, G_TYPE_INT, NULL, NULL, ___lambda3__gee_fold_func, self, (gpointer) ((gintptr) 0));
	count = (gint) ((gintptr) _tmp12_);
	_g_object_unref0 (_tmp11_);
	_tmp13_ = count;
	_vala_assert (_tmp13_ == 3, "count == 3");
	_tmp14_ = self->test_collection;
	_tmp15_ = gee_iterable_iterator ((GeeIterable*) _tmp14_);
	iter = _tmp15_;
	_tmp16_ = gee_iterator_next (iter);
	_vala_assert (_tmp16_, "iter.next ()");
	_tmp17_ = gee_traversable_fold ((GeeTraversable*) iter, G_TYPE_INT, NULL, NULL, ___lambda4__gee_fold_func, self, (gpointer) ((gintptr) 0));
	count = (gint) ((gintptr) _tmp17_);
	_tmp18_ = count;
	_vala_assert (_tmp18_ == 3, "count == 3");
	_g_object_unref0 (iter);
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		CollectionTests * self;
		self = _data1_->self;
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static gboolean __lambda5_ (Block1Data* _data1_, gchar* x) {
	CollectionTests * self;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	self = _data1_->self;
	g_return_val_if_fail (x != NULL, FALSE);
	_tmp0_ = _data1_->count;
	_data1_->count = _tmp0_ + 1;
	result = TRUE;
	_g_free0 (x);
	return result;
}


static gboolean ___lambda5__gee_forall_func (gpointer g, gpointer self) {
	gboolean result;
	result = __lambda5_ (self, g);
	return result;
}


static gboolean __lambda6_ (Block1Data* _data1_, gchar* x) {
	CollectionTests * self;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	self = _data1_->self;
	g_return_val_if_fail (x != NULL, FALSE);
	_tmp0_ = _data1_->count;
	_data1_->count = _tmp0_ + 1;
	result = TRUE;
	_g_free0 (x);
	return result;
}


static gboolean ___lambda6__gee_forall_func (gpointer g, gpointer self) {
	gboolean result;
	result = __lambda6_ (self, g);
	return result;
}


static gboolean __lambda7_ (Block1Data* _data1_, gchar* x) {
	CollectionTests * self;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	self = _data1_->self;
	g_return_val_if_fail (x != NULL, FALSE);
	_tmp0_ = _data1_->count;
	_data1_->count = _tmp0_ + 1;
	result = TRUE;
	_g_free0 (x);
	return result;
}


static gboolean ___lambda7__gee_forall_func (gpointer g, gpointer self) {
	gboolean result;
	result = __lambda7_ (self, g);
	return result;
}


static gboolean __lambda8_ (Block1Data* _data1_, gchar* x) {
	CollectionTests * self;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	self = _data1_->self;
	g_return_val_if_fail (x != NULL, FALSE);
	_tmp0_ = _data1_->count;
	_data1_->count = _tmp0_ + 1;
	result = FALSE;
	_g_free0 (x);
	return result;
}


static gboolean ___lambda8__gee_forall_func (gpointer g, gpointer self) {
	gboolean result;
	result = __lambda8_ (self, g);
	return result;
}


void collection_tests_test_foreach (CollectionTests* self) {
	Block1Data* _data1_;
	GeeCollection* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GeeCollection* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GeeCollection* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean res = FALSE;
	GeeCollection* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	GeeCollection* _tmp9_ = NULL;
	GeeIterator* _tmp10_ = NULL;
	GeeIterator* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	GeeIterator* iter = NULL;
	GeeCollection* _tmp14_ = NULL;
	GeeIterator* _tmp15_ = NULL;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	GeeCollection* _tmp19_ = NULL;
	gboolean _tmp20_ = FALSE;
	gboolean _tmp21_ = FALSE;
	g_return_if_fail (self != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = self->test_collection;
	_tmp1_ = gee_collection_add (_tmp0_, "one");
	_vala_assert (_tmp1_, "test_collection.add (\"one\")");
	_tmp2_ = self->test_collection;
	_tmp3_ = gee_collection_add (_tmp2_, "two");
	_vala_assert (_tmp3_, "test_collection.add (\"two\")");
	_tmp4_ = self->test_collection;
	_tmp5_ = gee_collection_add (_tmp4_, "three");
	_vala_assert (_tmp5_, "test_collection.add (\"three\")");
	_data1_->count = 0;
	_tmp6_ = self->test_collection;
	_tmp7_ = gee_traversable_foreach ((GeeTraversable*) _tmp6_, ___lambda5__gee_forall_func, _data1_);
	res = _tmp7_;
	_vala_assert (_data1_->count == 3, "count == 3");
	_tmp8_ = res;
	_vala_assert (_tmp8_ == TRUE, "res == true");
	_tmp9_ = self->test_collection;
	_tmp10_ = gee_iterable_iterator ((GeeIterable*) _tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = gee_traversable_foreach ((GeeTraversable*) _tmp11_, ___lambda6__gee_forall_func, _data1_);
	res = _tmp12_;
	_g_object_unref0 (_tmp11_);
	_vala_assert (_data1_->count == 6, "count == 6");
	_tmp13_ = res;
	_vala_assert (_tmp13_ == TRUE, "res == true");
	_tmp14_ = self->test_collection;
	_tmp15_ = gee_iterable_iterator ((GeeIterable*) _tmp14_);
	iter = _tmp15_;
	_tmp16_ = gee_iterator_next (iter);
	_vala_assert (_tmp16_, "iter.next ()");
	_tmp17_ = gee_traversable_foreach ((GeeTraversable*) iter, ___lambda7__gee_forall_func, _data1_);
	res = _tmp17_;
	_vala_assert (_data1_->count == 9, "count == 9");
	_tmp18_ = res;
	_vala_assert (_tmp18_ == TRUE, "res == true");
	_tmp19_ = self->test_collection;
	_tmp20_ = gee_traversable_foreach ((GeeTraversable*) _tmp19_, ___lambda8__gee_forall_func, _data1_);
	res = _tmp20_;
	_vala_assert (_data1_->count == 10, "count == 10");
	_tmp21_ = res;
	_vala_assert (_tmp21_ == FALSE, "res == false");
	_g_object_unref0 (iter);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		CollectionTests * self;
		self = _data2_->self;
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}


static gint __lambda9_ (Block2Data* _data2_, gchar* str) {
	CollectionTests * self;
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	gint _tmp6_ = 0;
	self = _data2_->self;
	g_return_val_if_fail (str != NULL, 0);
	_tmp0_ = str;
	if (g_strcmp0 (_tmp0_, "one") == 0) {
		gboolean _tmp1_ = FALSE;
		_tmp1_ = _data2_->one;
		_vala_assert (!_tmp1_, "!one");
		_data2_->one = TRUE;
	} else {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = str;
		if (g_strcmp0 (_tmp2_, "two") == 0) {
			gboolean _tmp3_ = FALSE;
			_tmp3_ = _data2_->two;
			_vala_assert (!_tmp3_, "!two");
			_data2_->two = TRUE;
		} else {
			const gchar* _tmp4_ = NULL;
			_tmp4_ = str;
			if (g_strcmp0 (_tmp4_, "three") == 0) {
				gboolean _tmp5_ = FALSE;
				_tmp5_ = _data2_->three;
				_vala_assert (!_tmp5_, "!three");
				_data2_->three = TRUE;
			} else {
				g_assert_not_reached ();
			}
		}
	}
	_tmp6_ = _data2_->i;
	_data2_->i = _tmp6_ + 1;
	result = _tmp6_;
	_g_free0 (str);
	return result;
}


static gpointer ___lambda9__gee_map_func (gpointer g, gpointer self) {
	gpointer result;
	result = __lambda9_ (self, g);
	return result;
}


static gint __lambda10_ (Block2Data* _data2_, gchar* str) {
	CollectionTests * self;
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	gint _tmp6_ = 0;
	self = _data2_->self;
	g_return_val_if_fail (str != NULL, 0);
	_tmp0_ = str;
	if (g_strcmp0 (_tmp0_, "one") == 0) {
		gboolean _tmp1_ = FALSE;
		_tmp1_ = _data2_->one;
		_vala_assert (!_tmp1_, "!one");
		_data2_->one = TRUE;
	} else {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = str;
		if (g_strcmp0 (_tmp2_, "two") == 0) {
			gboolean _tmp3_ = FALSE;
			_tmp3_ = _data2_->two;
			_vala_assert (!_tmp3_, "!two");
			_data2_->two = TRUE;
		} else {
			const gchar* _tmp4_ = NULL;
			_tmp4_ = str;
			if (g_strcmp0 (_tmp4_, "three") == 0) {
				gboolean _tmp5_ = FALSE;
				_tmp5_ = _data2_->three;
				_vala_assert (!_tmp5_, "!three");
				_data2_->three = TRUE;
			} else {
				g_assert_not_reached ();
			}
		}
	}
	_tmp6_ = _data2_->i;
	_data2_->i = _tmp6_ + 1;
	result = _tmp6_;
	_g_free0 (str);
	return result;
}


static gpointer ___lambda10__gee_map_func (gpointer g, gpointer self) {
	gpointer result;
	result = __lambda10_ (self, g);
	return result;
}


void collection_tests_test_map (CollectionTests* self) {
	Block2Data* _data2_;
	GeeCollection* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GeeCollection* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GeeCollection* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	GeeIterator* iter = NULL;
	GeeCollection* _tmp6_ = NULL;
	GeeIterator* _tmp7_ = NULL;
	GeeIterator* _tmp8_ = NULL;
	GeeIterator* _tmp9_ = NULL;
	GeeIterator* _tmp10_ = NULL;
	gint j = 0;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	gint _tmp26_ = 0;
	GeeCollection* _tmp27_ = NULL;
	gint _tmp28_ = 0;
	gint _tmp29_ = 0;
	gboolean _tmp30_ = FALSE;
	gboolean _tmp31_ = FALSE;
	gboolean _tmp32_ = FALSE;
	gboolean _tmp33_ = FALSE;
	gboolean _tmp34_ = FALSE;
	gint _tmp35_ = 0;
	GeeCollection* _tmp36_ = NULL;
	GeeIterator* _tmp37_ = NULL;
	gint _tmp51_ = 0;
	gint _tmp52_ = 0;
	gint _tmp53_ = 0;
	GeeCollection* _tmp54_ = NULL;
	gint _tmp55_ = 0;
	gint _tmp56_ = 0;
	gboolean _tmp57_ = FALSE;
	gboolean _tmp58_ = FALSE;
	gboolean _tmp59_ = FALSE;
	g_return_if_fail (self != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = self->test_collection;
	_tmp1_ = gee_collection_add (_tmp0_, "one");
	_vala_assert (_tmp1_, "test_collection.add (\"one\")");
	_tmp2_ = self->test_collection;
	_tmp3_ = gee_collection_add (_tmp2_, "two");
	_vala_assert (_tmp3_, "test_collection.add (\"two\")");
	_tmp4_ = self->test_collection;
	_tmp5_ = gee_collection_add (_tmp4_, "three");
	_vala_assert (_tmp5_, "test_collection.add (\"three\")");
	_data2_->one = FALSE;
	_data2_->two = FALSE;
	_data2_->three = FALSE;
	_data2_->i = 0;
	_tmp6_ = self->test_collection;
	_tmp7_ = gee_iterable_iterator ((GeeIterable*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = gee_traversable_map ((GeeTraversable*) _tmp8_, G_TYPE_INT, NULL, NULL, ___lambda9__gee_map_func, _data2_);
	_tmp10_ = _tmp9_;
	_g_object_unref0 (_tmp8_);
	iter = _tmp10_;
	j = 0;
	while (TRUE) {
		GeeIterator* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		GeeIterator* _tmp16_ = NULL;
		gpointer _tmp17_ = NULL;
		gint _tmp18_ = 0;
		GeeIterator* _tmp19_ = NULL;
		gpointer _tmp20_ = NULL;
		gint _tmp21_ = 0;
		gint _tmp22_ = 0;
		gint _tmp23_ = 0;
		_tmp11_ = iter;
		_tmp12_ = gee_iterator_next (_tmp11_);
		if (!_tmp12_) {
			break;
		}
		_tmp13_ = _data2_->i;
		_tmp14_ = j;
		_vala_assert (_tmp13_ == _tmp14_, "i == j");
		_tmp15_ = j;
		_tmp16_ = iter;
		_tmp17_ = gee_iterator_get (_tmp16_);
		_vala_assert (_tmp15_ == ((gint) ((gintptr) _tmp17_)), "j == iter.get ()");
		_tmp18_ = j;
		_tmp19_ = iter;
		_tmp20_ = gee_iterator_get (_tmp19_);
		_vala_assert (_tmp18_ == ((gint) ((gintptr) _tmp20_)), "j == iter.get ()");
		_tmp21_ = j;
		j = _tmp21_ + 1;
		_tmp22_ = _data2_->i;
		_tmp23_ = j;
		_vala_assert (_tmp22_ == _tmp23_, "i == j");
	}
	_tmp24_ = _data2_->i;
	_tmp25_ = j;
	_vala_assert (_tmp24_ == _tmp25_, "i == j");
	_tmp26_ = _data2_->i;
	_tmp27_ = self->test_collection;
	_tmp28_ = gee_collection_get_size (_tmp27_);
	_tmp29_ = _tmp28_;
	_vala_assert (_tmp26_ == _tmp29_, "i == test_collection.size");
	_tmp30_ = _data2_->one;
	_vala_assert (_tmp30_, "one");
	_tmp31_ = _data2_->two;
	_vala_assert (_tmp31_, "two");
	_tmp32_ = _data2_->three;
	_vala_assert (_tmp32_, "three");
	_data2_->three = FALSE;
	_tmp33_ = _data2_->three;
	_data2_->two = _tmp33_;
	_tmp34_ = _data2_->two;
	_data2_->one = _tmp34_;
	j = 0;
	_tmp35_ = j;
	_data2_->i = _tmp35_;
	_tmp36_ = self->test_collection;
	_tmp37_ = gee_traversable_map ((GeeTraversable*) _tmp36_, G_TYPE_INT, NULL, NULL, ___lambda10__gee_map_func, _data2_);
	_g_object_unref0 (iter);
	iter = _tmp37_;
	while (TRUE) {
		GeeIterator* _tmp38_ = NULL;
		gboolean _tmp39_ = FALSE;
		gint _tmp40_ = 0;
		gint _tmp41_ = 0;
		gint _tmp42_ = 0;
		GeeIterator* _tmp43_ = NULL;
		gpointer _tmp44_ = NULL;
		gint _tmp45_ = 0;
		GeeIterator* _tmp46_ = NULL;
		gpointer _tmp47_ = NULL;
		gint _tmp48_ = 0;
		gint _tmp49_ = 0;
		gint _tmp50_ = 0;
		_tmp38_ = iter;
		_tmp39_ = gee_iterator_next (_tmp38_);
		if (!_tmp39_) {
			break;
		}
		_tmp40_ = _data2_->i;
		_tmp41_ = j;
		_vala_assert (_tmp40_ == _tmp41_, "i == j");
		_tmp42_ = j;
		_tmp43_ = iter;
		_tmp44_ = gee_iterator_get (_tmp43_);
		_vala_assert (_tmp42_ == ((gint) ((gintptr) _tmp44_)), "j == iter.get ()");
		_tmp45_ = j;
		_tmp46_ = iter;
		_tmp47_ = gee_iterator_get (_tmp46_);
		_vala_assert (_tmp45_ == ((gint) ((gintptr) _tmp47_)), "j == iter.get ()");
		_tmp48_ = j;
		j = _tmp48_ + 1;
		_tmp49_ = _data2_->i;
		_tmp50_ = j;
		_vala_assert (_tmp49_ == _tmp50_, "i == j");
	}
	_tmp51_ = _data2_->i;
	_tmp52_ = j;
	_vala_assert (_tmp51_ == _tmp52_, "i == j");
	_tmp53_ = _data2_->i;
	_tmp54_ = self->test_collection;
	_tmp55_ = gee_collection_get_size (_tmp54_);
	_tmp56_ = _tmp55_;
	_vala_assert (_tmp53_ == _tmp56_, "i == test_collection.size");
	_tmp57_ = _data2_->one;
	_vala_assert (_tmp57_, "one");
	_tmp58_ = _data2_->two;
	_vala_assert (_tmp58_, "two");
	_tmp59_ = _data2_->three;
	_vala_assert (_tmp59_, "three");
	_g_object_unref0 (iter);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		CollectionTests * self;
		self = _data3_->self;
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}


static gint __lambda11_ (Block3Data* _data3_, gchar* str, gint cur) {
	CollectionTests * self;
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	gint _tmp6_ = 0;
	self = _data3_->self;
	g_return_val_if_fail (str != NULL, 0);
	_tmp0_ = str;
	if (g_strcmp0 (_tmp0_, "one") == 0) {
		gboolean _tmp1_ = FALSE;
		_tmp1_ = _data3_->one;
		_vala_assert (!_tmp1_, "!one");
		_data3_->one = TRUE;
	} else {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = str;
		if (g_strcmp0 (_tmp2_, "two") == 0) {
			gboolean _tmp3_ = FALSE;
			_tmp3_ = _data3_->two;
			_vala_assert (!_tmp3_, "!two");
			_data3_->two = TRUE;
		} else {
			const gchar* _tmp4_ = NULL;
			_tmp4_ = str;
			if (g_strcmp0 (_tmp4_, "three") == 0) {
				gboolean _tmp5_ = FALSE;
				_tmp5_ = _data3_->three;
				_vala_assert (!_tmp5_, "!three");
				_data3_->three = TRUE;
			} else {
				g_assert_not_reached ();
			}
		}
	}
	_tmp6_ = cur;
	result = _tmp6_ + 1;
	_g_free0 (str);
	return result;
}


static gpointer ___lambda11__gee_fold_func (gpointer g, gpointer a, gpointer self) {
	gpointer result;
	result = __lambda11_ (self, g, a);
	return result;
}


static gint __lambda12_ (Block3Data* _data3_, gchar* str, gint cur) {
	CollectionTests * self;
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	gint _tmp6_ = 0;
	self = _data3_->self;
	g_return_val_if_fail (str != NULL, 0);
	_tmp0_ = str;
	if (g_strcmp0 (_tmp0_, "one") == 0) {
		gboolean _tmp1_ = FALSE;
		_tmp1_ = _data3_->one;
		_vala_assert (!_tmp1_, "!one");
		_data3_->one = TRUE;
	} else {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = str;
		if (g_strcmp0 (_tmp2_, "two") == 0) {
			gboolean _tmp3_ = FALSE;
			_tmp3_ = _data3_->two;
			_vala_assert (!_tmp3_, "!two");
			_data3_->two = TRUE;
		} else {
			const gchar* _tmp4_ = NULL;
			_tmp4_ = str;
			if (g_strcmp0 (_tmp4_, "three") == 0) {
				gboolean _tmp5_ = FALSE;
				_tmp5_ = _data3_->three;
				_vala_assert (!_tmp5_, "!three");
				_data3_->three = TRUE;
			} else {
				g_assert_not_reached ();
			}
		}
	}
	_tmp6_ = cur;
	result = _tmp6_ + 1;
	_g_free0 (str);
	return result;
}


static gpointer ___lambda12__gee_fold_func (gpointer g, gpointer a, gpointer self) {
	gpointer result;
	result = __lambda12_ (self, g, a);
	return result;
}


void collection_tests_test_scan (CollectionTests* self) {
	Block3Data* _data3_;
	GeeCollection* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GeeCollection* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GeeCollection* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	GeeIterator* iter = NULL;
	GeeCollection* _tmp6_ = NULL;
	GeeIterator* _tmp7_ = NULL;
	GeeIterator* _tmp8_ = NULL;
	GeeIterator* _tmp9_ = NULL;
	GeeIterator* _tmp10_ = NULL;
	gint j = 0;
	gint _tmp22_ = 0;
	GeeCollection* _tmp23_ = NULL;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp27_ = FALSE;
	gboolean _tmp28_ = FALSE;
	gboolean _tmp29_ = FALSE;
	gboolean _tmp30_ = FALSE;
	GeeCollection* _tmp31_ = NULL;
	GeeIterator* _tmp32_ = NULL;
	gint _tmp44_ = 0;
	GeeCollection* _tmp45_ = NULL;
	gint _tmp46_ = 0;
	gint _tmp47_ = 0;
	gboolean _tmp48_ = FALSE;
	gboolean _tmp49_ = FALSE;
	gboolean _tmp50_ = FALSE;
	g_return_if_fail (self != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = self->test_collection;
	_tmp1_ = gee_collection_add (_tmp0_, "one");
	_vala_assert (_tmp1_, "test_collection.add (\"one\")");
	_tmp2_ = self->test_collection;
	_tmp3_ = gee_collection_add (_tmp2_, "two");
	_vala_assert (_tmp3_, "test_collection.add (\"two\")");
	_tmp4_ = self->test_collection;
	_tmp5_ = gee_collection_add (_tmp4_, "three");
	_vala_assert (_tmp5_, "test_collection.add (\"three\")");
	_data3_->one = FALSE;
	_data3_->two = FALSE;
	_data3_->three = FALSE;
	_tmp6_ = self->test_collection;
	_tmp7_ = gee_iterable_iterator ((GeeIterable*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = gee_traversable_scan ((GeeTraversable*) _tmp8_, G_TYPE_INT, NULL, NULL, ___lambda11__gee_fold_func, _data3_, (gpointer) ((gintptr) 0));
	_tmp10_ = _tmp9_;
	_g_object_unref0 (_tmp8_);
	iter = _tmp10_;
	j = 0;
	{
		gboolean _tmp11_ = FALSE;
		_tmp11_ = TRUE;
		while (TRUE) {
			gboolean _tmp12_ = FALSE;
			gint _tmp15_ = 0;
			GeeIterator* _tmp16_ = NULL;
			gpointer _tmp17_ = NULL;
			gint _tmp18_ = 0;
			GeeIterator* _tmp19_ = NULL;
			gpointer _tmp20_ = NULL;
			gint _tmp21_ = 0;
			_tmp12_ = _tmp11_;
			if (!_tmp12_) {
				GeeIterator* _tmp13_ = NULL;
				gboolean _tmp14_ = FALSE;
				_tmp13_ = iter;
				_tmp14_ = gee_iterator_next (_tmp13_);
				if (!_tmp14_) {
					break;
				}
			}
			_tmp11_ = FALSE;
			_tmp15_ = j;
			_tmp16_ = iter;
			_tmp17_ = gee_iterator_get (_tmp16_);
			_vala_assert (_tmp15_ == ((gint) ((gintptr) _tmp17_)), "j == iter.get ()");
			_tmp18_ = j;
			_tmp19_ = iter;
			_tmp20_ = gee_iterator_get (_tmp19_);
			_vala_assert (_tmp18_ == ((gint) ((gintptr) _tmp20_)), "j == iter.get ()");
			_tmp21_ = j;
			j = _tmp21_ + 1;
		}
	}
	_tmp22_ = j;
	_tmp23_ = self->test_collection;
	_tmp24_ = gee_collection_get_size (_tmp23_);
	_tmp25_ = _tmp24_;
	_vala_assert (_tmp22_ == (_tmp25_ + 1), "j == test_collection.size + 1");
	_tmp26_ = _data3_->one;
	_vala_assert (_tmp26_, "one");
	_tmp27_ = _data3_->two;
	_vala_assert (_tmp27_, "two");
	_tmp28_ = _data3_->three;
	_vala_assert (_tmp28_, "three");
	_data3_->three = FALSE;
	_tmp29_ = _data3_->three;
	_data3_->two = _tmp29_;
	_tmp30_ = _data3_->two;
	_data3_->one = _tmp30_;
	j = 0;
	_tmp31_ = self->test_collection;
	_tmp32_ = gee_traversable_scan ((GeeTraversable*) _tmp31_, G_TYPE_INT, NULL, NULL, ___lambda12__gee_fold_func, _data3_, (gpointer) ((gintptr) 0));
	_g_object_unref0 (iter);
	iter = _tmp32_;
	{
		gboolean _tmp33_ = FALSE;
		_tmp33_ = TRUE;
		while (TRUE) {
			gboolean _tmp34_ = FALSE;
			gint _tmp37_ = 0;
			GeeIterator* _tmp38_ = NULL;
			gpointer _tmp39_ = NULL;
			gint _tmp40_ = 0;
			GeeIterator* _tmp41_ = NULL;
			gpointer _tmp42_ = NULL;
			gint _tmp43_ = 0;
			_tmp34_ = _tmp33_;
			if (!_tmp34_) {
				GeeIterator* _tmp35_ = NULL;
				gboolean _tmp36_ = FALSE;
				_tmp35_ = iter;
				_tmp36_ = gee_iterator_next (_tmp35_);
				if (!_tmp36_) {
					break;
				}
			}
			_tmp33_ = FALSE;
			_tmp37_ = j;
			_tmp38_ = iter;
			_tmp39_ = gee_iterator_get (_tmp38_);
			_vala_assert (_tmp37_ == ((gint) ((gintptr) _tmp39_)), "j == iter.get ()");
			_tmp40_ = j;
			_tmp41_ = iter;
			_tmp42_ = gee_iterator_get (_tmp41_);
			_vala_assert (_tmp40_ == ((gint) ((gintptr) _tmp42_)), "j == iter.get ()");
			_tmp43_ = j;
			j = _tmp43_ + 1;
		}
	}
	_tmp44_ = j;
	_tmp45_ = self->test_collection;
	_tmp46_ = gee_collection_get_size (_tmp45_);
	_tmp47_ = _tmp46_;
	_vala_assert (_tmp44_ == (_tmp47_ + 1), "j == test_collection.size + 1");
	_tmp48_ = _data3_->one;
	_vala_assert (_tmp48_, "one");
	_tmp49_ = _data3_->two;
	_vala_assert (_tmp49_, "two");
	_tmp50_ = _data3_->three;
	_vala_assert (_tmp50_, "three");
	_g_object_unref0 (iter);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		CollectionTests * self;
		self = _data4_->self;
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}


static gboolean __lambda13_ (Block4Data* _data4_, const gchar* str) {
	CollectionTests * self;
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp6_ = NULL;
	self = _data4_->self;
	g_return_val_if_fail (str != NULL, FALSE);
	_tmp0_ = str;
	if (g_strcmp0 (_tmp0_, "one") == 0) {
		gboolean _tmp1_ = FALSE;
		_tmp1_ = _data4_->one;
		_vala_assert (!_tmp1_, "!one");
		_data4_->one = TRUE;
	} else {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = str;
		if (g_strcmp0 (_tmp2_, "two") == 0) {
			gboolean _tmp3_ = FALSE;
			_tmp3_ = _data4_->two;
			_vala_assert (!_tmp3_, "!two");
			_data4_->two = TRUE;
		} else {
			const gchar* _tmp4_ = NULL;
			_tmp4_ = str;
			if (g_strcmp0 (_tmp4_, "three") == 0) {
				gboolean _tmp5_ = FALSE;
				_tmp5_ = _data4_->three;
				_vala_assert (!_tmp5_, "!three");
				_data4_->three = TRUE;
			} else {
				g_assert_not_reached ();
			}
		}
	}
	_tmp6_ = str;
	result = g_strcmp0 (_tmp6_, "two") != 0;
	return result;
}


static gboolean ___lambda13__gee_predicate (gconstpointer g, gpointer self) {
	gboolean result;
	result = __lambda13_ (self, g);
	return result;
}


static gboolean __lambda14_ (Block4Data* _data4_, const gchar* str) {
	CollectionTests * self;
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp6_ = NULL;
	self = _data4_->self;
	g_return_val_if_fail (str != NULL, FALSE);
	_tmp0_ = str;
	if (g_strcmp0 (_tmp0_, "one") == 0) {
		gboolean _tmp1_ = FALSE;
		_tmp1_ = _data4_->one;
		_vala_assert (!_tmp1_, "!one");
		_data4_->one = TRUE;
	} else {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = str;
		if (g_strcmp0 (_tmp2_, "two") == 0) {
			gboolean _tmp3_ = FALSE;
			_tmp3_ = _data4_->two;
			_vala_assert (!_tmp3_, "!two");
			_data4_->two = TRUE;
		} else {
			const gchar* _tmp4_ = NULL;
			_tmp4_ = str;
			if (g_strcmp0 (_tmp4_, "three") == 0) {
				gboolean _tmp5_ = FALSE;
				_tmp5_ = _data4_->three;
				_vala_assert (!_tmp5_, "!three");
				_data4_->three = TRUE;
			} else {
				g_assert_not_reached ();
			}
		}
	}
	_tmp6_ = str;
	result = g_strcmp0 (_tmp6_, "two") != 0;
	return result;
}


static gboolean ___lambda14__gee_predicate (gconstpointer g, gpointer self) {
	gboolean result;
	result = __lambda14_ (self, g);
	return result;
}


void collection_tests_test_filter (CollectionTests* self) {
	Block4Data* _data4_;
	GeeCollection* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GeeCollection* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GeeCollection* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	GeeIterator* iter = NULL;
	GeeCollection* _tmp6_ = NULL;
	GeeIterator* _tmp7_ = NULL;
	GeeIterator* _tmp8_ = NULL;
	GeeIterator* _tmp9_ = NULL;
	GeeIterator* _tmp10_ = NULL;
	GeeIterator* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	gint j = 0;
	gint _tmp20_ = 0;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp22_ = FALSE;
	gboolean _tmp23_ = FALSE;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp25_ = FALSE;
	GeeCollection* _tmp26_ = NULL;
	GeeIterator* _tmp27_ = NULL;
	GeeIterator* _tmp28_ = NULL;
	gboolean _tmp29_ = FALSE;
	gboolean _tmp30_ = FALSE;
	gint _tmp37_ = 0;
	gboolean _tmp38_ = FALSE;
	gboolean _tmp39_ = FALSE;
	gboolean _tmp40_ = FALSE;
	g_return_if_fail (self != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = self->test_collection;
	_tmp1_ = gee_collection_add (_tmp0_, "one");
	_vala_assert (_tmp1_, "test_collection.add (\"one\")");
	_tmp2_ = self->test_collection;
	_tmp3_ = gee_collection_add (_tmp2_, "two");
	_vala_assert (_tmp3_, "test_collection.add (\"two\")");
	_tmp4_ = self->test_collection;
	_tmp5_ = gee_collection_add (_tmp4_, "three");
	_vala_assert (_tmp5_, "test_collection.add (\"three\")");
	_data4_->one = FALSE;
	_data4_->two = FALSE;
	_data4_->three = FALSE;
	_tmp6_ = self->test_collection;
	_tmp7_ = gee_iterable_iterator ((GeeIterable*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = gee_traversable_filter ((GeeTraversable*) _tmp8_, ___lambda13__gee_predicate, block4_data_ref (_data4_), block4_data_unref);
	_tmp10_ = _tmp9_;
	_g_object_unref0 (_tmp8_);
	iter = _tmp10_;
	_tmp11_ = iter;
	_tmp12_ = gee_iterator_get_valid (_tmp11_);
	_tmp13_ = _tmp12_;
	_vala_assert (!_tmp13_, "!iter.valid");
	j = 0;
	while (TRUE) {
		GeeIterator* _tmp14_ = NULL;
		gboolean _tmp15_ = FALSE;
		GeeIterator* _tmp16_ = NULL;
		gpointer _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		gint _tmp19_ = 0;
		_tmp14_ = iter;
		_tmp15_ = gee_iterator_next (_tmp14_);
		if (!_tmp15_) {
			break;
		}
		_tmp16_ = iter;
		_tmp17_ = gee_iterator_get (_tmp16_);
		_tmp18_ = (gchar*) _tmp17_;
		_vala_assert (g_strcmp0 (_tmp18_, "two") != 0, "iter.get () != \"two\"");
		_g_free0 (_tmp18_);
		_tmp19_ = j;
		j = _tmp19_ + 1;
	}
	_tmp20_ = j;
	_vala_assert (_tmp20_ == 2, "j == 2");
	_tmp21_ = _data4_->one;
	_vala_assert (_tmp21_, "one");
	_tmp22_ = _data4_->two;
	_vala_assert (_tmp22_, "two");
	_tmp23_ = _data4_->three;
	_vala_assert (_tmp23_, "three");
	_data4_->three = FALSE;
	_tmp24_ = _data4_->three;
	_data4_->two = _tmp24_;
	_tmp25_ = _data4_->two;
	_data4_->one = _tmp25_;
	j = 0;
	_tmp26_ = self->test_collection;
	_tmp27_ = gee_traversable_filter ((GeeTraversable*) _tmp26_, ___lambda14__gee_predicate, block4_data_ref (_data4_), block4_data_unref);
	_g_object_unref0 (iter);
	iter = _tmp27_;
	_tmp28_ = iter;
	_tmp29_ = gee_iterator_get_valid (_tmp28_);
	_tmp30_ = _tmp29_;
	_vala_assert (!_tmp30_, "!iter.valid");
	while (TRUE) {
		GeeIterator* _tmp31_ = NULL;
		gboolean _tmp32_ = FALSE;
		GeeIterator* _tmp33_ = NULL;
		gpointer _tmp34_ = NULL;
		gchar* _tmp35_ = NULL;
		gint _tmp36_ = 0;
		_tmp31_ = iter;
		_tmp32_ = gee_iterator_next (_tmp31_);
		if (!_tmp32_) {
			break;
		}
		_tmp33_ = iter;
		_tmp34_ = gee_iterator_get (_tmp33_);
		_tmp35_ = (gchar*) _tmp34_;
		_vala_assert (g_strcmp0 (_tmp35_, "two") != 0, "iter.get () != \"two\"");
		_g_free0 (_tmp35_);
		_tmp36_ = j;
		j = _tmp36_ + 1;
	}
	_tmp37_ = j;
	_vala_assert (_tmp37_ == 2, "j == 2");
	_tmp38_ = _data4_->one;
	_vala_assert (_tmp38_, "one");
	_tmp39_ = _data4_->two;
	_vala_assert (_tmp39_, "two");
	_tmp40_ = _data4_->three;
	_vala_assert (_tmp40_, "three");
	_g_object_unref0 (iter);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}


void collection_tests_test_chop (CollectionTests* self) {
	GeeCollection* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GeeCollection* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GeeCollection* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	GeeIterator* iter = NULL;
	GeeCollection* _tmp6_ = NULL;
	GeeIterator* _tmp7_ = NULL;
	GeeIterator* _tmp8_ = NULL;
	GeeIterator* _tmp9_ = NULL;
	GeeIterator* _tmp10_ = NULL;
	GeeIterator* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	GeeIterator* iter2 = NULL;
	GeeCollection* _tmp14_ = NULL;
	GeeIterator* _tmp15_ = NULL;
	GeeIterator* _tmp16_ = NULL;
	gboolean _tmp17_ = FALSE;
	GeeIterator* _tmp18_ = NULL;
	gboolean _tmp19_ = FALSE;
	GeeIterator* _tmp20_ = NULL;
	gboolean _tmp21_ = FALSE;
	GeeIterator* _tmp22_ = NULL;
	gpointer _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	GeeIterator* _tmp25_ = NULL;
	gpointer _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	GeeIterator* _tmp28_ = NULL;
	gboolean _tmp29_ = FALSE;
	GeeIterator* _tmp30_ = NULL;
	gboolean _tmp31_ = FALSE;
	GeeCollection* _tmp32_ = NULL;
	GeeIterator* _tmp33_ = NULL;
	GeeIterator* _tmp34_ = NULL;
	gboolean _tmp35_ = FALSE;
	gboolean _tmp36_ = FALSE;
	GeeCollection* _tmp37_ = NULL;
	GeeIterator* _tmp38_ = NULL;
	GeeIterator* _tmp39_ = NULL;
	gboolean _tmp40_ = FALSE;
	GeeIterator* _tmp41_ = NULL;
	gboolean _tmp42_ = FALSE;
	GeeIterator* _tmp43_ = NULL;
	gboolean _tmp44_ = FALSE;
	GeeIterator* _tmp45_ = NULL;
	gpointer _tmp46_ = NULL;
	gchar* _tmp47_ = NULL;
	GeeIterator* _tmp48_ = NULL;
	gpointer _tmp49_ = NULL;
	gchar* _tmp50_ = NULL;
	GeeIterator* _tmp51_ = NULL;
	gboolean _tmp52_ = FALSE;
	GeeIterator* _tmp53_ = NULL;
	gboolean _tmp54_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->test_collection;
	_tmp1_ = gee_collection_add (_tmp0_, "one");
	_vala_assert (_tmp1_, "test_collection.add (\"one\")");
	_tmp2_ = self->test_collection;
	_tmp3_ = gee_collection_add (_tmp2_, "two");
	_vala_assert (_tmp3_, "test_collection.add (\"two\")");
	_tmp4_ = self->test_collection;
	_tmp5_ = gee_collection_add (_tmp4_, "three");
	_vala_assert (_tmp5_, "test_collection.add (\"three\")");
	_tmp6_ = self->test_collection;
	_tmp7_ = gee_iterable_iterator ((GeeIterable*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = gee_traversable_chop ((GeeTraversable*) _tmp8_, 1, 1);
	_tmp10_ = _tmp9_;
	_g_object_unref0 (_tmp8_);
	iter = _tmp10_;
	_tmp11_ = iter;
	_tmp12_ = gee_iterator_get_valid (_tmp11_);
	_tmp13_ = _tmp12_;
	_vala_assert (!_tmp13_, "!iter.valid");
	_tmp14_ = self->test_collection;
	_tmp15_ = gee_iterable_iterator ((GeeIterable*) _tmp14_);
	iter2 = _tmp15_;
	_tmp16_ = iter2;
	_tmp17_ = gee_iterator_next (_tmp16_);
	_vala_assert (_tmp17_, "iter2.next ()");
	_tmp18_ = iter2;
	_tmp19_ = gee_iterator_next (_tmp18_);
	_vala_assert (_tmp19_, "iter2.next ()");
	_tmp20_ = iter;
	_tmp21_ = gee_iterator_next (_tmp20_);
	_vala_assert (_tmp21_, "iter.next ()");
	_tmp22_ = iter2;
	_tmp23_ = gee_iterator_get (_tmp22_);
	_tmp24_ = (gchar*) _tmp23_;
	_tmp25_ = iter;
	_tmp26_ = gee_iterator_get (_tmp25_);
	_tmp27_ = (gchar*) _tmp26_;
	_vala_assert (g_strcmp0 (_tmp24_, _tmp27_) == 0, "iter2.get () == iter.get ()");
	_g_free0 (_tmp27_);
	_g_free0 (_tmp24_);
	_tmp28_ = iter;
	_tmp29_ = gee_iterator_next (_tmp28_);
	_vala_assert (!_tmp29_, "!iter.next ()");
	_tmp30_ = iter2;
	_tmp31_ = gee_iterator_next (_tmp30_);
	_vala_assert (_tmp31_, "iter2.next ()");
	_tmp32_ = self->test_collection;
	_tmp33_ = gee_traversable_chop ((GeeTraversable*) _tmp32_, 1, 1);
	_g_object_unref0 (iter);
	iter = _tmp33_;
	_tmp34_ = iter;
	_tmp35_ = gee_iterator_get_valid (_tmp34_);
	_tmp36_ = _tmp35_;
	_vala_assert (!_tmp36_, "!iter.valid");
	_tmp37_ = self->test_collection;
	_tmp38_ = gee_iterable_iterator ((GeeIterable*) _tmp37_);
	_g_object_unref0 (iter2);
	iter2 = _tmp38_;
	_tmp39_ = iter2;
	_tmp40_ = gee_iterator_next (_tmp39_);
	_vala_assert (_tmp40_, "iter2.next ()");
	_tmp41_ = iter2;
	_tmp42_ = gee_iterator_next (_tmp41_);
	_vala_assert (_tmp42_, "iter2.next ()");
	_tmp43_ = iter;
	_tmp44_ = gee_iterator_next (_tmp43_);
	_vala_assert (_tmp44_, "iter.next ()");
	_tmp45_ = iter2;
	_tmp46_ = gee_iterator_get (_tmp45_);
	_tmp47_ = (gchar*) _tmp46_;
	_tmp48_ = iter;
	_tmp49_ = gee_iterator_get (_tmp48_);
	_tmp50_ = (gchar*) _tmp49_;
	_vala_assert (g_strcmp0 (_tmp47_, _tmp50_) == 0, "iter2.get () == iter.get ()");
	_g_free0 (_tmp50_);
	_g_free0 (_tmp47_);
	_tmp51_ = iter;
	_tmp52_ = gee_iterator_next (_tmp51_);
	_vala_assert (!_tmp52_, "!iter.next ()");
	_tmp53_ = iter2;
	_tmp54_ = gee_iterator_next (_tmp53_);
	_vala_assert (_tmp54_, "iter2.next ()");
	_g_object_unref0 (iter2);
	_g_object_unref0 (iter);
}


static void collection_tests_class_init (CollectionTestsClass * klass) {
	collection_tests_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = collection_tests_finalize;
}


static void collection_tests_instance_init (CollectionTests * self) {
}


static void collection_tests_finalize (GObject* obj) {
	CollectionTests * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_COLLECTION_TESTS, CollectionTests);
	_g_object_unref0 (self->test_collection);
	G_OBJECT_CLASS (collection_tests_parent_class)->finalize (obj);
}


GType collection_tests_get_type (void) {
	static volatile gsize collection_tests_type_id__volatile = 0;
	if (g_once_init_enter (&collection_tests_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CollectionTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) collection_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CollectionTests), 0, (GInstanceInitFunc) collection_tests_instance_init, NULL };
		GType collection_tests_type_id;
		collection_tests_type_id = g_type_register_static (GEE_TYPE_TEST_CASE, "CollectionTests", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&collection_tests_type_id__volatile, collection_tests_type_id);
	}
	return collection_tests_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



