#include <libglademm/xml.h>
#include <gtkmm.h>
#include <iostream>

int main (int argc, char **argv)
{
  Gtk::Main kit(argc, argv);

  //Load the Glade file and instiate its widgets:
  Glib::RefPtr<Gnome::Glade::Xml> refXml;
  try
  {
    refXml = Gnome::Glade::Xml::create("basic.glade");
  }
  catch(const Gnome::Glade::XmlError& ex)
  {
    std::cout << "Problem loading .glade file." << ex.what() << std::endl;
  }

  //Get the Glade-instantiated Dialog:
  Gtk::Dialog* pDialog = 0;
  refXml->get_widget("DialogBasic", pDialog);
  if(pDialog)
  {
    //Get the Glade-instantiated Button, and connect a signal handler:
    Gtk::Button* pButton = 0;
    refXml->get_widget("quit_button", pButton);
    if(pButton)
    {
      pButton->signal_clicked().connect(SigC::slot(*pDialog, &Gtk::Dialog::hide)); //hide() will cause main::run() to end.
    }

    kit.run(*pDialog);
  }
}
