/* 
 * GNetwork: libgnetwork/gnetwork-utils.h
 *
 * Copyright (C) 2003 James M. Cape
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; version 2.1 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __GNETWORK_UTILS_H__
#define __GNETWORK_UTILS_H__

#include <glib-object.h>

G_BEGIN_DECLS


typedef void (*GNetworkIOCallback) (GIOChannel * channel, GError * error, gpointer data);


GValueArray *_gnetwork_slist_to_value_array (GSList * list, GType item_type);

gboolean _gnetwork_enum_value_is_valid (GType enum_type, gint value);
gboolean _gnetwork_flags_value_is_valid (GType flags_type, guint value);


G_END_DECLS

#endif /* !__GNETWORK_UTILS_H__ */
