#ifndef GNOME_CUPS_REQUEST_H
#define GNOME_CUPS_REQUEST_H

#include <cups/ipp.h>
#include <glib.h>

ipp_t *gnome_cups_request_new                      (int          operation_id);
ipp_t *gnome_cups_request_new_for_printer          (int          operation_id,
						    const char  *printer_name);
ipp_t *gnome_cups_request_new_for_job              (int          operation_id,
						    int          job_id);
void   gnome_cups_request_add_requested_attributes (ipp_t       *request,
						    ipp_tag_t    group,
						    int          n_attributes,
						    char       **attributes);
ipp_t *gnome_cups_request_execute                  (ipp_t       *request,
						    const char  *path,
						    GError     **err);

/* private */
gboolean _gnome_cups_request_is_executing (void);



#endif
