/* gnome-db-field.c
 *
 * Copyright (C) 2003 - 2005 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "gnome-db-field.h"
#include "gnome-db-base.h"
#include "marshal.h"

static void gnome_db_field_iface_init (gpointer g_class);

GType
gnome_db_field_get_type (void)
{
	static GType type = 0;

	if (!type) {
		static const GTypeInfo info = {
			sizeof (GnomeDbFieldIface),
			(GBaseInitFunc) gnome_db_field_iface_init,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) NULL,
			NULL,
			NULL,
			0,
			0,
			(GInstanceInitFunc) NULL
		};
		
		type = g_type_register_static (G_TYPE_INTERFACE, "GnomeDbField", &info, 0);
		g_type_interface_add_prerequisite (type, GNOME_DB_BASE_TYPE);
	}
	return type;
}


static void
gnome_db_field_iface_init (gpointer g_class)
{
	static gboolean initialized = FALSE;

	if (! initialized) {
		initialized = TRUE;
	}
}


/**
 * gnome_db_field_get_entity
 * @iface: an object which implements the #GnomeDbField interface
 *
 * Get a reference to the object implementing the #GnomeDbEntity interface to which
 * the object implementing the #GnomeDbField is attached to.
 *
 * Returns: the object implementing the #GnomeDbEntity interface
 */
GnomeDbEntity *
gnome_db_field_get_entity (GnomeDbField *iface)
{
	g_return_val_if_fail (iface && IS_GNOME_DB_FIELD (iface), NULL);

	if (GNOME_DB_FIELD_GET_IFACE (iface)->get_entity)
		return (GNOME_DB_FIELD_GET_IFACE (iface)->get_entity) (iface);
	
	return NULL;
}

/**
 * gnome_db_field_get_data_type
 * @iface: an object which implements the #GnomeDbField interface
 *
 * Get a data type of the object implementing the #GnomeDbField interface
 *
 * Returns: the corresponding #GnomeDbServerDataType
 */
GnomeDbServerDataType *
gnome_db_field_get_data_type (GnomeDbField *iface)
{
	g_return_val_if_fail (iface && IS_GNOME_DB_FIELD (iface), NULL);

	if (GNOME_DB_FIELD_GET_IFACE (iface)->get_data_type)
		return (GNOME_DB_FIELD_GET_IFACE (iface)->get_data_type) (iface);
	
	return NULL;
}

/**
 * gnome_db_field_get_name
 * @iface: an object which implements the #GnomeDbField interface
 *
 * Get the name of the object implementing the #GnomeDbField interface
 *
 * Returns: the name
 */
const gchar *
gnome_db_field_get_name (GnomeDbField *iface)
{
	g_return_val_if_fail (iface && IS_GNOME_DB_FIELD (iface), NULL);

	return gnome_db_base_get_name (GNOME_DB_BASE (iface));
}

/**
 * gnome_db_field_get_description
 * @iface: an object which implements the #GnomeDbField interface
 *
 * Get the description of the object implementing the #GnomeDbField interface
 *
 * Returns: the description
 */
const gchar *
gnome_db_field_get_description (GnomeDbField *iface)
{
	g_return_val_if_fail (iface && IS_GNOME_DB_FIELD (iface), NULL);

	return gnome_db_base_get_description (GNOME_DB_BASE (iface));
}



