#include <glib.h>
#include "gnome-db-sql-parser.h"

static void test_string (const gchar *str);
int 
main (int argc, char **argv) {
	test_string ("Select field AS \"my field\" , 'sdfjk', func (sdlkfj + slkdjf) - sdlkf");
	test_string ("update kmj, sdfjk, ##[:name=\"titi\"] + ##[:name=\"toto\"], sdlkfj slkdjf sdlkf");
	test_string ("delete kmj, sdfjk [:name=\"titi\"] sdlkfj slkdjf sdlkf");
	test_string ("insert kmj, 'sdfjk [:name=\"titi\"]' sdlkfj slkdjf sdlkf");
	test_string ("SELECT kmj, \"sdfjk [:name=\"titi\"]\" sdlkfj slkdjf sdlkf");
	test_string ("SELECT schema.table.field || ##[:name=\"Postfix\" :type=\"varchar\"]");
	test_string ("SELECT afield; UPDATE a firld");
	
	return 0;
}

static void
test_string (const gchar *str)
{
	GnomeDbSqlStatement *statement, *copy;

	g_print ("\n\n");
	g_print ("##################################################################\n");
	g_print ("# SQL: %s\n", str);
	g_print ("##################################################################\n");
	statement = gnome_db_sql_parse (str);
	if (statement) {
		gnome_db_sql_display (statement);
		copy = gnome_db_sql_parse_copy_statement (statement);
		gnome_db_sql_destroy (statement);
		g_print ("#### COPY:\n");
		gnome_db_sql_display (copy);
		gnome_db_sql_destroy (copy);
	}
	else
		g_print ("ERROR\n");
}
