/* gnome-db-entry-filesel.h
 *
 * Copyright (C) 2005 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */


#ifndef __GNOME_DB_ENTRY_FILESEL_H_
#define __GNOME_DB_ENTRY_FILESEL_H_

#include "gnome-db-entry-wrapper.h"

G_BEGIN_DECLS

#define GNOME_DB_ENTRY_FILESEL_TYPE          (gnome_db_entry_filesel_get_type())
#define GNOME_DB_ENTRY_FILESEL(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, gnome_db_entry_filesel_get_type(), GnomeDbEntryFilesel)
#define GNOME_DB_ENTRY_FILESEL_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, gnome_db_entry_filesel_get_type (), GnomeDbEntryFileselClass)
#define IS_GNOME_DB_ENTRY_FILESEL(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, gnome_db_entry_filesel_get_type ())


typedef struct _GnomeDbEntryFilesel GnomeDbEntryFilesel;
typedef struct _GnomeDbEntryFileselClass GnomeDbEntryFileselClass;
typedef struct _GnomeDbEntryFileselPrivate GnomeDbEntryFileselPrivate;


/* struct for the object's data */
struct _GnomeDbEntryFilesel
{
	GnomeDbEntryWrapper              object;
	GnomeDbEntryFileselPrivate         *priv;
};

/* struct for the object's class */
struct _GnomeDbEntryFileselClass
{
	GnomeDbEntryWrapperClass         class;
};

GType        gnome_db_entry_filesel_get_type        (void);
GtkWidget   *gnome_db_entry_filesel_new             (GnomeDbDataHandler *dh, GdaValueType type);


G_END_DECLS

#endif
