/* gnome-db-join.h
 *
 * Copyright (C) 2003 - 2004 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */


#ifndef __GNOME_DB_JOIN_H_
#define __GNOME_DB_JOIN_H_

#include "gnome-db-base.h"
#include "gnome-db-decl.h"
#include <libgda/libgda.h>

G_BEGIN_DECLS

#define GNOME_DB_TYPE_JOIN          (gnome_db_join_get_type())
#define GNOME_DB_JOIN(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, gnome_db_join_get_type(), GnomeDbJoin)
#define GNOME_DB_JOIN_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, gnome_db_join_get_type (), GnomeDbJoinClass)
#define IS_GNOME_DB_JOIN(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, gnome_db_join_get_type ())


/* Interfaces:
 * GnomeDbXmlStorage
 * GnomeDbRerefer
 */

/* error reporting */
extern GQuark gnome_db_join_error_quark (void);
#define GNOME_DB_JOIN_ERROR gnome_db_join_error_quark ()

/* different possible types for a query */
typedef enum {
        GNOME_DB_JOIN_TYPE_INNER,
	GNOME_DB_JOIN_TYPE_LEFT_OUTER,
	GNOME_DB_JOIN_TYPE_RIGHT_OUTER,
	GNOME_DB_JOIN_TYPE_FULL_OUTER,
        GNOME_DB_JOIN_TYPE_CROSS,
        GNOME_DB_JOIN_TYPE_LAST
} GnomeDbJoinType;

enum
{
	GNOME_DB_JOIN_XML_LOAD_ERROR,
	GNOME_DB_JOIN_META_DATA_UPDATE,
	GNOME_DB_JOIN_FIELDS_ERROR,
	GNOME_DB_JOIN_SQL_ANALYSE_ERROR,
	GNOME_DB_JOIN_PARSE_ERROR
};


/* struct for the object's data */
struct _GnomeDbJoin
{
	GnomeDbBase               object;
	GnomeDbJoinPrivate       *priv;
};

/* struct for the object's class */
struct _GnomeDbJoinClass
{
	GnomeDbBaseClass                    class;

	/* signals */
	void   (*type_changed)         (GnomeDbJoin *join);
	void   (*condition_changed)    (GnomeDbJoin *join);
};

GType           gnome_db_join_get_type                  (void);
GObject        *gnome_db_join_new_with_targets          (GnomeDbQuery *query, GnomeDbTarget *target_1, GnomeDbTarget *target_2);
GObject        *gnome_db_join_new_with_xml_ids          (GnomeDbQuery *query, const gchar *target_1_xml_id, const gchar *target_2_xml_id);
GObject        *gnome_db_join_new_copy                  (GnomeDbJoin *orig, GHashTable *replacements);

void            gnome_db_join_set_join_type             (GnomeDbJoin *join, GnomeDbJoinType type);
GnomeDbJoinType      gnome_db_join_get_join_type             (GnomeDbJoin *join);
GnomeDbQuery        *gnome_db_join_get_query                 (GnomeDbJoin *join);

GnomeDbTarget       *gnome_db_join_get_target_1              (GnomeDbJoin *join);
GnomeDbTarget       *gnome_db_join_get_target_2              (GnomeDbJoin *join);
void            gnome_db_join_swap_targets              (GnomeDbJoin *join);

gboolean        gnome_db_join_set_condition             (GnomeDbJoin *join, GnomeDbCondition *cond);
GnomeDbCondition    *gnome_db_join_get_condition             (GnomeDbJoin *join);
gboolean        gnome_db_join_set_condition_from_fkcons (GnomeDbJoin *join);
gboolean        gnome_db_join_set_condition_from_sql    (GnomeDbJoin *join, const gchar *cond, GError **error);

const gchar    *gnome_db_join_render_type               (GnomeDbJoin *join);

G_END_DECLS

#endif
