/* gnome-db-server-aggregate.h
 *
 * Copyright (C) 2003 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */


#ifndef __GNOME_DB_SERVER_AGGREGATE_H_
#define __GNOME_DB_SERVER_AGGREGATE_H_

#include "gnome-db-base.h"
#include "gnome-db-decl.h"

G_BEGIN_DECLS

#define GNOME_DB_TYPE_SERVER_AGGREGATE          (gnome_db_server_aggregate_get_type())
#define GNOME_DB_SERVER_AGGREGATE(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, gnome_db_server_aggregate_get_type(), GnomeDbServerAggregate)
#define GNOME_DB_SERVER_AGGREGATE_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, gnome_db_server_aggregate_get_type (), GnomeDbServerAggregateClass)
#define IS_GNOME_DB_SERVER_AGGREGATE(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, gnome_db_server_aggregate_get_type ())


/* error reporting */
extern GQuark gnome_db_server_aggregate_error_quark (void);
#define GNOME_DB_SERVER_AGGREGATE_ERROR gnome_db_server_aggregate_error_quark ()

enum
{
	GNOME_DB_SERVER_AGGREGATE_XML_LOAD_ERROR
};


/* struct for the object's data */
struct _GnomeDbServerAggregate
{
	GnomeDbBase                         object;
	GnomeDbServerAggregatePrivate       *priv;
};

/* struct for the object's class */
struct _GnomeDbServerAggregateClass
{
	GnomeDbBaseClass                    class;

	/* signals */
	void   (*templ_signal)        (GnomeDbServerAggregate *obj);
};

GType             gnome_db_server_aggregate_get_type      (void);
GObject          *gnome_db_server_aggregate_new           (GnomeDbServer *srv);
void              gnome_db_server_aggregate_set_dbms_id   (GnomeDbServerAggregate *agg, const gchar *id);
gchar            *gnome_db_server_aggregate_get_dbms_id   (GnomeDbServerAggregate *agg);
void              gnome_db_server_aggregate_set_sqlname   (GnomeDbServerAggregate *agg, const gchar *sqlname);
const gchar      *gnome_db_server_aggregate_get_sqlname   (GnomeDbServerAggregate *agg);
void              gnome_db_server_aggregate_set_arg_type  (GnomeDbServerAggregate *agg, GnomeDbServerDataType *dt);
GnomeDbServerDataType *gnome_db_server_aggregate_get_arg_type  (GnomeDbServerAggregate *agg);
void              gnome_db_server_aggregate_set_ret_type  (GnomeDbServerAggregate *agg, GnomeDbServerDataType *dt);
GnomeDbServerDataType *gnome_db_server_aggregate_get_ret_type  (GnomeDbServerAggregate *agg);

G_END_DECLS

#endif
