/* gnome-db-goo-cursor.h
 *
 * Copyright (C) 2002 - 2004 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __GNOME_DB_GOO_CURSOR__
#define __GNOME_DB_GOO_CURSOR__

#include "gnome-db-goo-item.h"

G_BEGIN_DECLS

/*
 * 
 * "Drag item" GooCanvas item: a GnomeDbGooItem item which is used to represent
 * an element being dragged, and destroys itself when the mouse button is released
 *
 */

#define GNOME_DB_TYPE_GOO_CURSOR          (gnome_db_goo_cursor_get_type())
#define GNOME_DB_GOO_CURSOR(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, gnome_db_goo_cursor_get_type(), GnomeDbGooCursor)
#define GNOME_DB_GOO_CURSOR_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, gnome_db_goo_cursor_get_type (), GnomeDbGooCursorClass)
#define GNOME_DB_IS_GOO_CURSOR(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, gnome_db_goo_cursor_get_type ())


typedef struct _GnomeDbGooCursor      GnomeDbGooCursor;
typedef struct _GnomeDbGooCursorClass GnomeDbGooCursorClass;


/* struct for the object's data */
struct _GnomeDbGooCursor
{
	GnomeDbGooItem        object;

	GooCanvasItem    *item;
};

/* struct for the object's class */
struct _GnomeDbGooCursorClass
{
	GnomeDbGooItemClass   parent_class;
};

/* generic widget's functions */
GType          gnome_db_goo_cursor_get_type (void) G_GNUC_CONST;
GooCanvasItem *gnome_db_goo_cursor_new (GooCanvasItem *parent, ...);


G_END_DECLS

#endif
