/* gnome-db-goo-join.h
 *
 * Copyright (C) 2004 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __GNOME_DB_GOO_JOIN__
#define __GNOME_DB_GOO_JOIN__

#include "gnome-db-goo-item.h"

G_BEGIN_DECLS

/*
 * 
 * "Drag item" GooCanvas item: a GnomeDbGooItem item which is used to represent
 * an element being dragged, and destroys itself when the mouse button is released
 *
 */

#define GNOME_DB_TYPE_GOO_JOIN          (gnome_db_goo_join_get_type())
#define GNOME_DB_GOO_JOIN(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, gnome_db_goo_join_get_type(), GnomeDbGooJoin)
#define GNOME_DB_GOO_JOIN_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, gnome_db_goo_join_get_type (), GnomeDbGooJoinClass)
#define GNOME_DB_IS_GOO_JOIN(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, gnome_db_goo_join_get_type ())


typedef struct _GnomeDbGooJoin        GnomeDbGooJoin;
typedef struct _GnomeDbGooJoinClass   GnomeDbGooJoinClass;
typedef struct _GnomeDbGooJoinPrivate GnomeDbGooJoinPrivate;


/* struct for the object's data */
struct _GnomeDbGooJoin
{
	GnomeDbGooItem           object;

	GnomeDbGooJoinPrivate   *priv;
};

/* struct for the object's class */
struct _GnomeDbGooJoinClass
{
	GnomeDbGooItemClass      parent_class;
};

/* generic widget's functions */
GType          gnome_db_goo_join_get_type       (void) G_GNUC_CONST;
GooCanvasItem *gnome_db_goo_join_new            (GooCanvasItem *parent, GdaQueryJoin *join, ...);

G_END_DECLS

#endif
