
#include <libgnomeuimm/entry.h>
#include <libgnomeuimm/private/entry_p.h>

/* $Id: entry.ccg,v 1.5 2001/12/05 16:40:56 murrayc Exp $ */


/* entry.ccg
 * 
 * Copyright (C) 1999 The Gtk-- Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libgnomeui/gnome-entry.h>


namespace
{

const Glib::SignalProxyInfo Entry_signal_activate_info =
{
  "activate",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};

} // anonymous namespace


namespace Glib
{

Gnome::UI::Entry* wrap(GnomeEntry* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gnome::UI::Entry *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gnome
{

namespace UI
{


/* The *_Class implementation: */

GType Entry_Class::get_type()
{
  if(!gtype_) // create the GType if necessary
  {
    // TODO: This is currently just optimized away, apparently with no harm.
    // Is it actually needed?
    // Make sure that the parent type has been created.
    CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gnome_entry_get_type(), (GClassInitFunc) &class_init_function);

    // Add derived versions of interfaces, if the C type implements any interfaces:
  Gtk::Editable::add_interface(get_type());
  }

  return gtype_;
}

void Entry_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
  klass->activate = &activate_callback;
}


void Entry_Class::activate_callback(GnomeEntry* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_activate();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->activate)
      (*base->activate)(self);
  }
}


Glib::ObjectBase* Entry_Class::wrap_new(GObject* o)
{
  return manage(new Entry((GnomeEntry*)(o)));
}


/* The implementation: */

Entry::Entry(GnomeEntry* castitem)
: Gtk::Combo((GtkCombo*)(castitem))
{}

Entry::~Entry()
{
  destroy_();
}

Entry::CppClassType Entry::entry_class_; //Initialize static member.

GType Entry::get_type()
{
  return entry_class_.get_type();
}

GType Entry::get_base_type()
{
  return gnome_entry_get_type();
}

Entry::Entry()
: Gtk::Combo((GtkCombo*)(g_object_new(get_type(), (char*)0)))
{}

Gtk::Widget* Entry::gtk_entry()
{
  return Glib::wrap(gnome_entry_gtk_entry(gobj()));
}

void Entry::set_history_id(const Glib::ustring& history_id)
{
  gnome_entry_set_history_id(gobj(), history_id.c_str());
}

Glib::ustring Entry::get_history_id() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gnome_entry_get_history_id(const_cast<GnomeEntry*>(gobj())));
}

void Entry::set_max_saved(guint max_saved)
{
  gnome_entry_set_max_saved(gobj(), max_saved);
}

guint Entry::get_max_saved() const
{
  return gnome_entry_get_max_saved(const_cast<GnomeEntry*>(gobj()));
}

void Entry::prepend_history(bool save, const Glib::ustring& text)
{
  gnome_entry_prepend_history(gobj(), static_cast<int>(save), text.c_str());
}

void Entry::append_history(bool save, const Glib::ustring& text)
{
  gnome_entry_append_history(gobj(), static_cast<int>(save), text.c_str());
}

void Entry::clear_history()
{
  gnome_entry_clear_history(gobj());
}


Glib::SignalProxy0<void> Entry::signal_activate()
{
  return Glib::SignalProxy0<void>(this, &Entry_signal_activate_info);
}


Glib::PropertyProxy<Glib::ustring> Entry::property_history_id()
{
  return Glib::PropertyProxy<Glib::ustring>(this, "history_id");
}

Glib::PropertyProxy_ReadOnly<Gtk::Entry> Entry::property_gtk_entry()
{
  return Glib::PropertyProxy_ReadOnly<Gtk::Entry>(this, "gtk_entry");
}


void Gnome::UI::Entry::on_activate()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->activate)
    (*base->activate)(gobj());
}


} // namespace UI

} // namespace Gnome

