/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <sys/types.h>
#include <gtk/gtk.h>

#ifndef _Included_org_gnu_gtk_RadioToolButton
#define _Included_org_gnu_gtk_RadioToolButton
#ifdef __cplusplus
extern "C" {
#endif
/* Inaccessible static: evtMap */
/* Inaccessible static: class_00024org_00024gnu_00024gtk_00024event_00024LifeCycleListener */
/* Inaccessible static: class_00024org_00024gnu_00024gtk_00024event_00024FocusListener */
/* Inaccessible static: class_00024org_00024gnu_00024gtk_00024event_00024KeyListener */
/* Inaccessible static: class_00024org_00024gnu_00024gtk_00024event_00024MouseListener */
/* Inaccessible static: class_00024org_00024gnu_00024gtk_00024event_00024DragDestinationListener */
/* Inaccessible static: class_00024org_00024gnu_00024gtk_00024event_00024DragSourceListener */
/* Inaccessible static: evtMap */
/* Inaccessible static: class_00024org_00024gnu_00024gtk_00024event_00024ContainerListener */
/* Inaccessible static: evtMap */
/* Inaccessible static: class_00024org_00024gnu_00024gtk_00024event_00024ToolButtonListener */
/* Inaccessible static: evtMap */
/* Inaccessible static: class_00024org_00024gnu_00024gtk_00024event_00024ToggleToolButtonListener */

GSList* getListOfButtons(JNIEnv *env, jintArray buttons)
{
	GSList* list;
	jint* array;
	jsize len;
	int index;
	
	len = (*env)->GetArrayLength(env, buttons);
	array = (*env)->GetIntArrayElements(env, buttons, NULL);
	list = g_slist_alloc();
	for (index = 0; index < len; index++)
	{
		list = g_slist_append(list, (GtkRadioToolButton*)array[index]);
	}
	return list;
}


/*
 * Class:     org_gnu_gtk_RadioToolButton
 * Method:    gtk_radio_tool_button_get_type
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_RadioToolButton_gtk_1radio_1tool_1button_1get_1type
  (JNIEnv *env, jclass cls)
{
	return (jint)gtk_radio_tool_button_get_type();
}

/*
 * Class:     org_gnu_gtk_RadioToolButton
 * Method:    gtk_radio_tool_button_new
 * Signature: ([I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_RadioToolButton_gtk_1radio_1tool_1button_1new
  (JNIEnv *env, jclass cls, jintArray group)
{
	return (jint)gtk_radio_tool_button_new(getListOfButtons(env, group));
}

/*
 * Class:     org_gnu_gtk_RadioToolButton
 * Method:    gtk_radio_tool_button_new_from_stock
 * Signature: ([ILjava/lang/String;)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_RadioToolButton_gtk_1radio_1tool_1button_1new_1from_1stock
  (JNIEnv *env, jclass cls, jintArray group, jstring stockId)
{
	const gchar* s = (*env)->GetStringUTFChars(env, stockId, NULL);
	jint handle = (jint)gtk_radio_tool_button_new_from_stock(getListOfButtons(env, group), s);
	(*env)->ReleaseStringUTFChars(env, stockId, s);
	return handle;
}

/*
 * Class:     org_gnu_gtk_RadioToolButton
 * Method:    gtk_radio_tool_button_new_from_widget
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_RadioToolButton_gtk_1radio_1tool_1button_1new_1from_1widget
  (JNIEnv *env, jclass cls, jint button)
{
	return (jint)gtk_radio_tool_button_new_from_widget((GtkRadioToolButton*)button);
}

/*
 * Class:     org_gnu_gtk_RadioToolButton
 * Method:    gtk_radio_tool_button_new_with_stock_from_widget
 * Signature: (ILjava/lang/String;)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_RadioToolButton_gtk_1radio_1tool_1button_1new_1with_1stock_1from_1widget
  (JNIEnv *env, jclass cls, jint button, jstring stockId)
{
	const gchar* s = (*env)->GetStringUTFChars(env, stockId, NULL);
	jint handle = (jint)gtk_radio_tool_button_new_with_stock_from_widget((GtkWidget*)button, s);
	(*env)->ReleaseStringUTFChars(env, stockId, s);
	return handle;
}

/*
 * Class:     org_gnu_gtk_RadioToolButton
 * Method:    gtk_radio_tool_button_get_group
 * Signature: (I)[I
 */
JNIEXPORT jintArray JNICALL Java_org_gnu_gtk_RadioToolButton_gtk_1radio_1tool_1button_1get_1group
  (JNIEnv *env, jclass cls, jint button)
{
	GSList* list;
	GSList* item;
	jintArray array;
	guint len;
	guint index;
	
	list = gtk_radio_tool_button_get_group((GtkRadioToolButton*)button);
	if (NULL == list)
		return NULL;
	len = g_slist_length(list);
	array = (*env)->NewIntArray(env, len);
	for (index = 0; index < len; index++) {
		item = g_slist_nth(list, index);
		(*env)->SetIntArrayRegion(env, array, index, len, (jint*)(GtkRadioToolButton*)item->data);
	}
	return array;
}

/*
 * Class:     org_gnu_gtk_RadioToolButton
 * Method:    gtk_radio_tool_button_set_group
 * Signature: (I[I)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_RadioToolButton_gtk_1radio_1tool_1button_1set_1group
  (JNIEnv *env, jclass cls, jint button, jintArray group)
{
	gtk_radio_tool_button_set_group((GtkRadioToolButton*)button, getListOfButtons(env, group));
}

#ifdef __cplusplus
}
#endif
#endif
