/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import org.gnu.glib.GObject;

/**
 * Defination for sources and destinations of Drag and Drop operations.
 *
 * If a drag and drop is allowed between a pair of widgets, they must have the
 * same TargetEntry in their drop source and destination lists. 
 *
 *
 * TODO: Free the memory !!
 */
public class TargetEntry extends GObject
{
	/**
	 * Constructs a new target entry
	 * @param name Name of the drag and drop type. This must be the same in both
	 * the drag source and destination (possibly different applications).
	 * @param flags 
	 * @param id Integer id for the drag type. This will be passed to the event
	 * handers. It can be different to that used at the other end of the
	 * drag/drop operation.
	 */
	public TargetEntry( String name, TargetFlags flags, int id ){
		super(newTargetEntry(name, flags.getValue(), id));
	}

	native static protected final int newTargetEntry( String name, int flags, int id );

}

