/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <sys/types.h>
#include <gdk/gdk.h>
#include "jg_jnu.h"

#ifdef __cplusplus
extern "C" 
{
#endif

GdkEventType GdkEventSelection_get_type (GdkEventSelection * cptr) 
{
    return cptr->type;
}

/*
 * Class:     org.gnu.gdk.EventSelection
 * Method:    getType
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_EventSelection_getType (JNIEnv *env, jclass cls, jobject 
    obj) 
{
    GdkEventSelection *obj_g = (GdkEventSelection *)getPointerFromHandle(env, obj);
    return (jint) (GdkEventSelection_get_type (obj_g));
}

GdkWindow * GdkEventSelection_get_window (GdkEventSelection * cptr) 
{
    return cptr->window;
}

/*
 * Class:     org.gnu.gdk.EventSelection
 * Method:    getWindow
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gdk_EventSelection_getWindow (JNIEnv *env, jclass cls, jobject 
    obj) 
{
    GdkEventSelection *obj_g = (GdkEventSelection *)getPointerFromHandle(env, obj);
    return getHandleFromPointer(env, GdkEventSelection_get_window (obj_g));
}

gboolean GdkEventSelection_get_send_event (GdkEventSelection * cptr) 
{
    return cptr->send_event;
}

/*
 * Class:     org.gnu.gdk.EventSelection
 * Method:    getSendEvent
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gdk_EventSelection_getSendEvent (JNIEnv *env, jclass 
    cls, jobject obj) 
{
    GdkEventSelection *obj_g = (GdkEventSelection *)getPointerFromHandle(env, obj);
    return (jboolean) (GdkEventSelection_get_send_event (obj_g));
}

GdkAtom * GdkEventSelection_get_selection (GdkEventSelection * cptr) 
{
    return (GdkAtom *)cptr->selection;
}

/*
 * Class:     org.gnu.gdk.EventSelection
 * Method:    getSelection
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_EventSelection_getSelection (JNIEnv *env, jclass cls, 
    jobject obj) 
{
    GdkEventSelection *obj_g = (GdkEventSelection *)getPointerFromHandle(env, obj);
    return (jint)GdkEventSelection_get_selection (obj_g);
}

GdkAtom * GdkEventSelection_get_target (GdkEventSelection * cptr) 
{
    return (GdkAtom *)cptr->target;
}

/*
 * Class:     org.gnu.gdk.EventSelection
 * Method:    getTarget
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_EventSelection_getTarget (JNIEnv *env, jclass cls, jobject 
    obj) 
{
    GdkEventSelection *obj_g = (GdkEventSelection *)getPointerFromHandle(env, obj);
    return (jint)GdkEventSelection_get_target (obj_g);
}

GdkAtom * GdkEventSelection_get_property (GdkEventSelection * cptr) 
{
    return (GdkAtom *)cptr->property;
}

/*
 * Class:     org.gnu.gdk.EventSelection
 * Method:    getProperty
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_EventSelection_getProperty (JNIEnv *env, jclass cls, 
    jobject obj) 
{
    GdkEventSelection *obj_g = (GdkEventSelection *)getPointerFromHandle(env, obj);
    return (jint)GdkEventSelection_get_property (obj_g);
}

GdkNativeWindow * GdkEventSelection_get_requestor (GdkEventSelection * cptr) 
{
    return (GdkNativeWindow *)cptr->requestor;
}

/*
 * Class:     org.gnu.gdk.EventSelection
 * Method:    getRequestor
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gdk_EventSelection_getRequestor (JNIEnv *env, jclass cls, 
    jobject obj) 
{
    GdkEventSelection *obj_g = (GdkEventSelection *)getPointerFromHandle(env, obj);
    return getHandleFromPointer(env, GdkEventSelection_get_requestor (obj_g));
}

time_t GdkEventSelection_get_time (GdkEventSelection * cptr) 
{
    return cptr->time;
}

/*
 * Class:     org.gnu.gdk.EventSelection
 * Method:    getTime
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_EventSelection_getTime (JNIEnv *env, jclass cls, jobject 
    obj) 
{
    GdkEventSelection *obj_g = (GdkEventSelection *)getPointerFromHandle(env, obj);
    return GdkEventSelection_get_time (obj_g);
}


#ifdef __cplusplus
}

#endif
