/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <sys/types.h>
#include <gdk/gdk.h>
#ifdef __cplusplus
extern "C" 
{
#endif

/*
 * Class:     org.gnu.gdk.Drawable
 * Method:    gdk_drawable_get_type
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_Drawable_gdk_1drawable_1get_1type (JNIEnv *env, jclass 
    cls) 
{
    {
        return (jint)gdk_drawable_get_type ();
    }
}

/*
 * Class:     org.gnu.gdk.Drawable
 * Method:    gdk_drawable_get_size
 * Signature: (I[Lint ;[Lint ;)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Drawable_gdk_1drawable_1get_1size (JNIEnv *env, jclass 
    cls, jint drawable, jintArray width, jintArray height) 
{
    GdkDrawable *drawable_g = (GdkDrawable *)drawable;
    gint *width_g = (gint *) (*env)->GetIntArrayElements (env, width, NULL);
    gint *height_g = (gint *) (*env)->GetIntArrayElements (env, height, NULL);
    {
        gdk_drawable_get_size (drawable_g, width_g, height_g);
        (*env)->ReleaseIntArrayElements (env, width, (jint *) width_g, 0);
        (*env)->ReleaseIntArrayElements (env, height, (jint *) height_g, 0);
    }
}

/*
 * Class:     org.gnu.gdk.Drawable
 * Method:    gdk_drawable_set_colormap
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Drawable_gdk_1drawable_1set_1colormap (JNIEnv *env, 
    jclass cls, jint drawable, jint colormap) 
{
    GdkDrawable *drawable_g = (GdkDrawable *)drawable;
    GdkColormap *colormap_g = (GdkColormap *)colormap;
    {
        gdk_drawable_set_colormap (drawable_g, colormap_g);
    }
}

/*
 * Class:     org.gnu.gdk.Drawable
 * Method:    gdk_drawable_get_colormap
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_Drawable_gdk_1drawable_1get_1colormap (JNIEnv *env, 
    jclass cls, jint drawable) 
{
    GdkDrawable *drawable_g = (GdkDrawable *)drawable;
    {
        return (jint)gdk_drawable_get_colormap (drawable_g);
    }
}

/*
 * Class:     org.gnu.gdk.Drawable
 * Method:    gdk_drawable_get_visual
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_Drawable_gdk_1drawable_1get_1visual (JNIEnv *env, 
    jclass cls, jint drawable) 
{
    GdkDrawable *drawable_g = (GdkDrawable *)drawable;
    {
        return (jint)gdk_drawable_get_visual (drawable_g);
    }
}

/*
 * Class:     org.gnu.gdk.Drawable
 * Method:    gdk_drawable_get_depth
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_Drawable_gdk_1drawable_1get_1depth (JNIEnv *env, jclass 
    cls, jint drawable) 
{
    GdkDrawable *drawable_g = (GdkDrawable *)drawable;
    {
        jint result_j = (jint) (gdk_drawable_get_depth (drawable_g));
        return result_j;
    }
}

/*
 * Class:     org.gnu.gdk.Drawable
 * Method:    gdk_drawable_get_image
 * Signature: (IIIII)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_Drawable_gdk_1drawable_1get_1image (JNIEnv *env, jclass 
    cls, jint drawable, jint x, jint y, jint width, jint height) 
{
    GdkDrawable *drawable_g = (GdkDrawable *)drawable;
    gint32 x_g = (gint32) x;
    gint32 y_g = (gint32) y;
    gint32 width_g = (gint32) width;
    gint32 height_g = (gint32) height;
    {
        return (jint)gdk_drawable_get_image (drawable_g, x_g, y_g, width_g, height_g);
    }
}

/*
 * Class:     org.gnu.gdk.Drawable
 * Method:    gdk_drawable_get_clip_region
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_Drawable_gdk_1drawable_1get_1clip_1region (JNIEnv *env, 
    jclass cls, jint drawable) 
{
    GdkDrawable *drawable_g = (GdkDrawable *)drawable;
    {
        return (jint)gdk_drawable_get_clip_region (drawable_g);
    }
}

/*
 * Class:     org.gnu.gdk.Drawable
 * Method:    gdk_drawable_get_visible_region
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_Drawable_gdk_1drawable_1get_1visible_1region (JNIEnv 
    *env, jclass cls, jint drawable) 
{
    GdkDrawable *drawable_g = (GdkDrawable *)drawable;
    {
        return (jint)gdk_drawable_get_visible_region (drawable_g);
    }
}

/*
 * Class:     org.gnu.gdk.Drawable
 * Method:    gdk_draw_rgb_image
 * Signature: (IIIIIII[BI)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Drawable_gdk_1draw_1rgb_1image (JNIEnv *env, jclass cls, 
    jint drawable, jint gc, jint x, jint y, jint width, jint height, jint dith, jbyteArray 
    rgbBuf, jint rowstride) 
{
    GdkDrawable *drawable_g = (GdkDrawable *)drawable;
    GdkGC *gc_g = (GdkGC *)gc;
    gint32 x_g = (gint32) x;
    gint32 y_g = (gint32) y;
    gint32 width_g = (gint32) width;
    gint32 height_g = (gint32) height;
    GdkRgbDither dith_g = (GdkRgbDither) dith;
    jint rgbBuf_len = (*env)->GetArrayLength(env, rgbBuf);
    gchar* rgbBuf_g = (gchar*)g_malloc(rgbBuf_len + 1);
    gint32 rowstride_g = (gint32) rowstride;
    (*env)->GetByteArrayRegion(env, rgbBuf, 0, rgbBuf_len, (jbyte*)rgbBuf_g);
    rgbBuf_g[rgbBuf_len] = 0;
    {
        gdk_draw_rgb_image (drawable_g, gc_g, x_g, y_g, width_g, height_g, dith_g, rgbBuf_g, 
            rowstride_g);
    }
}

/*
 * Class:     org.gnu.gdk.Drawable
 * Method:    gdk_draw_rgb_image_dithalign
 * Signature: (IIIIIII[BIII)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Drawable_gdk_1draw_1rgb_1image_1dithalign (JNIEnv *env, 
    jclass cls, jint drawable, jint gc, jint x, jint y, jint width, jint height, jint dith, 
    jbyteArray rgbBuf, jint rowstride, jint xDith, jint yDith) 
{
    GdkDrawable *drawable_g = (GdkDrawable *)drawable;
    GdkGC *gc_g = (GdkGC *)gc;
    gint32 x_g = (gint32) x;
    gint32 y_g = (gint32) y;
    gint32 width_g = (gint32) width;
    gint32 height_g = (gint32) height;
    GdkRgbDither dith_g = (GdkRgbDither) dith;
    jint rgbBuf_len = (*env)->GetArrayLength(env, rgbBuf);
    gchar* rgbBuf_g = (gchar*)g_malloc(rgbBuf_len + 1);
    gint32 rowstride_g = (gint32) rowstride;
    gint32 xDith_g = (gint32) xDith;
    gint32 yDith_g = (gint32) yDith;
    (*env)->GetByteArrayRegion(env, rgbBuf, 0, rgbBuf_len, (jbyte*)rgbBuf_g);
    rgbBuf_g[rgbBuf_len] = 0;
    {
        gdk_draw_rgb_image_dithalign (drawable_g, gc_g, x_g, y_g, width_g, height_g, dith_g, 
            rgbBuf_g, rowstride_g, xDith_g, yDith_g);
    }
}

/*
 * Class:     org.gnu.gdk.Drawable
 * Method:    gdk_draw_rgb_32_image
 * Signature: (IIIIIII[BI)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Drawable_gdk_1draw_1rgb_132_1image (JNIEnv *env, jclass cls, 
    jint drawable, jint gc, jint x, jint y, jint width, jint height, jint dith, jbyteArray 
    rgbBuf, jint rowstride) 
{
    GdkDrawable *drawable_g = (GdkDrawable *)drawable;
    GdkGC *gc_g = (GdkGC *)gc;
    gint32 x_g = (gint32) x;
    gint32 y_g = (gint32) y;
    gint32 width_g = (gint32) width;
    gint32 height_g = (gint32) height;
    GdkRgbDither dith_g = (GdkRgbDither) dith;
    jint rgbBuf_len = (*env)->GetArrayLength(env, rgbBuf);
    gchar* rgbBuf_g = (gchar*)g_malloc(rgbBuf_len + 1);
    gint32 rowstride_g = (gint32) rowstride;
    (*env)->GetByteArrayRegion(env, rgbBuf, 0, rgbBuf_len, (jbyte*)rgbBuf_g);
    rgbBuf_g[rgbBuf_len] = 0;
    {
        gdk_draw_rgb_32_image (drawable_g, gc_g, x_g, y_g, width_g, height_g, dith_g, rgbBuf_g, 
            rowstride_g);
    }
}

/*
 * Class:     org.gnu.gdk.Drawable
 * Method:    gdk_draw_rgb_32_image_dithalign
 * Signature: (IIIIIII[BIII)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Drawable_gdk_1draw_1rgb_132_1image_1dithalign (JNIEnv *env, 
    jclass cls, jint drawable, jint gc, jint x, jint y, jint width, jint height, jint dith, 
    jbyteArray rgbBuf, jint rowstride, jint xDith, jint yDith) 
{
    GdkDrawable *drawable_g = (GdkDrawable *)drawable;
    GdkGC *gc_g = (GdkGC *)gc;
    gint32 x_g = (gint32) x;
    gint32 y_g = (gint32) y;
    gint32 width_g = (gint32) width;
    gint32 height_g = (gint32) height;
    GdkRgbDither dith_g = (GdkRgbDither) dith;
    jint rgbBuf_len = (*env)->GetArrayLength(env, rgbBuf);
    gchar* rgbBuf_g = (gchar*)g_malloc(rgbBuf_len + 1);
    gint32 rowstride_g = (gint32) rowstride;
    gint32 xDith_g = (gint32) xDith;
    gint32 yDith_g = (gint32) yDith;
    (*env)->GetByteArrayRegion(env, rgbBuf, 0, rgbBuf_len, (jbyte*)rgbBuf_g);
    rgbBuf_g[rgbBuf_len] = 0;
    {
        gdk_draw_rgb_32_image_dithalign (drawable_g, gc_g, x_g, y_g, width_g, height_g, dith_g, 
            rgbBuf_g, rowstride_g, xDith_g, yDith_g);
    }
}

/*
 * Class:     org.gnu.gdk.Drawable
 * Method:    gdk_draw_gray_image
 * Signature: (IIIIIII[BI)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Drawable_gdk_1draw_1gray_1image (JNIEnv *env, jclass cls, 
    jint drawable, jint gc, jint x, jint y, jint width, jint height, jint dith, jbyteArray 
    rgbBuf, jint rowstride) 
{
    GdkDrawable *drawable_g = (GdkDrawable *)drawable;
    GdkGC *gc_g = (GdkGC *)gc;
    gint32 x_g = (gint32) x;
    gint32 y_g = (gint32) y;
    gint32 width_g = (gint32) width;
    gint32 height_g = (gint32) height;
    GdkRgbDither dith_g = (GdkRgbDither) dith;
    jint rgbBuf_len = (*env)->GetArrayLength(env, rgbBuf);
    gchar* rgbBuf_g = (gchar*)g_malloc(rgbBuf_len + 1);
    gint32 rowstride_g = (gint32) rowstride;
    (*env)->GetByteArrayRegion(env, rgbBuf, 0, rgbBuf_len, (jbyte*)rgbBuf_g);
    rgbBuf_g[rgbBuf_len] = 0;
    {
        gdk_draw_gray_image (drawable_g, gc_g, x_g, y_g, width_g, height_g, dith_g, rgbBuf_g, 
            rowstride_g);
    }
}

/*
 * Class:     org.gnu.gdk.Drawable
 * Method:    gdk_draw_indexed_image
 * Signature: (IIIIIII[BII)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Drawable_gdk_1draw_1indexed_1image (JNIEnv *env, jclass cls, 
    jint drawable, jint gc, jint x, jint y, jint width, jint height, jint dith, jbyteArray buf, 
    jint rowstride, jint cmap) 
{
    GdkDrawable *drawable_g = (GdkDrawable *)drawable;
    GdkGC *gc_g = (GdkGC *)gc;
    gint32 x_g = (gint32) x;
    gint32 y_g = (gint32) y;
    gint32 width_g = (gint32) width;
    gint32 height_g = (gint32) height;
    GdkRgbDither dith_g = (GdkRgbDither) dith;
    jint buf_len = (*env)->GetArrayLength(env, buf);
    gchar* buf_g = (gchar*)g_malloc(buf_len + 1);
    gint32 rowstride_g = (gint32) rowstride;
    GdkRgbCmap *cmap_g = (GdkRgbCmap *)cmap;
    (*env)->GetByteArrayRegion(env, buf, 0, buf_len, (jbyte*)buf_g);
    buf_g[buf_len] = 0;
    {
        gdk_draw_indexed_image (drawable_g, gc_g, x_g, y_g, width_g, height_g, dith_g, buf_g, 
            rowstride_g, cmap_g);
    }
}

/*
 * Class:     org.gnu.gdk.Drawable
 * Method:    gdk_draw_polygon
 * Signature: (IIZ[Lint ;I)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Drawable_gdk_1draw_1polygon (JNIEnv *env, jclass cls, jint 
    window, jint gc, jboolean filled, jintArray points, jint numPoints) 
{
    GdkWindow *window_g = (GdkWindow *)window;
    GdkGC *gc_g = (GdkGC *)gc;
    gboolean filled_g = (gboolean) filled;
    gint *points_g_g = (gint *) (*env)->GetIntArrayElements (env, points, NULL);
    GdkPoint *points_g = (GdkPoint *)points_g_g;
    gint32 numPoints_g = (gint32) numPoints;
    {
        gdk_draw_polygon (window_g, gc_g, filled_g, points_g, numPoints_g);
        (*env)->ReleaseIntArrayElements (env, points, (jint*)points_g_g, 0);
    }
}

/*
 * Class:     org.gnu.gdk.Drawable
 * Method:    gdk_draw_drawable
 * Signature: (IIIIIIIII)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Drawable_gdk_1draw_1drawable (JNIEnv *env, jclass cls, jint 
    drawable, jint gc, jint src, jint xsrc, jint ysrc, jint xdest, jint ydest, jint width, jint 
    height) 
{
    GdkDrawable *drawable_g = (GdkDrawable *)drawable;
    GdkGC *gc_g = (GdkGC *)gc;
    GdkDrawable *src_g = (GdkDrawable *)src;
    gint32 xsrc_g = (gint32) xsrc;
    gint32 ysrc_g = (gint32) ysrc;
    gint32 xdest_g = (gint32) xdest;
    gint32 ydest_g = (gint32) ydest;
    gint32 width_g = (gint32) width;
    gint32 height_g = (gint32) height;
    {
        gdk_draw_drawable (drawable_g, gc_g, src_g, xsrc_g, ysrc_g, xdest_g, ydest_g, width_g, 
            height_g);
    }
}

/*
 * Class:     org.gnu.gdk.Drawable
 * Method:    gdk_draw_image
 * Signature: (IIIIIIIII)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Drawable_gdk_1draw_1image (JNIEnv *env, jclass cls, jint 
    drawable, jint gc, jint image, jint xsrc, jint ysrc, jint xdest, jint ydest, jint width, 
    jint height) 
{
    GdkDrawable *drawable_g = (GdkDrawable *)drawable;
    GdkGC *gc_g = (GdkGC *)gc;
    GdkImage *image_g = (GdkImage *)image;
    gint32 xsrc_g = (gint32) xsrc;
    gint32 ysrc_g = (gint32) ysrc;
    gint32 xdest_g = (gint32) xdest;
    gint32 ydest_g = (gint32) ydest;
    gint32 width_g = (gint32) width;
    gint32 height_g = (gint32) height;
    {
        gdk_draw_image (drawable_g, gc_g, image_g, xsrc_g, ysrc_g, xdest_g, ydest_g, width_g, 
            height_g);
    }
}

/*
 * Class:     org.gnu.gdk.Drawable
 * Method:    gdk_draw_points
 * Signature: (II[Lint ;I)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Drawable_gdk_1draw_1points (JNIEnv *env, jclass cls, jint 
    drawable, jint gc, jintArray points, jint numPoints) 
{
    GdkDrawable *drawable_g = (GdkDrawable *)drawable;
    GdkGC *gc_g = (GdkGC *)gc;
    gint *points_g_g = (gint *) (*env)->GetIntArrayElements (env, points, NULL);
    GdkPoint *points_g = (GdkPoint *)points_g_g;
    gint32 numPoints_g = (gint32) numPoints;
    {
        gdk_draw_points (drawable_g, gc_g, points_g, numPoints_g);
        (*env)->ReleaseIntArrayElements (env, points, (jint*)points_g_g, 0);
    }
}

/*
 * Class:     org.gnu.gdk.Drawable
 * Method:    gdk_draw_segments
 * Signature: (II[Lint ;I)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Drawable_gdk_1draw_1segments (JNIEnv *env, jclass cls, jint 
    drawable, jint gc, jintArray segments, jint numSegs) 
{
    GdkDrawable *drawable_g = (GdkDrawable *)drawable;
    GdkGC *gc_g = (GdkGC *)gc;
    gint *segments_g_g = (gint *) (*env)->GetIntArrayElements (env, segments, NULL);
    GdkSegment *segments_g = (GdkSegment *)segments_g_g;
    gint32 numSegs_g = (gint32) numSegs;
    {
        gdk_draw_segments (drawable_g, gc_g, segments_g, numSegs_g);
        (*env)->ReleaseIntArrayElements (env, segments, (jint*)segments_g_g, 0);
    }
}

/*
 * Class:     org.gnu.gdk.Drawable
 * Method:    gdk_draw_lines
 * Signature: (II[Lint ;I)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Drawable_gdk_1draw_1lines (JNIEnv *env, jclass cls, jint 
    window, jint gc, jintArray points, jint numPoints) 
{
    GdkWindow *window_g = (GdkWindow *)window;
    GdkGC *gc_g = (GdkGC *)gc;
    gint *points_g_g = (gint *) (*env)->GetIntArrayElements (env, points, NULL);
    GdkPoint *points_g = (GdkPoint *)points_g_g;
    gint32 numPoints_g = (gint32) numPoints;
    {
        gdk_draw_lines (window_g, gc_g, points_g, numPoints_g);
        (*env)->ReleaseIntArrayElements (env, points, (jint*)points_g_g, 0);
    }
}

/*
 * Class:     org.gnu.gdk.Drawable
 * Method:    gdk_draw_glyphs
 * Signature: (IIIIII)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Drawable_gdk_1draw_1glyphs (JNIEnv *env, jclass cls, jint 
    drawable, jint gc, jint font, jint x, jint y, jint glyphs) 
{
    GdkDrawable *drawable_g = (GdkDrawable *)drawable;
    GdkGC *gc_g = (GdkGC *)gc;
    PangoFont *font_g = (PangoFont *)font;
    gint32 x_g = (gint32) x;
    gint32 y_g = (gint32) y;
    PangoGlyphString *glyphs_g = (PangoGlyphString *)glyphs;
    {
        gdk_draw_glyphs (drawable_g, gc_g, font_g, x_g, y_g, glyphs_g);
    }
}

/*
 * Class:     org.gnu.gdk.Drawable
 * Method:    gdk_draw_layout_line
 * Signature: (IIIII)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Drawable_gdk_1draw_1layout_1line (JNIEnv *env, jclass cls, 
    jint drawable, jint gc, jint x, jint y, jint line) 
{
    GdkDrawable *drawable_g = (GdkDrawable *)drawable;
    GdkGC *gc_g = (GdkGC *)gc;
    gint32 x_g = (gint32) x;
    gint32 y_g = (gint32) y;
    PangoLayoutLine *line_g = (PangoLayoutLine *)line;
    {
        gdk_draw_layout_line (drawable_g, gc_g, x_g, y_g, line_g);
    }
}

/*
 * Class:     org.gnu.gdk.Drawable
 * Method:    gdk_draw_layout
 * Signature: (IIIII)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Drawable_gdk_1draw_1layout (JNIEnv *env, jclass cls, jint 
    drawable, jint gc, jint x, jint y, jint layout) 
{
    GdkDrawable *drawable_g = (GdkDrawable *)drawable;
    GdkGC *gc_g = (GdkGC *)gc;
    gint32 x_g = (gint32) x;
    gint32 y_g = (gint32) y;
    PangoLayout *layout_g = (PangoLayout *)layout;
    {
        gdk_draw_layout (drawable_g, gc_g, x_g, y_g, layout_g);
    }
}

/*
 * Class:     org.gnu.gdk.Drawable
 * Method:    gdk_draw_layout_line_with_colors
 * Signature: (IIIIIII)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Drawable_gdk_1draw_1layout_1line_1with_1colors (JNIEnv *env, 
    jclass cls, jint drawable, jint gc, jint x, jint y, jint line, jint foreground, jint 
    background) 
{
    GdkDrawable *drawable_g = (GdkDrawable *)drawable;
    GdkGC *gc_g = (GdkGC *)gc;
    gint32 x_g = (gint32) x;
    gint32 y_g = (gint32) y;
    PangoLayoutLine *line_g = (PangoLayoutLine *)line;
    GdkColor *foreground_g = (GdkColor *)foreground;
    GdkColor *background_g = (GdkColor *)background;
    {
        gdk_draw_layout_line_with_colors (drawable_g, gc_g, x_g, y_g, line_g, foreground_g, 
            background_g);
    }
}

/*
 * Class:     org.gnu.gdk.Drawable
 * Method:    gdk_draw_layout_with_colors
 * Signature: (IIIIIII)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Drawable_gdk_1draw_1layout_1with_1colors (JNIEnv *env, 
    jclass cls, jint drawable, jint gc, jint x, jint y, jint layout, jint foreground, jint 
    background) 
{
    GdkDrawable *drawable_g = (GdkDrawable *)drawable;
    GdkGC *gc_g = (GdkGC *)gc;
    gint32 x_g = (gint32) x;
    gint32 y_g = (gint32) y;
    PangoLayout *layout_g = (PangoLayout *)layout;
    GdkColor *foreground_g = (GdkColor *)foreground;
    GdkColor *background_g = (GdkColor *)background;
    {
        gdk_draw_layout_with_colors (drawable_g, gc_g, x_g, y_g, layout_g, foreground_g, 
            background_g);
    }
}

#ifdef __cplusplus
}

#endif
