/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <gdk/gdk.h>
#include "jg_jnu.h"

#ifdef __cplusplus
extern "C" 
{
#endif

/*
 * Class:     org.gnu.gdk.Colormap
 * Method:    gdk_colormap_get_type
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_Colormap_gdk_1colormap_1get_1type (JNIEnv *env, jclass 
    cls) 
{
    return (jint)gdk_colormap_get_type ();
}

/*
 * Class:     org.gnu.gdk.Colormap
 * Method:    gdk_colormap_new
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gdk_Colormap_gdk_1colormap_1new (JNIEnv *env, jclass cls, 
    jobject visual, jint allocate) 
{
    GdkVisual *visual_g = (GdkVisual *)getPointerFromHandle(env, visual);
    gint32 allocate_g = (gint32) allocate;
    return getHandleFromPointer(env, gdk_colormap_new (visual_g, allocate_g));
}

/*
 * Class:     org.gnu.gdk.Colormap
 * Method:    gdk_colormap_get_system
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gdk_Colormap_gdk_1colormap_1get_1system (JNIEnv *env, 
    jclass cls) 
{
    return getHandleFromPointer(env, gdk_colormap_get_system ());
}

/*
 * Class:     org.gnu.gdk.Colormap
 * Method:    gdk_colormap_alloc_colors
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_Colormap_gdk_1colormap_1alloc_1colors (JNIEnv *env, 
    jclass cls, jobject colormap, jobjectArray colors, jboolean writable, jboolean 
    bestMatch, jbooleanArray success) 
{
    GdkColormap *colormap_g = (GdkColormap *)getPointerFromHandle(env, colormap);
    GdkColor *colors_g = (GdkColor *)getPointerArrayFromHandles(env, colors);
    gboolean writable_g = (gboolean) writable;
    gboolean bestMatch_g = (gboolean) bestMatch;
    gboolean *success_g = (gboolean *) (*env)->GetBooleanArrayElements(env, success, NULL);
    jsize len = (*env)->GetArrayLength(env, colors);
    jint result_j = (jint) (gdk_colormap_alloc_colors (colormap_g, colors_g, len, 
                writable_g, bestMatch_g, success_g));
    (*env)->ReleaseBooleanArrayElements(env, success, (jboolean *)success_g, 0);
    return result_j;
}

/*
 * Class:     org.gnu.gdk.Colormap
 * Method:    gdk_colormap_alloc_color
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gdk_Colormap_gdk_1colormap_1alloc_1color (JNIEnv *env, 
    jclass cls, jobject colormap, jobject color, jboolean writable, jboolean best_match) 
{
    GdkColormap *colormap_g = (GdkColormap *)getPointerFromHandle(env, colormap);
    GdkColor *color_g = (GdkColor *)getPointerFromHandle(env, color);
    gboolean writable_g = (gboolean) writable;
    gboolean best_match_g = (gboolean) best_match;
    return (jboolean) (gdk_colormap_alloc_color (colormap_g, color_g, 
                writable_g, best_match_g));
}

/*
 * Class:     org.gnu.gdk.Colormap
 * Method:    gdk_colormap_free_colors
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Colormap_gdk_1colormap_1free_1colors (JNIEnv *env, 
    jclass cls, jobject colormap, jobjectArray colors) 
{
    GdkColormap *colormap_g = (GdkColormap *)getPointerFromHandle(env, colormap);
    GdkColor *colors_g = (GdkColor *)getPointerArrayFromHandles(env, colors);
    gdk_colormap_free_colors (colormap_g, colors_g, (*env)->GetArrayLength(env, colors));
}

/*
 * Class:     org.gnu.gdk.Colormap
 * Method:    gdk_colormap_query_color
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Colormap_gdk_1colormap_1query_1color (JNIEnv *env, 
    jclass cls, jobject colormap, jlong pixel, jobject result) 
{
    GdkColormap *colormap_g = (GdkColormap *)getPointerFromHandle(env, colormap);
    glong pixel_g = (glong) pixel;
    GdkColor *result_g = (GdkColor *)getPointerFromHandle(env, result);
    gdk_colormap_query_color (colormap_g, pixel_g, result_g);
}

/*
 * Class:     org.gnu.gdk.Colormap
 * Method:    gdk_colormap_get_visual
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gdk_Colormap_gdk_1colormap_1get_1visual (JNIEnv *env, 
    jclass cls, jobject colormap) 
{
    GdkColormap *colormap_g = (GdkColormap *)getPointerFromHandle(env, colormap);
    return getHandleFromPointer(env, gdk_colormap_get_visual (colormap_g));
}


#ifdef __cplusplus
}

#endif
