/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import org.gnu.glib.Handle;
import org.gnu.glib.Type;

/**
 *
 */
public class TearoffMenuItem extends MenuItem 
{
	/**
	 * Construct a new TearoffMenuItem
	 */
	public TearoffMenuItem() {
		super(gtk_tearoff_menu_item_new());
	}
	
	/**
	 * Construct a TearoffMenuItem using a handle to a native resource.
	 */
	public TearoffMenuItem(Handle handle) {
	    super(handle);
	}

	public boolean getTornOff() {
		return getTornOff(getHandle());
	}
	
	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_tearoff_menu_item_get_type());
	}

    native static final protected int gtk_tearoff_menu_item_get_type ();
    native static final protected Handle gtk_tearoff_menu_item_new ();
    native static final protected boolean getTornOff(Handle menu);
}

