/*
 * Java-Gnome Bindings Library
 *
 * * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */
package org.gnu.gtk;

import org.gnu.gdk.EventKey;
import org.gnu.gdk.KeySymbol;
import org.gnu.gdk.ModifierType;
import org.gnu.glib.MemStruct;
import org.gnu.javagnome.Handle;

/**
 * Key bindings for individual widgets.
 * TODO: Complete javadocs. 
 */
public class BindingSet extends MemStruct {
	
	/**
	 * Construct a new BindingSet using a handle to a native resource.
	 */
	private BindingSet(Handle handle) {
		super(handle);
	}
	
	/**
	 * Construct a new BindingSet.
	 * @param setName The name of the BindingSet
	 */
	public BindingSet(String setName) {
		super(gtk_binding_set_new(setName));
	}
	
	/**
	 * Finds a BindingSet object given the name.
	 * @param setName The name of the BindingSet to find
	 * @return A BindingSet object
	 */
	static public BindingSet findBindingSet(String setName) {
        Handle handle = gtk_binding_set_find(setName);
        BindingSet bSet;
        if (handle == null) {
            return null;
        }
        bSet = (BindingSet) getMemStructFromHandle(handle);
        if (bSet == null) {
            bSet = new BindingSet(handle);
        }
        return bSet;
	}
	
	/**
	 * 
	 * @param keyval The key value for the BindingSet.
	 * @param modifier The key modifier for the BindingSet
	 */
	public boolean activateBindings(KeySymbol keyval, ModifierType modifier) {
        return gtk_bindings_activate(getHandle(), keyval.getValue(), modifier.getValue());
	}
	
	/**
	 * 
	 * @param keyval The key value for the BindingSet.
	 * @param modifier The key modifier for the BindingSet
	 */
	public boolean activateBindingSet(KeySymbol keyval, ModifierType modifier) {
		return gtk_binding_set_activate(getHandle(), keyval.getValue(), modifier.getValue(), getHandle());
	}
	
	/**
	 * Clears a BindingSet entry.
	 * @param keyval The key value for the BindingSet.
	 * @param modifier The key modifier for the BindingSet
	 */
	public void clearEntry(KeySymbol keyval, ModifierType modifier) {
		gtk_binding_entry_clear(getHandle(), keyval.getValue(), modifier.getValue());
	}
	
	/**
	 *  
	 * @param pathType
	 * @param pathPattern
	 * @param priority
	 */
	public void addPath(PathType pathType, String pathPattern, PathPriorityType priority) {
		gtk_binding_set_add_path(getHandle(), pathType.getValue(), pathPattern, priority.getValue());
	}
	
    /**
     * Looks up key bindings for this BindingSet to find one that matches
     * <tt>event</tt>, and if one was found, activate it.
     *
     * @return TRUE if a matching key binding was found.
     */
    public boolean activateEvent( EventKey event ) {
        return gtk_bindings_activate_event( getHandle(), event.getHandle() );
    }
    /**
     * 
     */
    public void removeEntry(KeySymbol keyval, ModifierType modifier) {
        gtk_binding_entry_remove(getHandle(), keyval.getValue(), modifier.getValue());
    }

	native static final protected Handle gtk_binding_set_new(String setName);
	native static final protected Handle gtk_binding_set_find(String setName);
	native static final protected boolean gtk_bindings_activate(Handle object, int keyval, int modifier);
	native static final protected boolean gtk_binding_set_activate(Handle bindingSet, int keyval, int modifier, Handle object);
	native static final protected void gtk_binding_entry_clear(Handle bindingSet, int keyval, int modifier);
	native static final protected void gtk_binding_set_add_path(Handle bindingSet, int pathType, String pathPattern, int priority);

    native static final private boolean gtk_bindings_activate_event(Handle object, Handle event);
    native static final private void gtk_binding_entry_remove(Handle binding_set, int keyval, int modifiers);

}
