/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.pango;

import org.gnu.glib.Handle;
import org.gnu.glib.MemStruct;

/**
 * The PangoRectangle structure represents a rectangle. It is
 * frequently used to represent the logical or ink extents of a single
 * glyph or section of text.
 */
public class Rectangle extends MemStruct
{

    protected Rectangle(Handle handle){
        super(handle);
    }

    /**
     * Create a new rectangle with x=y=width=height=0.
     */
    public Rectangle() {
        super(pango_rectangle_new(0, 0, 0, 0));
    }
    /**
     * Create a new rectangle with the given x, y, width and height
     * parameters.
     */
    public Rectangle(int x, int y, int width, int height) {
        super(pango_rectangle_new(x, y, width, height));
    }

    /**
     * Returns X coordinate of the left side of the rectangle.
     */
    public int getX(){
        return getX(getHandle());
    }

    /**
     * Returns Y coordinate of the the top side of the rectangle.
     */
    public int getY(){
        return getY(getHandle());
    }

    /**
     * Returns width of the rectangle.
     */
    public int getWidth(){
        return getWidth(getHandle());
    }

    /**
     * Returns height of the rectangle.
     */
    public int getHeight(){
        return getHeight(getHandle());
    }	
		
    /**
     * Package private helper method.
     */
    static Rectangle getRectangleFromHandle( Handle hndl ) {
        if ( hndl != null ) {
            MemStruct obj = MemStruct.getMemStructFromHandle( hndl );
            return ( obj != null ) ? (Rectangle)obj : new Rectangle(hndl);
        }
        return null;
    }

    native static final protected Handle pango_rectangle_new(int x, int y, int width, int height);
    native static final protected int getX (Handle obj);
    native static final protected int getY (Handle obj);
    native static final protected int getWidth (Handle obj);
    native static final protected int getHeight (Handle obj);
}

