// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKSOURCEVIEWMM_SOURCETAG_H
#define _GTKSOURCEVIEWMM_SOURCETAG_H


#include <glibmm.h>

/* sourcetag.hg
 * 
 *
 * Copyright (C) 2004-2005 Jae Jang
 * Copyright (C) 2005-2006 Rob Page
 * Copyright (C)2006 Dodji Seketeli
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/// \file
/// \brief SourceTag class
///

#include <glibmm/slisthandle.h>
#include <gtkmm/textbuffer.h>
#include <gtksourceviewmm/sourcetagstyle.h>
#include <gtksourceview/gtksourcetag.h>


/// \page patternpage Grammar of SourceTag related patterns
/// \section introduction
/// the format of the SourceTag patterns is the POSIX
/// Extended Regular Expression Syntax, plus GNU operators (word operators
/// and buffer operators). Look at the GNU grep man pages for more about the
/// the precise syntax.


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkSourceTag GtkSourceTag;
typedef struct _GtkSourceTagClass GtkSourceTagClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace gtksourceview
{ class SourceTag_Class; } // namespace gtksourceview
namespace gtksourceview
{
/// \brief An attribute that can be applied to a range of text.
///
/// A tag is a an attribute that can be applied to a range of text
/// One can associate style information to a given Tag.
/// For example, a tag might be called "bold" and might make the text
/// inside the tag bold.
/// GtkSourceView uses SourceTag to perform syntax highlighting.
///

class SourceTag : public Gtk::TextTag
{
    
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef SourceTag CppObjectType;
  typedef SourceTag_Class CppClassType;
  typedef GtkSourceTag BaseObjectType;
  typedef GtkSourceTagClass BaseClassType;

private:  friend class SourceTag_Class;
  static CppClassType sourcetag_class_;

private:
  // noncopyable
  SourceTag(const SourceTag&);
  SourceTag& operator=(const SourceTag&);

protected:
  explicit SourceTag(const Glib::ConstructParams& construct_params);
  explicit SourceTag(GtkSourceTag* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~SourceTag();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkSourceTag*       gobj()       { return reinterpret_cast<GtkSourceTag*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkSourceTag* gobj() const { return reinterpret_cast<GtkSourceTag*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkSourceTag* gobj_copy();

private:


protected:
    SourceTag();

public:

    /// \brief create a syntax tag.
    ///
    /// A syntax tag is a tag that applies to a region of text.
    /// The region is identified by a starting pattern and an ending pattern.
    /// \param a_id the ID of the tag. That ID must be unique accross all the
    /// tag IDs.
    /// \param a_name the name of the tag. Can be translatable.
    /// \param a_pat_start the regular expression pattern
    /// that describes the beginning of the region
    /// the tag applied to. See \ref patternpage for more about the syntax.
    /// \param a_pat_end the pattern that describes the end of the region.
    /// \return the newly created SourceTag
    static Glib::RefPtr<SourceTag> create_syntax_tag (const Glib::ustring &a_id,
                                                      const Glib::ustring &a_name,
                                                      const Glib::ustring &a_pat_start,
                                                      const Glib::ustring &a_pat_end);
    

    /// \brief create a pattern tag.
    ///
    /// A pattern tag is a tag that applies to a word (keyword, or term).
    /// In this case The word is represented by a regular expression pattern.
    /// \param a_id the id of the tag. Must be unique accross all the pattter ids.
    /// \param a_name the name of the tag. Is a translatable string.
    /// \param a_pattern the word pattern.
    static Glib::RefPtr<SourceTag> create_pattern_tag (const Glib::ustring &a_id,
                                                       const Glib::ustring &a_name,
                                                       const Glib::ustring &a_pattern);
    

    /// \brief create a tag for a list of keywords.
    ///
    /// This is a more user friendly wrapper to SourceTag::create_pattern_tag() .
    /// \param a_id the ID of the tag. Must be unique accross all tag IDs.
    /// \param a_name the name of the tag. Can be a translated string.
    /// \param a_keywords the list of keyword the tag applies to.
    /// \param a_case_sensitive wether the tag should match the keywords
    /// in a case sentive context or not.
    /// \param a_match_empty_string_at_beginning whether the tag should match
    /// an empty string at the beginning of keywords or not.
    /// \param a_match_empty_string_at_end wether the tag should match the
    /// an empty string at the end of keywords or not.
    /// \param a_beginning_regex a regex that that describes a  pattern that can
    /// be present at the beginning of each keyword. If you don't understand what this is,
    /// just let it be.
    /// \param a_end_regex same as a_beginning_regex but applies for a pattern at
    /// the end the keywords.
    /// \return the newly created SourceTag
    static Glib::RefPtr<SourceTag> create_keyword_list_tag (const Glib::ustring &a_id,
                                                            const Glib::ustring &a_name,
                                                            const Glib::SListHandle<const Glib::ustring> &a_keywords,
                                                            bool a_case_sensitive=true,
                                                            bool a_match_empty_string_at_beginning=true,
                                                            bool a_match_empty_string_at_end=true,
                                                            const Glib::ustring &a_beginning_regex="",
                                                            const Glib::ustring &a_end_regex="") ;
    

    /// \brief create a tag for a comment.
    ///
    /// This is a user friendly way to create a syntax tag for a one liner comment.
    /// \param a_id the ID of the of the tag. Must be unique accross all tag IDs.
    /// \param a_name the name of the tag. Can be a translated string.
    /// \param a_pattern_start the pattern of the beginning of the commented line.
    /// the tag will applied to the region located between by a_patter_start and the end of line.
    /// \return the newly created SourceTag
    static Glib::RefPtr<SourceTag> create_line_comment_tag_new (const Glib::ustring &a_id,
                                                                const Glib::ustring &a_name,
                                                                const Glib::ustring &a_pattern_start) ;
    

    /// \brief create a tag for a string delimited by two patterns.
    ///
    /// \param a_id the ID of the tag. Must be unique accross all tag IDs.
    /// \param a_name the name of the tag. Can be a translated string.
    /// \param a_pattern_start the starting pattern of the string.
    /// \param a_pattern_end the ending pattern of the string.
    /// \param a_end_at_line_end whether the ending pattern should be suffixed
    ///  by an end of line character.
    static Glib::RefPtr<SourceTag> create_string_tag_new (const Glib::ustring &a_id,
                                                          const Glib::ustring &a_name,
                                                          const Glib::ustring &a_pattern_start,
                                                          const Glib::ustring &a_pattern_end,
                                                          bool a_end_at_line_end=true) ;
    

    /// \brief getter of the tag ID.
    ///
    /// \return the ID
    
  Glib::ustring get_id() const;

    /// \brief getter of the tag style.
    ///
    /// \return the style
    
  SourceTagStyle get_style() const;

    /// \brief setter of the tag style.
    ///
    /// \param a_style the new style
    
  void set_style(const SourceTagStyle& a_style);


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};//end class SourceTag

}//end namespace gtksourceview


namespace Glib
{
  /** @relates gtksourceview::SourceTag
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Glib::RefPtr<gtksourceview::SourceTag> wrap(GtkSourceTag* object, bool take_copy = false);
}


#endif /* _GTKSOURCEVIEWMM_SOURCETAG_H */

