/* $Id: write.c,v 1.6 1998/06/18 10:22:37 martin Exp $ */

/* Copyright (C) 1995, 1996, 1997 Free Software Foundation, Inc.
   This file is part of the Gnome Top Library.
   Contributed by Martin Baulig <martin@home-of-linux.org>, April 1998.

   The Gnome Top Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The Gnome Top Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

#include <glibtop/write.h>

/* Writes some data to server. */

void
glibtop_write_l (glibtop *server, size_t size, void *buf)
{
	int ret;

	glibtop_init_r (&server, 0, 0);

	if (size == 0) return;

#ifdef DEBUG
	fprintf (stderr, "LIBRARY: really writing %d bytes.\n", size);
#endif

	if (server->socket) {
		ret = send (server->socket, buf, size, 0);
	} else {
		ret = write (server->output [1], buf, size);
	}

	if (ret < 0)
		glibtop_error_io_r (server, _("write %d bytes"), size);
}
