/* $Id: glibtop_suid.h,v 1.2 1998/08/25 08:09:48 martin Exp $ */

/* Copyright (C) 1995, 1996, 1997 Free Software Foundation, Inc.
   This file is part of the Gnome Top Library.
   Contributed by Martin Baulig <martin@home-of-linux.org>, April 1998.

   The Gnome Top Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The Gnome Top Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

#ifndef __GLIBTOP_SUID_H__
#define __GLIBTOP_SUID_H__

__BEGIN_DECLS

static inline void glibtop_suid_enter (glibtop *server) {
	setregid (server->machine.gid, server->machine.egid);
};

static inline void glibtop_suid_leave (glibtop *server) {
	if (setregid (server->machine.egid, server->machine.gid))
		_exit (1);
};

extern void glibtop_init_p __P((glibtop *, const unsigned long, const unsigned));

extern void glibtop_open_p __P((glibtop *, const char *, const unsigned long, const unsigned));

__END_DECLS

#endif
