/* demarshal.c */
/* This is a generated file.  Please modify `demarshal.pl' */

#include <glibtop.h>
#include <glibtop/open.h>
#include <glibtop/xmalloc.h>

#include <glibtop/sysdeps.h>
#include <glibtop/union.h>

#include <glibtop/backend.h>

#include <glibtop-backend-private.h>
#include "server.h"

#if GLIBTOP_SUID_CPU

static int
_glibtop_demarshal_cpu_i (glibtop *server, glibtop_backend *backend, const void *send_ptr, size_t send_size, void *data_ptr, size_t data_size, void **recv_buf_ptr, size_t *recv_size_ptr, void **recv_data_ptr, size_t *recv_data_size_ptr, int *retval_ptr)
{
	size_t _LIBGTOP_SEND_len, _LIBGTOP_RECV_len;
	off_t _LIBGTOP_SEND_offset;
	char *_LIBGTOP_RECV_buf, *_LIBGTOP_RECV_ptr;
	const char *_LIBGTOP_SEND_ptr;
	glibtop_cpu cpu;
	int retval = (int) 0;

	/* variable initialization */
	memset (&cpu, 0, sizeof (glibtop_cpu));
	_LIBGTOP_SEND_offset = 0;
	_LIBGTOP_SEND_ptr = (char *) send_ptr;

	/* send size */
	_LIBGTOP_SEND_len = 0;
	if (_LIBGTOP_SEND_len != send_size)
		return -GLIBTOP_ERROR_DEMARSHAL_ERROR;

	/* recv size */
	_LIBGTOP_RECV_len = 0;
	_LIBGTOP_RECV_len += sizeof (glibtop_cpu);

	/* recv buffer */
	_LIBGTOP_RECV_buf = glibtop_malloc_r (server, _LIBGTOP_RECV_len);
	_LIBGTOP_RECV_ptr = _LIBGTOP_RECV_buf;

	retval = glibtop_get_cpu_p (server, &cpu);
	if (retval_ptr)
		*retval_ptr = retval;

	/* write recv buffer */
	memcpy (_LIBGTOP_RECV_ptr, &cpu, sizeof (glibtop_cpu));
	_LIBGTOP_RECV_ptr += sizeof (glibtop_cpu);

	*recv_buf_ptr = _LIBGTOP_RECV_buf;
	*recv_size_ptr = _LIBGTOP_RECV_len;

	return 0;
}

#endif /* GLIBTOP_SUID_CPU */


#if GLIBTOP_SUID_MEM

static int
_glibtop_demarshal_mem_i (glibtop *server, glibtop_backend *backend, const void *send_ptr, size_t send_size, void *data_ptr, size_t data_size, void **recv_buf_ptr, size_t *recv_size_ptr, void **recv_data_ptr, size_t *recv_data_size_ptr, int *retval_ptr)
{
	size_t _LIBGTOP_SEND_len, _LIBGTOP_RECV_len;
	off_t _LIBGTOP_SEND_offset;
	char *_LIBGTOP_RECV_buf, *_LIBGTOP_RECV_ptr;
	const char *_LIBGTOP_SEND_ptr;
	glibtop_mem mem;
	int retval = (int) 0;

	/* variable initialization */
	memset (&mem, 0, sizeof (glibtop_mem));
	_LIBGTOP_SEND_offset = 0;
	_LIBGTOP_SEND_ptr = (char *) send_ptr;

	/* send size */
	_LIBGTOP_SEND_len = 0;
	if (_LIBGTOP_SEND_len != send_size)
		return -GLIBTOP_ERROR_DEMARSHAL_ERROR;

	/* recv size */
	_LIBGTOP_RECV_len = 0;
	_LIBGTOP_RECV_len += sizeof (glibtop_mem);

	/* recv buffer */
	_LIBGTOP_RECV_buf = glibtop_malloc_r (server, _LIBGTOP_RECV_len);
	_LIBGTOP_RECV_ptr = _LIBGTOP_RECV_buf;

	retval = glibtop_get_mem_p (server, &mem);
	if (retval_ptr)
		*retval_ptr = retval;

	/* write recv buffer */
	memcpy (_LIBGTOP_RECV_ptr, &mem, sizeof (glibtop_mem));
	_LIBGTOP_RECV_ptr += sizeof (glibtop_mem);

	*recv_buf_ptr = _LIBGTOP_RECV_buf;
	*recv_size_ptr = _LIBGTOP_RECV_len;

	return 0;
}

#endif /* GLIBTOP_SUID_MEM */


#if GLIBTOP_SUID_SWAP

static int
_glibtop_demarshal_swap_i (glibtop *server, glibtop_backend *backend, const void *send_ptr, size_t send_size, void *data_ptr, size_t data_size, void **recv_buf_ptr, size_t *recv_size_ptr, void **recv_data_ptr, size_t *recv_data_size_ptr, int *retval_ptr)
{
	size_t _LIBGTOP_SEND_len, _LIBGTOP_RECV_len;
	off_t _LIBGTOP_SEND_offset;
	char *_LIBGTOP_RECV_buf, *_LIBGTOP_RECV_ptr;
	const char *_LIBGTOP_SEND_ptr;
	glibtop_swap swap;
	int retval = (int) 0;

	/* variable initialization */
	memset (&swap, 0, sizeof (glibtop_swap));
	_LIBGTOP_SEND_offset = 0;
	_LIBGTOP_SEND_ptr = (char *) send_ptr;

	/* send size */
	_LIBGTOP_SEND_len = 0;
	if (_LIBGTOP_SEND_len != send_size)
		return -GLIBTOP_ERROR_DEMARSHAL_ERROR;

	/* recv size */
	_LIBGTOP_RECV_len = 0;
	_LIBGTOP_RECV_len += sizeof (glibtop_swap);

	/* recv buffer */
	_LIBGTOP_RECV_buf = glibtop_malloc_r (server, _LIBGTOP_RECV_len);
	_LIBGTOP_RECV_ptr = _LIBGTOP_RECV_buf;

	retval = glibtop_get_swap_p (server, &swap);
	if (retval_ptr)
		*retval_ptr = retval;

	/* write recv buffer */
	memcpy (_LIBGTOP_RECV_ptr, &swap, sizeof (glibtop_swap));
	_LIBGTOP_RECV_ptr += sizeof (glibtop_swap);

	*recv_buf_ptr = _LIBGTOP_RECV_buf;
	*recv_size_ptr = _LIBGTOP_RECV_len;

	return 0;
}

#endif /* GLIBTOP_SUID_SWAP */


#if GLIBTOP_SUID_UPTIME

static int
_glibtop_demarshal_uptime_i (glibtop *server, glibtop_backend *backend, const void *send_ptr, size_t send_size, void *data_ptr, size_t data_size, void **recv_buf_ptr, size_t *recv_size_ptr, void **recv_data_ptr, size_t *recv_data_size_ptr, int *retval_ptr)
{
	size_t _LIBGTOP_SEND_len, _LIBGTOP_RECV_len;
	off_t _LIBGTOP_SEND_offset;
	char *_LIBGTOP_RECV_buf, *_LIBGTOP_RECV_ptr;
	const char *_LIBGTOP_SEND_ptr;
	glibtop_uptime uptime;
	int retval = (int) 0;

	/* variable initialization */
	memset (&uptime, 0, sizeof (glibtop_uptime));
	_LIBGTOP_SEND_offset = 0;
	_LIBGTOP_SEND_ptr = (char *) send_ptr;

	/* send size */
	_LIBGTOP_SEND_len = 0;
	if (_LIBGTOP_SEND_len != send_size)
		return -GLIBTOP_ERROR_DEMARSHAL_ERROR;

	/* recv size */
	_LIBGTOP_RECV_len = 0;
	_LIBGTOP_RECV_len += sizeof (glibtop_uptime);

	/* recv buffer */
	_LIBGTOP_RECV_buf = glibtop_malloc_r (server, _LIBGTOP_RECV_len);
	_LIBGTOP_RECV_ptr = _LIBGTOP_RECV_buf;

	retval = glibtop_get_uptime_p (server, &uptime);
	if (retval_ptr)
		*retval_ptr = retval;

	/* write recv buffer */
	memcpy (_LIBGTOP_RECV_ptr, &uptime, sizeof (glibtop_uptime));
	_LIBGTOP_RECV_ptr += sizeof (glibtop_uptime);

	*recv_buf_ptr = _LIBGTOP_RECV_buf;
	*recv_size_ptr = _LIBGTOP_RECV_len;

	return 0;
}

#endif /* GLIBTOP_SUID_UPTIME */


#if GLIBTOP_SUID_LOADAVG

static int
_glibtop_demarshal_loadavg_i (glibtop *server, glibtop_backend *backend, const void *send_ptr, size_t send_size, void *data_ptr, size_t data_size, void **recv_buf_ptr, size_t *recv_size_ptr, void **recv_data_ptr, size_t *recv_data_size_ptr, int *retval_ptr)
{
	size_t _LIBGTOP_SEND_len, _LIBGTOP_RECV_len;
	off_t _LIBGTOP_SEND_offset;
	char *_LIBGTOP_RECV_buf, *_LIBGTOP_RECV_ptr;
	const char *_LIBGTOP_SEND_ptr;
	glibtop_loadavg loadavg;
	int retval = (int) 0;

	/* variable initialization */
	memset (&loadavg, 0, sizeof (glibtop_loadavg));
	_LIBGTOP_SEND_offset = 0;
	_LIBGTOP_SEND_ptr = (char *) send_ptr;

	/* send size */
	_LIBGTOP_SEND_len = 0;
	if (_LIBGTOP_SEND_len != send_size)
		return -GLIBTOP_ERROR_DEMARSHAL_ERROR;

	/* recv size */
	_LIBGTOP_RECV_len = 0;
	_LIBGTOP_RECV_len += sizeof (glibtop_loadavg);

	/* recv buffer */
	_LIBGTOP_RECV_buf = glibtop_malloc_r (server, _LIBGTOP_RECV_len);
	_LIBGTOP_RECV_ptr = _LIBGTOP_RECV_buf;

	retval = glibtop_get_loadavg_p (server, &loadavg);
	if (retval_ptr)
		*retval_ptr = retval;

	/* write recv buffer */
	memcpy (_LIBGTOP_RECV_ptr, &loadavg, sizeof (glibtop_loadavg));
	_LIBGTOP_RECV_ptr += sizeof (glibtop_loadavg);

	*recv_buf_ptr = _LIBGTOP_RECV_buf;
	*recv_size_ptr = _LIBGTOP_RECV_len;

	return 0;
}

#endif /* GLIBTOP_SUID_LOADAVG */


#if GLIBTOP_SUID_SHM_LIMITS

static int
_glibtop_demarshal_shm_limits_i (glibtop *server, glibtop_backend *backend, const void *send_ptr, size_t send_size, void *data_ptr, size_t data_size, void **recv_buf_ptr, size_t *recv_size_ptr, void **recv_data_ptr, size_t *recv_data_size_ptr, int *retval_ptr)
{
	size_t _LIBGTOP_SEND_len, _LIBGTOP_RECV_len;
	off_t _LIBGTOP_SEND_offset;
	char *_LIBGTOP_RECV_buf, *_LIBGTOP_RECV_ptr;
	const char *_LIBGTOP_SEND_ptr;
	glibtop_shm_limits shm_limits;
	int retval = (int) 0;

	/* variable initialization */
	memset (&shm_limits, 0, sizeof (glibtop_shm_limits));
	_LIBGTOP_SEND_offset = 0;
	_LIBGTOP_SEND_ptr = (char *) send_ptr;

	/* send size */
	_LIBGTOP_SEND_len = 0;
	if (_LIBGTOP_SEND_len != send_size)
		return -GLIBTOP_ERROR_DEMARSHAL_ERROR;

	/* recv size */
	_LIBGTOP_RECV_len = 0;
	_LIBGTOP_RECV_len += sizeof (glibtop_shm_limits);

	/* recv buffer */
	_LIBGTOP_RECV_buf = glibtop_malloc_r (server, _LIBGTOP_RECV_len);
	_LIBGTOP_RECV_ptr = _LIBGTOP_RECV_buf;

	retval = glibtop_get_shm_limits_p (server, &shm_limits);
	if (retval_ptr)
		*retval_ptr = retval;

	/* write recv buffer */
	memcpy (_LIBGTOP_RECV_ptr, &shm_limits, sizeof (glibtop_shm_limits));
	_LIBGTOP_RECV_ptr += sizeof (glibtop_shm_limits);

	*recv_buf_ptr = _LIBGTOP_RECV_buf;
	*recv_size_ptr = _LIBGTOP_RECV_len;

	return 0;
}

#endif /* GLIBTOP_SUID_SHM_LIMITS */


#if GLIBTOP_SUID_MSG_LIMITS

static int
_glibtop_demarshal_msg_limits_i (glibtop *server, glibtop_backend *backend, const void *send_ptr, size_t send_size, void *data_ptr, size_t data_size, void **recv_buf_ptr, size_t *recv_size_ptr, void **recv_data_ptr, size_t *recv_data_size_ptr, int *retval_ptr)
{
	size_t _LIBGTOP_SEND_len, _LIBGTOP_RECV_len;
	off_t _LIBGTOP_SEND_offset;
	char *_LIBGTOP_RECV_buf, *_LIBGTOP_RECV_ptr;
	const char *_LIBGTOP_SEND_ptr;
	glibtop_msg_limits msg_limits;
	int retval = (int) 0;

	/* variable initialization */
	memset (&msg_limits, 0, sizeof (glibtop_msg_limits));
	_LIBGTOP_SEND_offset = 0;
	_LIBGTOP_SEND_ptr = (char *) send_ptr;

	/* send size */
	_LIBGTOP_SEND_len = 0;
	if (_LIBGTOP_SEND_len != send_size)
		return -GLIBTOP_ERROR_DEMARSHAL_ERROR;

	/* recv size */
	_LIBGTOP_RECV_len = 0;
	_LIBGTOP_RECV_len += sizeof (glibtop_msg_limits);

	/* recv buffer */
	_LIBGTOP_RECV_buf = glibtop_malloc_r (server, _LIBGTOP_RECV_len);
	_LIBGTOP_RECV_ptr = _LIBGTOP_RECV_buf;

	retval = glibtop_get_msg_limits_p (server, &msg_limits);
	if (retval_ptr)
		*retval_ptr = retval;

	/* write recv buffer */
	memcpy (_LIBGTOP_RECV_ptr, &msg_limits, sizeof (glibtop_msg_limits));
	_LIBGTOP_RECV_ptr += sizeof (glibtop_msg_limits);

	*recv_buf_ptr = _LIBGTOP_RECV_buf;
	*recv_size_ptr = _LIBGTOP_RECV_len;

	return 0;
}

#endif /* GLIBTOP_SUID_MSG_LIMITS */


#if GLIBTOP_SUID_SEM_LIMITS

static int
_glibtop_demarshal_sem_limits_i (glibtop *server, glibtop_backend *backend, const void *send_ptr, size_t send_size, void *data_ptr, size_t data_size, void **recv_buf_ptr, size_t *recv_size_ptr, void **recv_data_ptr, size_t *recv_data_size_ptr, int *retval_ptr)
{
	size_t _LIBGTOP_SEND_len, _LIBGTOP_RECV_len;
	off_t _LIBGTOP_SEND_offset;
	char *_LIBGTOP_RECV_buf, *_LIBGTOP_RECV_ptr;
	const char *_LIBGTOP_SEND_ptr;
	glibtop_sem_limits sem_limits;
	int retval = (int) 0;

	/* variable initialization */
	memset (&sem_limits, 0, sizeof (glibtop_sem_limits));
	_LIBGTOP_SEND_offset = 0;
	_LIBGTOP_SEND_ptr = (char *) send_ptr;

	/* send size */
	_LIBGTOP_SEND_len = 0;
	if (_LIBGTOP_SEND_len != send_size)
		return -GLIBTOP_ERROR_DEMARSHAL_ERROR;

	/* recv size */
	_LIBGTOP_RECV_len = 0;
	_LIBGTOP_RECV_len += sizeof (glibtop_sem_limits);

	/* recv buffer */
	_LIBGTOP_RECV_buf = glibtop_malloc_r (server, _LIBGTOP_RECV_len);
	_LIBGTOP_RECV_ptr = _LIBGTOP_RECV_buf;

	retval = glibtop_get_sem_limits_p (server, &sem_limits);
	if (retval_ptr)
		*retval_ptr = retval;

	/* write recv buffer */
	memcpy (_LIBGTOP_RECV_ptr, &sem_limits, sizeof (glibtop_sem_limits));
	_LIBGTOP_RECV_ptr += sizeof (glibtop_sem_limits);

	*recv_buf_ptr = _LIBGTOP_RECV_buf;
	*recv_size_ptr = _LIBGTOP_RECV_len;

	return 0;
}

#endif /* GLIBTOP_SUID_SEM_LIMITS */


#if GLIBTOP_SUID_PROCLIST

static int
_glibtop_demarshal_proclist_i (glibtop *server, glibtop_backend *backend, const void *send_ptr, size_t send_size, void *data_ptr, size_t data_size, void **recv_buf_ptr, size_t *recv_size_ptr, void **recv_data_ptr, size_t *recv_data_size_ptr, int *retval_ptr)
{
	size_t _LIBGTOP_SEND_len, _LIBGTOP_RECV_len;
	off_t _LIBGTOP_SEND_offset;
	char *_LIBGTOP_RECV_buf, *_LIBGTOP_RECV_ptr;
	const char *_LIBGTOP_SEND_ptr;
	glibtop_proclist proclist;
	unsigned * retval = (unsigned *) 0;
	int64_t _LIBGTOP_demarshal_which;
	int64_t _LIBGTOP_demarshal_arg;
	glibtop_array array;

	/* variable initialization */
	memset (&proclist, 0, sizeof (glibtop_proclist));
	_LIBGTOP_SEND_offset = 0;
	_LIBGTOP_SEND_ptr = (char *) send_ptr;
	memset (&_LIBGTOP_demarshal_which, 0, sizeof (int64_t));
	memset (&_LIBGTOP_demarshal_arg, 0, sizeof (int64_t));

	/* send size */
	_LIBGTOP_SEND_len = 0;
	_LIBGTOP_SEND_len += sizeof (int64_t);
	_LIBGTOP_SEND_len += sizeof (int64_t);
	if (_LIBGTOP_SEND_len != send_size)
		return -GLIBTOP_ERROR_DEMARSHAL_ERROR;

	/* recv size */
	_LIBGTOP_RECV_len = 0;
	_LIBGTOP_RECV_len += sizeof (glibtop_array);

	/* recv buffer */
	_LIBGTOP_RECV_buf = glibtop_malloc_r (server, _LIBGTOP_RECV_len);
	_LIBGTOP_RECV_ptr = _LIBGTOP_RECV_buf;

	/* demarshal start */
	_LIBGTOP_SEND_ptr = (char *) send_ptr + _LIBGTOP_SEND_offset;
	memcpy (&_LIBGTOP_demarshal_which, _LIBGTOP_SEND_ptr, sizeof (int64_t));
	_LIBGTOP_SEND_offset += sizeof (int64_t);
	_LIBGTOP_SEND_ptr = (char *) send_ptr + _LIBGTOP_SEND_offset;
	memcpy (&_LIBGTOP_demarshal_arg, _LIBGTOP_SEND_ptr, sizeof (int64_t));
	_LIBGTOP_SEND_offset += sizeof (int64_t);

	retval = glibtop_get_proclist_p (server, &array, _LIBGTOP_demarshal_which, _LIBGTOP_demarshal_arg);
	if (retval_ptr)
		*retval_ptr = server->glibtop_errno;

	/* write recv buffer */
	memcpy (_LIBGTOP_RECV_ptr, &array, sizeof (glibtop_array));
	_LIBGTOP_RECV_ptr += sizeof (glibtop_array);

	*recv_buf_ptr = _LIBGTOP_RECV_buf;
	*recv_size_ptr = _LIBGTOP_RECV_len;

	if (recv_data_ptr) {
		*recv_data_ptr = retval;
		*recv_data_size_ptr = array.total;
	}

	return 0;
}

#endif /* GLIBTOP_SUID_PROCLIST */


#if GLIBTOP_SUID_PROC_STATE

static int
_glibtop_demarshal_proc_state_i (glibtop *server, glibtop_backend *backend, const void *send_ptr, size_t send_size, void *data_ptr, size_t data_size, void **recv_buf_ptr, size_t *recv_size_ptr, void **recv_data_ptr, size_t *recv_data_size_ptr, int *retval_ptr)
{
	size_t _LIBGTOP_SEND_len, _LIBGTOP_RECV_len;
	off_t _LIBGTOP_SEND_offset;
	char *_LIBGTOP_RECV_buf, *_LIBGTOP_RECV_ptr;
	const char *_LIBGTOP_SEND_ptr;
	glibtop_proc_state proc_state;
	int retval = (int) 0;
	pid_t _LIBGTOP_demarshal_pid;

	/* variable initialization */
	memset (&proc_state, 0, sizeof (glibtop_proc_state));
	_LIBGTOP_SEND_offset = 0;
	_LIBGTOP_SEND_ptr = (char *) send_ptr;
	memset (&_LIBGTOP_demarshal_pid, 0, sizeof (pid_t));

	/* send size */
	_LIBGTOP_SEND_len = 0;
	_LIBGTOP_SEND_len += sizeof (pid_t);
	if (_LIBGTOP_SEND_len != send_size)
		return -GLIBTOP_ERROR_DEMARSHAL_ERROR;

	/* recv size */
	_LIBGTOP_RECV_len = 0;
	_LIBGTOP_RECV_len += sizeof (glibtop_proc_state);

	/* recv buffer */
	_LIBGTOP_RECV_buf = glibtop_malloc_r (server, _LIBGTOP_RECV_len);
	_LIBGTOP_RECV_ptr = _LIBGTOP_RECV_buf;

	/* demarshal start */
	_LIBGTOP_SEND_ptr = (char *) send_ptr + _LIBGTOP_SEND_offset;
	memcpy (&_LIBGTOP_demarshal_pid, _LIBGTOP_SEND_ptr, sizeof (pid_t));
	_LIBGTOP_SEND_offset += sizeof (pid_t);

	retval = glibtop_get_proc_state_p (server, &proc_state, _LIBGTOP_demarshal_pid);
	if (retval_ptr)
		*retval_ptr = retval;

	/* write recv buffer */
	memcpy (_LIBGTOP_RECV_ptr, &proc_state, sizeof (glibtop_proc_state));
	_LIBGTOP_RECV_ptr += sizeof (glibtop_proc_state);

	*recv_buf_ptr = _LIBGTOP_RECV_buf;
	*recv_size_ptr = _LIBGTOP_RECV_len;

	return 0;
}

#endif /* GLIBTOP_SUID_PROC_STATE */


#if GLIBTOP_SUID_PROC_UID

static int
_glibtop_demarshal_proc_uid_i (glibtop *server, glibtop_backend *backend, const void *send_ptr, size_t send_size, void *data_ptr, size_t data_size, void **recv_buf_ptr, size_t *recv_size_ptr, void **recv_data_ptr, size_t *recv_data_size_ptr, int *retval_ptr)
{
	size_t _LIBGTOP_SEND_len, _LIBGTOP_RECV_len;
	off_t _LIBGTOP_SEND_offset;
	char *_LIBGTOP_RECV_buf, *_LIBGTOP_RECV_ptr;
	const char *_LIBGTOP_SEND_ptr;
	glibtop_proc_uid proc_uid;
	int retval = (int) 0;
	pid_t _LIBGTOP_demarshal_pid;

	/* variable initialization */
	memset (&proc_uid, 0, sizeof (glibtop_proc_uid));
	_LIBGTOP_SEND_offset = 0;
	_LIBGTOP_SEND_ptr = (char *) send_ptr;
	memset (&_LIBGTOP_demarshal_pid, 0, sizeof (pid_t));

	/* send size */
	_LIBGTOP_SEND_len = 0;
	_LIBGTOP_SEND_len += sizeof (pid_t);
	if (_LIBGTOP_SEND_len != send_size)
		return -GLIBTOP_ERROR_DEMARSHAL_ERROR;

	/* recv size */
	_LIBGTOP_RECV_len = 0;
	_LIBGTOP_RECV_len += sizeof (glibtop_proc_uid);

	/* recv buffer */
	_LIBGTOP_RECV_buf = glibtop_malloc_r (server, _LIBGTOP_RECV_len);
	_LIBGTOP_RECV_ptr = _LIBGTOP_RECV_buf;

	/* demarshal start */
	_LIBGTOP_SEND_ptr = (char *) send_ptr + _LIBGTOP_SEND_offset;
	memcpy (&_LIBGTOP_demarshal_pid, _LIBGTOP_SEND_ptr, sizeof (pid_t));
	_LIBGTOP_SEND_offset += sizeof (pid_t);

	retval = glibtop_get_proc_uid_p (server, &proc_uid, _LIBGTOP_demarshal_pid);
	if (retval_ptr)
		*retval_ptr = retval;

	/* write recv buffer */
	memcpy (_LIBGTOP_RECV_ptr, &proc_uid, sizeof (glibtop_proc_uid));
	_LIBGTOP_RECV_ptr += sizeof (glibtop_proc_uid);

	*recv_buf_ptr = _LIBGTOP_RECV_buf;
	*recv_size_ptr = _LIBGTOP_RECV_len;

	return 0;
}

#endif /* GLIBTOP_SUID_PROC_UID */


#if GLIBTOP_SUID_PROC_MEM

static int
_glibtop_demarshal_proc_mem_i (glibtop *server, glibtop_backend *backend, const void *send_ptr, size_t send_size, void *data_ptr, size_t data_size, void **recv_buf_ptr, size_t *recv_size_ptr, void **recv_data_ptr, size_t *recv_data_size_ptr, int *retval_ptr)
{
	size_t _LIBGTOP_SEND_len, _LIBGTOP_RECV_len;
	off_t _LIBGTOP_SEND_offset;
	char *_LIBGTOP_RECV_buf, *_LIBGTOP_RECV_ptr;
	const char *_LIBGTOP_SEND_ptr;
	glibtop_proc_mem proc_mem;
	int retval = (int) 0;
	pid_t _LIBGTOP_demarshal_pid;

	/* variable initialization */
	memset (&proc_mem, 0, sizeof (glibtop_proc_mem));
	_LIBGTOP_SEND_offset = 0;
	_LIBGTOP_SEND_ptr = (char *) send_ptr;
	memset (&_LIBGTOP_demarshal_pid, 0, sizeof (pid_t));

	/* send size */
	_LIBGTOP_SEND_len = 0;
	_LIBGTOP_SEND_len += sizeof (pid_t);
	if (_LIBGTOP_SEND_len != send_size)
		return -GLIBTOP_ERROR_DEMARSHAL_ERROR;

	/* recv size */
	_LIBGTOP_RECV_len = 0;
	_LIBGTOP_RECV_len += sizeof (glibtop_proc_mem);

	/* recv buffer */
	_LIBGTOP_RECV_buf = glibtop_malloc_r (server, _LIBGTOP_RECV_len);
	_LIBGTOP_RECV_ptr = _LIBGTOP_RECV_buf;

	/* demarshal start */
	_LIBGTOP_SEND_ptr = (char *) send_ptr + _LIBGTOP_SEND_offset;
	memcpy (&_LIBGTOP_demarshal_pid, _LIBGTOP_SEND_ptr, sizeof (pid_t));
	_LIBGTOP_SEND_offset += sizeof (pid_t);

	retval = glibtop_get_proc_mem_p (server, &proc_mem, _LIBGTOP_demarshal_pid);
	if (retval_ptr)
		*retval_ptr = retval;

	/* write recv buffer */
	memcpy (_LIBGTOP_RECV_ptr, &proc_mem, sizeof (glibtop_proc_mem));
	_LIBGTOP_RECV_ptr += sizeof (glibtop_proc_mem);

	*recv_buf_ptr = _LIBGTOP_RECV_buf;
	*recv_size_ptr = _LIBGTOP_RECV_len;

	return 0;
}

#endif /* GLIBTOP_SUID_PROC_MEM */


#if GLIBTOP_SUID_PROC_TIME

static int
_glibtop_demarshal_proc_time_i (glibtop *server, glibtop_backend *backend, const void *send_ptr, size_t send_size, void *data_ptr, size_t data_size, void **recv_buf_ptr, size_t *recv_size_ptr, void **recv_data_ptr, size_t *recv_data_size_ptr, int *retval_ptr)
{
	size_t _LIBGTOP_SEND_len, _LIBGTOP_RECV_len;
	off_t _LIBGTOP_SEND_offset;
	char *_LIBGTOP_RECV_buf, *_LIBGTOP_RECV_ptr;
	const char *_LIBGTOP_SEND_ptr;
	glibtop_proc_time proc_time;
	int retval = (int) 0;
	pid_t _LIBGTOP_demarshal_pid;

	/* variable initialization */
	memset (&proc_time, 0, sizeof (glibtop_proc_time));
	_LIBGTOP_SEND_offset = 0;
	_LIBGTOP_SEND_ptr = (char *) send_ptr;
	memset (&_LIBGTOP_demarshal_pid, 0, sizeof (pid_t));

	/* send size */
	_LIBGTOP_SEND_len = 0;
	_LIBGTOP_SEND_len += sizeof (pid_t);
	if (_LIBGTOP_SEND_len != send_size)
		return -GLIBTOP_ERROR_DEMARSHAL_ERROR;

	/* recv size */
	_LIBGTOP_RECV_len = 0;
	_LIBGTOP_RECV_len += sizeof (glibtop_proc_time);

	/* recv buffer */
	_LIBGTOP_RECV_buf = glibtop_malloc_r (server, _LIBGTOP_RECV_len);
	_LIBGTOP_RECV_ptr = _LIBGTOP_RECV_buf;

	/* demarshal start */
	_LIBGTOP_SEND_ptr = (char *) send_ptr + _LIBGTOP_SEND_offset;
	memcpy (&_LIBGTOP_demarshal_pid, _LIBGTOP_SEND_ptr, sizeof (pid_t));
	_LIBGTOP_SEND_offset += sizeof (pid_t);

	retval = glibtop_get_proc_time_p (server, &proc_time, _LIBGTOP_demarshal_pid);
	if (retval_ptr)
		*retval_ptr = retval;

	/* write recv buffer */
	memcpy (_LIBGTOP_RECV_ptr, &proc_time, sizeof (glibtop_proc_time));
	_LIBGTOP_RECV_ptr += sizeof (glibtop_proc_time);

	*recv_buf_ptr = _LIBGTOP_RECV_buf;
	*recv_size_ptr = _LIBGTOP_RECV_len;

	return 0;
}

#endif /* GLIBTOP_SUID_PROC_TIME */


#if GLIBTOP_SUID_PROC_SIGNAL

static int
_glibtop_demarshal_proc_signal_i (glibtop *server, glibtop_backend *backend, const void *send_ptr, size_t send_size, void *data_ptr, size_t data_size, void **recv_buf_ptr, size_t *recv_size_ptr, void **recv_data_ptr, size_t *recv_data_size_ptr, int *retval_ptr)
{
	size_t _LIBGTOP_SEND_len, _LIBGTOP_RECV_len;
	off_t _LIBGTOP_SEND_offset;
	char *_LIBGTOP_RECV_buf, *_LIBGTOP_RECV_ptr;
	const char *_LIBGTOP_SEND_ptr;
	glibtop_proc_signal proc_signal;
	int retval = (int) 0;
	pid_t _LIBGTOP_demarshal_pid;

	/* variable initialization */
	memset (&proc_signal, 0, sizeof (glibtop_proc_signal));
	_LIBGTOP_SEND_offset = 0;
	_LIBGTOP_SEND_ptr = (char *) send_ptr;
	memset (&_LIBGTOP_demarshal_pid, 0, sizeof (pid_t));

	/* send size */
	_LIBGTOP_SEND_len = 0;
	_LIBGTOP_SEND_len += sizeof (pid_t);
	if (_LIBGTOP_SEND_len != send_size)
		return -GLIBTOP_ERROR_DEMARSHAL_ERROR;

	/* recv size */
	_LIBGTOP_RECV_len = 0;
	_LIBGTOP_RECV_len += sizeof (glibtop_proc_signal);

	/* recv buffer */
	_LIBGTOP_RECV_buf = glibtop_malloc_r (server, _LIBGTOP_RECV_len);
	_LIBGTOP_RECV_ptr = _LIBGTOP_RECV_buf;

	/* demarshal start */
	_LIBGTOP_SEND_ptr = (char *) send_ptr + _LIBGTOP_SEND_offset;
	memcpy (&_LIBGTOP_demarshal_pid, _LIBGTOP_SEND_ptr, sizeof (pid_t));
	_LIBGTOP_SEND_offset += sizeof (pid_t);

	retval = glibtop_get_proc_signal_p (server, &proc_signal, _LIBGTOP_demarshal_pid);
	if (retval_ptr)
		*retval_ptr = retval;

	/* write recv buffer */
	memcpy (_LIBGTOP_RECV_ptr, &proc_signal, sizeof (glibtop_proc_signal));
	_LIBGTOP_RECV_ptr += sizeof (glibtop_proc_signal);

	*recv_buf_ptr = _LIBGTOP_RECV_buf;
	*recv_size_ptr = _LIBGTOP_RECV_len;

	return 0;
}

#endif /* GLIBTOP_SUID_PROC_SIGNAL */


#if GLIBTOP_SUID_PROC_KERNEL

static int
_glibtop_demarshal_proc_kernel_i (glibtop *server, glibtop_backend *backend, const void *send_ptr, size_t send_size, void *data_ptr, size_t data_size, void **recv_buf_ptr, size_t *recv_size_ptr, void **recv_data_ptr, size_t *recv_data_size_ptr, int *retval_ptr)
{
	size_t _LIBGTOP_SEND_len, _LIBGTOP_RECV_len;
	off_t _LIBGTOP_SEND_offset;
	char *_LIBGTOP_RECV_buf, *_LIBGTOP_RECV_ptr;
	const char *_LIBGTOP_SEND_ptr;
	glibtop_proc_kernel proc_kernel;
	int retval = (int) 0;
	pid_t _LIBGTOP_demarshal_pid;

	/* variable initialization */
	memset (&proc_kernel, 0, sizeof (glibtop_proc_kernel));
	_LIBGTOP_SEND_offset = 0;
	_LIBGTOP_SEND_ptr = (char *) send_ptr;
	memset (&_LIBGTOP_demarshal_pid, 0, sizeof (pid_t));

	/* send size */
	_LIBGTOP_SEND_len = 0;
	_LIBGTOP_SEND_len += sizeof (pid_t);
	if (_LIBGTOP_SEND_len != send_size)
		return -GLIBTOP_ERROR_DEMARSHAL_ERROR;

	/* recv size */
	_LIBGTOP_RECV_len = 0;
	_LIBGTOP_RECV_len += sizeof (glibtop_proc_kernel);

	/* recv buffer */
	_LIBGTOP_RECV_buf = glibtop_malloc_r (server, _LIBGTOP_RECV_len);
	_LIBGTOP_RECV_ptr = _LIBGTOP_RECV_buf;

	/* demarshal start */
	_LIBGTOP_SEND_ptr = (char *) send_ptr + _LIBGTOP_SEND_offset;
	memcpy (&_LIBGTOP_demarshal_pid, _LIBGTOP_SEND_ptr, sizeof (pid_t));
	_LIBGTOP_SEND_offset += sizeof (pid_t);

	retval = glibtop_get_proc_kernel_p (server, &proc_kernel, _LIBGTOP_demarshal_pid);
	if (retval_ptr)
		*retval_ptr = retval;

	/* write recv buffer */
	memcpy (_LIBGTOP_RECV_ptr, &proc_kernel, sizeof (glibtop_proc_kernel));
	_LIBGTOP_RECV_ptr += sizeof (glibtop_proc_kernel);

	*recv_buf_ptr = _LIBGTOP_RECV_buf;
	*recv_size_ptr = _LIBGTOP_RECV_len;

	return 0;
}

#endif /* GLIBTOP_SUID_PROC_KERNEL */


#if GLIBTOP_SUID_PROC_SEGMENT

static int
_glibtop_demarshal_proc_segment_i (glibtop *server, glibtop_backend *backend, const void *send_ptr, size_t send_size, void *data_ptr, size_t data_size, void **recv_buf_ptr, size_t *recv_size_ptr, void **recv_data_ptr, size_t *recv_data_size_ptr, int *retval_ptr)
{
	size_t _LIBGTOP_SEND_len, _LIBGTOP_RECV_len;
	off_t _LIBGTOP_SEND_offset;
	char *_LIBGTOP_RECV_buf, *_LIBGTOP_RECV_ptr;
	const char *_LIBGTOP_SEND_ptr;
	glibtop_proc_segment proc_segment;
	int retval = (int) 0;
	pid_t _LIBGTOP_demarshal_pid;

	/* variable initialization */
	memset (&proc_segment, 0, sizeof (glibtop_proc_segment));
	_LIBGTOP_SEND_offset = 0;
	_LIBGTOP_SEND_ptr = (char *) send_ptr;
	memset (&_LIBGTOP_demarshal_pid, 0, sizeof (pid_t));

	/* send size */
	_LIBGTOP_SEND_len = 0;
	_LIBGTOP_SEND_len += sizeof (pid_t);
	if (_LIBGTOP_SEND_len != send_size)
		return -GLIBTOP_ERROR_DEMARSHAL_ERROR;

	/* recv size */
	_LIBGTOP_RECV_len = 0;
	_LIBGTOP_RECV_len += sizeof (glibtop_proc_segment);

	/* recv buffer */
	_LIBGTOP_RECV_buf = glibtop_malloc_r (server, _LIBGTOP_RECV_len);
	_LIBGTOP_RECV_ptr = _LIBGTOP_RECV_buf;

	/* demarshal start */
	_LIBGTOP_SEND_ptr = (char *) send_ptr + _LIBGTOP_SEND_offset;
	memcpy (&_LIBGTOP_demarshal_pid, _LIBGTOP_SEND_ptr, sizeof (pid_t));
	_LIBGTOP_SEND_offset += sizeof (pid_t);

	retval = glibtop_get_proc_segment_p (server, &proc_segment, _LIBGTOP_demarshal_pid);
	if (retval_ptr)
		*retval_ptr = retval;

	/* write recv buffer */
	memcpy (_LIBGTOP_RECV_ptr, &proc_segment, sizeof (glibtop_proc_segment));
	_LIBGTOP_RECV_ptr += sizeof (glibtop_proc_segment);

	*recv_buf_ptr = _LIBGTOP_RECV_buf;
	*recv_size_ptr = _LIBGTOP_RECV_len;

	return 0;
}

#endif /* GLIBTOP_SUID_PROC_SEGMENT */


#if GLIBTOP_SUID_PROC_ARGS

static int
_glibtop_demarshal_proc_args_i (glibtop *server, glibtop_backend *backend, const void *send_ptr, size_t send_size, void *data_ptr, size_t data_size, void **recv_buf_ptr, size_t *recv_size_ptr, void **recv_data_ptr, size_t *recv_data_size_ptr, int *retval_ptr)
{
	size_t _LIBGTOP_SEND_len, _LIBGTOP_RECV_len;
	off_t _LIBGTOP_SEND_offset;
	char *_LIBGTOP_RECV_buf, *_LIBGTOP_RECV_ptr;
	const char *_LIBGTOP_SEND_ptr;
	glibtop_proc_args proc_args;
	char ** retval = (char **) 0;
	pid_t _LIBGTOP_demarshal_pid;
	glibtop_array array;
	char **_LIBGTOP_TEMP_ptr;
	char *_LIBGTOP_ARRAY_ptr;
	char *_LIBGTOP_ARRAY_base;
	off_t _LIBGTOP_ARRAY_offset;
	off_t *_LIBGTOP_ARRAY_off_ptr;
	size_t _LIBGTOP_TEMP_len;
	size_t _LIBGTOP_DATA_len;
	off_t _LIBGTOP_DATA_offset;
	char *_LIBGTOP_DATA_ptr;

	/* variable initialization */
	memset (&proc_args, 0, sizeof (glibtop_proc_args));
	_LIBGTOP_SEND_offset = 0;
	_LIBGTOP_SEND_ptr = (char *) send_ptr;
	memset (&_LIBGTOP_demarshal_pid, 0, sizeof (pid_t));
	_LIBGTOP_DATA_len = 0;
	_LIBGTOP_DATA_offset = 0;
	_LIBGTOP_DATA_ptr = (char *) data_ptr;

	/* send size */
	_LIBGTOP_SEND_len = 0;
	_LIBGTOP_SEND_len += sizeof (pid_t);
	if (_LIBGTOP_SEND_len != send_size)
		return -GLIBTOP_ERROR_DEMARSHAL_ERROR;

	/* recv size */
	_LIBGTOP_RECV_len = 0;
	_LIBGTOP_RECV_len += sizeof (glibtop_array);

	/* recv buffer */
	_LIBGTOP_RECV_buf = glibtop_malloc_r (server, _LIBGTOP_RECV_len);
	_LIBGTOP_RECV_ptr = _LIBGTOP_RECV_buf;

	/* demarshal start */
	_LIBGTOP_SEND_ptr = (char *) send_ptr + _LIBGTOP_SEND_offset;
	memcpy (&_LIBGTOP_demarshal_pid, _LIBGTOP_SEND_ptr, sizeof (pid_t));
	_LIBGTOP_SEND_offset += sizeof (pid_t);

	retval = glibtop_get_proc_args_p (server, &array, _LIBGTOP_demarshal_pid);
	if (retval_ptr)
		*retval_ptr = server->glibtop_errno;

	/* write recv buffer */
	memcpy (_LIBGTOP_RECV_ptr, &array, sizeof (glibtop_array));
	_LIBGTOP_RECV_ptr += sizeof (glibtop_array);

	*recv_buf_ptr = _LIBGTOP_RECV_buf;
	*recv_size_ptr = _LIBGTOP_RECV_len;

	_LIBGTOP_TEMP_len = 0;
	_LIBGTOP_TEMP_ptr = retval;
	for (_LIBGTOP_TEMP_ptr = retval; _LIBGTOP_TEMP_ptr && *_LIBGTOP_TEMP_ptr; _LIBGTOP_TEMP_ptr++)
		_LIBGTOP_TEMP_len += strlen (*_LIBGTOP_TEMP_ptr)+1;

	_LIBGTOP_TEMP_len += sizeof (off_t) + 1;
	_LIBGTOP_TEMP_len += array.number * sizeof (off_t);
	_LIBGTOP_ARRAY_base = glibtop_malloc_r (server, _LIBGTOP_TEMP_len);	_LIBGTOP_ARRAY_ptr = _LIBGTOP_ARRAY_base;
	_LIBGTOP_ARRAY_offset = array.number * sizeof (off_t);
	_LIBGTOP_ARRAY_offset += sizeof (off_t);
	_LIBGTOP_ARRAY_off_ptr = (off_t *) _LIBGTOP_ARRAY_ptr;

	*_LIBGTOP_ARRAY_off_ptr++ = _LIBGTOP_ARRAY_offset;
	for (_LIBGTOP_TEMP_ptr = retval; _LIBGTOP_TEMP_ptr && *_LIBGTOP_TEMP_ptr; _LIBGTOP_TEMP_ptr++) {
		*_LIBGTOP_ARRAY_off_ptr++ = _LIBGTOP_ARRAY_offset;
		_LIBGTOP_ARRAY_offset += strlen (*_LIBGTOP_TEMP_ptr)+1;
	}

	_LIBGTOP_ARRAY_ptr = (char *) _LIBGTOP_ARRAY_off_ptr;
	for (_LIBGTOP_TEMP_ptr = retval; _LIBGTOP_TEMP_ptr && *_LIBGTOP_TEMP_ptr; _LIBGTOP_TEMP_ptr++) {
		strcpy (_LIBGTOP_ARRAY_ptr, *_LIBGTOP_TEMP_ptr);
		_LIBGTOP_ARRAY_ptr += strlen (*_LIBGTOP_TEMP_ptr)+1;
	}

	if (recv_data_ptr) {
		*recv_data_ptr = _LIBGTOP_ARRAY_base;
		*recv_data_size_ptr = _LIBGTOP_TEMP_len;
	}

	return 0;
}

#endif /* GLIBTOP_SUID_PROC_ARGS */


#if GLIBTOP_SUID_PROC_MAP

static int
_glibtop_demarshal_proc_map_i (glibtop *server, glibtop_backend *backend, const void *send_ptr, size_t send_size, void *data_ptr, size_t data_size, void **recv_buf_ptr, size_t *recv_size_ptr, void **recv_data_ptr, size_t *recv_data_size_ptr, int *retval_ptr)
{
	size_t _LIBGTOP_SEND_len, _LIBGTOP_RECV_len;
	off_t _LIBGTOP_SEND_offset;
	char *_LIBGTOP_RECV_buf, *_LIBGTOP_RECV_ptr;
	const char *_LIBGTOP_SEND_ptr;
	glibtop_proc_map proc_map;
	glibtop_map_entry * retval = (glibtop_map_entry *) 0;
	pid_t _LIBGTOP_demarshal_pid;
	glibtop_array array;

	/* variable initialization */
	memset (&proc_map, 0, sizeof (glibtop_proc_map));
	_LIBGTOP_SEND_offset = 0;
	_LIBGTOP_SEND_ptr = (char *) send_ptr;
	memset (&_LIBGTOP_demarshal_pid, 0, sizeof (pid_t));

	/* send size */
	_LIBGTOP_SEND_len = 0;
	_LIBGTOP_SEND_len += sizeof (pid_t);
	if (_LIBGTOP_SEND_len != send_size)
		return -GLIBTOP_ERROR_DEMARSHAL_ERROR;

	/* recv size */
	_LIBGTOP_RECV_len = 0;
	_LIBGTOP_RECV_len += sizeof (glibtop_array);

	/* recv buffer */
	_LIBGTOP_RECV_buf = glibtop_malloc_r (server, _LIBGTOP_RECV_len);
	_LIBGTOP_RECV_ptr = _LIBGTOP_RECV_buf;

	/* demarshal start */
	_LIBGTOP_SEND_ptr = (char *) send_ptr + _LIBGTOP_SEND_offset;
	memcpy (&_LIBGTOP_demarshal_pid, _LIBGTOP_SEND_ptr, sizeof (pid_t));
	_LIBGTOP_SEND_offset += sizeof (pid_t);

	retval = glibtop_get_proc_map_p (server, &array, _LIBGTOP_demarshal_pid);
	if (retval_ptr)
		*retval_ptr = server->glibtop_errno;

	/* write recv buffer */
	memcpy (_LIBGTOP_RECV_ptr, &array, sizeof (glibtop_array));
	_LIBGTOP_RECV_ptr += sizeof (glibtop_array);

	*recv_buf_ptr = _LIBGTOP_RECV_buf;
	*recv_size_ptr = _LIBGTOP_RECV_len;

	if (recv_data_ptr) {
		*recv_data_ptr = retval;
		*recv_data_size_ptr = array.total;
	}

	return 0;
}

#endif /* GLIBTOP_SUID_PROC_MAP */


#if GLIBTOP_SUID_INTERFACE_NAMES

static int
_glibtop_demarshal_interface_names_i (glibtop *server, glibtop_backend *backend, const void *send_ptr, size_t send_size, void *data_ptr, size_t data_size, void **recv_buf_ptr, size_t *recv_size_ptr, void **recv_data_ptr, size_t *recv_data_size_ptr, int *retval_ptr)
{
	size_t _LIBGTOP_SEND_len, _LIBGTOP_RECV_len;
	off_t _LIBGTOP_SEND_offset;
	char *_LIBGTOP_RECV_buf, *_LIBGTOP_RECV_ptr;
	const char *_LIBGTOP_SEND_ptr;
	glibtop_interface_names interface_names;
	glibtop_interface * retval = (glibtop_interface *) 0;
	u_int64_t _LIBGTOP_demarshal_interface;
	u_int64_t _LIBGTOP_demarshal_number;
	u_int64_t _LIBGTOP_demarshal_instance;
	u_int64_t _LIBGTOP_demarshal_strategy;
	glibtop_array array;

	/* variable initialization */
	memset (&interface_names, 0, sizeof (glibtop_interface_names));
	_LIBGTOP_SEND_offset = 0;
	_LIBGTOP_SEND_ptr = (char *) send_ptr;
	memset (&_LIBGTOP_demarshal_interface, 0, sizeof (u_int64_t));
	memset (&_LIBGTOP_demarshal_number, 0, sizeof (u_int64_t));
	memset (&_LIBGTOP_demarshal_instance, 0, sizeof (u_int64_t));
	memset (&_LIBGTOP_demarshal_strategy, 0, sizeof (u_int64_t));

	/* send size */
	_LIBGTOP_SEND_len = 0;
	_LIBGTOP_SEND_len += sizeof (u_int64_t);
	_LIBGTOP_SEND_len += sizeof (u_int64_t);
	_LIBGTOP_SEND_len += sizeof (u_int64_t);
	_LIBGTOP_SEND_len += sizeof (u_int64_t);
	if (_LIBGTOP_SEND_len != send_size)
		return -GLIBTOP_ERROR_DEMARSHAL_ERROR;

	/* recv size */
	_LIBGTOP_RECV_len = 0;
	_LIBGTOP_RECV_len += sizeof (glibtop_array);

	/* recv buffer */
	_LIBGTOP_RECV_buf = glibtop_malloc_r (server, _LIBGTOP_RECV_len);
	_LIBGTOP_RECV_ptr = _LIBGTOP_RECV_buf;

	/* demarshal start */
	_LIBGTOP_SEND_ptr = (char *) send_ptr + _LIBGTOP_SEND_offset;
	memcpy (&_LIBGTOP_demarshal_interface, _LIBGTOP_SEND_ptr, sizeof (u_int64_t));
	_LIBGTOP_SEND_offset += sizeof (u_int64_t);
	_LIBGTOP_SEND_ptr = (char *) send_ptr + _LIBGTOP_SEND_offset;
	memcpy (&_LIBGTOP_demarshal_number, _LIBGTOP_SEND_ptr, sizeof (u_int64_t));
	_LIBGTOP_SEND_offset += sizeof (u_int64_t);
	_LIBGTOP_SEND_ptr = (char *) send_ptr + _LIBGTOP_SEND_offset;
	memcpy (&_LIBGTOP_demarshal_instance, _LIBGTOP_SEND_ptr, sizeof (u_int64_t));
	_LIBGTOP_SEND_offset += sizeof (u_int64_t);
	_LIBGTOP_SEND_ptr = (char *) send_ptr + _LIBGTOP_SEND_offset;
	memcpy (&_LIBGTOP_demarshal_strategy, _LIBGTOP_SEND_ptr, sizeof (u_int64_t));
	_LIBGTOP_SEND_offset += sizeof (u_int64_t);

	retval = glibtop_get_interface_names_p (server, &array, _LIBGTOP_demarshal_interface, _LIBGTOP_demarshal_number, _LIBGTOP_demarshal_instance, _LIBGTOP_demarshal_strategy);
	if (retval_ptr)
		*retval_ptr = server->glibtop_errno;

	/* write recv buffer */
	memcpy (_LIBGTOP_RECV_ptr, &array, sizeof (glibtop_array));
	_LIBGTOP_RECV_ptr += sizeof (glibtop_array);

	*recv_buf_ptr = _LIBGTOP_RECV_buf;
	*recv_size_ptr = _LIBGTOP_RECV_len;

	if (recv_data_ptr) {
		*recv_data_ptr = retval;
		*recv_data_size_ptr = array.total;
	}

	return 0;
}

#endif /* GLIBTOP_SUID_INTERFACE_NAMES */


#if GLIBTOP_SUID_NETINFO

static int
_glibtop_demarshal_netinfo_i (glibtop *server, glibtop_backend *backend, const void *send_ptr, size_t send_size, void *data_ptr, size_t data_size, void **recv_buf_ptr, size_t *recv_size_ptr, void **recv_data_ptr, size_t *recv_data_size_ptr, int *retval_ptr)
{
	size_t _LIBGTOP_SEND_len, _LIBGTOP_RECV_len;
	off_t _LIBGTOP_SEND_offset;
	char *_LIBGTOP_RECV_buf, *_LIBGTOP_RECV_ptr;
	const char *_LIBGTOP_SEND_ptr;
	glibtop_netinfo netinfo;
	glibtop_ifaddr * retval = (glibtop_ifaddr *) 0;
	const char * _LIBGTOP_demarshal_interface;
	u_int64_t _LIBGTOP_demarshal_transport;
	glibtop_array array;
	size_t _LIBGTOP_TEMP_len;
	size_t _LIBGTOP_DATA_len;
	off_t _LIBGTOP_DATA_offset;
	char *_LIBGTOP_DATA_ptr;

	/* variable initialization */
	memset (&netinfo, 0, sizeof (glibtop_netinfo));
	_LIBGTOP_SEND_offset = 0;
	_LIBGTOP_SEND_ptr = (char *) send_ptr;
	memset (&_LIBGTOP_demarshal_interface, 0, sizeof (const char *));
	memset (&_LIBGTOP_demarshal_transport, 0, sizeof (u_int64_t));
	_LIBGTOP_DATA_len = 0;
	_LIBGTOP_DATA_offset = 0;
	_LIBGTOP_DATA_ptr = (char *) data_ptr;

	/* send size */
	_LIBGTOP_SEND_len = 0;
	_LIBGTOP_SEND_len += sizeof (size_t);
	_LIBGTOP_SEND_len += sizeof (u_int64_t);
	if (_LIBGTOP_SEND_len != send_size)
		return -GLIBTOP_ERROR_DEMARSHAL_ERROR;

	/* recv size */
	_LIBGTOP_RECV_len = 0;
	_LIBGTOP_RECV_len += sizeof (glibtop_array);
	_LIBGTOP_RECV_len += sizeof (glibtop_netinfo);

	/* recv buffer */
	_LIBGTOP_RECV_buf = glibtop_malloc_r (server, _LIBGTOP_RECV_len);
	_LIBGTOP_RECV_ptr = _LIBGTOP_RECV_buf;

	/* demarshal start */
	_LIBGTOP_SEND_ptr = (char *) send_ptr + _LIBGTOP_SEND_offset;
	memcpy (&_LIBGTOP_TEMP_len, _LIBGTOP_SEND_ptr, sizeof (size_t));
	_LIBGTOP_DATA_len += _LIBGTOP_TEMP_len;
	if (_LIBGTOP_DATA_len > data_size)
		return -GLIBTOP_ERROR_DEMARSHAL_ERROR;
	_LIBGTOP_DATA_offset += _LIBGTOP_TEMP_len;
	_LIBGTOP_demarshal_interface = _LIBGTOP_DATA_ptr;
	if (_LIBGTOP_TEMP_len) --_LIBGTOP_TEMP_len;
	*(_LIBGTOP_DATA_ptr + _LIBGTOP_TEMP_len) = 0;
	_LIBGTOP_SEND_offset += sizeof (size_t);
	_LIBGTOP_SEND_ptr = (char *) send_ptr + _LIBGTOP_SEND_offset;
	memcpy (&_LIBGTOP_demarshal_transport, _LIBGTOP_SEND_ptr, sizeof (u_int64_t));
	_LIBGTOP_SEND_offset += sizeof (u_int64_t);

	retval = glibtop_get_netinfo_p (server, &array, &netinfo, _LIBGTOP_demarshal_interface, _LIBGTOP_demarshal_transport);
	if (retval_ptr)
		*retval_ptr = server->glibtop_errno;

	/* write recv buffer */
	memcpy (_LIBGTOP_RECV_ptr, &array, sizeof (glibtop_array));
	_LIBGTOP_RECV_ptr += sizeof (glibtop_array);
	memcpy (_LIBGTOP_RECV_ptr, &netinfo, sizeof (glibtop_netinfo));
	_LIBGTOP_RECV_ptr += sizeof (glibtop_netinfo);

	*recv_buf_ptr = _LIBGTOP_RECV_buf;
	*recv_size_ptr = _LIBGTOP_RECV_len;

	if (recv_data_ptr) {
		*recv_data_ptr = retval;
		*recv_data_size_ptr = array.total;
	}

	return 0;
}

#endif /* GLIBTOP_SUID_NETINFO */


#if GLIBTOP_SUID_NETLOAD

static int
_glibtop_demarshal_netload_i (glibtop *server, glibtop_backend *backend, const void *send_ptr, size_t send_size, void *data_ptr, size_t data_size, void **recv_buf_ptr, size_t *recv_size_ptr, void **recv_data_ptr, size_t *recv_data_size_ptr, int *retval_ptr)
{
	size_t _LIBGTOP_SEND_len, _LIBGTOP_RECV_len;
	off_t _LIBGTOP_SEND_offset;
	char *_LIBGTOP_RECV_buf, *_LIBGTOP_RECV_ptr;
	const char *_LIBGTOP_SEND_ptr;
	glibtop_netload netload;
	int retval = (int) 0;
	const char * _LIBGTOP_demarshal_interface;
	unsigned _LIBGTOP_demarshal_transport;
	unsigned _LIBGTOP_demarshal_protocol;
	size_t _LIBGTOP_TEMP_len;
	size_t _LIBGTOP_DATA_len;
	off_t _LIBGTOP_DATA_offset;
	char *_LIBGTOP_DATA_ptr;

	/* variable initialization */
	memset (&netload, 0, sizeof (glibtop_netload));
	_LIBGTOP_SEND_offset = 0;
	_LIBGTOP_SEND_ptr = (char *) send_ptr;
	memset (&_LIBGTOP_demarshal_interface, 0, sizeof (const char *));
	memset (&_LIBGTOP_demarshal_transport, 0, sizeof (unsigned));
	memset (&_LIBGTOP_demarshal_protocol, 0, sizeof (unsigned));
	_LIBGTOP_DATA_len = 0;
	_LIBGTOP_DATA_offset = 0;
	_LIBGTOP_DATA_ptr = (char *) data_ptr;

	/* send size */
	_LIBGTOP_SEND_len = 0;
	_LIBGTOP_SEND_len += sizeof (size_t);
	_LIBGTOP_SEND_len += sizeof (unsigned);
	_LIBGTOP_SEND_len += sizeof (unsigned);
	if (_LIBGTOP_SEND_len != send_size)
		return -GLIBTOP_ERROR_DEMARSHAL_ERROR;

	/* recv size */
	_LIBGTOP_RECV_len = 0;
	_LIBGTOP_RECV_len += sizeof (glibtop_netload);

	/* recv buffer */
	_LIBGTOP_RECV_buf = glibtop_malloc_r (server, _LIBGTOP_RECV_len);
	_LIBGTOP_RECV_ptr = _LIBGTOP_RECV_buf;

	/* demarshal start */
	_LIBGTOP_SEND_ptr = (char *) send_ptr + _LIBGTOP_SEND_offset;
	memcpy (&_LIBGTOP_TEMP_len, _LIBGTOP_SEND_ptr, sizeof (size_t));
	_LIBGTOP_DATA_len += _LIBGTOP_TEMP_len;
	if (_LIBGTOP_DATA_len > data_size)
		return -GLIBTOP_ERROR_DEMARSHAL_ERROR;
	_LIBGTOP_DATA_offset += _LIBGTOP_TEMP_len;
	_LIBGTOP_demarshal_interface = _LIBGTOP_DATA_ptr;
	if (_LIBGTOP_TEMP_len) --_LIBGTOP_TEMP_len;
	*(_LIBGTOP_DATA_ptr + _LIBGTOP_TEMP_len) = 0;
	_LIBGTOP_SEND_offset += sizeof (size_t);
	_LIBGTOP_SEND_ptr = (char *) send_ptr + _LIBGTOP_SEND_offset;
	memcpy (&_LIBGTOP_demarshal_transport, _LIBGTOP_SEND_ptr, sizeof (unsigned));
	_LIBGTOP_SEND_offset += sizeof (unsigned);
	_LIBGTOP_SEND_ptr = (char *) send_ptr + _LIBGTOP_SEND_offset;
	memcpy (&_LIBGTOP_demarshal_protocol, _LIBGTOP_SEND_ptr, sizeof (unsigned));
	_LIBGTOP_SEND_offset += sizeof (unsigned);

	retval = glibtop_get_netload_p (server, &netload, _LIBGTOP_demarshal_interface, _LIBGTOP_demarshal_transport, _LIBGTOP_demarshal_protocol);
	if (retval_ptr)
		*retval_ptr = retval;

	/* write recv buffer */
	memcpy (_LIBGTOP_RECV_ptr, &netload, sizeof (glibtop_netload));
	_LIBGTOP_RECV_ptr += sizeof (glibtop_netload);

	*recv_buf_ptr = _LIBGTOP_RECV_buf;
	*recv_size_ptr = _LIBGTOP_RECV_len;

	return 0;
}

#endif /* GLIBTOP_SUID_NETLOAD */


#if GLIBTOP_SUID_PPP

static int
_glibtop_demarshal_ppp_i (glibtop *server, glibtop_backend *backend, const void *send_ptr, size_t send_size, void *data_ptr, size_t data_size, void **recv_buf_ptr, size_t *recv_size_ptr, void **recv_data_ptr, size_t *recv_data_size_ptr, int *retval_ptr)
{
	size_t _LIBGTOP_SEND_len, _LIBGTOP_RECV_len;
	off_t _LIBGTOP_SEND_offset;
	char *_LIBGTOP_RECV_buf, *_LIBGTOP_RECV_ptr;
	const char *_LIBGTOP_SEND_ptr;
	glibtop_ppp ppp;
	int retval = (int) 0;
	unsigned short _LIBGTOP_demarshal_device;
	unsigned short _LIBGTOP_demarshal_use_isdn;

	/* variable initialization */
	memset (&ppp, 0, sizeof (glibtop_ppp));
	_LIBGTOP_SEND_offset = 0;
	_LIBGTOP_SEND_ptr = (char *) send_ptr;
	memset (&_LIBGTOP_demarshal_device, 0, sizeof (unsigned short));
	memset (&_LIBGTOP_demarshal_use_isdn, 0, sizeof (unsigned short));

	/* send size */
	_LIBGTOP_SEND_len = 0;
	_LIBGTOP_SEND_len += sizeof (unsigned short);
	_LIBGTOP_SEND_len += sizeof (unsigned short);
	if (_LIBGTOP_SEND_len != send_size)
		return -GLIBTOP_ERROR_DEMARSHAL_ERROR;

	/* recv size */
	_LIBGTOP_RECV_len = 0;
	_LIBGTOP_RECV_len += sizeof (glibtop_ppp);

	/* recv buffer */
	_LIBGTOP_RECV_buf = glibtop_malloc_r (server, _LIBGTOP_RECV_len);
	_LIBGTOP_RECV_ptr = _LIBGTOP_RECV_buf;

	/* demarshal start */
	_LIBGTOP_SEND_ptr = (char *) send_ptr + _LIBGTOP_SEND_offset;
	memcpy (&_LIBGTOP_demarshal_device, _LIBGTOP_SEND_ptr, sizeof (unsigned short));
	_LIBGTOP_SEND_offset += sizeof (unsigned short);
	_LIBGTOP_SEND_ptr = (char *) send_ptr + _LIBGTOP_SEND_offset;
	memcpy (&_LIBGTOP_demarshal_use_isdn, _LIBGTOP_SEND_ptr, sizeof (unsigned short));
	_LIBGTOP_SEND_offset += sizeof (unsigned short);

	retval = glibtop_get_ppp_p (server, &ppp, _LIBGTOP_demarshal_device, _LIBGTOP_demarshal_use_isdn);
	if (retval_ptr)
		*retval_ptr = retval;

	/* write recv buffer */
	memcpy (_LIBGTOP_RECV_ptr, &ppp, sizeof (glibtop_ppp));
	_LIBGTOP_RECV_ptr += sizeof (glibtop_ppp);

	*recv_buf_ptr = _LIBGTOP_RECV_buf;
	*recv_size_ptr = _LIBGTOP_RECV_len;

	return 0;
}

#endif /* GLIBTOP_SUID_PPP */


int
glibtop_demarshal_func_i (glibtop *server, glibtop_backend *backend, unsigned command, const void *send_ptr, size_t send_size, void *data_ptr, size_t data_size, void **recv_buf_ptr, size_t *recv_size_ptr, void **recv_data_ptr, size_t *recv_data_size_ptr, int *retval_ptr)
{
	switch (command) {
#if GLIBTOP_SUID_CPU
	case GLIBTOP_CMND_CPU:
		return _glibtop_demarshal_cpu_i
			(server, backend, send_ptr, send_size,
			 data_ptr, data_size,
			 recv_buf_ptr, recv_size_ptr,
			 recv_data_ptr, recv_data_size_ptr, retval_ptr);
#endif /* GLIBTOP_SUID_CPU */
#if GLIBTOP_SUID_MEM
	case GLIBTOP_CMND_MEM:
		return _glibtop_demarshal_mem_i
			(server, backend, send_ptr, send_size,
			 data_ptr, data_size,
			 recv_buf_ptr, recv_size_ptr,
			 recv_data_ptr, recv_data_size_ptr, retval_ptr);
#endif /* GLIBTOP_SUID_MEM */
#if GLIBTOP_SUID_SWAP
	case GLIBTOP_CMND_SWAP:
		return _glibtop_demarshal_swap_i
			(server, backend, send_ptr, send_size,
			 data_ptr, data_size,
			 recv_buf_ptr, recv_size_ptr,
			 recv_data_ptr, recv_data_size_ptr, retval_ptr);
#endif /* GLIBTOP_SUID_SWAP */
#if GLIBTOP_SUID_UPTIME
	case GLIBTOP_CMND_UPTIME:
		return _glibtop_demarshal_uptime_i
			(server, backend, send_ptr, send_size,
			 data_ptr, data_size,
			 recv_buf_ptr, recv_size_ptr,
			 recv_data_ptr, recv_data_size_ptr, retval_ptr);
#endif /* GLIBTOP_SUID_UPTIME */
#if GLIBTOP_SUID_LOADAVG
	case GLIBTOP_CMND_LOADAVG:
		return _glibtop_demarshal_loadavg_i
			(server, backend, send_ptr, send_size,
			 data_ptr, data_size,
			 recv_buf_ptr, recv_size_ptr,
			 recv_data_ptr, recv_data_size_ptr, retval_ptr);
#endif /* GLIBTOP_SUID_LOADAVG */
#if GLIBTOP_SUID_SHM_LIMITS
	case GLIBTOP_CMND_SHM_LIMITS:
		return _glibtop_demarshal_shm_limits_i
			(server, backend, send_ptr, send_size,
			 data_ptr, data_size,
			 recv_buf_ptr, recv_size_ptr,
			 recv_data_ptr, recv_data_size_ptr, retval_ptr);
#endif /* GLIBTOP_SUID_SHM_LIMITS */
#if GLIBTOP_SUID_MSG_LIMITS
	case GLIBTOP_CMND_MSG_LIMITS:
		return _glibtop_demarshal_msg_limits_i
			(server, backend, send_ptr, send_size,
			 data_ptr, data_size,
			 recv_buf_ptr, recv_size_ptr,
			 recv_data_ptr, recv_data_size_ptr, retval_ptr);
#endif /* GLIBTOP_SUID_MSG_LIMITS */
#if GLIBTOP_SUID_SEM_LIMITS
	case GLIBTOP_CMND_SEM_LIMITS:
		return _glibtop_demarshal_sem_limits_i
			(server, backend, send_ptr, send_size,
			 data_ptr, data_size,
			 recv_buf_ptr, recv_size_ptr,
			 recv_data_ptr, recv_data_size_ptr, retval_ptr);
#endif /* GLIBTOP_SUID_SEM_LIMITS */
#if GLIBTOP_SUID_PROCLIST
	case GLIBTOP_CMND_PROCLIST:
		return _glibtop_demarshal_proclist_i
			(server, backend, send_ptr, send_size,
			 data_ptr, data_size,
			 recv_buf_ptr, recv_size_ptr,
			 recv_data_ptr, recv_data_size_ptr, retval_ptr);
#endif /* GLIBTOP_SUID_PROCLIST */
#if GLIBTOP_SUID_PROC_STATE
	case GLIBTOP_CMND_PROC_STATE:
		return _glibtop_demarshal_proc_state_i
			(server, backend, send_ptr, send_size,
			 data_ptr, data_size,
			 recv_buf_ptr, recv_size_ptr,
			 recv_data_ptr, recv_data_size_ptr, retval_ptr);
#endif /* GLIBTOP_SUID_PROC_STATE */
#if GLIBTOP_SUID_PROC_UID
	case GLIBTOP_CMND_PROC_UID:
		return _glibtop_demarshal_proc_uid_i
			(server, backend, send_ptr, send_size,
			 data_ptr, data_size,
			 recv_buf_ptr, recv_size_ptr,
			 recv_data_ptr, recv_data_size_ptr, retval_ptr);
#endif /* GLIBTOP_SUID_PROC_UID */
#if GLIBTOP_SUID_PROC_MEM
	case GLIBTOP_CMND_PROC_MEM:
		return _glibtop_demarshal_proc_mem_i
			(server, backend, send_ptr, send_size,
			 data_ptr, data_size,
			 recv_buf_ptr, recv_size_ptr,
			 recv_data_ptr, recv_data_size_ptr, retval_ptr);
#endif /* GLIBTOP_SUID_PROC_MEM */
#if GLIBTOP_SUID_PROC_TIME
	case GLIBTOP_CMND_PROC_TIME:
		return _glibtop_demarshal_proc_time_i
			(server, backend, send_ptr, send_size,
			 data_ptr, data_size,
			 recv_buf_ptr, recv_size_ptr,
			 recv_data_ptr, recv_data_size_ptr, retval_ptr);
#endif /* GLIBTOP_SUID_PROC_TIME */
#if GLIBTOP_SUID_PROC_SIGNAL
	case GLIBTOP_CMND_PROC_SIGNAL:
		return _glibtop_demarshal_proc_signal_i
			(server, backend, send_ptr, send_size,
			 data_ptr, data_size,
			 recv_buf_ptr, recv_size_ptr,
			 recv_data_ptr, recv_data_size_ptr, retval_ptr);
#endif /* GLIBTOP_SUID_PROC_SIGNAL */
#if GLIBTOP_SUID_PROC_KERNEL
	case GLIBTOP_CMND_PROC_KERNEL:
		return _glibtop_demarshal_proc_kernel_i
			(server, backend, send_ptr, send_size,
			 data_ptr, data_size,
			 recv_buf_ptr, recv_size_ptr,
			 recv_data_ptr, recv_data_size_ptr, retval_ptr);
#endif /* GLIBTOP_SUID_PROC_KERNEL */
#if GLIBTOP_SUID_PROC_SEGMENT
	case GLIBTOP_CMND_PROC_SEGMENT:
		return _glibtop_demarshal_proc_segment_i
			(server, backend, send_ptr, send_size,
			 data_ptr, data_size,
			 recv_buf_ptr, recv_size_ptr,
			 recv_data_ptr, recv_data_size_ptr, retval_ptr);
#endif /* GLIBTOP_SUID_PROC_SEGMENT */
#if GLIBTOP_SUID_PROC_ARGS
	case GLIBTOP_CMND_PROC_ARGS:
		return _glibtop_demarshal_proc_args_i
			(server, backend, send_ptr, send_size,
			 data_ptr, data_size,
			 recv_buf_ptr, recv_size_ptr,
			 recv_data_ptr, recv_data_size_ptr, retval_ptr);
#endif /* GLIBTOP_SUID_PROC_ARGS */
#if GLIBTOP_SUID_PROC_MAP
	case GLIBTOP_CMND_PROC_MAP:
		return _glibtop_demarshal_proc_map_i
			(server, backend, send_ptr, send_size,
			 data_ptr, data_size,
			 recv_buf_ptr, recv_size_ptr,
			 recv_data_ptr, recv_data_size_ptr, retval_ptr);
#endif /* GLIBTOP_SUID_PROC_MAP */
#if GLIBTOP_SUID_INTERFACE_NAMES
	case GLIBTOP_CMND_INTERFACE_NAMES:
		return _glibtop_demarshal_interface_names_i
			(server, backend, send_ptr, send_size,
			 data_ptr, data_size,
			 recv_buf_ptr, recv_size_ptr,
			 recv_data_ptr, recv_data_size_ptr, retval_ptr);
#endif /* GLIBTOP_SUID_INTERFACE_NAMES */
#if GLIBTOP_SUID_NETINFO
	case GLIBTOP_CMND_NETINFO:
		return _glibtop_demarshal_netinfo_i
			(server, backend, send_ptr, send_size,
			 data_ptr, data_size,
			 recv_buf_ptr, recv_size_ptr,
			 recv_data_ptr, recv_data_size_ptr, retval_ptr);
#endif /* GLIBTOP_SUID_NETINFO */
#if GLIBTOP_SUID_NETLOAD
	case GLIBTOP_CMND_NETLOAD:
		return _glibtop_demarshal_netload_i
			(server, backend, send_ptr, send_size,
			 data_ptr, data_size,
			 recv_buf_ptr, recv_size_ptr,
			 recv_data_ptr, recv_data_size_ptr, retval_ptr);
#endif /* GLIBTOP_SUID_NETLOAD */
#if GLIBTOP_SUID_PPP
	case GLIBTOP_CMND_PPP:
		return _glibtop_demarshal_ppp_i
			(server, backend, send_ptr, send_size,
			 data_ptr, data_size,
			 recv_buf_ptr, recv_size_ptr,
			 recv_data_ptr, recv_data_size_ptr, retval_ptr);
#endif /* GLIBTOP_SUID_PPP */
	default:
		return -GLIBTOP_ERROR_INVALID_ARGUMENT;
	}
}


