/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * This library is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <libical-glib/i-cal-geo-type.h>

G_DEFINE_TYPE (ICalGeoType, i_cal_geo_type, I_CAL_TYPE_OBJECT)

static void
i_cal_geo_type_class_init (ICalGeoTypeClass *klass)
{	
	g_type_class_add_private (klass, sizeof (ICalGeoType));
}

static void
i_cal_geo_type_init (ICalGeoType *self)
{
}

/**
 * i_cal_geo_type_new_full: (skip)
 * @native: The native libical object.
 *
 * Create a new libical-glib object from the native libical object and the owner.
 * 
 * Returns: (transfer full): The newly create libical-glib object.
 *
 * Since: 1.0
 **/
ICalGeoType *
i_cal_geo_type_new_full (struct icalgeotype native)
{
	ICalGeoType *object;
	struct icalgeotype *clone;
	object = g_object_new (I_CAL_GEO_TYPE_TYPE, NULL);
	clone = g_new (struct icalgeotype, 1);
	*clone = native;
	i_cal_object_construct ((ICalObject *)object,
		        	(gpointer) clone,
		        	(GDestroyNotify) g_free,
		        	FALSE,
		        	NULL);
    							
	return object;
}

/**
 * i_cal_geo_type_new_default: (skip)
 *
 * Create a new default #ICalGeoType.
 *
 * Returns: (transfer full): The newly created #ICalGeoType
 *
 * Since: 1.0
 *
 **/
struct icalgeotype
i_cal_geo_type_new_default (void)
{
	struct icalgeotype geotype;
	geotype.lat = 0;
	geotype.lon = 0;
	return geotype;
}

/**
 * i_cal_geo_type_get_lat:
 * @geo_type: The #ICalGeoType to be queried.
 *
 * Get the lat of #ICalGeoType.
 *
 * Returns: The lat.
 *
 * Since: 1.0
 *
 **/
gdouble
i_cal_geo_type_get_lat (ICalGeoType *geo_type)
{
	g_return_val_if_fail (geo_type != NULL, 0);
	return ((struct icalgeotype *)i_cal_object_get_native ((ICalObject *)geo_type))->lat;
}

/**
 * i_cal_geo_type_set_lat:
 * @geo_type: The #ICalGeoType to be set.
 * @lat: The lat.
 *
 * Set the lat of #ICalGeoType.
 *
 * Since: 1.0
 *
 **/
void
i_cal_geo_type_set_lat (ICalGeoType *geo_type, 
                        gdouble lat)
{
	g_return_if_fail (geo_type != NULL && I_CAL_IS_GEO_TYPE (geo_type));
	((struct icalgeotype *)i_cal_object_get_native ((ICalObject *)geo_type))->lat = lat;
}

/**
 * i_cal_geo_type_get_lon:
 * @geo_type: The #ICalGeoType to be queried.
 *
 * Get the lon of #ICalGeoType.
 *
 * Returns: The lon.
 *
 * Since: 1.0
 *
 **/
gdouble
i_cal_geo_type_get_lon (ICalGeoType *geo_type)
{
	g_return_val_if_fail (geo_type != NULL, 0);
	return ((struct icalgeotype *)i_cal_object_get_native ((ICalObject *)geo_type))->lon;
}

/**
 * i_cal_geo_type_set_lon:
 * @geo_type: The #ICalGeoType to be set.
 * @lon: The lon.
 *
 * Set the lon of #ICalGeoType.
 *
 * Since: 1.0
 *
 **/
void
i_cal_geo_type_set_lon (ICalGeoType *geo_type, 
                        gdouble lon)
{
	g_return_if_fail (geo_type != NULL && I_CAL_IS_GEO_TYPE (geo_type));
	((struct icalgeotype *)i_cal_object_get_native ((ICalObject *)geo_type))->lon = lon;
}