/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * This library is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#if !defined (__LIBICAL_GLIB_H_INSIDE__) && !defined (LIBICAL_GLIB_COMPILATION)
#error "Only <libical-glib/libical-glib.h> can be included directly."
#endif

#ifndef I_CAL_TIMEZONETYPE_H
#define I_CAL_TIMEZONETYPE_H

#include <libical-glib/i-cal-timetype.h>
#include <libical-glib/i-cal-object.h>

G_BEGIN_DECLS

#define I_CAL_TIMEZONETYPE_TYPE \
        (i_cal_timezonetype_get_type ())
#define I_CAL_TIMEZONETYPE(obj) \
        (G_TYPE_CHECK_INSTANCE_CAST \
        ((obj), I_CAL_TIMEZONETYPE_TYPE, ICalTimezonetype))
#define I_CAL_TIMEZONETYPE_CLASS(klass) \
        (G_TYPE_CHECK_CLASS_CAST \
        ((klass), I_CAL_TIMEZONETYPE_TYPE, ICalTimezonetypeClass))
#define I_CAL_IS_TIMEZONETYPE(obj) \
        (G_TYPE_CHECK_INSTANCE_TYPE \
        ((obj), I_CAL_TIMEZONETYPE_TYPE))
#define I_CAL_IS_TIMEZONETYPE_CLASS(klass) \
        (G_TYPE_CHECK_CLASS_TYPE \
        ((klass), I_CAL_TIMEZONETYPE_TYPE))

/**
 * ICalTimezonetype:
 *
 * This is the ICalTimezonetype instance.
 */
typedef struct _ICalTimezonetype ICalTimezonetype;

/**
 * ICalTimezonetypeClass:
 *
 * This is the ICalTimezonetype class.
 */
typedef struct _ICalTimezonetypeClass ICalTimezonetypeClass;

struct _ICalTimezonetype {
	/*< private >*/
	ICalObject parent;
};

struct _ICalTimezonetypeClass {
	/*< private >*/
	ICalObjectClass parent;
};

typedef struct _ICalTimetype ICalTimetype;

ICalTimezonetype *
		i_cal_timezonetype_new_full	(struct icaltimezonetype native);
GType 		i_cal_timezonetype_get_type	(void);
struct icaltimezonetype 
		i_cal_timezonetype_new_default	(void);
const gchar *	i_cal_timezonetype_get_tzid	(ICalTimezonetype *timezonetype);
const gchar *	i_cal_timezonetype_get_tzurl	(ICalTimezonetype *timezonetype);
ICalTimetype *	i_cal_timezonetype_get_last_mod	(ICalTimezonetype *timezonetype);
void		i_cal_timezonetype_set_last_mod	(ICalTimezonetype *timezonetype,
						 ICalTimetype *last_mod);

G_END_DECLS

#endif /* I_CAL_TIMEZONETYPE_H */