/* Generated file (by src-generator) */

/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2015 William Yu <williamyu@gnome.org>
 *
 * This library is free software: you can redistribute it and/or modify it
 * under the terms of version 2.1. of the GNU Lesser General Public License
 * as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <libical-glib/i-cal-recur-iterator.h>
#include <libical-glib/i-cal-recurrence-type.h>
#include <libical-glib/i-cal-timetype.h>

G_DEFINE_TYPE (ICalRecurIterator, i_cal_recur_iterator, I_CAL_TYPE_OBJECT)

static void
i_cal_recur_iterator_class_init (ICalRecurIteratorClass *klass)
{	
	g_type_class_add_private (klass, sizeof (ICalRecurIterator));
}

static void
i_cal_recur_iterator_init (ICalRecurIterator *self)
{
}

/**
 * i_cal_recur_iterator_new_full: (skip)
 * @native: The native libical object.
 * @owner: The parent.
 *
 * Create a new libical-glib object from the native libical object and the owner.
 * 
 * Returns: (transfer full): The newly create libical-glib object.
 *
 * Since: 1.0
 **/
ICalRecurIterator *
i_cal_recur_iterator_new_full (icalrecur_iterator *native, 
                               GObject *owner)
{
	ICalRecurIterator *object;
	if (native == NULL)
		return NULL;
	object = g_object_new (I_CAL_RECUR_ITERATOR_TYPE, NULL);
	i_cal_object_construct ((ICalObject *)object,
		        	(gpointer) native,
		        	(GDestroyNotify) icalrecur_iterator_free,
		        	FALSE,
		        	owner);
    							
	return object;
}

/**
 * i_cal_recur_iterator_new:
 * @rule: The rule applied on the #ICalRecurIterator.
 * @dtstart: The start time of the recurrence.
 *
 * Create a #ICalRecurIterator.
 *
 * Returns: (transfer full): The newly created #ICalRecurIterator
 *
 * Since: 1.0
 *
 **/
ICalRecurIterator *
i_cal_recur_iterator_new (ICalRecurrenceType *rule, 
                          ICalTimetype *dtstart)
{
	g_return_val_if_fail (I_CAL_IS_RECURRENCE_TYPE (rule), NULL);
	g_return_val_if_fail (rule != NULL, NULL);
	g_return_val_if_fail (I_CAL_IS_TIMETYPE (dtstart), NULL);
	g_return_val_if_fail (dtstart != NULL, NULL);

	return i_cal_recur_iterator_new_full (icalrecur_iterator_new (* (struct icalrecurrencetype *) i_cal_object_get_native (I_CAL_OBJECT (rule)), * (struct icaltimetype *) i_cal_object_get_native (I_CAL_OBJECT (dtstart))), NULL);
}

/**
 * i_cal_recur_iterator_next:
 * @iterator: The iterator.
 *
 * Get the next occurrence from an iterator.
 *
 * Returns: (transfer none): The next occurrence according to this recurrence rule.
 *
 * Since: 1.0
 *
 **/
ICalTimetype *
i_cal_recur_iterator_next (ICalRecurIterator *iterator)
{
	g_return_val_if_fail (I_CAL_IS_RECUR_ITERATOR (iterator), NULL);
	g_return_val_if_fail (iterator != NULL, NULL);

	return i_cal_timetype_new_full (icalrecur_iterator_next ((icalrecur_iterator *)i_cal_object_get_native (I_CAL_OBJECT (iterator))));
}

/**
 * i_cal_recur_iterator_free: (skip)
 * @iterator: The iterator to be freed.
 *
 * Free an iterator.
 *
 * Since: 1.0
 *
 **/
void
i_cal_recur_iterator_free (ICalRecurIterator *iterator)
{
	g_return_if_fail (I_CAL_IS_RECUR_ITERATOR (iterator));
	g_return_if_fail (iterator != NULL);

	icalrecur_iterator_free ((icalrecur_iterator *)i_cal_object_get_native (I_CAL_OBJECT (iterator)));
}
