/* Generated file (by src-generator) */

/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2015 William Yu <williamyu@gnome.org>
 *
 * This library is free software: you can redistribute it and/or modify it
 * under the terms of version 2.1. of the GNU Lesser General Public License
 * as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <libical-glib/i-cal-time-span.h>

G_DEFINE_TYPE (ICalTimeSpan, i_cal_time_span, I_CAL_TYPE_OBJECT)

static void
i_cal_time_span_class_init (ICalTimeSpanClass *klass)
{	
	g_type_class_add_private (klass, sizeof (ICalTimeSpan));
}

static void
i_cal_time_span_init (ICalTimeSpan *self)
{
}

/**
 * i_cal_time_span_new_full: (skip)
 * @native: The native libical object.
 *
 * Create a new libical-glib object from the native libical object and the owner.
 * 
 * Returns: (transfer full): The newly create libical-glib object.
 *
 * Since: 1.0
 **/
ICalTimeSpan *
i_cal_time_span_new_full (struct icaltime_span native)
{
	ICalTimeSpan *object;
	struct icaltime_span *clone;
	object = g_object_new (I_CAL_TIME_SPAN_TYPE, NULL);
	clone = g_new (struct icaltime_span, 1);
	*clone = native;
	i_cal_object_construct ((ICalObject *)object,
		        	(gpointer) clone,
		        	(GDestroyNotify) g_free,
		        	FALSE,
		        	NULL);
    							
	return object;
}

/**
 * i_cal_time_span_get_start:
 * @timespan: The #ICalTimeSpan to be queried.
 *
 * Get the start of #ICalTimeSpan.
 *
 * Returns: The start.
 *
 * Since: 1.0
 *
 **/
time_t
i_cal_time_span_get_start (ICalTimeSpan *timespan)
{
	g_return_val_if_fail (timespan != NULL, 0);
	return ((struct icaltime_span *)i_cal_object_get_native ((ICalObject *)timespan))->start;
}

/**
 * i_cal_time_span_set_start:
 * @timespan: The #ICalTimeSpan to be set.
 * @start: The start.
 *
 * Set the start of #ICalTimeSpan.
 *
 * Since: 1.0
 *
 **/
void
i_cal_time_span_set_start (ICalTimeSpan *timespan, 
                           time_t start)
{
	g_return_if_fail (timespan != NULL);
	((struct icaltime_span *)i_cal_object_get_native ((ICalObject *)timespan))->start = start;
}

/**
 * i_cal_time_span_get_end:
 * @timespan: The #ICalTimeSpan to be queried.
 *
 * Get the end of #ICalTimeSpan.
 *
 * Returns: The end.
 *
 * Since: 1.0
 *
 **/
time_t
i_cal_time_span_get_end (ICalTimeSpan *timespan)
{
	g_return_val_if_fail (timespan != NULL, 0);
	return ((struct icaltime_span *)i_cal_object_get_native ((ICalObject *)timespan))->end;
}

/**
 * i_cal_time_span_set_end:
 * @timespan: The #ICalTimeSpan to be set.
 * @end: The end.
 *
 * Set the end of #ICalTimeSpan.
 *
 * Since: 1.0
 *
 **/
void
i_cal_time_span_set_end (ICalTimeSpan *timespan, 
                         time_t end)
{
	g_return_if_fail (timespan != NULL);
	((struct icaltime_span *)i_cal_object_get_native ((ICalObject *)timespan))->end = end;
}

/**
 * i_cal_time_span_is_busy:
 * @timespan: The #ICalTimeSpan to be queried.
 *
 * Get the is_busy of #ICalTimeSpan.
 *
 * Returns: The is_busy.
 *
 * Since: 1.0
 *
 **/
gint
i_cal_time_span_is_busy (ICalTimeSpan *timespan)
{
	g_return_val_if_fail (timespan != NULL, 0);
	return ((struct icaltime_span *)i_cal_object_get_native ((ICalObject *)timespan))->is_busy;
}

/**
 * i_cal_time_span_set_is_busy:
 * @timespan: The #ICalTimeSpan to be set.
 * @is_busy: The is_busy.
 *
 * Set the is_busy of #ICalTimeSpan.
 *
 * Since: 1.0
 *
 **/
void
i_cal_time_span_set_is_busy (ICalTimeSpan *timespan, 
                             gint is_busy)
{
	g_return_if_fail (timespan != NULL);
	((struct icaltime_span *)i_cal_object_get_native ((ICalObject *)timespan))->is_busy = is_busy;
}
