/* Generated file (by src-generator) */

/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2015 William Yu <williamyu@gnome.org>
 *
 * This library is free software: you can redistribute it and/or modify it
 * under the terms of version 2.1. of the GNU Lesser General Public License
 * as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#if !defined (__LIBICAL_GLIB_H_INSIDE__) && !defined (LIBICAL_GLIB_COMPILATION)
#error "Only <libical-glib/libical-glib.h> can be included directly."
#endif

#ifndef I_CAL_TIMEZONE_H
#define I_CAL_TIMEZONE_H

#include <libical-glib/i-cal-object.h>

G_BEGIN_DECLS

#define I_CAL_TIMEZONE_TYPE \
        (i_cal_timezone_get_type ())
#define I_CAL_TIMEZONE(obj) \
        (G_TYPE_CHECK_INSTANCE_CAST \
        ((obj), I_CAL_TIMEZONE_TYPE, ICalTimezone))
#define I_CAL_TIMEZONE_CLASS(klass) \
        (G_TYPE_CHECK_CLASS_CAST \
        ((klass), I_CAL_TIMEZONE_TYPE, ICalTimezoneClass))
#define I_CAL_IS_TIMEZONE(obj) \
        (G_TYPE_CHECK_INSTANCE_TYPE \
        ((obj), I_CAL_TIMEZONE_TYPE))
#define I_CAL_IS_TIMEZONE_CLASS(klass) \
        (G_TYPE_CHECK_CLASS_TYPE \
        ((klass), I_CAL_TIMEZONE_TYPE))

/**
 * ICalTimezone:
 *
 * This is the ICalTimezone instance.
 */
typedef struct _ICalTimezone ICalTimezone;

/**
 * ICalTimezoneClass:
 *
 * This is the ICalTimezone class.
 */
typedef struct _ICalTimezoneClass ICalTimezoneClass;

struct _ICalTimezone {
	/*< private >*/
	ICalObject parent;
};

struct _ICalTimezoneClass {
	/*< private >*/
	ICalObjectClass parent;
};

typedef struct _ICalTimetype ICalTimetype;
typedef struct _ICalArray ICalArray;
typedef struct _ICalComponent ICalComponent;

GType 		i_cal_timezone_get_type		(void);
ICalTimezone *	i_cal_timezone_new		(void);
ICalTimezone *	i_cal_timezone_copy		(const ICalTimezone *zone);
void		i_cal_timezone_free		(ICalTimezone *zone,
						 gint free_struct);
void		i_cal_timezone_set_tzid_prefix	(const gchar *new_prefix);
void		i_cal_timezone_free_builtin_timezones
						(void);
ICalTimezone *	i_cal_timezone_get_builtin_timezone
						(const gchar *location);
ICalTimezone *	i_cal_timezone_get_builtin_timezone_from_offset
						(gint offset,
						 const gchar *tzname);
ICalTimezone *	i_cal_timezone_get_builtin_timezone_from_tzid
						(const gchar *tzid);
ICalArray *	i_cal_timezone_get_builtin_timezones
						(void);
ICalTimezone *	i_cal_timezone_get_utc_timezone	(void);
const gchar *	i_cal_timezone_get_tzid		(const ICalTimezone *zone);
const gchar *	i_cal_timezone_get_location	(const ICalTimezone *zone);
const gchar *	i_cal_timezone_get_tznames	(const ICalTimezone *zone);
gdouble 		i_cal_timezone_get_latitude	(const ICalTimezone *zone);
gdouble 		i_cal_timezone_get_longitude	(const ICalTimezone *zone);
ICalComponent *	i_cal_timezone_get_component	(const ICalTimezone *zone);
gint 		i_cal_timezone_set_component	(ICalTimezone *zone,
						 ICalComponent *comp);
const gchar *	i_cal_timezone_get_display_name	(const ICalTimezone *zone);
void		i_cal_timezone_convert_time	(ICalTimetype *tt,
						 ICalTimezone *from_zone,
						 ICalTimezone *to_zone);
void		i_cal_timezone_get_utc_offset	(ICalTimezone *zone,
						 ICalTimetype *tt,
						 gint *is_daylight);
void		i_cal_timezone_get_utc_offset_of_utc_time
						(ICalTimezone *zone,
						 ICalTimetype *tt,
						 gint *is_daylight);
ICalArray *	i_cal_timezone_array_new	(void);
void		i_cal_timezone_array_append_from_vtimezone
						(ICalArray *timezones,
						 ICalComponent *child);
void		i_cal_timezone_array_free	(ICalArray *timezones);
void		i_cal_timezone_set_zone_directory
						(gchar *path);
void		i_cal_timezone_free_zone_directory
						(void);
void		i_cal_timezone_release_zone_tab	(void);
gint 		i_cal_timezone_dump_changes	(ICalTimezone *zone,
						 gint max_year,
						 FILE *fp);
ICalTimezone *	i_cal_timezone_array_element_at	(ICalArray *timezones,
						 guint index);

G_END_DECLS

#endif /* I_CAL_TIMEZONE_H */
