/* Generated file (by src-generator) */

/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2015 William Yu <williamyu@gnome.org>
 *
 * This library is free software: you can redistribute it and/or modify it
 * under the terms of version 2.1. of the GNU Lesser General Public License
 * as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "i-cal-duration-type.h"
#include "libical-glib-private.h"

G_DEFINE_TYPE (ICalDurationType, i_cal_duration_type, I_CAL_TYPE_OBJECT)

static void
i_cal_duration_type_class_init (ICalDurationTypeClass *klass)
{	
	g_type_class_add_private (klass, sizeof (ICalDurationType));
}

static void
i_cal_duration_type_init (ICalDurationType *self)
{
}

/**
 * i_cal_duration_type_new_full: (skip)
 * @native: The native libical object.
 *
 * Create a new libical-glib object from the native libical object and the owner.
 * 
 * Returns: (transfer full): The newly create libical-glib object.
 *
 * Since: 1.0
 **/
ICalDurationType *
i_cal_duration_type_new_full (struct icaldurationtype native)
{
	ICalDurationType *object;
	struct icaldurationtype *clone;
	object = g_object_new (I_CAL_DURATION_TYPE_TYPE, NULL);
	clone = g_new (struct icaldurationtype, 1);
	*clone = native;
	i_cal_object_construct ((ICalObject *)object,
		        	(gpointer) clone,
		        	(GDestroyNotify) g_free,
		        	FALSE,
		        	NULL);
    							
	return object;
}

/**
 * i_cal_duration_type_is_neg:
 * @duration_type: The #ICalDurationType to be queried.
 *
 * Get the is_neg of #ICalDurationType.
 *
 * Returns: The is_neg.
 *
 * Since: 1.0
 *
 **/
gint
i_cal_duration_type_is_neg (ICalDurationType *duration_type)
{
	g_return_val_if_fail (duration_type != NULL, 0);
	return ((struct icaldurationtype *)i_cal_object_get_native ((ICalObject *)duration_type))->is_neg;
}

/**
 * i_cal_duration_type_set_is_neg:
 * @duration_type: The #ICalDurationType to be set.
 * @is_neg: The is_neg.
 *
 * Set the is_neg of #ICalDurationType.
 *
 * Since: 1.0
 *
 **/
void
i_cal_duration_type_set_is_neg (ICalDurationType *duration_type, 
                                gint is_neg)
{
	g_return_if_fail (duration_type != NULL && I_CAL_IS_DURATION_TYPE (duration_type));
	((struct icaldurationtype *)i_cal_object_get_native ((ICalObject *)duration_type))->is_neg = is_neg;
}

/**
 * i_cal_duration_type_get_days:
 * @duration_type: The #ICalDurationType to be queried.
 *
 * Get the days of #ICalDurationType.
 *
 * Returns: The days.
 *
 * Since: 1.0
 *
 **/
guint
i_cal_duration_type_get_days (ICalDurationType *duration_type)
{
	g_return_val_if_fail (duration_type != NULL, 0);
	return ((struct icaldurationtype *)i_cal_object_get_native ((ICalObject *)duration_type))->days;
}

/**
 * i_cal_duration_type_set_days:
 * @duration_type: The #ICalDurationType to be set.
 * @days: The days.
 *
 * Set the days of #ICalDurationType.
 *
 * Since: 1.0
 *
 **/
void
i_cal_duration_type_set_days (ICalDurationType *duration_type, 
                              guint days)
{
	g_return_if_fail (duration_type != NULL && I_CAL_IS_DURATION_TYPE (duration_type));
	((struct icaldurationtype *)i_cal_object_get_native ((ICalObject *)duration_type))->days = days;
}

/**
 * i_cal_duration_type_get_weeks:
 * @duration_type: The #ICalDurationType to be queried.
 *
 * Get the weeks of #ICalDurationType.
 *
 * Returns: The weeks.
 *
 * Since: 1.0
 *
 **/
guint
i_cal_duration_type_get_weeks (ICalDurationType *duration_type)
{
	g_return_val_if_fail (duration_type != NULL, 0);
	return ((struct icaldurationtype *)i_cal_object_get_native ((ICalObject *)duration_type))->weeks;
}

/**
 * i_cal_duration_type_set_weeks:
 * @duration_type: The #ICalDurationType to be set.
 * @weeks: The weeks.
 *
 * Set the weeks of #ICalDurationType.
 *
 * Since: 1.0
 *
 **/
void
i_cal_duration_type_set_weeks (ICalDurationType *duration_type, 
                               guint weeks)
{
	g_return_if_fail (duration_type != NULL && I_CAL_IS_DURATION_TYPE (duration_type));
	((struct icaldurationtype *)i_cal_object_get_native ((ICalObject *)duration_type))->weeks = weeks;
}

/**
 * i_cal_duration_type_get_hours:
 * @duration_type: The #ICalDurationType to be queried.
 *
 * Get the hours of #ICalDurationType.
 *
 * Returns: The hours.
 *
 * Since: 1.0
 *
 **/
guint
i_cal_duration_type_get_hours (ICalDurationType *duration_type)
{
	g_return_val_if_fail (duration_type != NULL, 0);
	return ((struct icaldurationtype *)i_cal_object_get_native ((ICalObject *)duration_type))->hours;
}

/**
 * i_cal_duration_type_set_hours:
 * @duration_type: The #ICalDurationType to be set.
 * @hours: The hours.
 *
 * Set the hours of #ICalDurationType.
 *
 * Since: 1.0
 *
 **/
void
i_cal_duration_type_set_hours (ICalDurationType *duration_type, 
                               guint hours)
{
	g_return_if_fail (duration_type != NULL && I_CAL_IS_DURATION_TYPE (duration_type));
	((struct icaldurationtype *)i_cal_object_get_native ((ICalObject *)duration_type))->hours = hours;
}

/**
 * i_cal_duration_type_get_minutes:
 * @duration_type: The #ICalDurationType to be queried.
 *
 * Get the minutes of #ICalDurationType.
 *
 * Returns: The minutes.
 *
 * Since: 1.0
 *
 **/
guint
i_cal_duration_type_get_minutes (ICalDurationType *duration_type)
{
	g_return_val_if_fail (duration_type != NULL, 0);
	return ((struct icaldurationtype *)i_cal_object_get_native ((ICalObject *)duration_type))->minutes;
}

/**
 * i_cal_duration_type_set_minutes:
 * @duration_type: The #ICalDurationType to be set.
 * @minutes: The minutes.
 *
 * Set the minutes of #ICalDurationType.
 *
 * Since: 1.0
 *
 **/
void
i_cal_duration_type_set_minutes (ICalDurationType *duration_type, 
                                 guint minutes)
{
	g_return_if_fail (duration_type != NULL && I_CAL_IS_DURATION_TYPE (duration_type));
	((struct icaldurationtype *)i_cal_object_get_native ((ICalObject *)duration_type))->minutes = minutes;
}

/**
 * i_cal_duration_type_get_seconds:
 * @duration_type: The #ICalDurationType to be queried.
 *
 * Get the seconds of #ICalDurationType.
 *
 * Returns: The seconds.
 *
 * Since: 1.0
 *
 **/
guint
i_cal_duration_type_get_seconds (ICalDurationType *duration_type)
{
	g_return_val_if_fail (duration_type != NULL, 0);
	return ((struct icaldurationtype *)i_cal_object_get_native ((ICalObject *)duration_type))->seconds;
}

/**
 * i_cal_duration_type_set_seconds:
 * @duration_type: The #ICalDurationType to be set.
 * @seconds: The seconds.
 *
 * Set the seconds of #ICalDurationType.
 *
 * Since: 1.0
 *
 **/
void
i_cal_duration_type_set_seconds (ICalDurationType *duration_type, 
                                 guint seconds)
{
	g_return_if_fail (duration_type != NULL && I_CAL_IS_DURATION_TYPE (duration_type));
	((struct icaldurationtype *)i_cal_object_get_native ((ICalObject *)duration_type))->seconds = seconds;
}

/**
 * i_cal_duration_type_from_int:
 * @t: the duration in second
 *
 * Create a #ICalDurationType from the duration in second
 *
 * Returns: (transfer full): The newly created #ICalDurationType
 *
 * Since: 1.0
 *
 **/
ICalDurationType *
i_cal_duration_type_from_int (gint t)
{
	return i_cal_duration_type_new_full (icaldurationtype_from_int (t));
}

/**
 * i_cal_duration_type_from_string:
 * @str: The string representation of the duration
 *
 * Create a #ICalDurationType from the duration in string
 *
 * Returns: (transfer full): The newly created #ICalDurationType
 *
 * Since: 1.0
 *
 **/
ICalDurationType *
i_cal_duration_type_from_string (const gchar *str)
{
	g_return_val_if_fail (str != NULL, NULL);

	return i_cal_duration_type_new_full (icaldurationtype_from_string (str));
}

/**
 * i_cal_duration_type_as_int:
 * @duration: The #ICalDurationType to be converted
 *
 * Convert the #ICalDurationType to the representation in second
 *
 * Returns: The duration in second
 *
 * Since: 1.0
 *
 **/
gint
i_cal_duration_type_as_int (ICalDurationType *duration)
{
	g_return_val_if_fail (I_CAL_IS_DURATION_TYPE (duration), 0);
	g_return_val_if_fail (duration != NULL, 0);

	return icaldurationtype_as_int (* (struct icaldurationtype *) i_cal_object_get_native (I_CAL_OBJECT (duration)));
}

/**
 * i_cal_duration_type_as_ical_string_r:
 * @duration: The #ICalDurationType to be converted
 *
 * Convert the #ICalDurationType to the representation in string
 *
 * Returns: (transfer full): The duration in string
 *
 * Since: 1.0
 *
 **/
gchar *
i_cal_duration_type_as_ical_string_r (ICalDurationType *duration)
{
	g_return_val_if_fail (I_CAL_IS_DURATION_TYPE (duration), NULL);
	g_return_val_if_fail (duration != NULL, NULL);

	return icaldurationtype_as_ical_string_r (* (struct icaldurationtype *) i_cal_object_get_native (I_CAL_OBJECT (duration)));
}

/**
 * i_cal_duration_type_null_duration:
 *
 * Create a #ICalDurationType with all the fields to be zero
 *
 * Returns: (transfer full): The newly created #ICalDurationType
 *
 * Since: 1.0
 *
 **/
ICalDurationType *
i_cal_duration_type_null_duration (void)
{
	return i_cal_duration_type_new_full (icaldurationtype_null_duration ());
}

/**
 * i_cal_duration_type_bad_duration:
 *
 * Create a bad #ICalDurationType
 *
 * Returns: (transfer full): The newly created #ICalDurationType
 *
 * Since: 1.0
 *
 **/
ICalDurationType *
i_cal_duration_type_bad_duration (void)
{
	return i_cal_duration_type_new_full (icaldurationtype_bad_duration ());
}

/**
 * i_cal_duration_type_is_null_duration:
 * @duration: The #ICalDurationType to be checked
 *
 * Check whether the #ICalDurationType is the null_duration
 *
 * Returns: 1 if @duration is the null_duration, 0 if not.
 *
 * Since: 1.0
 *
 **/
gint
i_cal_duration_type_is_null_duration (ICalDurationType *duration)
{
	g_return_val_if_fail (I_CAL_IS_DURATION_TYPE (duration), 0);
	g_return_val_if_fail (duration != NULL, 0);

	return icaldurationtype_is_null_duration (* (struct icaldurationtype *) i_cal_object_get_native (I_CAL_OBJECT (duration)));
}

/**
 * i_cal_duration_type_is_bad_duration:
 * @duration: The #ICalDurationType to be checked
 *
 * Check whether the #ICalDurationType is the bad_duration
 *
 * Returns: 1 if @duration is the bad_duration, 0 if not.
 *
 * Since: 1.0
 *
 **/
gint
i_cal_duration_type_is_bad_duration (ICalDurationType *duration)
{
	g_return_val_if_fail (I_CAL_IS_DURATION_TYPE (duration), 0);
	g_return_val_if_fail (duration != NULL, 0);

	return icaldurationtype_is_bad_duration (* (struct icaldurationtype *) i_cal_object_get_native (I_CAL_OBJECT (duration)));
}
