/* Generated file (by src-generator) */

/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2015 William Yu <williamyu@gnome.org>
 *
 * This library is free software: you can redistribute it and/or modify it
 * under the terms of version 2.1. of the GNU Lesser General Public License
 * as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "i-cal-parser.h"
#include "libical-glib-private.h"
#include "i-cal-component.h"

G_DEFINE_TYPE (ICalParser, i_cal_parser, I_CAL_TYPE_OBJECT)

static void
i_cal_parser_class_init (ICalParserClass *klass)
{	
	g_type_class_add_private (klass, sizeof (ICalParser));
}

static void
i_cal_parser_init (ICalParser *self)
{
}

/**
 * i_cal_parser_new_full: (skip)
 * @native: The native libical object.
 * @owner: The parent.
 *
 * Create a new libical-glib object from the native libical object and the owner.
 * 
 * Returns: (transfer full): The newly create libical-glib object.
 *
 * Since: 1.0
 **/
ICalParser *
i_cal_parser_new_full (icalparser *native, 
                       GObject *owner)
{
	ICalParser *object;
	if (native == NULL)
		return NULL;
	object = g_object_new (I_CAL_PARSER_TYPE, NULL);
	i_cal_object_construct ((ICalObject *)object,
		        	(gpointer) native,
		        	(GDestroyNotify) icalparser_free,
		        	FALSE,
		        	owner);
    							
	return object;
}

/**
 * i_cal_parser_new:
 *
 * Create a default #ICalParser.
 *
 * Returns: (transfer full): The newly created #ICalParser.
 *
 * Since: 1.0
 *
 **/
ICalParser *
i_cal_parser_new (void)
{
	return i_cal_parser_new_full (icalparser_new (), NULL);
}

/**
 * i_cal_parser_add_line:
 * @parser: (in) (transfer full): The #ICalParser used to parse the string into the #ICalComponent.
 * @str: (allow-none) (transfer none): A line of string representation of the #ICalComponent.
 *
 * Add a line at one time into the #ICalParser until the parsing is complete and #ICalComponent will be
 * returned.
 *
 * Returns: (allow-none) (transfer full): The complete #ICalComponent.
 *
 * Since: 1.0
 *
 **/
ICalComponent *
i_cal_parser_add_line (ICalParser *parser, 
                       gchar *str)
{
	g_return_val_if_fail (I_CAL_IS_PARSER (parser), NULL);
	g_return_val_if_fail (parser != NULL, NULL);

	return i_cal_component_new_full (icalparser_add_line ((icalparser *)i_cal_object_get_native (I_CAL_OBJECT (parser)), str), (gpointer) parser);
}

/**
 * i_cal_parser_clean:
 * @parser: The parser to be cleaned and queried.
 *
 * We won't get a clean exit if some components did not have an "END" tag. Clear off any component that
 * may be left in the list
 *
 * Returns: (allow-none) (transfer full): The root #ICalComponent in @parser.
 *
 * Since: 1.0
 *
 **/
ICalComponent *
i_cal_parser_clean (ICalParser *parser)
{
	g_return_val_if_fail (I_CAL_IS_PARSER (parser), NULL);
	g_return_val_if_fail (parser != NULL, NULL);

	return i_cal_component_new_full (icalparser_clean ((icalparser *)i_cal_object_get_native (I_CAL_OBJECT (parser))), (gpointer) parser);
}

/**
 * i_cal_parser_get_state:
 * @parser: The #ICalParser to be queried.
 *
 * Get the state of the target parser.
 *
 * Returns: The parser state stored in the #ICalParser.
 *
 * Since: 1.0
 *
 **/
ICalParserState
i_cal_parser_get_state (ICalParser *parser)
{
	g_return_val_if_fail (I_CAL_IS_PARSER (parser), I_CAL_PARSER_ERROR);
	g_return_val_if_fail (parser != NULL, I_CAL_PARSER_ERROR);

	return icalparser_get_state ((icalparser *)i_cal_object_get_native (I_CAL_OBJECT (parser)));
}

/**
 * i_cal_parser_free:
 * @parser: The #ICalParser to be freed.
 *
 * Free a #ICalParser.
 *
 * Since: 1.0
 *
 **/
void
i_cal_parser_free (ICalParser *parser)
{
	g_return_if_fail (I_CAL_IS_PARSER (parser));
	g_return_if_fail (parser != NULL);

	icalparser_free ((icalparser *)i_cal_object_get_native (I_CAL_OBJECT (parser)));
}

/**
 * i_cal_parser_parse:
 * @parser: The parser used to parse the string and output the #ICalComponent.
 *  @func: The function used to parse.
 *
 * icalparser_parse takes a string that holds the text ( in RFC 2445 format ) and returns a pointer to an
 * icalcomponent. The caller owns the memory. line_gen_func is a pointer to a function that returns one
 * content line per invocation
 *
 * Returns: (transfer full): The component output by the parser.
 *
 * Since: 1.0
 *
 **/
ICalComponent *
i_cal_parser_parse (ICalParser *parser, 
                    gchar *(*func)(gchar *,size_t,void *))
{
	g_return_val_if_fail (parser != NULL && func != NULL, NULL);
	
	return i_cal_component_new_full (icalparser_parse ((icalparser *)i_cal_object_get_native ((ICalObject *)parser), func), NULL);
}

/**
 * i_cal_parser_set_gen_data:
 * @parser: The parser
 * @data: Set the data that icalparser_parse will give to the line_gen_func as the parameter 'd'
 *
 * Set the data that icalparser_parse will give to the line_gen_func as the parameter 'd'
 *
 * Since: 1.0
 *
 **/
void
i_cal_parser_set_gen_data (ICalParser *parser, 
                           void *data)
{
	g_return_if_fail (I_CAL_IS_PARSER (parser));
	g_return_if_fail (parser != NULL);
	g_return_if_fail (data != NULL);

	icalparser_set_gen_data ((icalparser *)i_cal_object_get_native (I_CAL_OBJECT (parser)), data);
}

/**
 * i_cal_parser_parse_string:
 * @str: The string to be parsed
 *
 * Parse the string into a #ICalComponent.
 *
 * Returns: (transfer full): The #ICalComponent parsed from str.
 *
 * Since: 1.0
 *
 **/
ICalComponent *
i_cal_parser_parse_string (const gchar *str)
{
	g_return_val_if_fail (str != NULL, NULL);

	return i_cal_component_new_full (icalparser_parse_string (str), NULL);
}

/**
 * i_cal_parser_get_line:
 * @parser: The parser to be queried.
 *  @func: A line generator function.
 *
 * Given a line generator function, return a single iCal content line.
 *
 * Returns: (transfer full): A single iCal content line.
 *
 * Since: 1.0
 *
 **/
gchar *
i_cal_parser_get_line (ICalParser *parser, 
                       gchar *(*func)(gchar *,size_t,void *))
{
	g_return_val_if_fail (parser != NULL && func != NULL, NULL);
	
	return icalparser_get_line ((icalparser *)i_cal_object_get_native ((ICalObject *)parser), func);
}

/**
 * i_cal_parser_string_line_generator:
 * @out: The input.
 * @buf_size: The size of the buffer.
 * @d: The data to be supplied.
 *
 * The string line generator used as line_gen_func
 *
 * Returns: (transfer full): The generated line.
 *
 * Since: 1.0
 *
 **/
gchar *
i_cal_parser_string_line_generator (gchar *out, 
                                    size_t buf_size, 
                                    void *d)
{
	g_return_val_if_fail (out != NULL, NULL);
	g_return_val_if_fail (d != NULL, NULL);

	return icalparser_string_line_generator (out, buf_size, d);
}
