/* Generated file (by src-generator) */

/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2015 William Yu <williamyu@gnome.org>
 *
 * This library is free software: you can redistribute it and/or modify it
 * under the terms of version 2.1. of the GNU Lesser General Public License
 * as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "i-cal-timezonetype.h"
#include "libical-glib-private.h"
#include "i-cal-timetype.h"

G_DEFINE_TYPE (ICalTimezonetype, i_cal_timezonetype, I_CAL_TYPE_OBJECT)

static void
i_cal_timezonetype_class_init (ICalTimezonetypeClass *klass)
{	
	g_type_class_add_private (klass, sizeof (ICalTimezonetype));
}

static void
i_cal_timezonetype_init (ICalTimezonetype *self)
{
}

/**
 * i_cal_timezonetype_new_full: (skip)
 * @native: The native libical object.
 *
 * Create a new libical-glib object from the native libical object and the owner.
 * 
 * Returns: (transfer full): The newly create libical-glib object.
 *
 * Since: 1.0
 **/
ICalTimezonetype *
i_cal_timezonetype_new_full (struct icaltimezonetype native)
{
	ICalTimezonetype *object;
	struct icaltimezonetype *clone;
	object = g_object_new (I_CAL_TIMEZONETYPE_TYPE, NULL);
	clone = g_new (struct icaltimezonetype, 1);
	*clone = native;
	i_cal_object_construct ((ICalObject *)object,
		        	(gpointer) clone,
		        	(GDestroyNotify) g_free,
		        	FALSE,
		        	NULL);
    							
	return object;
}

/**
 * i_cal_timezonetype_new_default:
 *
 * Create a new default #ICalTimezonetype
 *
 * Returns: (transfer full): The newly created #ICalTimezonetype
 *
 * Since: 1.0
 *
 **/
struct icaltimezonetype
i_cal_timezonetype_new_default (void)
{
	struct icaltimezonetype timezonetype;
	timezonetype.last_mod = i_cal_timetype_new_default ();
	timezonetype.phases = NULL;
	return timezonetype;
}

/**
 * i_cal_timezonetype_get_tzid:
 * @timezonetype: The #ICalTimezonetype.
 *
 * Get the tzid of #ICalTimezonetype.
 *
 * Returns: (transfer none): The tzid of @timezonetype.
 *
 * Since: 1.0
 *
 **/
const gchar *
i_cal_timezonetype_get_tzid (ICalTimezonetype *timezonetype)
{
	g_return_val_if_fail (timezonetype != NULL && I_CAL_IS_TIMEZONETYPE (timezonetype), NULL);
	return ((struct icaltimezonetype *)i_cal_object_get_native ((ICalObject *)timezonetype))->tzid;
}

/**
 * i_cal_timezonetype_get_tzurl:
 * @timezonetype: The #ICalTimezonetype.
 *
 * Get the tzurl of #ICalTimezonetype.
 *
 * Returns: (transfer none): The tzurl of @timezonetype.
 *
 * Since: 1.0
 *
 **/
const gchar *
i_cal_timezonetype_get_tzurl (ICalTimezonetype *timezonetype)
{
	g_return_val_if_fail (timezonetype != NULL && I_CAL_IS_TIMEZONETYPE (timezonetype), NULL);
	return ((struct icaltimezonetype *)i_cal_object_get_native ((ICalObject *)timezonetype))->tzurl;
}

/**
 * i_cal_timezonetype_get_last_mod:
 * @timezonetype: The #ICalTimezonetype.
 *
 * Get the last_mod from #ICalTimezonetype.
 *
 * Returns: (transfer full): The last_mod of #ICalTimezonetype.
 *
 * Since: 1.0
 *
 **/
ICalTimetype *
i_cal_timezonetype_get_last_mod (ICalTimezonetype *timezonetype)
{
	g_return_val_if_fail (timezonetype != NULL && I_CAL_IS_TIMEZONETYPE (timezonetype), NULL);
	return i_cal_timetype_new_full (((struct icaltimezonetype *)i_cal_object_get_native ((ICalObject *)timezonetype))->last_mod);
}

/**
 * i_cal_timezonetype_set_last_mod:
 * @timezonetype: The #ICalTimezonetype.
 * @last_mod: The last_mod of #ICalTimezonetype.
 *
 * Set the last_mod from #ICalTimezonetype.
 *
 * Since: 1.0
 *
 **/
void
i_cal_timezonetype_set_last_mod (ICalTimezonetype *timezonetype, 
                                 ICalTimetype *last_mod)
{
	g_return_if_fail (timezonetype != NULL && I_CAL_IS_TIMEZONETYPE (timezonetype));
    g_return_if_fail (last_mod != NULL && I_CAL_IS_TIMETYPE (last_mod));
	((struct icaltimezonetype *)i_cal_object_get_native ((ICalObject *)timezonetype))->last_mod = *(struct icaltimetype *)i_cal_object_get_native ((ICalObject *)last_mod);
}
