// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBNOTIFYMM_NOTIFICATION_H
#define _LIBNOTIFYMM_NOTIFICATION_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/*
 * Copyright 2003 libnotifymm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <glibmm.h>

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _NotifyNotification NotifyNotification;
typedef struct _NotifyNotificationClass NotifyNotificationClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Notify
{ class Notification_Class; } // namespace Notify
namespace Gdk
{
class Pixbuf;
}

namespace Notify
{

/** The default expiration time on a notification.
 */
extern const int EXPIRES_DEFAULT;

/** The notification never expires. It stays open until closed by the calling API
 * or the user.
 */
extern const int EXPIRES_NEVER;

/** @addtogroup libnotifymmEnums libnotifymm Enums and Flags */

/**
 * @ingroup libnotifymmEnums
 */
enum Urgency
{
  URGENCY_LOW,
  URGENCY_NORMAL,
  URGENCY_CRITICAL
};

} // namespace Notify


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Notify::Urgency> : public Glib::Value_Enum<Notify::Urgency>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Notify
{


/** Notification offers a way to show notification for a widget or
 * in the system tray.
 */

class Notification : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Notification CppObjectType;
  typedef Notification_Class CppClassType;
  typedef NotifyNotification BaseObjectType;
  typedef NotifyNotificationClass BaseClassType;

private:  friend class Notification_Class;
  static CppClassType notification_class_;

private:
  // noncopyable
  Notification(const Notification&);
  Notification& operator=(const Notification&);

protected:
  explicit Notification(const Glib::ConstructParams& construct_params);
  explicit Notification(NotifyNotification* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Notification();

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  NotifyNotification*       gobj()       { return reinterpret_cast<NotifyNotification*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const NotifyNotification* gobj() const { return reinterpret_cast<NotifyNotification*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  NotifyNotification* gobj_copy();

private:

public:

  
  explicit Notification(const Glib::ustring& summary, const Glib::ustring& body = Glib::ustring(),
    const Glib::ustring& icon = Glib::ustring());

  
  bool update(const Glib::ustring& summary, const Glib::ustring& body = Glib::ustring(),
    const Glib::ustring& icon = Glib::ustring());

  
  bool show();

  
  void set_app_name(const Glib::ustring& app_name);

  
  void set_timeout(int timeout);

  
  void set_category(const Glib::ustring& category);

  
  void set_urgency(Urgency urgency);

  
  void set_image_from_pixbuf(const Glib::RefPtr<Gdk::Pixbuf>& pixbuf);

  
#ifndef LIBNOTIFYMM_DISABLE_DEPRECATED

  void set_icon_from_pixbuf(const Glib::RefPtr<Gdk::Pixbuf>& icon);
#endif // LIBNOTIFYMM_DISABLE_DEPRECATED


#ifndef LIBNOTIFYMM_DISABLE_DEPRECATED

  void set_hint(const Glib::ustring& key, int value);
#endif // LIBNOTIFYMM_DISABLE_DEPRECATED


#ifndef LIBNOTIFYMM_DISABLE_DEPRECATED

  void set_hint(const Glib::ustring& key, guint value);
#endif // LIBNOTIFYMM_DISABLE_DEPRECATED


#ifndef LIBNOTIFYMM_DISABLE_DEPRECATED

  void set_hint(const Glib::ustring& key, double value);
#endif // LIBNOTIFYMM_DISABLE_DEPRECATED


#ifndef LIBNOTIFYMM_DISABLE_DEPRECATED

  void set_hint(const Glib::ustring& key, const Glib::ustring& value);
#endif // LIBNOTIFYMM_DISABLE_DEPRECATED


#ifndef LIBNOTIFYMM_DISABLE_DEPRECATED

  void set_hint(const Glib::ustring& key, guchar value);
#endif // LIBNOTIFYMM_DISABLE_DEPRECATED


#ifndef LIBNOTIFYMM_DISABLE_DEPRECATED
  /** Set byte array hint.
   * Sets a hint with a byte array value.
   *
   * @param key the hint
   * @param values the hint's value
   *
   * @deprecated Use set_hint(const Glib::ustring& key, const Glib::VariantBase& value) instead.
   */
  void set_hint(const Glib::ustring& key, const Glib::ArrayHandle<guchar>& values);
  
#endif // LIBNOTIFYMM_DISABLE_DEPRECATED

  
  void set_hint(const Glib::ustring& key, const Glib::VariantBase& value);

  
  void clear_hints();

  typedef sigc::slot<void, const Glib::ustring& /* action */> SlotInvokeAction;

  /** Add an action to the notification
   *
   * @param action the action id
   * @param label the action label
   * @param slot A function or method to call when the action is invoked
   *
   * Adds an action to a notification. When the action is invoked,
   * the specified callback function will be called.
   */
  void add_action(const Glib::ustring& action, const Glib::ustring& label, const SlotInvokeAction& slot);
  

  void clear_actions();

  
  bool close();

  
  int get_closed_reason() const;

  
/**
   * @par Slot Prototype:
   * <tt>void on_my_%closed()</tt>
   *
   * Emitted when the notification is closed.
   */

  Glib::SignalProxy0< void > signal_closed();


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The notification ID.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< int > property_id() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The notification ID.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_id() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The summary text.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_summary() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The summary text.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_summary() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The message body text.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_body() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The message body text.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_body() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The icon filename or icon theme-compliant name.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_icon_name() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The icon filename or icon theme-compliant name.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_icon_name() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The application name to use for this notification.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_app_name() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The application name to use for this notification.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_app_name() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The reason code for why the notification was closed.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_closed_reason() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  /// This is a default handler for the signal signal_closed().
  virtual void on_closed();


};

} // namespace Notify


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Notify::Notification
   */
  Glib::RefPtr<Notify::Notification> wrap(NotifyNotification* object, bool take_copy = false);
}


#endif /* _LIBNOTIFYMM_NOTIFICATION_H */

