#include <sigc++/sigc++.h>

/// This class emits a signal in its destructor
struct foo
{
        ~foo() { signal.emit(); }
        SigC::Signal0<void> signal;
};

/// This class deletes itself when it receives a signal
struct bar :
        public SigC::Object
{
        bar(foo& Foo)
        {
               Foo.signal.connect(SigC::slot(*this, &bar::closed));
        }

        void closed()
        {
		delete this;
        }
};

int main(int, char**)
{
	foo f;
        new bar(f);

	return 0;
}


