/* board-view.c generated by valac 0.22.0.45-383d, the Vala compiler
 * generated from board-view.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <clutter/clutter.h>
#include <float.h>
#include <math.h>


#define TYPE_LIGHT (light_get_type ())
#define LIGHT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIGHT, Light))
#define LIGHT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIGHT, LightClass))
#define IS_LIGHT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIGHT))
#define IS_LIGHT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIGHT))
#define LIGHT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIGHT, LightClass))

typedef struct _Light Light;
typedef struct _LightClass LightClass;
typedef struct _LightPrivate LightPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_BOARD_VIEW (board_view_get_type ())
#define BOARD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOARD_VIEW, BoardView))
#define BOARD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOARD_VIEW, BoardViewClass))
#define IS_BOARD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOARD_VIEW))
#define IS_BOARD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOARD_VIEW))
#define BOARD_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOARD_VIEW, BoardViewClass))

typedef struct _BoardView BoardView;
typedef struct _BoardViewClass BoardViewClass;
typedef struct _BoardViewPrivate BoardViewPrivate;

#define TYPE_PUZZLE_GENERATOR (puzzle_generator_get_type ())
#define PUZZLE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PUZZLE_GENERATOR, PuzzleGenerator))
#define PUZZLE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PUZZLE_GENERATOR, PuzzleGeneratorClass))
#define IS_PUZZLE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PUZZLE_GENERATOR))
#define IS_PUZZLE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PUZZLE_GENERATOR))
#define PUZZLE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PUZZLE_GENERATOR, PuzzleGeneratorClass))

typedef struct _PuzzleGenerator PuzzleGenerator;
typedef struct _PuzzleGeneratorClass PuzzleGeneratorClass;
#define _puzzle_generator_unref0(var) ((var == NULL) ? NULL : (var = (puzzle_generator_unref (var), NULL)))

struct _Light {
	ClutterGroup parent_instance;
	LightPrivate * priv;
};

struct _LightClass {
	ClutterGroupClass parent_class;
};

struct _LightPrivate {
	ClutterActor* off;
	ClutterActor* on;
	gboolean _is_lit;
};

struct _BoardView {
	ClutterGroup parent_instance;
	BoardViewPrivate * priv;
	gboolean playable;
};

struct _BoardViewClass {
	ClutterGroupClass parent_class;
};

struct _BoardViewPrivate {
	PuzzleGenerator* puzzle_generator;
	ClutterTexture* off_texture;
	ClutterTexture* on_texture;
	Light** lights;
	gint lights_length1;
	gint lights_length2;
};


static gpointer light_parent_class = NULL;
static gpointer board_view_parent_class = NULL;

GType light_get_type (void) G_GNUC_CONST;
#define LIGHT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_LIGHT, LightPrivate))
enum  {
	LIGHT_DUMMY_PROPERTY,
	LIGHT_IS_LIT
};
Light* light_new (ClutterActor* off_actor, ClutterActor* on_actor);
Light* light_construct (GType object_type, ClutterActor* off_actor, ClutterActor* on_actor);
void light_toggle (Light* self, ClutterTimeline* timeline);
gboolean light_get_is_lit (Light* self);
void light_set_is_lit (Light* self, gboolean value);
static void light_finalize (GObject* obj);
static void _vala_light_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_light_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType board_view_get_type (void) G_GNUC_CONST;
gpointer puzzle_generator_ref (gpointer instance);
void puzzle_generator_unref (gpointer instance);
GParamSpec* param_spec_puzzle_generator (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_puzzle_generator (GValue* value, gpointer v_object);
void value_take_puzzle_generator (GValue* value, gpointer v_object);
gpointer value_get_puzzle_generator (const GValue* value);
GType puzzle_generator_get_type (void) G_GNUC_CONST;
#define BOARD_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_BOARD_VIEW, BoardViewPrivate))
enum  {
	BOARD_VIEW_DUMMY_PROPERTY
};
#define BOARD_VIEW_size 5
BoardView* board_view_new (ClutterTexture* off_texture, ClutterTexture* on_texture);
BoardView* board_view_construct (GType object_type, ClutterTexture* off_texture, ClutterTexture* on_texture);
PuzzleGenerator* puzzle_generator_new (gint size);
PuzzleGenerator* puzzle_generator_construct (GType object_type, gint size);
static gboolean board_view_light_button_press_cb (BoardView* self, ClutterActor* actor, ClutterButtonEvent* event);
static gboolean _board_view_light_button_press_cb_clutter_actor_button_press_event (ClutterActor* _sender, ClutterButtonEvent* event, gpointer self);
void board_view_get_light_position (BoardView* self, gint x, gint y, gfloat* xx, gfloat* yy);
void board_view_fade_in (BoardView* self, ClutterTimeline* timeline);
void board_view_fade_out (BoardView* self, ClutterTimeline* timeline);
void board_view_slide_in (BoardView* self, gint direction, gint sign, ClutterTimeline* timeline);
void board_view_slide_out (BoardView* self, gint direction, gint sign, ClutterTimeline* timeline);
void board_view_swap_in (BoardView* self, gfloat direction, ClutterTimeline* timeline);
void board_view_swap_out (BoardView* self, gfloat direction, ClutterTimeline* timeline);
static void board_view_find_light (BoardView* self, Light* light, gint* x, gint* y);
void board_view_toggle_light (BoardView* self, gint x, gint y, gboolean animate);
static void board_view_toggle_completed_cb (BoardView* self);
static void _board_view_toggle_completed_cb_clutter_timeline_completed (ClutterTimeline* _sender, gpointer self);
void board_view_load_level (BoardView* self, gint level);
gboolean* puzzle_generator_minimal_solution (PuzzleGenerator* self, gint solution_length, int* result_length1, int* result_length2);
static void board_view_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


Light* light_construct (GType object_type, ClutterActor* off_actor, ClutterActor* on_actor) {
	Light * self = NULL;
	ClutterActor* _tmp0_ = NULL;
	ClutterClone* _tmp1_ = NULL;
	ClutterActor* _tmp2_ = NULL;
	ClutterActor* _tmp3_ = NULL;
	ClutterActor* _tmp4_ = NULL;
	ClutterClone* _tmp5_ = NULL;
	ClutterActor* _tmp6_ = NULL;
	ClutterActor* _tmp7_ = NULL;
	ClutterActor* _tmp8_ = NULL;
	gfloat _tmp9_ = 0.0F;
	gfloat _tmp10_ = 0.0F;
	gfloat _tmp11_ = 0.0F;
	gfloat _tmp12_ = 0.0F;
	ClutterActor* _tmp13_ = NULL;
	gfloat _tmp14_ = 0.0F;
	gfloat _tmp15_ = 0.0F;
	gfloat _tmp16_ = 0.0F;
	gfloat _tmp17_ = 0.0F;
	ClutterActor* _tmp18_ = NULL;
	gfloat _tmp19_ = 0.0F;
	gfloat _tmp20_ = 0.0F;
	gfloat _tmp21_ = 0.0F;
	gfloat _tmp22_ = 0.0F;
	g_return_val_if_fail (off_actor != NULL, NULL);
	g_return_val_if_fail (on_actor != NULL, NULL);
	self = (Light*) g_object_new (object_type, NULL);
	clutter_actor_set_scale ((ClutterActor*) self, 0.9, 0.9);
	_tmp0_ = off_actor;
	_tmp1_ = (ClutterClone*) clutter_clone_new (_tmp0_);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->off);
	self->priv->off = (ClutterActor*) _tmp1_;
	_tmp2_ = self->priv->off;
	g_object_set (_tmp2_, "anchor-gravity", CLUTTER_GRAVITY_CENTER, NULL);
	_tmp3_ = self->priv->off;
	clutter_container_add_actor ((ClutterContainer*) self, _tmp3_);
	_tmp4_ = on_actor;
	_tmp5_ = (ClutterClone*) clutter_clone_new (_tmp4_);
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->on);
	self->priv->on = (ClutterActor*) _tmp5_;
	_tmp6_ = self->priv->on;
	g_object_set (_tmp6_, "anchor-gravity", CLUTTER_GRAVITY_CENTER, NULL);
	_tmp7_ = self->priv->on;
	clutter_actor_set_opacity (_tmp7_, (guint) 0);
	_tmp8_ = self->priv->on;
	clutter_container_add_actor ((ClutterContainer*) self, _tmp8_);
	_tmp9_ = clutter_actor_get_width ((ClutterActor*) self);
	_tmp10_ = _tmp9_;
	clutter_actor_set_width ((ClutterActor*) self, _tmp10_ + 4);
	_tmp11_ = clutter_actor_get_height ((ClutterActor*) self);
	_tmp12_ = _tmp11_;
	clutter_actor_set_height ((ClutterActor*) self, _tmp12_ + 4);
	_tmp13_ = self->priv->off;
	_tmp14_ = clutter_actor_get_width ((ClutterActor*) self);
	_tmp15_ = _tmp14_;
	_tmp16_ = clutter_actor_get_height ((ClutterActor*) self);
	_tmp17_ = _tmp16_;
	clutter_actor_set_position (_tmp13_, _tmp15_ / 2, _tmp17_ / 2);
	_tmp18_ = self->priv->on;
	_tmp19_ = clutter_actor_get_width ((ClutterActor*) self);
	_tmp20_ = _tmp19_;
	_tmp21_ = clutter_actor_get_height ((ClutterActor*) self);
	_tmp22_ = _tmp21_;
	clutter_actor_set_position (_tmp18_, _tmp20_ / 2, _tmp22_ / 2);
	return self;
}


Light* light_new (ClutterActor* off_actor, ClutterActor* on_actor) {
	return light_construct (TYPE_LIGHT, off_actor, on_actor);
}


void light_toggle (Light* self, ClutterTimeline* timeline) {
	gboolean _tmp0_ = FALSE;
	ClutterTimeline* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_is_lit;
	self->priv->_is_lit = !_tmp0_;
	_tmp1_ = timeline;
	if (_tmp1_ != NULL) {
		gint _tmp2_ = 0;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		ClutterActor* _tmp5_ = NULL;
		ClutterTimeline* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		ClutterActor* _tmp11_ = NULL;
		ClutterTimeline* _tmp12_ = NULL;
		gint _tmp13_ = 0;
		gdouble _tmp14_ = 0.0;
		gboolean _tmp15_ = FALSE;
		gboolean _tmp16_ = FALSE;
		gdouble _tmp17_ = 0.0;
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_ = FALSE;
		ClutterTimeline* _tmp20_ = NULL;
		gdouble _tmp21_ = 0.0;
		gdouble _tmp22_ = 0.0;
		_tmp3_ = light_get_is_lit (self);
		_tmp4_ = _tmp3_;
		if (_tmp4_) {
			_tmp2_ = 0;
		} else {
			_tmp2_ = 255;
		}
		_tmp5_ = self->priv->off;
		_tmp6_ = timeline;
		_tmp7_ = _tmp2_;
		clutter_actor_animate_with_timeline (_tmp5_, (gulong) CLUTTER_EASE_OUT_SINE, _tmp6_, "opacity", _tmp7_, NULL);
		_tmp9_ = light_get_is_lit (self);
		_tmp10_ = _tmp9_;
		if (_tmp10_) {
			_tmp8_ = 255;
		} else {
			_tmp8_ = 0;
		}
		_tmp11_ = self->priv->on;
		_tmp12_ = timeline;
		_tmp13_ = _tmp8_;
		clutter_actor_animate_with_timeline (_tmp11_, (gulong) CLUTTER_EASE_OUT_SINE, _tmp12_, "opacity", _tmp13_, NULL);
		_tmp15_ = light_get_is_lit (self);
		_tmp16_ = _tmp15_;
		if (_tmp16_) {
			_tmp14_ = 1.0;
		} else {
			_tmp14_ = 0.9;
		}
		_tmp18_ = light_get_is_lit (self);
		_tmp19_ = _tmp18_;
		if (_tmp19_) {
			_tmp17_ = 1.0;
		} else {
			_tmp17_ = 0.9;
		}
		_tmp20_ = timeline;
		_tmp21_ = _tmp14_;
		_tmp22_ = _tmp17_;
		clutter_actor_animate_with_timeline ((ClutterActor*) self, (gulong) CLUTTER_EASE_OUT_SINE, _tmp20_, "scale-x", _tmp21_, "scale-y", _tmp22_, NULL);
	} else {
		gint _tmp23_ = 0;
		gboolean _tmp24_ = FALSE;
		gboolean _tmp25_ = FALSE;
		ClutterActor* _tmp26_ = NULL;
		gint _tmp27_ = 0;
		gint _tmp28_ = 0;
		gboolean _tmp29_ = FALSE;
		gboolean _tmp30_ = FALSE;
		ClutterActor* _tmp31_ = NULL;
		gint _tmp32_ = 0;
		gdouble _tmp33_ = 0.0;
		gboolean _tmp34_ = FALSE;
		gboolean _tmp35_ = FALSE;
		gdouble _tmp36_ = 0.0;
		gdouble _tmp37_ = 0.0;
		gboolean _tmp38_ = FALSE;
		gboolean _tmp39_ = FALSE;
		gdouble _tmp40_ = 0.0;
		_tmp24_ = light_get_is_lit (self);
		_tmp25_ = _tmp24_;
		if (_tmp25_) {
			_tmp23_ = 0;
		} else {
			_tmp23_ = 255;
		}
		_tmp26_ = self->priv->off;
		_tmp27_ = _tmp23_;
		clutter_actor_set_opacity (_tmp26_, (guint) _tmp27_);
		_tmp29_ = light_get_is_lit (self);
		_tmp30_ = _tmp29_;
		if (_tmp30_) {
			_tmp28_ = 255;
		} else {
			_tmp28_ = 0;
		}
		_tmp31_ = self->priv->on;
		_tmp32_ = _tmp28_;
		clutter_actor_set_opacity (_tmp31_, (guint) _tmp32_);
		_tmp34_ = light_get_is_lit (self);
		_tmp35_ = _tmp34_;
		if (_tmp35_) {
			_tmp33_ = (gdouble) 1;
		} else {
			_tmp33_ = 0.9;
		}
		_tmp36_ = _tmp33_;
		g_object_set ((ClutterActor*) self, "scale-x", _tmp36_, NULL);
		_tmp38_ = light_get_is_lit (self);
		_tmp39_ = _tmp38_;
		if (_tmp39_) {
			_tmp37_ = (gdouble) 1;
		} else {
			_tmp37_ = 0.9;
		}
		_tmp40_ = _tmp37_;
		g_object_set ((ClutterActor*) self, "scale-y", _tmp40_, NULL);
	}
}


gboolean light_get_is_lit (Light* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_lit;
	result = _tmp0_;
	return result;
}


void light_set_is_lit (Light* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	value = _tmp0_ != FALSE;
	_tmp1_ = value;
	_tmp2_ = self->priv->_is_lit;
	if (_tmp1_ != _tmp2_) {
		light_toggle (self, NULL);
	}
	g_object_notify ((GObject *) self, "is-lit");
}


static void light_class_init (LightClass * klass) {
	light_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (LightPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_light_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_light_set_property;
	G_OBJECT_CLASS (klass)->finalize = light_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), LIGHT_IS_LIT, g_param_spec_boolean ("is-lit", "is-lit", "is-lit", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void light_instance_init (Light * self) {
	self->priv = LIGHT_GET_PRIVATE (self);
}


static void light_finalize (GObject* obj) {
	Light * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_LIGHT, Light);
	_g_object_unref0 (self->priv->off);
	_g_object_unref0 (self->priv->on);
	G_OBJECT_CLASS (light_parent_class)->finalize (obj);
}


GType light_get_type (void) {
	static volatile gsize light_type_id__volatile = 0;
	if (g_once_init_enter (&light_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (LightClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) light_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Light), 0, (GInstanceInitFunc) light_instance_init, NULL };
		GType light_type_id;
		light_type_id = g_type_register_static (clutter_group_get_type (), "Light", &g_define_type_info, 0);
		g_once_init_leave (&light_type_id__volatile, light_type_id);
	}
	return light_type_id__volatile;
}


static void _vala_light_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Light * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_LIGHT, Light);
	switch (property_id) {
		case LIGHT_IS_LIT:
		g_value_set_boolean (value, light_get_is_lit (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_light_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Light * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_LIGHT, Light);
	switch (property_id) {
		case LIGHT_IS_LIT:
		light_set_is_lit (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean _board_view_light_button_press_cb_clutter_actor_button_press_event (ClutterActor* _sender, ClutterButtonEvent* event, gpointer self) {
	gboolean result;
	result = board_view_light_button_press_cb (self, _sender, event);
	return result;
}


BoardView* board_view_construct (GType object_type, ClutterTexture* off_texture, ClutterTexture* on_texture) {
	BoardView * self = NULL;
	ClutterTexture* _tmp0_ = NULL;
	ClutterTexture* _tmp1_ = NULL;
	ClutterTexture* _tmp2_ = NULL;
	ClutterTexture* _tmp3_ = NULL;
	PuzzleGenerator* _tmp4_ = NULL;
	Light** _tmp5_ = NULL;
	g_return_val_if_fail (off_texture != NULL, NULL);
	g_return_val_if_fail (on_texture != NULL, NULL);
	self = (BoardView*) g_object_new (object_type, NULL);
	_tmp0_ = off_texture;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->off_texture);
	self->priv->off_texture = _tmp1_;
	_tmp2_ = on_texture;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->on_texture);
	self->priv->on_texture = _tmp3_;
	_tmp4_ = puzzle_generator_new (BOARD_VIEW_size);
	_puzzle_generator_unref0 (self->priv->puzzle_generator);
	self->priv->puzzle_generator = _tmp4_;
	_tmp5_ = g_new0 (Light*, (BOARD_VIEW_size * BOARD_VIEW_size) + 1);
	self->priv->lights = (_vala_array_free (self->priv->lights, self->priv->lights_length1 * self->priv->lights_length2, (GDestroyNotify) g_object_unref), NULL);
	self->priv->lights = _tmp5_;
	self->priv->lights_length1 = BOARD_VIEW_size;
	self->priv->lights_length2 = BOARD_VIEW_size;
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				gboolean _tmp7_ = FALSE;
				gint _tmp9_ = 0;
				_tmp7_ = _tmp6_;
				if (!_tmp7_) {
					gint _tmp8_ = 0;
					_tmp8_ = x;
					x = _tmp8_ + 1;
				}
				_tmp6_ = FALSE;
				_tmp9_ = x;
				if (!(_tmp9_ < BOARD_VIEW_size)) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp10_ = FALSE;
						_tmp10_ = TRUE;
						while (TRUE) {
							gboolean _tmp11_ = FALSE;
							gint _tmp13_ = 0;
							Light* l = NULL;
							ClutterTexture* _tmp14_ = NULL;
							ClutterTexture* _tmp15_ = NULL;
							Light* _tmp16_ = NULL;
							Light* _tmp17_ = NULL;
							Light* _tmp18_ = NULL;
							gfloat xx = 0.0F;
							gfloat yy = 0.0F;
							gint _tmp19_ = 0;
							gint _tmp20_ = 0;
							gfloat _tmp21_ = 0.0F;
							gfloat _tmp22_ = 0.0F;
							Light* _tmp23_ = NULL;
							Light* _tmp24_ = NULL;
							gfloat _tmp25_ = 0.0F;
							gfloat _tmp26_ = 0.0F;
							Light** _tmp27_ = NULL;
							gint _tmp27__length1 = 0;
							gint _tmp27__length2 = 0;
							gint _tmp28_ = 0;
							gint _tmp29_ = 0;
							Light* _tmp30_ = NULL;
							Light* _tmp31_ = NULL;
							Light* _tmp32_ = NULL;
							Light* _tmp33_ = NULL;
							_tmp11_ = _tmp10_;
							if (!_tmp11_) {
								gint _tmp12_ = 0;
								_tmp12_ = y;
								y = _tmp12_ + 1;
							}
							_tmp10_ = FALSE;
							_tmp13_ = y;
							if (!(_tmp13_ < BOARD_VIEW_size)) {
								break;
							}
							_tmp14_ = off_texture;
							_tmp15_ = on_texture;
							_tmp16_ = light_new ((ClutterActor*) _tmp14_, (ClutterActor*) _tmp15_);
							g_object_ref_sink (_tmp16_);
							l = _tmp16_;
							_tmp17_ = l;
							clutter_actor_set_reactive ((ClutterActor*) _tmp17_, TRUE);
							_tmp18_ = l;
							g_signal_connect_object ((ClutterActor*) _tmp18_, "button-press-event", (GCallback) _board_view_light_button_press_cb_clutter_actor_button_press_event, self, 0);
							_tmp19_ = x;
							_tmp20_ = y;
							board_view_get_light_position (self, _tmp19_, _tmp20_, &_tmp21_, &_tmp22_);
							xx = _tmp21_;
							yy = _tmp22_;
							_tmp23_ = l;
							g_object_set ((ClutterActor*) _tmp23_, "anchor-gravity", CLUTTER_GRAVITY_CENTER, NULL);
							_tmp24_ = l;
							_tmp25_ = xx;
							_tmp26_ = yy;
							clutter_actor_set_position ((ClutterActor*) _tmp24_, _tmp25_, _tmp26_);
							_tmp27_ = self->priv->lights;
							_tmp27__length1 = self->priv->lights_length1;
							_tmp27__length2 = self->priv->lights_length2;
							_tmp28_ = x;
							_tmp29_ = y;
							_tmp30_ = l;
							_tmp31_ = _g_object_ref0 (_tmp30_);
							_g_object_unref0 (_tmp27_[(_tmp28_ * _tmp27__length2) + _tmp29_]);
							_tmp27_[(_tmp28_ * _tmp27__length2) + _tmp29_] = _tmp31_;
							_tmp32_ = _tmp27_[(_tmp28_ * _tmp27__length2) + _tmp29_];
							_tmp33_ = l;
							clutter_container_add_actor ((ClutterContainer*) self, (ClutterActor*) _tmp33_);
							_g_object_unref0 (l);
						}
					}
				}
			}
		}
	}
	return self;
}


BoardView* board_view_new (ClutterTexture* off_texture, ClutterTexture* on_texture) {
	return board_view_construct (TYPE_BOARD_VIEW, off_texture, on_texture);
}


void board_view_get_light_position (BoardView* self, gint x, gint y, gfloat* xx, gfloat* yy) {
	gfloat _vala_xx = 0.0F;
	gfloat _vala_yy = 0.0F;
	gint _tmp0_ = 0;
	ClutterTexture* _tmp1_ = NULL;
	gfloat _tmp2_ = 0.0F;
	gfloat _tmp3_ = 0.0F;
	gint _tmp4_ = 0;
	ClutterTexture* _tmp5_ = NULL;
	gfloat _tmp6_ = 0.0F;
	gfloat _tmp7_ = 0.0F;
	g_return_if_fail (self != NULL);
	_tmp0_ = x;
	_tmp1_ = self->priv->off_texture;
	_tmp2_ = clutter_actor_get_width ((ClutterActor*) _tmp1_);
	_tmp3_ = _tmp2_;
	_vala_xx = ((_tmp0_ + 0.5f) * _tmp3_) + 2;
	_tmp4_ = y;
	_tmp5_ = self->priv->off_texture;
	_tmp6_ = clutter_actor_get_height ((ClutterActor*) _tmp5_);
	_tmp7_ = _tmp6_;
	_vala_yy = ((_tmp4_ + 0.5f) * _tmp7_) + 2;
	if (xx) {
		*xx = _vala_xx;
	}
	if (yy) {
		*yy = _vala_yy;
	}
}


void board_view_fade_in (BoardView* self, ClutterTimeline* timeline) {
	ClutterTimeline* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (timeline != NULL);
	_tmp0_ = timeline;
	clutter_actor_animate_with_timeline ((ClutterActor*) self, (gulong) CLUTTER_EASE_OUT_SINE, _tmp0_, "opactity", 0, NULL);
}


void board_view_fade_out (BoardView* self, ClutterTimeline* timeline) {
	ClutterTimeline* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (timeline != NULL);
	_tmp0_ = timeline;
	clutter_actor_animate_with_timeline ((ClutterActor*) self, (gulong) CLUTTER_EASE_OUT_SINE, _tmp0_, "opactity", 255, NULL);
}


void board_view_slide_in (BoardView* self, gint direction, gint sign, ClutterTimeline* timeline) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gfloat _tmp2_ = 0.0F;
	gfloat _tmp3_ = 0.0F;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gfloat _tmp6_ = 0.0F;
	gfloat _tmp7_ = 0.0F;
	ClutterTimeline* _tmp8_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (timeline != NULL);
	_tmp0_ = sign;
	_tmp1_ = direction;
	_tmp2_ = clutter_actor_get_width ((ClutterActor*) self);
	_tmp3_ = _tmp2_;
	clutter_actor_set_x ((ClutterActor*) self, ((-_tmp0_) * _tmp1_) * _tmp3_);
	_tmp4_ = sign;
	_tmp5_ = direction;
	_tmp6_ = clutter_actor_get_height ((ClutterActor*) self);
	_tmp7_ = _tmp6_;
	clutter_actor_set_y ((ClutterActor*) self, ((-_tmp4_) * (1 - _tmp5_)) * _tmp7_);
	_tmp8_ = timeline;
	clutter_actor_animate_with_timeline ((ClutterActor*) self, (gulong) CLUTTER_EASE_OUT_BOUNCE, _tmp8_, "x", 0.0, "y", 0.0, NULL);
}


void board_view_slide_out (BoardView* self, gint direction, gint sign, ClutterTimeline* timeline) {
	ClutterTimeline* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gfloat _tmp3_ = 0.0F;
	gfloat _tmp4_ = 0.0F;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gfloat _tmp7_ = 0.0F;
	gfloat _tmp8_ = 0.0F;
	g_return_if_fail (self != NULL);
	g_return_if_fail (timeline != NULL);
	_tmp0_ = timeline;
	_tmp1_ = sign;
	_tmp2_ = direction;
	_tmp3_ = clutter_actor_get_width ((ClutterActor*) self);
	_tmp4_ = _tmp3_;
	_tmp5_ = sign;
	_tmp6_ = direction;
	_tmp7_ = clutter_actor_get_height ((ClutterActor*) self);
	_tmp8_ = _tmp7_;
	clutter_actor_animate_with_timeline ((ClutterActor*) self, (gulong) CLUTTER_EASE_OUT_BOUNCE, _tmp0_, "x", (_tmp1_ * _tmp2_) * _tmp4_, "y", (_tmp5_ * (1 - _tmp6_)) * _tmp8_, NULL);
}


void board_view_swap_in (BoardView* self, gfloat direction, ClutterTimeline* timeline) {
	ClutterTimeline* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (timeline != NULL);
	_tmp0_ = timeline;
	clutter_actor_animate_with_timeline ((ClutterActor*) self, (gulong) CLUTTER_EASE_IN_SINE, _tmp0_, "opacity", 255, "depth", 0.0, NULL);
}


void board_view_swap_out (BoardView* self, gfloat direction, ClutterTimeline* timeline) {
	ClutterTimeline* _tmp0_ = NULL;
	gfloat _tmp1_ = 0.0F;
	g_return_if_fail (self != NULL);
	g_return_if_fail (timeline != NULL);
	_tmp0_ = timeline;
	_tmp1_ = direction;
	clutter_actor_animate_with_timeline ((ClutterActor*) self, (gulong) CLUTTER_EASE_IN_SINE, _tmp0_, "depth", 250.0 * _tmp1_, "opacity", 0, NULL);
}


static void board_view_find_light (BoardView* self, Light* light, gint* x, gint* y) {
	gint _vala_x = 0;
	gint _vala_y = 0;
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (light != NULL);
	_vala_y = 0;
	_tmp0_ = _vala_y;
	_vala_x = _tmp0_;
	{
		gboolean _tmp1_ = FALSE;
		_vala_x = 0;
		_tmp1_ = TRUE;
		while (TRUE) {
			gboolean _tmp2_ = FALSE;
			gint _tmp4_ = 0;
			_tmp2_ = _tmp1_;
			if (!_tmp2_) {
				gint _tmp3_ = 0;
				_tmp3_ = _vala_x;
				_vala_x = _tmp3_ + 1;
			}
			_tmp1_ = FALSE;
			_tmp4_ = _vala_x;
			if (!(_tmp4_ < BOARD_VIEW_size)) {
				break;
			}
			{
				gboolean _tmp5_ = FALSE;
				_vala_y = 0;
				_tmp5_ = TRUE;
				while (TRUE) {
					gboolean _tmp6_ = FALSE;
					gint _tmp8_ = 0;
					Light** _tmp9_ = NULL;
					gint _tmp9__length1 = 0;
					gint _tmp9__length2 = 0;
					gint _tmp10_ = 0;
					gint _tmp11_ = 0;
					Light* _tmp12_ = NULL;
					Light* _tmp13_ = NULL;
					_tmp6_ = _tmp5_;
					if (!_tmp6_) {
						gint _tmp7_ = 0;
						_tmp7_ = _vala_y;
						_vala_y = _tmp7_ + 1;
					}
					_tmp5_ = FALSE;
					_tmp8_ = _vala_y;
					if (!(_tmp8_ < BOARD_VIEW_size)) {
						break;
					}
					_tmp9_ = self->priv->lights;
					_tmp9__length1 = self->priv->lights_length1;
					_tmp9__length2 = self->priv->lights_length2;
					_tmp10_ = _vala_x;
					_tmp11_ = _vala_y;
					_tmp12_ = _tmp9_[(_tmp10_ * _tmp9__length2) + _tmp11_];
					_tmp13_ = light;
					if (_tmp12_ == _tmp13_) {
						if (x) {
							*x = _vala_x;
						}
						if (y) {
							*y = _vala_y;
						}
						return;
					}
				}
			}
		}
	}
	if (x) {
		*x = _vala_x;
	}
	if (y) {
		*y = _vala_y;
	}
}


static gboolean board_view_light_button_press_cb (BoardView* self, ClutterActor* actor, ClutterButtonEvent* event) {
	gboolean result = FALSE;
	gint x = 0;
	gint y = 0;
	ClutterActor* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (actor != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = actor;
	board_view_find_light (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_LIGHT, Light), &_tmp1_, &_tmp2_);
	x = _tmp1_;
	y = _tmp2_;
	board_view_toggle_light (self, x, y, TRUE);
	result = FALSE;
	return result;
}


static void _board_view_toggle_completed_cb_clutter_timeline_completed (ClutterTimeline* _sender, gpointer self) {
	board_view_toggle_completed_cb (self);
}


void board_view_toggle_light (BoardView* self, gint x, gint y, gboolean animate) {
	gboolean _tmp0_ = FALSE;
	ClutterTimeline* timeline = NULL;
	gboolean _tmp1_ = FALSE;
	gint _tmp4_ = 0;
	gint _tmp10_ = 0;
	gint _tmp16_ = 0;
	gint _tmp22_ = 0;
	Light** _tmp28_ = NULL;
	gint _tmp28__length1 = 0;
	gint _tmp28__length2 = 0;
	gint _tmp29_ = 0;
	gint _tmp30_ = 0;
	Light* _tmp31_ = NULL;
	ClutterTimeline* _tmp32_ = NULL;
	gboolean _tmp33_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->playable;
	if (!_tmp0_) {
		return;
	}
	timeline = NULL;
	_tmp1_ = animate;
	if (_tmp1_) {
		ClutterTimeline* _tmp2_ = NULL;
		ClutterTimeline* _tmp3_ = NULL;
		_tmp2_ = clutter_timeline_new ((guint) 300);
		_g_object_unref0 (timeline);
		timeline = _tmp2_;
		_tmp3_ = timeline;
		g_signal_connect_object (_tmp3_, "completed", (GCallback) _board_view_toggle_completed_cb_clutter_timeline_completed, self, 0);
	}
	_tmp4_ = x;
	if ((((gint) _tmp4_) + 1) < BOARD_VIEW_size) {
		Light** _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		gint _tmp5__length2 = 0;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		Light* _tmp8_ = NULL;
		ClutterTimeline* _tmp9_ = NULL;
		_tmp5_ = self->priv->lights;
		_tmp5__length1 = self->priv->lights_length1;
		_tmp5__length2 = self->priv->lights_length2;
		_tmp6_ = x;
		_tmp7_ = y;
		_tmp8_ = _tmp5_[((((gint) _tmp6_) + 1) * _tmp5__length2) + ((gint) _tmp7_)];
		_tmp9_ = timeline;
		light_toggle (_tmp8_, _tmp9_);
	}
	_tmp10_ = x;
	if ((((gint) _tmp10_) - 1) >= 0) {
		Light** _tmp11_ = NULL;
		gint _tmp11__length1 = 0;
		gint _tmp11__length2 = 0;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		Light* _tmp14_ = NULL;
		ClutterTimeline* _tmp15_ = NULL;
		_tmp11_ = self->priv->lights;
		_tmp11__length1 = self->priv->lights_length1;
		_tmp11__length2 = self->priv->lights_length2;
		_tmp12_ = x;
		_tmp13_ = y;
		_tmp14_ = _tmp11_[((((gint) _tmp12_) - 1) * _tmp11__length2) + ((gint) _tmp13_)];
		_tmp15_ = timeline;
		light_toggle (_tmp14_, _tmp15_);
	}
	_tmp16_ = y;
	if ((((gint) _tmp16_) + 1) < BOARD_VIEW_size) {
		Light** _tmp17_ = NULL;
		gint _tmp17__length1 = 0;
		gint _tmp17__length2 = 0;
		gint _tmp18_ = 0;
		gint _tmp19_ = 0;
		Light* _tmp20_ = NULL;
		ClutterTimeline* _tmp21_ = NULL;
		_tmp17_ = self->priv->lights;
		_tmp17__length1 = self->priv->lights_length1;
		_tmp17__length2 = self->priv->lights_length2;
		_tmp18_ = x;
		_tmp19_ = y;
		_tmp20_ = _tmp17_[(((gint) _tmp18_) * _tmp17__length2) + (((gint) _tmp19_) + 1)];
		_tmp21_ = timeline;
		light_toggle (_tmp20_, _tmp21_);
	}
	_tmp22_ = y;
	if ((((gint) _tmp22_) - 1) >= 0) {
		Light** _tmp23_ = NULL;
		gint _tmp23__length1 = 0;
		gint _tmp23__length2 = 0;
		gint _tmp24_ = 0;
		gint _tmp25_ = 0;
		Light* _tmp26_ = NULL;
		ClutterTimeline* _tmp27_ = NULL;
		_tmp23_ = self->priv->lights;
		_tmp23__length1 = self->priv->lights_length1;
		_tmp23__length2 = self->priv->lights_length2;
		_tmp24_ = x;
		_tmp25_ = y;
		_tmp26_ = _tmp23_[(((gint) _tmp24_) * _tmp23__length2) + (((gint) _tmp25_) - 1)];
		_tmp27_ = timeline;
		light_toggle (_tmp26_, _tmp27_);
	}
	_tmp28_ = self->priv->lights;
	_tmp28__length1 = self->priv->lights_length1;
	_tmp28__length2 = self->priv->lights_length2;
	_tmp29_ = x;
	_tmp30_ = y;
	_tmp31_ = _tmp28_[(((gint) _tmp29_) * _tmp28__length2) + ((gint) _tmp30_)];
	_tmp32_ = timeline;
	light_toggle (_tmp31_, _tmp32_);
	_tmp33_ = animate;
	if (_tmp33_) {
		ClutterTimeline* _tmp34_ = NULL;
		_tmp34_ = timeline;
		clutter_timeline_start (_tmp34_);
	}
	_g_object_unref0 (timeline);
}


static void board_view_toggle_completed_cb (BoardView* self) {
	gboolean cleared = FALSE;
	gboolean _tmp14_ = FALSE;
	g_return_if_fail (self != NULL);
	cleared = TRUE;
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = x;
					x = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = x;
				if (!(_tmp3_ < BOARD_VIEW_size)) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp4_ = FALSE;
						_tmp4_ = TRUE;
						while (TRUE) {
							gboolean _tmp5_ = FALSE;
							gint _tmp7_ = 0;
							Light** _tmp8_ = NULL;
							gint _tmp8__length1 = 0;
							gint _tmp8__length2 = 0;
							gint _tmp9_ = 0;
							gint _tmp10_ = 0;
							Light* _tmp11_ = NULL;
							gboolean _tmp12_ = FALSE;
							gboolean _tmp13_ = FALSE;
							_tmp5_ = _tmp4_;
							if (!_tmp5_) {
								gint _tmp6_ = 0;
								_tmp6_ = y;
								y = _tmp6_ + 1;
							}
							_tmp4_ = FALSE;
							_tmp7_ = y;
							if (!(_tmp7_ < BOARD_VIEW_size)) {
								break;
							}
							_tmp8_ = self->priv->lights;
							_tmp8__length1 = self->priv->lights_length1;
							_tmp8__length2 = self->priv->lights_length2;
							_tmp9_ = x;
							_tmp10_ = y;
							_tmp11_ = _tmp8_[(_tmp9_ * _tmp8__length2) + _tmp10_];
							_tmp12_ = light_get_is_lit (_tmp11_);
							_tmp13_ = _tmp12_;
							if (_tmp13_) {
								cleared = FALSE;
							}
						}
					}
				}
			}
		}
	}
	_tmp14_ = cleared;
	if (_tmp14_) {
		g_signal_emit_by_name (self, "game-won");
	}
}


void board_view_load_level (BoardView* self, gint level) {
	gint _tmp0_ = 0;
	gint _tmp13_ = 0;
	gint solution_length = 0;
	gint _tmp14_ = 0;
	gdouble _tmp15_ = 0.0;
	gdouble _tmp16_ = 0.0;
	gboolean* sol = NULL;
	PuzzleGenerator* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	gboolean* _tmp21_ = NULL;
	gint sol_length1 = 0;
	gint sol_length2 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = level;
	if (_tmp0_ < 1) {
		level = 1;
	}
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gboolean _tmp2_ = FALSE;
				gint _tmp4_ = 0;
				_tmp2_ = _tmp1_;
				if (!_tmp2_) {
					gint _tmp3_ = 0;
					_tmp3_ = x;
					x = _tmp3_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp4_ = x;
				if (!(_tmp4_ < BOARD_VIEW_size)) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp5_ = FALSE;
						_tmp5_ = TRUE;
						while (TRUE) {
							gboolean _tmp6_ = FALSE;
							gint _tmp8_ = 0;
							Light** _tmp9_ = NULL;
							gint _tmp9__length1 = 0;
							gint _tmp9__length2 = 0;
							gint _tmp10_ = 0;
							gint _tmp11_ = 0;
							Light* _tmp12_ = NULL;
							_tmp6_ = _tmp5_;
							if (!_tmp6_) {
								gint _tmp7_ = 0;
								_tmp7_ = y;
								y = _tmp7_ + 1;
							}
							_tmp5_ = FALSE;
							_tmp8_ = y;
							if (!(_tmp8_ < BOARD_VIEW_size)) {
								break;
							}
							_tmp9_ = self->priv->lights;
							_tmp9__length1 = self->priv->lights_length1;
							_tmp9__length2 = self->priv->lights_length2;
							_tmp10_ = x;
							_tmp11_ = y;
							_tmp12_ = _tmp9_[(_tmp10_ * _tmp9__length2) + _tmp11_];
							light_set_is_lit (_tmp12_, FALSE);
						}
					}
				}
			}
		}
	}
	_tmp13_ = level;
	g_random_set_seed ((guint32) _tmp13_);
	_tmp14_ = level;
	_tmp15_ = log ((gdouble) _tmp14_);
	_tmp16_ = floor ((2 * _tmp15_) + 1);
	solution_length = (gint) _tmp16_;
	_tmp17_ = self->priv->puzzle_generator;
	_tmp18_ = solution_length;
	_tmp21_ = puzzle_generator_minimal_solution (_tmp17_, _tmp18_, &_tmp19_, &_tmp20_);
	sol = _tmp21_;
	sol_length1 = _tmp19_;
	sol_length2 = _tmp20_;
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp22_ = FALSE;
			_tmp22_ = TRUE;
			while (TRUE) {
				gboolean _tmp23_ = FALSE;
				gint _tmp25_ = 0;
				_tmp23_ = _tmp22_;
				if (!_tmp23_) {
					gint _tmp24_ = 0;
					_tmp24_ = x;
					x = _tmp24_ + 1;
				}
				_tmp22_ = FALSE;
				_tmp25_ = x;
				if (!(_tmp25_ < BOARD_VIEW_size)) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp26_ = FALSE;
						_tmp26_ = TRUE;
						while (TRUE) {
							gboolean _tmp27_ = FALSE;
							gint _tmp29_ = 0;
							gboolean* _tmp30_ = NULL;
							gint _tmp30__length1 = 0;
							gint _tmp30__length2 = 0;
							gint _tmp31_ = 0;
							gint _tmp32_ = 0;
							gboolean _tmp33_ = FALSE;
							_tmp27_ = _tmp26_;
							if (!_tmp27_) {
								gint _tmp28_ = 0;
								_tmp28_ = y;
								y = _tmp28_ + 1;
							}
							_tmp26_ = FALSE;
							_tmp29_ = y;
							if (!(_tmp29_ < BOARD_VIEW_size)) {
								break;
							}
							_tmp30_ = sol;
							_tmp30__length1 = sol_length1;
							_tmp30__length2 = sol_length2;
							_tmp31_ = x;
							_tmp32_ = y;
							_tmp33_ = _tmp30_[(_tmp31_ * _tmp30__length2) + _tmp32_];
							if (_tmp33_) {
								gint _tmp34_ = 0;
								gint _tmp35_ = 0;
								_tmp34_ = x;
								_tmp35_ = y;
								board_view_toggle_light (self, _tmp34_, _tmp35_, FALSE);
							}
						}
					}
				}
			}
		}
	}
	sol = (g_free (sol), NULL);
}


static void board_view_class_init (BoardViewClass * klass) {
	board_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BoardViewPrivate));
	G_OBJECT_CLASS (klass)->finalize = board_view_finalize;
	g_signal_new ("game_won", TYPE_BOARD_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void board_view_instance_init (BoardView * self) {
	self->priv = BOARD_VIEW_GET_PRIVATE (self);
	self->playable = TRUE;
}


static void board_view_finalize (GObject* obj) {
	BoardView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BOARD_VIEW, BoardView);
	_puzzle_generator_unref0 (self->priv->puzzle_generator);
	_g_object_unref0 (self->priv->off_texture);
	_g_object_unref0 (self->priv->on_texture);
	self->priv->lights = (_vala_array_free (self->priv->lights, self->priv->lights_length1 * self->priv->lights_length2, (GDestroyNotify) g_object_unref), NULL);
	G_OBJECT_CLASS (board_view_parent_class)->finalize (obj);
}


GType board_view_get_type (void) {
	static volatile gsize board_view_type_id__volatile = 0;
	if (g_once_init_enter (&board_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BoardViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) board_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoardView), 0, (GInstanceInitFunc) board_view_instance_init, NULL };
		GType board_view_type_id;
		board_view_type_id = g_type_register_static (clutter_group_get_type (), "BoardView", &g_define_type_info, 0);
		g_once_init_leave (&board_view_type_id__volatile, board_view_type_id);
	}
	return board_view_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



