/* game-view.c generated by valac 0.23.3.20-47868, the Vala compiler
 * generated from game-view.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <clutter/clutter.h>
#include <float.h>
#include <math.h>


#define TYPE_GAME_VIEW (game_view_get_type ())
#define GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_VIEW, GameView))
#define GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_VIEW, GameViewClass))
#define IS_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_VIEW))
#define IS_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_VIEW))
#define GAME_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_VIEW, GameViewClass))

typedef struct _GameView GameView;
typedef struct _GameViewClass GameViewClass;
typedef struct _GameViewPrivate GameViewPrivate;

#define TYPE_LED_ARRAY (led_array_get_type ())
#define LED_ARRAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LED_ARRAY, LEDArray))
#define LED_ARRAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LED_ARRAY, LEDArrayClass))
#define IS_LED_ARRAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LED_ARRAY))
#define IS_LED_ARRAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LED_ARRAY))
#define LED_ARRAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LED_ARRAY, LEDArrayClass))

typedef struct _LEDArray LEDArray;
typedef struct _LEDArrayClass LEDArrayClass;

#define TYPE_BOARD_VIEW (board_view_get_type ())
#define BOARD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOARD_VIEW, BoardView))
#define BOARD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOARD_VIEW, BoardViewClass))
#define IS_BOARD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOARD_VIEW))
#define IS_BOARD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOARD_VIEW))
#define BOARD_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOARD_VIEW, BoardViewClass))

typedef struct _BoardView BoardView;
typedef struct _BoardViewClass BoardViewClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _BoardViewPrivate BoardViewPrivate;

struct _GameView {
	ClutterGroup parent_instance;
	GameViewPrivate * priv;
};

struct _GameViewClass {
	ClutterGroupClass parent_class;
};

struct _GameViewPrivate {
	ClutterTexture* backing_texture;
	ClutterTexture* highlight_texture;
	ClutterTexture* off_texture;
	ClutterTexture* on_texture;
	ClutterTexture* led_back_texture;
	ClutterTexture* arrow_texture;
	gint current_level;
	GList* actor_remove_queue;
	LEDArray* score_view;
	ClutterGroup* board_group;
	BoardView* board_view;
	BoardView* new_board_view;
	ClutterActor* backing_view;
	ClutterActor* left_arrow;
	ClutterActor* right_arrow;
	ClutterActor* key_cursor_view;
	ClutterTimeline* timeline;
	gint key_cursor_x;
	gint key_cursor_y;
	gboolean key_cursor_ready;
	gint last_direction;
	gint last_sign;
};

struct _BoardView {
	ClutterGroup parent_instance;
	BoardViewPrivate * priv;
	gboolean playable;
};

struct _BoardViewClass {
	ClutterGroupClass parent_class;
};


static gpointer game_view_parent_class = NULL;

GType game_view_get_type (void) G_GNUC_CONST;
GType led_array_get_type (void) G_GNUC_CONST;
GType board_view_get_type (void) G_GNUC_CONST;
#define GAME_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GAME_VIEW, GameViewPrivate))
enum  {
	GAME_VIEW_DUMMY_PROPERTY
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
GameView* game_view_new (gint level);
GameView* game_view_construct (GType object_type, gint level);
static BoardView* game_view_create_board_view (GameView* self, gint level);
LEDArray* led_array_new (gint n_digits, ClutterActor* back_texture);
LEDArray* led_array_construct (GType object_type, gint n_digits, ClutterActor* back_texture);
void led_array_set_value (LEDArray* self, gint value);
static gboolean game_view_left_arrow_button_release_cb (GameView* self, ClutterActor* actor, ClutterButtonEvent* event);
static gboolean _game_view_left_arrow_button_release_cb_clutter_actor_button_release_event (ClutterActor* _sender, ClutterButtonEvent* event, gpointer self);
static gboolean game_view_right_arrow_button_release_cb (GameView* self, ClutterActor* actor, ClutterButtonEvent* event);
static gboolean _game_view_right_arrow_button_release_cb_clutter_actor_button_release_event (ClutterActor* _sender, ClutterButtonEvent* event, gpointer self);
BoardView* board_view_new (ClutterTexture* off_texture, ClutterTexture* on_texture);
BoardView* board_view_construct (GType object_type, ClutterTexture* off_texture, ClutterTexture* on_texture);
void board_view_load_level (BoardView* self, gint level);
static void game_view_game_won_cb (GameView* self);
static void _game_view_game_won_cb_board_view_game_won (BoardView* _sender, gpointer self);
static void game_view_transition_complete_cb (GameView* self);
void board_view_slide_in (BoardView* self, gint direction, gint sign, ClutterTimeline* timeline);
void board_view_slide_out (BoardView* self, gint direction, gint sign, ClutterTimeline* timeline);
static void _game_view_transition_complete_cb_clutter_timeline_completed (ClutterTimeline* _sender, gpointer self);
static void game_view_swap_board (GameView* self, gint direction);
void board_view_swap_in (BoardView* self, gfloat direction, ClutterTimeline* timeline);
void board_view_swap_out (BoardView* self, gfloat direction, ClutterTimeline* timeline);
void game_view_hide_cursor (GameView* self);
void game_view_move_cursor (GameView* self, gint x_step, gint y_step);
void board_view_get_light_position (BoardView* self, gint x, gint y, gfloat* xx, gfloat* yy);
void game_view_activate_cursor (GameView* self);
void board_view_toggle_light (BoardView* self, gint x, gint y, gboolean animate);
void game_view_reset_game (GameView* self);
static void game_view_finalize (GObject* obj);


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static gboolean _game_view_left_arrow_button_release_cb_clutter_actor_button_release_event (ClutterActor* _sender, ClutterButtonEvent* event, gpointer self) {
	gboolean result;
	result = game_view_left_arrow_button_release_cb ((GameView*) self, _sender, event);
	return result;
}


static gboolean _game_view_right_arrow_button_release_cb_clutter_actor_button_release_event (ClutterActor* _sender, ClutterButtonEvent* event, gpointer self) {
	gboolean result;
	result = game_view_right_arrow_button_release_cb ((GameView*) self, _sender, event);
	return result;
}


GameView* game_view_construct (GType object_type, gint level) {
	GameView * self = NULL;
	ClutterTexture* _tmp38_ = NULL;
	ClutterTexture* _tmp39_ = NULL;
	ClutterTexture* _tmp40_ = NULL;
	ClutterTexture* _tmp41_ = NULL;
	ClutterTexture* _tmp42_ = NULL;
	ClutterTexture* _tmp43_ = NULL;
	ClutterTexture* _tmp44_ = NULL;
	ClutterTexture* _tmp45_ = NULL;
	ClutterTexture* _tmp46_ = NULL;
	ClutterTexture* _tmp47_ = NULL;
	ClutterTexture* _tmp48_ = NULL;
	ClutterTexture* _tmp49_ = NULL;
	gfloat real_board_width = 0.0F;
	ClutterTexture* _tmp50_ = NULL;
	gfloat _tmp51_ = 0.0F;
	gfloat _tmp52_ = 0.0F;
	gfloat real_board_height = 0.0F;
	ClutterTexture* _tmp53_ = NULL;
	gfloat _tmp54_ = 0.0F;
	gfloat _tmp55_ = 0.0F;
	ClutterGroup* _tmp56_ = NULL;
	ClutterGroup* _tmp57_ = NULL;
	gint _tmp58_ = 0;
	gint _tmp59_ = 0;
	BoardView* _tmp60_ = NULL;
	BoardView* _tmp61_ = NULL;
	ClutterGroup* _tmp62_ = NULL;
	BoardView* _tmp63_ = NULL;
	ClutterTexture* _tmp64_ = NULL;
	ClutterClone* _tmp65_ = NULL;
	ClutterActor* _tmp66_ = NULL;
	ClutterActor* _tmp67_ = NULL;
	ClutterTexture* _tmp68_ = NULL;
	LEDArray* _tmp69_ = NULL;
	LEDArray* _tmp70_ = NULL;
	gint _tmp71_ = 0;
	LEDArray* _tmp72_ = NULL;
	LEDArray* _tmp73_ = NULL;
	gfloat _tmp74_ = 0.0F;
	gfloat _tmp75_ = 0.0F;
	LEDArray* _tmp76_ = NULL;
	LEDArray* _tmp77_ = NULL;
	LEDArray* _tmp78_ = NULL;
	gfloat _tmp79_ = 0.0F;
	gfloat _tmp80_ = 0.0F;
	LEDArray* _tmp81_ = NULL;
	gfloat _tmp82_ = 0.0F;
	gfloat _tmp83_ = 0.0F;
	ClutterTexture* _tmp84_ = NULL;
	ClutterClone* _tmp85_ = NULL;
	ClutterActor* _tmp86_ = NULL;
	ClutterActor* _tmp87_ = NULL;
	ClutterActor* _tmp88_ = NULL;
	ClutterActor* _tmp89_ = NULL;
	LEDArray* _tmp90_ = NULL;
	gfloat _tmp91_ = 0.0F;
	gfloat _tmp92_ = 0.0F;
	LEDArray* _tmp93_ = NULL;
	gfloat _tmp94_ = 0.0F;
	gfloat _tmp95_ = 0.0F;
	LEDArray* _tmp96_ = NULL;
	gfloat _tmp97_ = 0.0F;
	gfloat _tmp98_ = 0.0F;
	LEDArray* _tmp99_ = NULL;
	gfloat _tmp100_ = 0.0F;
	gfloat _tmp101_ = 0.0F;
	ClutterActor* _tmp102_ = NULL;
	ClutterTexture* _tmp103_ = NULL;
	ClutterClone* _tmp104_ = NULL;
	ClutterActor* _tmp105_ = NULL;
	ClutterActor* _tmp106_ = NULL;
	ClutterActor* _tmp107_ = NULL;
	ClutterActor* _tmp108_ = NULL;
	ClutterActor* _tmp109_ = NULL;
	ClutterActor* _tmp110_ = NULL;
	gfloat _tmp111_ = 0.0F;
	gfloat _tmp112_ = 0.0F;
	LEDArray* _tmp113_ = NULL;
	gfloat _tmp114_ = 0.0F;
	gfloat _tmp115_ = 0.0F;
	LEDArray* _tmp116_ = NULL;
	gfloat _tmp117_ = 0.0F;
	gfloat _tmp118_ = 0.0F;
	ClutterActor* _tmp119_ = NULL;
	ClutterTexture* _tmp120_ = NULL;
	ClutterClone* _tmp121_ = NULL;
	ClutterActor* _tmp122_ = NULL;
	ClutterActor* _tmp123_ = NULL;
	ClutterActor* _tmp124_ = NULL;
	GError * _inner_error_ = NULL;
	self = (GameView*) g_object_new (object_type, NULL);
	{
		ClutterTexture* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		ClutterTexture* _tmp3_ = NULL;
		ClutterTexture* _tmp4_ = NULL;
		ClutterTexture* _tmp5_ = NULL;
		ClutterTexture* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		ClutterTexture* _tmp9_ = NULL;
		ClutterTexture* _tmp10_ = NULL;
		ClutterTexture* _tmp11_ = NULL;
		ClutterTexture* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		ClutterTexture* _tmp15_ = NULL;
		ClutterTexture* _tmp16_ = NULL;
		ClutterTexture* _tmp17_ = NULL;
		ClutterTexture* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		ClutterTexture* _tmp21_ = NULL;
		ClutterTexture* _tmp22_ = NULL;
		ClutterTexture* _tmp23_ = NULL;
		ClutterTexture* _tmp24_ = NULL;
		gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
		ClutterTexture* _tmp27_ = NULL;
		ClutterTexture* _tmp28_ = NULL;
		ClutterTexture* _tmp29_ = NULL;
		ClutterTexture* _tmp30_ = NULL;
		gchar* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		ClutterTexture* _tmp33_ = NULL;
		ClutterTexture* _tmp34_ = NULL;
		ClutterTexture* _tmp35_ = NULL;
		_tmp1_ = g_build_filename (DATADIR, "backing.svg", NULL);
		_tmp2_ = _tmp1_;
		_tmp3_ = (ClutterTexture*) clutter_texture_new_from_file (_tmp2_, &_inner_error_);
		g_object_ref_sink (_tmp3_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		_tmp0_ = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == CLUTTER_TEXTURE_ERROR) {
				goto __catch1_clutter_texture_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp5_ = _tmp0_;
		_tmp0_ = NULL;
		g_object_ref_sink (_tmp5_);
		_g_object_unref0 (self->priv->backing_texture);
		self->priv->backing_texture = _tmp5_;
		_tmp7_ = g_build_filename (DATADIR, "highlight.svg", NULL);
		_tmp8_ = _tmp7_;
		_tmp9_ = (ClutterTexture*) clutter_texture_new_from_file (_tmp8_, &_inner_error_);
		g_object_ref_sink (_tmp9_);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		_tmp6_ = _tmp10_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (_tmp0_);
			if (_inner_error_->domain == CLUTTER_TEXTURE_ERROR) {
				goto __catch1_clutter_texture_error;
			}
			_g_object_unref0 (_tmp0_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp11_ = _tmp6_;
		_tmp6_ = NULL;
		g_object_ref_sink (_tmp11_);
		_g_object_unref0 (self->priv->highlight_texture);
		self->priv->highlight_texture = _tmp11_;
		_tmp13_ = g_build_filename (DATADIR, "off.svg", NULL);
		_tmp14_ = _tmp13_;
		_tmp15_ = (ClutterTexture*) clutter_texture_new_from_file (_tmp14_, &_inner_error_);
		g_object_ref_sink (_tmp15_);
		_tmp16_ = _tmp15_;
		_g_free0 (_tmp14_);
		_tmp12_ = _tmp16_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (_tmp6_);
			_g_object_unref0 (_tmp0_);
			if (_inner_error_->domain == CLUTTER_TEXTURE_ERROR) {
				goto __catch1_clutter_texture_error;
			}
			_g_object_unref0 (_tmp6_);
			_g_object_unref0 (_tmp0_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp17_ = _tmp12_;
		_tmp12_ = NULL;
		g_object_ref_sink (_tmp17_);
		_g_object_unref0 (self->priv->off_texture);
		self->priv->off_texture = _tmp17_;
		_tmp19_ = g_build_filename (DATADIR, "on.svg", NULL);
		_tmp20_ = _tmp19_;
		_tmp21_ = (ClutterTexture*) clutter_texture_new_from_file (_tmp20_, &_inner_error_);
		g_object_ref_sink (_tmp21_);
		_tmp22_ = _tmp21_;
		_g_free0 (_tmp20_);
		_tmp18_ = _tmp22_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (_tmp12_);
			_g_object_unref0 (_tmp6_);
			_g_object_unref0 (_tmp0_);
			if (_inner_error_->domain == CLUTTER_TEXTURE_ERROR) {
				goto __catch1_clutter_texture_error;
			}
			_g_object_unref0 (_tmp12_);
			_g_object_unref0 (_tmp6_);
			_g_object_unref0 (_tmp0_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp23_ = _tmp18_;
		_tmp18_ = NULL;
		g_object_ref_sink (_tmp23_);
		_g_object_unref0 (self->priv->on_texture);
		self->priv->on_texture = _tmp23_;
		_tmp25_ = g_build_filename (DATADIR, "led-back.svg", NULL);
		_tmp26_ = _tmp25_;
		_tmp27_ = (ClutterTexture*) clutter_texture_new_from_file (_tmp26_, &_inner_error_);
		g_object_ref_sink (_tmp27_);
		_tmp28_ = _tmp27_;
		_g_free0 (_tmp26_);
		_tmp24_ = _tmp28_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (_tmp18_);
			_g_object_unref0 (_tmp12_);
			_g_object_unref0 (_tmp6_);
			_g_object_unref0 (_tmp0_);
			if (_inner_error_->domain == CLUTTER_TEXTURE_ERROR) {
				goto __catch1_clutter_texture_error;
			}
			_g_object_unref0 (_tmp18_);
			_g_object_unref0 (_tmp12_);
			_g_object_unref0 (_tmp6_);
			_g_object_unref0 (_tmp0_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp29_ = _tmp24_;
		_tmp24_ = NULL;
		g_object_ref_sink (_tmp29_);
		_g_object_unref0 (self->priv->led_back_texture);
		self->priv->led_back_texture = _tmp29_;
		_tmp31_ = g_build_filename (DATADIR, "arrow.svg", NULL);
		_tmp32_ = _tmp31_;
		_tmp33_ = (ClutterTexture*) clutter_texture_new_from_file (_tmp32_, &_inner_error_);
		g_object_ref_sink (_tmp33_);
		_tmp34_ = _tmp33_;
		_g_free0 (_tmp32_);
		_tmp30_ = _tmp34_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (_tmp24_);
			_g_object_unref0 (_tmp18_);
			_g_object_unref0 (_tmp12_);
			_g_object_unref0 (_tmp6_);
			_g_object_unref0 (_tmp0_);
			if (_inner_error_->domain == CLUTTER_TEXTURE_ERROR) {
				goto __catch1_clutter_texture_error;
			}
			_g_object_unref0 (_tmp24_);
			_g_object_unref0 (_tmp18_);
			_g_object_unref0 (_tmp12_);
			_g_object_unref0 (_tmp6_);
			_g_object_unref0 (_tmp0_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp35_ = _tmp30_;
		_tmp30_ = NULL;
		g_object_ref_sink (_tmp35_);
		_g_object_unref0 (self->priv->arrow_texture);
		self->priv->arrow_texture = _tmp35_;
		_g_object_unref0 (_tmp30_);
		_g_object_unref0 (_tmp24_);
		_g_object_unref0 (_tmp18_);
		_g_object_unref0 (_tmp12_);
		_g_object_unref0 (_tmp6_);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally1;
	__catch1_clutter_texture_error:
	{
		GError* e = NULL;
		GError* _tmp36_ = NULL;
		const gchar* _tmp37_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp36_ = e;
		_tmp37_ = _tmp36_->message;
		g_warning ("game-view.vala:57: Failed to load textures: %s", _tmp37_);
		_g_error_free0 (e);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp38_ = self->priv->backing_texture;
	clutter_actor_hide ((ClutterActor*) _tmp38_);
	_tmp39_ = self->priv->backing_texture;
	clutter_container_add_actor ((ClutterContainer*) self, (ClutterActor*) _tmp39_);
	_tmp40_ = self->priv->highlight_texture;
	clutter_actor_hide ((ClutterActor*) _tmp40_);
	_tmp41_ = self->priv->highlight_texture;
	clutter_container_add_actor ((ClutterContainer*) self, (ClutterActor*) _tmp41_);
	_tmp42_ = self->priv->off_texture;
	clutter_actor_hide ((ClutterActor*) _tmp42_);
	_tmp43_ = self->priv->off_texture;
	clutter_container_add_actor ((ClutterContainer*) self, (ClutterActor*) _tmp43_);
	_tmp44_ = self->priv->on_texture;
	clutter_actor_hide ((ClutterActor*) _tmp44_);
	_tmp45_ = self->priv->on_texture;
	clutter_container_add_actor ((ClutterContainer*) self, (ClutterActor*) _tmp45_);
	_tmp46_ = self->priv->led_back_texture;
	clutter_actor_hide ((ClutterActor*) _tmp46_);
	_tmp47_ = self->priv->led_back_texture;
	clutter_container_add_actor ((ClutterContainer*) self, (ClutterActor*) _tmp47_);
	_tmp48_ = self->priv->arrow_texture;
	clutter_actor_hide ((ClutterActor*) _tmp48_);
	_tmp49_ = self->priv->arrow_texture;
	clutter_container_add_actor ((ClutterContainer*) self, (ClutterActor*) _tmp49_);
	_tmp50_ = self->priv->off_texture;
	_tmp51_ = clutter_actor_get_width ((ClutterActor*) _tmp50_);
	_tmp52_ = _tmp51_;
	real_board_width = (5 * _tmp52_) + 4;
	_tmp53_ = self->priv->off_texture;
	_tmp54_ = clutter_actor_get_height ((ClutterActor*) _tmp53_);
	_tmp55_ = _tmp54_;
	real_board_height = (5 * _tmp55_) + 4;
	_tmp56_ = (ClutterGroup*) clutter_group_new ();
	g_object_ref_sink (_tmp56_);
	_g_object_unref0 (self->priv->board_group);
	self->priv->board_group = _tmp56_;
	_tmp57_ = self->priv->board_group;
	clutter_container_add_actor ((ClutterContainer*) self, (ClutterActor*) _tmp57_);
	_tmp58_ = level;
	self->priv->current_level = _tmp58_;
	_tmp59_ = self->priv->current_level;
	_tmp60_ = game_view_create_board_view (self, _tmp59_);
	_g_object_unref0 (self->priv->board_view);
	self->priv->board_view = _tmp60_;
	_tmp61_ = self->priv->board_view;
	_tmp61_->playable = TRUE;
	_tmp62_ = self->priv->board_group;
	_tmp63_ = self->priv->board_view;
	clutter_container_add_actor ((ClutterContainer*) _tmp62_, (ClutterActor*) _tmp63_);
	_tmp64_ = self->priv->backing_texture;
	_tmp65_ = (ClutterClone*) clutter_clone_new ((ClutterActor*) _tmp64_);
	g_object_ref_sink (_tmp65_);
	_g_object_unref0 (self->priv->backing_view);
	self->priv->backing_view = (ClutterActor*) _tmp65_;
	_tmp66_ = self->priv->backing_view;
	clutter_actor_set_position (_tmp66_, (gfloat) 0, real_board_height);
	_tmp67_ = self->priv->backing_view;
	clutter_container_add_actor ((ClutterContainer*) self, _tmp67_);
	_tmp68_ = self->priv->led_back_texture;
	_tmp69_ = led_array_new (5, (ClutterActor*) _tmp68_);
	g_object_ref_sink (_tmp69_);
	_g_object_unref0 (self->priv->score_view);
	self->priv->score_view = _tmp69_;
	_tmp70_ = self->priv->score_view;
	_tmp71_ = self->priv->current_level;
	led_array_set_value (_tmp70_, _tmp71_);
	_tmp72_ = self->priv->score_view;
	_tmp73_ = self->priv->score_view;
	_tmp74_ = clutter_actor_get_width ((ClutterActor*) _tmp73_);
	_tmp75_ = _tmp74_;
	clutter_actor_set_anchor_point ((ClutterActor*) _tmp72_, _tmp75_ / 2, (gfloat) 0);
	_tmp76_ = self->priv->score_view;
	clutter_actor_set_position ((ClutterActor*) _tmp76_, real_board_width / 2, real_board_height + 18);
	_tmp77_ = self->priv->score_view;
	clutter_container_add_actor ((ClutterContainer*) self, (ClutterActor*) _tmp77_);
	_tmp78_ = self->priv->score_view;
	_tmp79_ = clutter_actor_get_y ((ClutterActor*) _tmp78_);
	_tmp80_ = _tmp79_;
	_tmp81_ = self->priv->score_view;
	_tmp82_ = clutter_actor_get_height ((ClutterActor*) _tmp81_);
	_tmp83_ = _tmp82_;
	clutter_actor_set_size ((ClutterActor*) self, real_board_width, _tmp80_ + _tmp83_);
	_tmp84_ = self->priv->arrow_texture;
	_tmp85_ = (ClutterClone*) clutter_clone_new ((ClutterActor*) _tmp84_);
	g_object_ref_sink (_tmp85_);
	_g_object_unref0 (self->priv->left_arrow);
	self->priv->left_arrow = (ClutterActor*) _tmp85_;
	_tmp86_ = self->priv->left_arrow;
	g_object_set (_tmp86_, "anchor-gravity", CLUTTER_GRAVITY_CENTER, NULL);
	_tmp87_ = self->priv->left_arrow;
	clutter_actor_set_reactive (_tmp87_, TRUE);
	_tmp88_ = self->priv->left_arrow;
	g_signal_connect_object (_tmp88_, "button-release-event", (GCallback) _game_view_left_arrow_button_release_cb_clutter_actor_button_release_event, self, 0);
	_tmp89_ = self->priv->left_arrow;
	_tmp90_ = self->priv->score_view;
	_tmp91_ = clutter_actor_get_x ((ClutterActor*) _tmp90_);
	_tmp92_ = _tmp91_;
	_tmp93_ = self->priv->score_view;
	g_object_get ((ClutterActor*) _tmp93_, "anchor-x", &_tmp94_, NULL);
	_tmp95_ = _tmp94_;
	_tmp96_ = self->priv->score_view;
	_tmp97_ = clutter_actor_get_y ((ClutterActor*) _tmp96_);
	_tmp98_ = _tmp97_;
	_tmp99_ = self->priv->score_view;
	_tmp100_ = clutter_actor_get_height ((ClutterActor*) _tmp99_);
	_tmp101_ = _tmp100_;
	clutter_actor_set_position (_tmp89_, (_tmp92_ - _tmp95_) / 2, (_tmp98_ + (_tmp101_ / 2)) - 10);
	_tmp102_ = self->priv->left_arrow;
	clutter_container_add_actor ((ClutterContainer*) self, _tmp102_);
	_tmp103_ = self->priv->arrow_texture;
	_tmp104_ = (ClutterClone*) clutter_clone_new ((ClutterActor*) _tmp103_);
	g_object_ref_sink (_tmp104_);
	_g_object_unref0 (self->priv->right_arrow);
	self->priv->right_arrow = (ClutterActor*) _tmp104_;
	_tmp105_ = self->priv->right_arrow;
	g_object_set (_tmp105_, "anchor-gravity", CLUTTER_GRAVITY_CENTER, NULL);
	_tmp106_ = self->priv->right_arrow;
	clutter_actor_set_reactive (_tmp106_, TRUE);
	_tmp107_ = self->priv->right_arrow;
	g_signal_connect_object (_tmp107_, "button-release-event", (GCallback) _game_view_right_arrow_button_release_cb_clutter_actor_button_release_event, self, 0);
	_tmp108_ = self->priv->right_arrow;
	g_object_set (_tmp108_, "rotation-angle-y", (gdouble) 180, NULL);
	_tmp109_ = self->priv->right_arrow;
	_tmp110_ = self->priv->left_arrow;
	_tmp111_ = clutter_actor_get_x (_tmp110_);
	_tmp112_ = _tmp111_;
	_tmp113_ = self->priv->score_view;
	_tmp114_ = clutter_actor_get_y ((ClutterActor*) _tmp113_);
	_tmp115_ = _tmp114_;
	_tmp116_ = self->priv->score_view;
	_tmp117_ = clutter_actor_get_height ((ClutterActor*) _tmp116_);
	_tmp118_ = _tmp117_;
	clutter_actor_set_position (_tmp109_, real_board_width - _tmp112_, (_tmp115_ + (_tmp118_ / 2)) - 10);
	_tmp119_ = self->priv->right_arrow;
	clutter_container_add_actor ((ClutterContainer*) self, _tmp119_);
	_tmp120_ = self->priv->highlight_texture;
	_tmp121_ = (ClutterClone*) clutter_clone_new ((ClutterActor*) _tmp120_);
	g_object_ref_sink (_tmp121_);
	_g_object_unref0 (self->priv->key_cursor_view);
	self->priv->key_cursor_view = (ClutterActor*) _tmp121_;
	_tmp122_ = self->priv->key_cursor_view;
	clutter_actor_set_position (_tmp122_, (gfloat) (-100), (gfloat) (-100));
	_tmp123_ = self->priv->key_cursor_view;
	g_object_set (_tmp123_, "anchor-gravity", CLUTTER_GRAVITY_CENTER, NULL);
	_tmp124_ = self->priv->key_cursor_view;
	clutter_container_add_actor ((ClutterContainer*) self, _tmp124_);
	return self;
}


GameView* game_view_new (gint level) {
	return game_view_construct (TYPE_GAME_VIEW, level);
}


static void _game_view_game_won_cb_board_view_game_won (BoardView* _sender, gpointer self) {
	game_view_game_won_cb ((GameView*) self);
}


static BoardView* game_view_create_board_view (GameView* self, gint level) {
	BoardView* result = NULL;
	BoardView* view = NULL;
	ClutterTexture* _tmp0_ = NULL;
	ClutterTexture* _tmp1_ = NULL;
	BoardView* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->off_texture;
	_tmp1_ = self->priv->on_texture;
	_tmp2_ = board_view_new (_tmp0_, _tmp1_);
	g_object_ref_sink (_tmp2_);
	view = _tmp2_;
	_tmp3_ = level;
	board_view_load_level (view, _tmp3_);
	g_signal_connect_object (view, "game-won", (GCallback) _game_view_game_won_cb_board_view_game_won, self, 0);
	view->playable = FALSE;
	result = view;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void game_view_transition_complete_cb (GameView* self) {
	BoardView* _tmp0_ = NULL;
	BoardView* _tmp1_ = NULL;
	BoardView* _tmp2_ = NULL;
	BoardView* _tmp3_ = NULL;
	GList* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->board_view;
	clutter_actor_destroy ((ClutterActor*) _tmp0_);
	_tmp1_ = self->priv->new_board_view;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->board_view);
	self->priv->board_view = _tmp2_;
	_tmp3_ = self->priv->board_view;
	_tmp3_->playable = TRUE;
	_g_object_unref0 (self->priv->new_board_view);
	self->priv->new_board_view = NULL;
	_g_object_unref0 (self->priv->timeline);
	self->priv->timeline = NULL;
	_tmp4_ = self->priv->actor_remove_queue;
	{
		GList* actor_collection = NULL;
		GList* actor_it = NULL;
		actor_collection = _tmp4_;
		for (actor_it = actor_collection; actor_it != NULL; actor_it = actor_it->next) {
			ClutterActor* _tmp5_ = NULL;
			ClutterActor* actor = NULL;
			_tmp5_ = _g_object_ref0 ((ClutterActor*) actor_it->data);
			actor = _tmp5_;
			{
				ClutterActor* _tmp6_ = NULL;
				_tmp6_ = actor;
				clutter_actor_destroy (_tmp6_);
				_g_object_unref0 (actor);
			}
		}
	}
	__g_list_free__g_object_unref0_0 (self->priv->actor_remove_queue);
	self->priv->actor_remove_queue = NULL;
}


static void _game_view_transition_complete_cb_clutter_timeline_completed (ClutterTimeline* _sender, gpointer self) {
	game_view_transition_complete_cb ((GameView*) self);
}


static void game_view_game_won_cb (GameView* self) {
	gboolean _tmp0_ = FALSE;
	ClutterTimeline* _tmp1_ = NULL;
	gint _tmp4_ = 0;
	LEDArray* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint direction = 0;
	gint sign = 0;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	BoardView* _tmp19_ = NULL;
	ClutterGroup* _tmp20_ = NULL;
	BoardView* _tmp21_ = NULL;
	ClutterTimeline* _tmp22_ = NULL;
	BoardView* _tmp23_ = NULL;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	ClutterTimeline* _tmp26_ = NULL;
	BoardView* _tmp27_ = NULL;
	gint _tmp28_ = 0;
	gint _tmp29_ = 0;
	ClutterTimeline* _tmp30_ = NULL;
	ClutterTimeline* _tmp31_ = NULL;
	gint _tmp32_ = 0;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->timeline;
	if (_tmp1_ != NULL) {
		ClutterTimeline* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = self->priv->timeline;
		_tmp3_ = clutter_timeline_is_playing (_tmp2_);
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	_tmp4_ = self->priv->current_level;
	self->priv->current_level = _tmp4_ + 1;
	_tmp5_ = self->priv->score_view;
	_tmp6_ = self->priv->current_level;
	led_array_set_value (_tmp5_, _tmp6_);
	direction = 0;
	sign = 0;
	{
		gboolean _tmp7_ = FALSE;
		_tmp7_ = TRUE;
		while (TRUE) {
			gint32 _tmp13_ = 0;
			gint _tmp14_ = 0;
			gboolean _tmp15_ = FALSE;
			if (!_tmp7_) {
				gboolean _tmp8_ = FALSE;
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
				_tmp9_ = self->priv->last_direction;
				_tmp10_ = direction;
				if (_tmp9_ == _tmp10_) {
					gint _tmp11_ = 0;
					gint _tmp12_ = 0;
					_tmp11_ = self->priv->last_sign;
					_tmp12_ = sign;
					_tmp8_ = _tmp11_ == _tmp12_;
				} else {
					_tmp8_ = FALSE;
				}
				if (!_tmp8_) {
					break;
				}
			}
			_tmp7_ = FALSE;
			_tmp13_ = g_random_int_range ((gint32) 0, (gint32) 2);
			direction = (gint) _tmp13_;
			_tmp15_ = g_random_boolean ();
			if (_tmp15_) {
				_tmp14_ = 1;
			} else {
				_tmp14_ = -1;
			}
			sign = _tmp14_;
		}
	}
	_tmp16_ = direction;
	self->priv->last_direction = _tmp16_;
	_tmp17_ = sign;
	self->priv->last_sign = _tmp17_;
	_tmp18_ = self->priv->current_level;
	_tmp19_ = game_view_create_board_view (self, _tmp18_);
	_g_object_unref0 (self->priv->new_board_view);
	self->priv->new_board_view = _tmp19_;
	_tmp20_ = self->priv->board_group;
	_tmp21_ = self->priv->new_board_view;
	clutter_container_add_actor ((ClutterContainer*) _tmp20_, (ClutterActor*) _tmp21_);
	_tmp22_ = clutter_timeline_new ((guint) 1500);
	_g_object_unref0 (self->priv->timeline);
	self->priv->timeline = _tmp22_;
	_tmp23_ = self->priv->new_board_view;
	_tmp24_ = direction;
	_tmp25_ = sign;
	_tmp26_ = self->priv->timeline;
	board_view_slide_in (_tmp23_, _tmp24_, _tmp25_, _tmp26_);
	_tmp27_ = self->priv->board_view;
	_tmp28_ = direction;
	_tmp29_ = sign;
	_tmp30_ = self->priv->timeline;
	board_view_slide_out (_tmp27_, _tmp28_, _tmp29_, _tmp30_);
	_tmp31_ = self->priv->timeline;
	g_signal_connect_object (_tmp31_, "completed", (GCallback) _game_view_transition_complete_cb_clutter_timeline_completed, self, 0);
	_tmp32_ = self->priv->current_level;
	g_signal_emit_by_name (self, "level-changed", _tmp32_);
}


static gboolean game_view_left_arrow_button_release_cb (GameView* self, ClutterActor* actor, ClutterButtonEvent* event) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (actor != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	game_view_swap_board (self, -1);
	result = FALSE;
	return result;
}


static gboolean game_view_right_arrow_button_release_cb (GameView* self, ClutterActor* actor, ClutterButtonEvent* event) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (actor != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	game_view_swap_board (self, 1);
	result = FALSE;
	return result;
}


static void game_view_swap_board (GameView* self, gint direction) {
	gboolean _tmp0_ = FALSE;
	ClutterTimeline* _tmp1_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	LEDArray* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	ClutterTimeline* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	BoardView* _tmp11_ = NULL;
	ClutterGroup* _tmp12_ = NULL;
	BoardView* _tmp13_ = NULL;
	BoardView* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	BoardView* _tmp16_ = NULL;
	BoardView* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	ClutterTimeline* _tmp19_ = NULL;
	BoardView* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	ClutterTimeline* _tmp22_ = NULL;
	ClutterTimeline* _tmp23_ = NULL;
	gint _tmp24_ = 0;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->timeline;
	if (_tmp1_ != NULL) {
		ClutterTimeline* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = self->priv->timeline;
		_tmp3_ = clutter_timeline_is_playing (_tmp2_);
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	_tmp4_ = self->priv->current_level;
	_tmp5_ = direction;
	self->priv->current_level = _tmp4_ + _tmp5_;
	_tmp6_ = self->priv->current_level;
	if (_tmp6_ <= 0) {
		self->priv->current_level = 1;
		return;
	}
	_tmp7_ = self->priv->score_view;
	_tmp8_ = self->priv->current_level;
	led_array_set_value (_tmp7_, _tmp8_);
	_tmp9_ = clutter_timeline_new ((guint) 500);
	_g_object_unref0 (self->priv->timeline);
	self->priv->timeline = _tmp9_;
	_tmp10_ = self->priv->current_level;
	_tmp11_ = game_view_create_board_view (self, _tmp10_);
	_g_object_unref0 (self->priv->new_board_view);
	self->priv->new_board_view = _tmp11_;
	_tmp12_ = self->priv->board_group;
	_tmp13_ = self->priv->new_board_view;
	clutter_container_add_actor ((ClutterContainer*) _tmp12_, (ClutterActor*) _tmp13_);
	_tmp14_ = self->priv->new_board_view;
	_tmp15_ = direction;
	clutter_actor_set_depth ((ClutterActor*) _tmp14_, (gfloat) ((-250) * _tmp15_));
	_tmp16_ = self->priv->new_board_view;
	clutter_actor_set_opacity ((ClutterActor*) _tmp16_, (guint) 0);
	_tmp17_ = self->priv->new_board_view;
	_tmp18_ = direction;
	_tmp19_ = self->priv->timeline;
	board_view_swap_in (_tmp17_, (gfloat) _tmp18_, _tmp19_);
	_tmp20_ = self->priv->board_view;
	_tmp21_ = direction;
	_tmp22_ = self->priv->timeline;
	board_view_swap_out (_tmp20_, (gfloat) _tmp21_, _tmp22_);
	_tmp23_ = self->priv->timeline;
	g_signal_connect_object (_tmp23_, "completed", (GCallback) _game_view_transition_complete_cb_clutter_timeline_completed, self, 0);
	_tmp24_ = self->priv->current_level;
	g_signal_emit_by_name (self, "level-changed", _tmp24_);
}


void game_view_hide_cursor (GameView* self) {
	ClutterActor* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->key_cursor_view;
	clutter_actor_animate (_tmp0_, (gulong) CLUTTER_EASE_OUT_SINE, (guint) 250, "opacity", 0, NULL);
	self->priv->key_cursor_ready = FALSE;
}


void game_view_move_cursor (GameView* self, gint x_step, gint y_step) {
	gboolean _tmp0_ = FALSE;
	gfloat x = 0.0F;
	gfloat y = 0.0F;
	BoardView* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gfloat _tmp16_ = 0.0F;
	gfloat _tmp17_ = 0.0F;
	gboolean _tmp18_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->key_cursor_ready;
	if (_tmp0_) {
		gint _tmp1_ = 0;
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		_tmp1_ = self->priv->key_cursor_x;
		_tmp2_ = x_step;
		self->priv->key_cursor_x = _tmp1_ + _tmp2_;
		_tmp3_ = self->priv->key_cursor_y;
		_tmp4_ = y_step;
		self->priv->key_cursor_y = _tmp3_ + _tmp4_;
		_tmp5_ = self->priv->key_cursor_x;
		_tmp6_ = MAX (_tmp5_, 0);
		self->priv->key_cursor_x = _tmp6_;
		_tmp7_ = self->priv->key_cursor_x;
		_tmp8_ = MIN (_tmp7_, 4);
		self->priv->key_cursor_x = _tmp8_;
		_tmp9_ = self->priv->key_cursor_y;
		_tmp10_ = MAX (_tmp9_, 0);
		self->priv->key_cursor_y = _tmp10_;
		_tmp11_ = self->priv->key_cursor_y;
		_tmp12_ = MIN (_tmp11_, 4);
		self->priv->key_cursor_y = _tmp12_;
	}
	_tmp13_ = self->priv->board_view;
	_tmp14_ = self->priv->key_cursor_x;
	_tmp15_ = self->priv->key_cursor_y;
	board_view_get_light_position (_tmp13_, _tmp14_, _tmp15_, &_tmp16_, &_tmp17_);
	x = _tmp16_;
	y = _tmp17_;
	_tmp18_ = self->priv->key_cursor_ready;
	if (_tmp18_) {
		ClutterActor* _tmp19_ = NULL;
		gfloat _tmp20_ = 0.0F;
		gfloat _tmp21_ = 0.0F;
		_tmp19_ = self->priv->key_cursor_view;
		_tmp20_ = x;
		_tmp21_ = y;
		clutter_actor_animate (_tmp19_, (gulong) CLUTTER_EASE_OUT_SINE, (guint) 250, "x", _tmp20_, "y", _tmp21_, NULL);
	} else {
		ClutterActor* _tmp22_ = NULL;
		ClutterActor* _tmp23_ = NULL;
		gfloat _tmp24_ = 0.0F;
		gfloat _tmp25_ = 0.0F;
		ClutterActor* _tmp26_ = NULL;
		_tmp22_ = self->priv->key_cursor_view;
		clutter_actor_set_opacity (_tmp22_, (guint) 0);
		_tmp23_ = self->priv->key_cursor_view;
		_tmp24_ = x;
		_tmp25_ = y;
		clutter_actor_set_position (_tmp23_, _tmp24_, _tmp25_);
		_tmp26_ = self->priv->key_cursor_view;
		clutter_actor_animate (_tmp26_, (gulong) CLUTTER_EASE_OUT_SINE, (guint) 250, "opacity", 255, NULL);
	}
	self->priv->key_cursor_ready = TRUE;
}


void game_view_activate_cursor (GameView* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->key_cursor_ready;
	if (_tmp0_) {
		BoardView* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		_tmp1_ = self->priv->board_view;
		_tmp2_ = self->priv->key_cursor_x;
		_tmp3_ = self->priv->key_cursor_y;
		board_view_toggle_light (_tmp1_, _tmp2_, _tmp3_, TRUE);
	}
}


void game_view_reset_game (GameView* self) {
	gboolean _tmp0_ = FALSE;
	ClutterTimeline* _tmp1_ = NULL;
	LEDArray* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	ClutterTimeline* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	BoardView* _tmp8_ = NULL;
	ClutterGroup* _tmp9_ = NULL;
	BoardView* _tmp10_ = NULL;
	BoardView* _tmp11_ = NULL;
	BoardView* _tmp12_ = NULL;
	BoardView* _tmp13_ = NULL;
	ClutterTimeline* _tmp14_ = NULL;
	BoardView* _tmp15_ = NULL;
	ClutterTimeline* _tmp16_ = NULL;
	ClutterTimeline* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->timeline;
	if (_tmp1_ != NULL) {
		ClutterTimeline* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = self->priv->timeline;
		_tmp3_ = clutter_timeline_is_playing (_tmp2_);
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	self->priv->current_level = 1;
	_tmp4_ = self->priv->score_view;
	_tmp5_ = self->priv->current_level;
	led_array_set_value (_tmp4_, _tmp5_);
	_tmp6_ = clutter_timeline_new ((guint) 500);
	_g_object_unref0 (self->priv->timeline);
	self->priv->timeline = _tmp6_;
	_tmp7_ = self->priv->current_level;
	_tmp8_ = game_view_create_board_view (self, _tmp7_);
	_g_object_unref0 (self->priv->new_board_view);
	self->priv->new_board_view = _tmp8_;
	_tmp9_ = self->priv->board_group;
	_tmp10_ = self->priv->new_board_view;
	clutter_container_add_actor ((ClutterContainer*) _tmp9_, (ClutterActor*) _tmp10_);
	_tmp11_ = self->priv->new_board_view;
	clutter_actor_set_depth ((ClutterActor*) _tmp11_, (gfloat) 250);
	_tmp12_ = self->priv->new_board_view;
	clutter_actor_set_opacity ((ClutterActor*) _tmp12_, (guint) 0);
	_tmp13_ = self->priv->new_board_view;
	_tmp14_ = self->priv->timeline;
	board_view_swap_in (_tmp13_, (gfloat) (-1), _tmp14_);
	_tmp15_ = self->priv->board_view;
	_tmp16_ = self->priv->timeline;
	board_view_swap_out (_tmp15_, (gfloat) (-1), _tmp16_);
	_tmp17_ = self->priv->timeline;
	g_signal_connect_object (_tmp17_, "completed", (GCallback) _game_view_transition_complete_cb_clutter_timeline_completed, self, 0);
	_tmp18_ = self->priv->current_level;
	g_signal_emit_by_name (self, "level-changed", _tmp18_);
}


static void game_view_class_init (GameViewClass * klass) {
	game_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GameViewPrivate));
	G_OBJECT_CLASS (klass)->finalize = game_view_finalize;
	g_signal_new ("level_changed", TYPE_GAME_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
}


static void game_view_instance_init (GameView * self) {
	self->priv = GAME_VIEW_GET_PRIVATE (self);
	self->priv->actor_remove_queue = NULL;
	self->priv->new_board_view = NULL;
	self->priv->key_cursor_x = 0;
	self->priv->key_cursor_y = 0;
	self->priv->key_cursor_ready = FALSE;
	self->priv->last_direction = 0;
	self->priv->last_sign = 0;
}


static void game_view_finalize (GObject* obj) {
	GameView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME_VIEW, GameView);
	_g_object_unref0 (self->priv->backing_texture);
	_g_object_unref0 (self->priv->highlight_texture);
	_g_object_unref0 (self->priv->off_texture);
	_g_object_unref0 (self->priv->on_texture);
	_g_object_unref0 (self->priv->led_back_texture);
	_g_object_unref0 (self->priv->arrow_texture);
	__g_list_free__g_object_unref0_0 (self->priv->actor_remove_queue);
	_g_object_unref0 (self->priv->score_view);
	_g_object_unref0 (self->priv->board_group);
	_g_object_unref0 (self->priv->board_view);
	_g_object_unref0 (self->priv->new_board_view);
	_g_object_unref0 (self->priv->backing_view);
	_g_object_unref0 (self->priv->left_arrow);
	_g_object_unref0 (self->priv->right_arrow);
	_g_object_unref0 (self->priv->key_cursor_view);
	_g_object_unref0 (self->priv->timeline);
	G_OBJECT_CLASS (game_view_parent_class)->finalize (obj);
}


GType game_view_get_type (void) {
	static volatile gsize game_view_type_id__volatile = 0;
	if (g_once_init_enter (&game_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GameViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameView), 0, (GInstanceInitFunc) game_view_instance_init, NULL };
		GType game_view_type_id;
		game_view_type_id = g_type_register_static (clutter_group_get_type (), "GameView", &g_define_type_info, 0);
		g_once_init_leave (&game_view_type_id__volatile, game_view_type_id);
	}
	return game_view_type_id__volatile;
}



