//  Copyright(C) 2007-2009 Andoni Morales Alastruey
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
//
//

namespace LongoMatch.Video.Player {

	using System;
	using System.Collections;
	using System.Runtime.InteropServices;
	using LongoMatch.Video.Handlers;
	using LongoMatch.Video.Utils;

#region Autogenerated code
	public class GstPlayer : Gtk.EventBox,IPlayer, IMetadataReader, IFramesCapturer{

		[Obsolete]
		protected GstPlayer(GLib.GType gtype) : base(gtype) {}
		public GstPlayer(IntPtr raw) : base(raw) {}

		[DllImport("libcesarplayer.dll")]
		static extern unsafe IntPtr bacon_video_widget_new(int width, int height, int type, out IntPtr error);

		public unsafe GstPlayer (int width, int height, LongoMatch.Video.Player.GstUseType type) : base (IntPtr.Zero)
		{
			if (GetType () != typeof (GstPlayer)) {
				throw new InvalidOperationException ("Can't override this constructor.");
			}
			IntPtr error = IntPtr.Zero;
			Raw = bacon_video_widget_new(width, height, (int) type, out error);
			if (error != IntPtr.Zero) throw new GLib.GException (error);
		}

		[GLib.Property ("seekable")]
		public bool Seekable {
			get {
				GLib.Value val = GetProperty ("seekable");
				bool ret = (bool) val;
				val.Dispose ();
				return ret;
			}
		}

		[DllImport("libcesarplayer.dll")]
		static extern bool bacon_video_widget_get_logo_mode(IntPtr raw);

		[DllImport("libcesarplayer.dll")]
		static extern void bacon_video_widget_set_logo_mode(IntPtr raw, bool logo_mode);

		[GLib.Property ("logo_mode")]
		public bool LogoMode {
			get  {
				bool raw_ret = bacon_video_widget_get_logo_mode(Handle);
				bool ret = raw_ret;
				return ret;
			}
			set  {
				bacon_video_widget_set_logo_mode(Handle, value);
			}
		}

		[DllImport("libcesarplayer.dll")]
		static extern long bacon_video_widget_get_stream_length(IntPtr raw);

		[GLib.Property ("stream_length")]
		public long StreamLength {
			get  {
				long raw_ret = bacon_video_widget_get_stream_length(Handle);
				long ret = raw_ret;
				return ret;
			}
		}

		[DllImport("libcesarplayer.dll")]
		static extern double bacon_video_widget_get_volume(IntPtr raw);

		[DllImport("libcesarplayer.dll")]
		static extern void bacon_video_widget_set_volume(IntPtr raw, double volume);

		[GLib.Property ("volume")]
		public double Volume {
			get  {
				double raw_ret = bacon_video_widget_get_volume(Handle);
				double ret = raw_ret;
				return ret;
			}
			set  {
				bacon_video_widget_set_volume(Handle, value);
			}
		}

		[GLib.Property ("showcursor")]
		public bool Showcursor {
			get {
				GLib.Value val = GetProperty ("showcursor");
				bool ret = (bool) val;
				val.Dispose ();
				return ret;
			}
			set {
				GLib.Value val = new GLib.Value(value);
				SetProperty("showcursor", val);
				val.Dispose ();
			}
		}

		[GLib.Property ("playing")]
		public bool Playing {
			get {
				GLib.Value val = GetProperty ("playing");
				bool ret = (bool) val;
				val.Dispose ();
				return ret;
			}
		}

		[DllImport("libcesarplayer.dll")]
		static extern double bacon_video_widget_get_position(IntPtr raw);

		[GLib.Property ("position")]
		public double Position {
			get  {
				double raw_ret = bacon_video_widget_get_position(Handle);
				double ret = raw_ret;
				return ret;
			}
			set {
				this.Seek(value,1);
			}

		}

		[GLib.Property ("mediadev")]
		public string Mediadev {
			get {
				GLib.Value val = GetProperty ("mediadev");
				string ret = (string) val;
				val.Dispose ();
				return ret;
			}
			set {
				GLib.Value val = new GLib.Value(value);
				SetProperty("mediadev", val);
				val.Dispose ();
			}
		}

		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		delegate void ReadyToSeekVMDelegate (IntPtr bvw);

		static ReadyToSeekVMDelegate ReadyToSeekVMCallback;

		static void readytoseek_cb (IntPtr bvw)
		{
			try {
				GstPlayer bvw_managed = GLib.Object.GetObject (bvw, false) as GstPlayer;
				bvw_managed.OnReadyToSeek ();
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		private static void OverrideReadyToSeek (GLib.GType gtype)
		{
			if (ReadyToSeekVMCallback == null)
				ReadyToSeekVMCallback = new ReadyToSeekVMDelegate (readytoseek_cb);
			OverrideVirtualMethod (gtype, "ready_to_seek", ReadyToSeekVMCallback);
		}

		[GLib.DefaultSignalHandler(Type=typeof(LongoMatch.Video.Player.GstPlayer), ConnectionMethod="OverrideReadyToSeek")]
		protected virtual void OnReadyToSeek ()
		{
			GLib.Value ret = GLib.Value.Empty;
			GLib.ValueArray inst_and_params = new GLib.ValueArray (1);
			GLib.Value[] vals = new GLib.Value [1];
			vals [0] = new GLib.Value (this);
			inst_and_params.Append (vals [0]);
			g_signal_chain_from_overridden (inst_and_params.ArrayPtr, ref ret);
			foreach (GLib.Value v in vals)
				v.Dispose ();
		}

		[GLib.Signal("ready_to_seek")]
		public event System.EventHandler ReadyToSeek {
			add {
				GLib.Signal sig = GLib.Signal.Lookup (this, "ready_to_seek");
				sig.AddDelegate (value);
			}
			remove {
				GLib.Signal sig = GLib.Signal.Lookup (this, "ready_to_seek");
				sig.RemoveDelegate (value);
			}
		}

		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		delegate void StateChangeVMDelegate (IntPtr bvw, bool playing);

		static StateChangeVMDelegate StateChangeVMCallback;

		static void statechange_cb (IntPtr bvw, bool playing)
		{
			try {
				GstPlayer bvw_managed = GLib.Object.GetObject (bvw, false) as GstPlayer;
				bvw_managed.OnStateChange (playing);
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		private static void OverrideStateChange (GLib.GType gtype)
		{
			if (StateChangeVMCallback == null)
				StateChangeVMCallback = new StateChangeVMDelegate (statechange_cb);
			OverrideVirtualMethod (gtype, "state_change", StateChangeVMCallback);
		}

		[GLib.DefaultSignalHandler(Type=typeof(LongoMatch.Video.Player.GstPlayer), ConnectionMethod="OverrideStateChange")]
		protected virtual void OnStateChange (bool playing)
		{
			GLib.Value ret = GLib.Value.Empty;
			GLib.ValueArray inst_and_params = new GLib.ValueArray (2);
			GLib.Value[] vals = new GLib.Value [2];
			vals [0] = new GLib.Value (this);
			inst_and_params.Append (vals [0]);
			vals [1] = new GLib.Value (playing);
			inst_and_params.Append (vals [1]);
			g_signal_chain_from_overridden (inst_and_params.ArrayPtr, ref ret);
			foreach (GLib.Value v in vals)
				v.Dispose ();
		}

		[GLib.Signal("state_change")]
		public event LongoMatch.Video.Handlers.StateChangeHandler StateChange {
			add {
				GLib.Signal sig = GLib.Signal.Lookup (this, "state_change", typeof (LongoMatch.Video.Handlers.StateChangeArgs));
				sig.AddDelegate (value);
			}
			remove {
				GLib.Signal sig = GLib.Signal.Lookup (this, "state_change", typeof (LongoMatch.Video.Handlers.StateChangeArgs));
				sig.RemoveDelegate (value);
			}
		}

		/*[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		delegate void GotRedirectVMDelegate (IntPtr bvw, IntPtr mrl);

		static GotRedirectVMDelegate GotRedirectVMCallback;

		static void gotredirect_cb (IntPtr bvw, IntPtr mrl)
		{
			try {
				GstPlayer bvw_managed = GLib.Object.GetObject (bvw, false) as GstPlayer;
				bvw_managed.OnGotRedirect (GLib.Marshaller.Utf8PtrToString (mrl));
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		private static void OverrideGotRedirect (GLib.GType gtype)
		{
			if (GotRedirectVMCallback == null)
				GotRedirectVMCallback = new GotRedirectVMDelegate (gotredirect_cb);
			OverrideVirtualMethod (gtype, "got-redirect", GotRedirectVMCallback);
		}

		[GLib.DefaultSignalHandler(Type=typeof(LongoMatch.Video.Player.GstPlayer), ConnectionMethod="OverrideGotRedirect")]
		protected virtual void OnGotRedirect (string mrl)
		{
			GLib.Value ret = GLib.Value.Empty;
			GLib.ValueArray inst_and_params = new GLib.ValueArray (2);
			GLib.Value[] vals = new GLib.Value [2];
			vals [0] = new GLib.Value (this);
			inst_and_params.Append (vals [0]);
			vals [1] = new GLib.Value (mrl);
			inst_and_params.Append (vals [1]);
			g_signal_chain_from_overridden (inst_and_params.ArrayPtr, ref ret);
			foreach (GLib.Value v in vals)
				v.Dispose ();
		}

		[GLib.Signal("got-redirect")]
		public event LongoMatch.Video.Handlers.GotRedirectHandler GotRedirect {
			add {
				GLib.Signal sig = GLib.Signal.Lookup (this, "got-redirect", typeof (LongoMatch.GotRedirectArgs));
				sig.AddDelegate (value);
			}
			remove {
				GLib.Signal sig = GLib.Signal.Lookup (this, "got-redirect", typeof (LongoMatch.GotRedirectArgs));
				sig.RemoveDelegate (value);
			}
		}*/

		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		delegate void SegmentDoneVMDelegate (IntPtr bvw);

		static SegmentDoneVMDelegate SegmentDoneVMCallback;

		static void segmentdone_cb (IntPtr bvw)
		{
			try {
				GstPlayer bvw_managed = GLib.Object.GetObject (bvw, false) as GstPlayer;
				bvw_managed.OnSegmentDone ();
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		private static void OverrideSegmentDone (GLib.GType gtype)
		{
			if (SegmentDoneVMCallback == null)
				SegmentDoneVMCallback = new SegmentDoneVMDelegate (segmentdone_cb);
			OverrideVirtualMethod (gtype, "segment_done", SegmentDoneVMCallback);
		}

		[GLib.DefaultSignalHandler(Type=typeof(LongoMatch.Video.Player.GstPlayer), ConnectionMethod="OverrideSegmentDone")]
		protected virtual void OnSegmentDone ()
		{
			GLib.Value ret = GLib.Value.Empty;
			GLib.ValueArray inst_and_params = new GLib.ValueArray (1);
			GLib.Value[] vals = new GLib.Value [1];
			vals [0] = new GLib.Value (this);
			inst_and_params.Append (vals [0]);
			g_signal_chain_from_overridden (inst_and_params.ArrayPtr, ref ret);
			foreach (GLib.Value v in vals)
				v.Dispose ();
		}

		[GLib.Signal("segment_done")]
		public event System.EventHandler SegmentDone {
			add {
				GLib.Signal sig = GLib.Signal.Lookup (this, "segment_done");
				sig.AddDelegate (value);
			}
			remove {
				GLib.Signal sig = GLib.Signal.Lookup (this, "segment_done");
				sig.RemoveDelegate (value);
			}
		}

		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		delegate void EosVMDelegate (IntPtr bvw);

		static EosVMDelegate EosVMCallback;

		static void eos_cb (IntPtr bvw)
		{
			try {
				GstPlayer bvw_managed = GLib.Object.GetObject (bvw, false) as GstPlayer;
				bvw_managed.OnEos ();
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		private static void OverrideEos (GLib.GType gtype)
		{
			if (EosVMCallback == null)
				EosVMCallback = new EosVMDelegate (eos_cb);
			OverrideVirtualMethod (gtype, "eos", EosVMCallback);
		}

		[GLib.DefaultSignalHandler(Type=typeof(LongoMatch.Video.Player.GstPlayer), ConnectionMethod="OverrideEos")]
		protected virtual void OnEos ()
		{
			GLib.Value ret = GLib.Value.Empty;
			GLib.ValueArray inst_and_params = new GLib.ValueArray (1);
			GLib.Value[] vals = new GLib.Value [1];
			vals [0] = new GLib.Value (this);
			inst_and_params.Append (vals [0]);
			g_signal_chain_from_overridden (inst_and_params.ArrayPtr, ref ret);
			foreach (GLib.Value v in vals)
				v.Dispose ();
		}

		[GLib.Signal("eos")]
		public event System.EventHandler Eos {
			add {
				GLib.Signal sig = GLib.Signal.Lookup (this, "eos");
				sig.AddDelegate (value);
			}
			remove {
				GLib.Signal sig = GLib.Signal.Lookup (this, "eos");
				sig.RemoveDelegate (value);
			}
		}

		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		delegate void ErrorVMDelegate (IntPtr bvw, IntPtr message);

		static ErrorVMDelegate ErrorVMCallback;

		static void error_cb (IntPtr bvw, IntPtr message)
		{
			try {
				GstPlayer bvw_managed = GLib.Object.GetObject (bvw, false) as GstPlayer;
				bvw_managed.OnError (GLib.Marshaller.Utf8PtrToString (message));
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		private static void OverrideError (GLib.GType gtype)
		{
			if (ErrorVMCallback == null)
				ErrorVMCallback = new ErrorVMDelegate (error_cb);
			OverrideVirtualMethod (gtype, "error", ErrorVMCallback);
		}

		[GLib.DefaultSignalHandler(Type=typeof(LongoMatch.Video.Player.GstPlayer), ConnectionMethod="OverrideError")]
		protected virtual void OnError (string message)
		{
			GLib.Value ret = GLib.Value.Empty;
			GLib.ValueArray inst_and_params = new GLib.ValueArray (2);
			GLib.Value[] vals = new GLib.Value [2];
			vals [0] = new GLib.Value (this);
			inst_and_params.Append (vals [0]);
			vals [1] = new GLib.Value (message);
			inst_and_params.Append (vals [1]);
			g_signal_chain_from_overridden (inst_and_params.ArrayPtr, ref ret);
			foreach (GLib.Value v in vals)
				v.Dispose ();
		}

		[GLib.Signal("error")]
		public event LongoMatch.Video.Handlers.ErrorHandler Error {
			add {
				GLib.Signal sig = GLib.Signal.Lookup (this, "error", typeof (LongoMatch.Video.Handlers.ErrorArgs));
				sig.AddDelegate (value);
			}
			remove {
				GLib.Signal sig = GLib.Signal.Lookup (this, "error", typeof (LongoMatch.Video.Handlers.ErrorArgs));
				sig.RemoveDelegate (value);
			}
		}

		/*[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		delegate void BufferingVMDelegate (IntPtr bvw, uint progress);

		static BufferingVMDelegate BufferingVMCallback;

		static void buffering_cb (IntPtr bvw, uint progress)
		{
			try {
				GstPlayer bvw_managed = GLib.Object.GetObject (bvw, false) as GstPlayer;
				bvw_managed.OnBuffering (progress);
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		private static void OverrideBuffering (GLib.GType gtype)
		{
			if (BufferingVMCallback == null)
				BufferingVMCallback = new BufferingVMDelegate (buffering_cb);
			OverrideVirtualMethod (gtype, "buffering", BufferingVMCallback);
		}

		[GLib.DefaultSignalHandler(Type=typeof(LongoMatch.Video.Player.GstPlayer), ConnectionMethod="OverrideBuffering")]
		protected virtual void OnBuffering (uint progress)
		{
			GLib.Value ret = GLib.Value.Empty;
			GLib.ValueArray inst_and_params = new GLib.ValueArray (2);
			GLib.Value[] vals = new GLib.Value [2];
			vals [0] = new GLib.Value (this);
			inst_and_params.Append (vals [0]);
			vals [1] = new GLib.Value (progress);
			inst_and_params.Append (vals [1]);
			g_signal_chain_from_overridden (inst_and_params.ArrayPtr, ref ret);
			foreach (GLib.Value v in vals)
				v.Dispose ();
		}

		[GLib.Signal("buffering")]
		public event LongoMatch.BufferingHandler Buffering {
			add {
				GLib.Signal sig = GLib.Signal.Lookup (this, "buffering", typeof (LongoMatch.BufferingArgs));
				sig.AddDelegate (value);
			}
			remove {
				GLib.Signal sig = GLib.Signal.Lookup (this, "buffering", typeof (LongoMatch.BufferingArgs));
				sig.RemoveDelegate (value);
			}
		}*/

		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		delegate void ChannelsChangeVMDelegate (IntPtr bvw);

		static ChannelsChangeVMDelegate ChannelsChangeVMCallback;

		static void channelschange_cb (IntPtr bvw)
		{
			try {
				GstPlayer bvw_managed = GLib.Object.GetObject (bvw, false) as GstPlayer;
				bvw_managed.OnChannelsChange ();
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		private static void OverrideChannelsChange (GLib.GType gtype)
		{
			if (ChannelsChangeVMCallback == null)
				ChannelsChangeVMCallback = new ChannelsChangeVMDelegate (channelschange_cb);
			OverrideVirtualMethod (gtype, "channels-change", ChannelsChangeVMCallback);
		}

		[GLib.DefaultSignalHandler(Type=typeof(LongoMatch.Video.Player.GstPlayer), ConnectionMethod="OverrideChannelsChange")]
		protected virtual void OnChannelsChange ()
		{
			GLib.Value ret = GLib.Value.Empty;
			GLib.ValueArray inst_and_params = new GLib.ValueArray (1);
			GLib.Value[] vals = new GLib.Value [1];
			vals [0] = new GLib.Value (this);
			inst_and_params.Append (vals [0]);
			g_signal_chain_from_overridden (inst_and_params.ArrayPtr, ref ret);
			foreach (GLib.Value v in vals)
				v.Dispose ();
		}

		[GLib.Signal("channels-change")]
		public event System.EventHandler ChannelsChange {
			add {
				GLib.Signal sig = GLib.Signal.Lookup (this, "channels-change");
				sig.AddDelegate (value);
			}
			remove {
				GLib.Signal sig = GLib.Signal.Lookup (this, "channels-change");
				sig.RemoveDelegate (value);
			}
		}

		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		delegate void GotMetadataVMDelegate (IntPtr bvw);

		static GotMetadataVMDelegate GotMetadataVMCallback;

		static void gotmetadata_cb (IntPtr bvw)
		{
			try {
				GstPlayer bvw_managed = GLib.Object.GetObject (bvw, false) as GstPlayer;
				bvw_managed.OnGotMetadata ();
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		private static void OverrideGotMetadata (GLib.GType gtype)
		{
			if (GotMetadataVMCallback == null)
				GotMetadataVMCallback = new GotMetadataVMDelegate (gotmetadata_cb);
			OverrideVirtualMethod (gtype, "got-metadata", GotMetadataVMCallback);
		}

		[GLib.DefaultSignalHandler(Type=typeof(LongoMatch.Video.Player.GstPlayer), ConnectionMethod="OverrideGotMetadata")]
		protected virtual void OnGotMetadata ()
		{
			GLib.Value ret = GLib.Value.Empty;
			GLib.ValueArray inst_and_params = new GLib.ValueArray (1);
			GLib.Value[] vals = new GLib.Value [1];
			vals [0] = new GLib.Value (this);
			inst_and_params.Append (vals [0]);
			g_signal_chain_from_overridden (inst_and_params.ArrayPtr, ref ret);
			foreach (GLib.Value v in vals)
				v.Dispose ();
		}

		[GLib.Signal("got-metadata")]
		public event System.EventHandler GotMetadata {
			add {
				GLib.Signal sig = GLib.Signal.Lookup (this, "got-metadata");
				sig.AddDelegate (value);
			}
			remove {
				GLib.Signal sig = GLib.Signal.Lookup (this, "got-metadata");
				sig.RemoveDelegate (value);
			}
		}

		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		delegate void TickVMDelegate (IntPtr bvw, long current_time, long stream_length, float current_position, bool seekable);

		static TickVMDelegate TickVMCallback;

		static void tick_cb (IntPtr bvw, long current_time, long stream_length, float current_position, bool seekable)
		{
			try {
				GstPlayer bvw_managed = GLib.Object.GetObject (bvw, false) as GstPlayer;
				bvw_managed.OnTick (current_time, stream_length, current_position, seekable);
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		private static void OverrideTick (GLib.GType gtype)
		{
			if (TickVMCallback == null)
				TickVMCallback = new TickVMDelegate (tick_cb);
			OverrideVirtualMethod (gtype, "tick", TickVMCallback);
		}

		[GLib.DefaultSignalHandler(Type=typeof(LongoMatch.Video.Player.GstPlayer), ConnectionMethod="OverrideTick")]
		protected virtual void OnTick (long current_time, long stream_length, float current_position, bool seekable)
		{
			GLib.Value ret = GLib.Value.Empty;
			GLib.ValueArray inst_and_params = new GLib.ValueArray (5);
			GLib.Value[] vals = new GLib.Value [5];
			vals [0] = new GLib.Value (this);
			inst_and_params.Append (vals [0]);
			vals [1] = new GLib.Value (current_time);
			inst_and_params.Append (vals [1]);
			vals [2] = new GLib.Value (stream_length);
			inst_and_params.Append (vals [2]);
			vals [3] = new GLib.Value (current_position);
			inst_and_params.Append (vals [3]);
			vals [4] = new GLib.Value (seekable);
			inst_and_params.Append (vals [4]);
			g_signal_chain_from_overridden (inst_and_params.ArrayPtr, ref ret);
			foreach (GLib.Value v in vals)
				v.Dispose ();
		}

		[GLib.Signal("tick")]
		public event LongoMatch.Video.Handlers.TickHandler Tick {
			add {
				GLib.Signal sig = GLib.Signal.Lookup (this, "tick", typeof (LongoMatch.Video.Handlers.TickArgs));
				sig.AddDelegate (value);
			}
			remove {
				GLib.Signal sig = GLib.Signal.Lookup (this, "tick", typeof (LongoMatch.Video.Handlers.TickArgs));
				sig.RemoveDelegate (value);
			}
		}

		/*[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		delegate void TitleChangeVMDelegate (IntPtr bvw, IntPtr title);

		static TitleChangeVMDelegate TitleChangeVMCallback;

		static void titlechange_cb (IntPtr bvw, IntPtr title)
		{
			try {
				GstPlayer bvw_managed = GLib.Object.GetObject (bvw, false) as GstPlayer;
				bvw_managed.OnTitleChange (GLib.Marshaller.Utf8PtrToString (title));
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		private static void OverrideTitleChange (GLib.GType gtype)
		{
			if (TitleChangeVMCallback == null)
				TitleChangeVMCallback = new TitleChangeVMDelegate (titlechange_cb);
			OverrideVirtualMethod (gtype, "title-change", TitleChangeVMCallback);
		}

		[GLib.DefaultSignalHandler(Type=typeof(LongoMatch.Video.Player.GstPlayer), ConnectionMethod="OverrideTitleChange")]
		protected virtual void OnTitleChange (string title)
		{
			GLib.Value ret = GLib.Value.Empty;
			GLib.ValueArray inst_and_params = new GLib.ValueArray (2);
			GLib.Value[] vals = new GLib.Value [2];
			vals [0] = new GLib.Value (this);
			inst_and_params.Append (vals [0]);
			vals [1] = new GLib.Value (title);
			inst_and_params.Append (vals [1]);
			g_signal_chain_from_overridden (inst_and_params.ArrayPtr, ref ret);
			foreach (GLib.Value v in vals)
				v.Dispose ();
		}

		[GLib.Signal("title-change")]
		public event LongoMatch.Video.Handlers.TitleChangeHandler TitleChange {
			add {
				GLib.Signal sig = GLib.Signal.Lookup (this, "title-change", typeof (LongoMatch.TitleChangeArgs));
				sig.AddDelegate (value);
			}
			remove {
				GLib.Signal sig = GLib.Signal.Lookup (this, "title-change", typeof (LongoMatch.TitleChangeArgs));
				sig.RemoveDelegate (value);
			}
		}*/

		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		delegate void GotDurationVMDelegate (IntPtr bvw);

		static GotDurationVMDelegate GotDurationVMCallback;

		static void gotduration_cb (IntPtr bvw)
		{
			try {
				GstPlayer bvw_managed = GLib.Object.GetObject (bvw, false) as GstPlayer;
				bvw_managed.OnGotDuration ();
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		private static void OverrideGotDuration (GLib.GType gtype)
		{
			if (GotDurationVMCallback == null)
				GotDurationVMCallback = new GotDurationVMDelegate (gotduration_cb);
			OverrideVirtualMethod (gtype, "got_duration", GotDurationVMCallback);
		}

		[GLib.DefaultSignalHandler(Type=typeof(LongoMatch.Video.Player.GstPlayer), ConnectionMethod="OverrideGotDuration")]
		protected virtual void OnGotDuration ()
		{
			GLib.Value ret = GLib.Value.Empty;
			GLib.ValueArray inst_and_params = new GLib.ValueArray (1);
			GLib.Value[] vals = new GLib.Value [1];
			vals [0] = new GLib.Value (this);
			inst_and_params.Append (vals [0]);
			g_signal_chain_from_overridden (inst_and_params.ArrayPtr, ref ret);
			foreach (GLib.Value v in vals)
				v.Dispose ();
		}

		[GLib.Signal("got_duration")]
		public event System.EventHandler GotDuration {
			add {
				GLib.Signal sig = GLib.Signal.Lookup (this, "got_duration");
				sig.AddDelegate (value);
			}
			remove {
				GLib.Signal sig = GLib.Signal.Lookup (this, "got_duration");
				sig.RemoveDelegate (value);
			}
		}

		[DllImport("libcesarplayer.dll")]
		static extern IntPtr bacon_video_widget_get_backend_name(IntPtr raw);

		public string BackendName { 
			get {
				IntPtr raw_ret = bacon_video_widget_get_backend_name(Handle);
				string ret = GLib.Marshaller.PtrToStringGFree(raw_ret);
				return ret;
			}
		}

		[DllImport("libcesarplayer.dll")]
		static extern bool bacon_video_widget_set_rate(IntPtr raw, float rate);

		public bool SetRate(float rate) {
			bool raw_ret = bacon_video_widget_set_rate(Handle, rate);
			bool ret = raw_ret;
			return ret;
		}

		[DllImport("libcesarplayer.dll")]
		static extern bool bacon_video_widget_is_playing(IntPtr raw);

		public bool IsPlaying { 
			get {
				bool raw_ret = bacon_video_widget_is_playing(Handle);
				bool ret = raw_ret;
				return ret;
			}
		}

		[DllImport("libcesarplayer.dll")]
		static extern bool bacon_video_widget_get_auto_resize(IntPtr raw);

		[DllImport("libcesarplayer.dll")]
		static extern void bacon_video_widget_set_auto_resize(IntPtr raw, bool auto_resize);

		public bool AutoResize { 
			get {
				bool raw_ret = bacon_video_widget_get_auto_resize(Handle);
				bool ret = raw_ret;
				return ret;
			}
			set {
				bacon_video_widget_set_auto_resize(Handle, value);
			}
		}

		[DllImport("libcesarplayer.dll")]
		static extern bool bacon_video_widget_seek(IntPtr raw, double position, float rate);

		public bool Seek(double position, float rate) {
			bool raw_ret = bacon_video_widget_seek(Handle, position, rate);
			bool ret = raw_ret;
			return ret;
		}

		[DllImport("libcesarplayer.dll")]
		static extern bool bacon_video_widget_get_show_cursor(IntPtr raw);

		[DllImport("libcesarplayer.dll")]
		static extern void bacon_video_widget_set_show_cursor(IntPtr raw, bool show_cursor);

		public bool ShowCursor { 
			get {
				bool raw_ret = bacon_video_widget_get_show_cursor(Handle);
				bool ret = raw_ret;
				return ret;
			}
			set {
				bacon_video_widget_set_show_cursor(Handle, value);
			}
		}

		[DllImport("libcesarplayer.dll")]
		static extern void bacon_video_widget_init_backend(out int argc, IntPtr argv);

		public static int InitBackend(string argv) {
			int argc;
			bacon_video_widget_init_backend(out argc, GLib.Marshaller.StringToPtrGStrdup(argv));
			return argc;
		}

		[DllImport("libcesarplayer.dll")]
		static extern void bacon_video_widget_pause(IntPtr raw);

		public void Pause() {
			bacon_video_widget_pause(Handle);
		}

		[DllImport("libcesarplayer.dll")]
		static extern double bacon_video_widget_get_zoom(IntPtr raw);

		[DllImport("libcesarplayer.dll")]
		static extern void bacon_video_widget_set_zoom(IntPtr raw, double zoom);

		public double Zoom { 
			get {
				double raw_ret = bacon_video_widget_get_zoom(Handle);
				double ret = raw_ret;
				return ret;
			}
			set {
				bacon_video_widget_set_zoom(Handle, value);
			}
		}

		[DllImport("libcesarplayer.dll")]
		static extern bool bacon_video_widget_seek_in_segment(IntPtr raw, long pos, float rate);

		public bool SeekInSegment(long pos, float rate) {
			bool raw_ret = bacon_video_widget_seek_in_segment(Handle, pos, rate);
			bool ret = raw_ret;
			return ret;
		}

		[DllImport("libcesarplayer.dll")]
		static extern bool bacon_video_widget_segment_seek(IntPtr raw, long start, long stop, float rate);

		public bool SegmentSeek(long start, long stop, float rate) {
			bool raw_ret = bacon_video_widget_segment_seek(Handle, start, stop, rate);
			bool ret = raw_ret;
			return ret;
		}

		[DllImport("libcesarplayer.dll")]
		static extern void bacon_video_widget_stop(IntPtr raw);

		public void Stop() {
			bacon_video_widget_stop(Handle);
		}

		[DllImport("libcesarplayer.dll")]
		static extern bool bacon_video_widget_has_next_track(IntPtr raw);

		public bool HasNextTrack { 
			get {
				bool raw_ret = bacon_video_widget_has_next_track(Handle);
				bool ret = raw_ret;
				return ret;
			}
		}

		[DllImport("libcesarplayer.dll")]
		static extern void bacon_video_widget_set_subtitle_font(IntPtr raw, IntPtr font);

		public string SubtitleFont { 
			set {
				IntPtr native_value = GLib.Marshaller.StringToPtrGStrdup (value);
				bacon_video_widget_set_subtitle_font(Handle, native_value);
				GLib.Marshaller.Free (native_value);
			}
		}

		[DllImport("libcesarplayer.dll")]
		static extern bool bacon_video_widget_set_visuals(IntPtr raw, IntPtr name);

		public bool SetVisuals(string name) {
			IntPtr native_name = GLib.Marshaller.StringToPtrGStrdup (name);
			bool raw_ret = bacon_video_widget_set_visuals(Handle, native_name);
			bool ret = raw_ret;
			GLib.Marshaller.Free (native_name);
			return ret;
		}

		[DllImport("libcesarplayer.dll")]
		static extern long bacon_video_widget_get_accurate_current_time(IntPtr raw);

		public long AccurateCurrentTime { 
			get {
				long raw_ret = bacon_video_widget_get_accurate_current_time(Handle);
				long ret = raw_ret;
				return ret;
			}
		}

		[DllImport("libcesarplayer.dll")]
		static extern int bacon_video_widget_get_video_property(IntPtr raw, int type);

		public int GetVideoProperty(GstVideoProperty type) {
			int raw_ret = bacon_video_widget_get_video_property(Handle, (int) type);
			int ret = raw_ret;
			return ret;
		}

		[DllImport("libcesarplayer.dll")]
		static extern int bacon_video_widget_get_language(IntPtr raw);

		[DllImport("libcesarplayer.dll")]
		static extern void bacon_video_widget_set_language(IntPtr raw, int language);

		public int Language { 
			get {
				int raw_ret = bacon_video_widget_get_language(Handle);
				int ret = raw_ret;
				return ret;
			}
			set {
				bacon_video_widget_set_language(Handle, value);
			}
		}

		[DllImport("libcesarplayer.dll")]
		static extern bool bacon_video_widget_seek_time(IntPtr raw, long time, float rate, bool accurate);

		public bool SeekTime(long time, float rate, bool accurate) {
			bool raw_ret = bacon_video_widget_seek_time(Handle, time, rate, accurate);
			bool ret = raw_ret;
			return ret;
		}

		[DllImport("libcesarplayer.dll")]
		static extern bool bacon_video_widget_is_seekable(IntPtr raw);

		public bool IsSeekable { 
			get {
				bool raw_ret = bacon_video_widget_is_seekable(Handle);
				bool ret = raw_ret;
				return ret;
			}
		}

		[DllImport("libcesarplayer.dll")]
		static extern unsafe bool bacon_video_widget_can_get_frames(IntPtr raw, out IntPtr error);

		public unsafe bool CanGetFrames() {
			IntPtr error = IntPtr.Zero;
			bool raw_ret = bacon_video_widget_can_get_frames(Handle, out error);
			bool ret = raw_ret;
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("libcesarplayer.dll")]
		static extern long bacon_video_widget_get_current_time(IntPtr raw);

		public long CurrentTime { 
			get {
				long raw_ret = bacon_video_widget_get_current_time(Handle);
				long ret = raw_ret;
				return ret;
			}
		}

		[DllImport("libcesarplayer.dll")]
		static extern bool bacon_video_widget_seek_to_previous_frame(IntPtr raw, float rate, bool in_segment);

		public bool SeekToPreviousFrame(float rate, bool in_segment) {
			bool raw_ret = bacon_video_widget_seek_to_previous_frame(Handle, rate, in_segment);
			bool ret = raw_ret;
			return ret;
		}

		[DllImport("libcesarplayer.dll")]
		static extern IntPtr bacon_video_widget_get_type();

		public static new GLib.GType GType { 
			get {
				IntPtr raw_ret = bacon_video_widget_get_type();
				GLib.GType ret = new GLib.GType(raw_ret);
				return ret;
			}
		}

		[DllImport("libcesarplayer.dll")]
		static extern IntPtr bacon_video_widget_get_languages(IntPtr raw);

		public GLib.List Languages { 
			get {
				IntPtr raw_ret = bacon_video_widget_get_languages(Handle);
				GLib.List ret = new GLib.List(raw_ret);
				return ret;
			}
		}

		[DllImport("libcesarplayer.dll")]
		static extern void bacon_video_widget_set_fullscreen(IntPtr raw, bool fullscreen);

		public bool Fullscreen { 
			set {
				bacon_video_widget_set_fullscreen(Handle, value);
			}
		}

		[DllImport("libcesarplayer.dll")]
		static extern bool bacon_video_widget_set_audio_out_type(IntPtr raw, int type);

		public bool SetAudioOutType(GstAudioOutType type) {
			bool raw_ret = bacon_video_widget_set_audio_out_type(Handle, (int) type);
			bool ret = raw_ret;
			return ret;
		}

		[DllImport("libcesarplayer.dll")]
		static extern void bacon_video_widget_dvd_event(IntPtr raw, int type);

		public void DvdEvent(GstDVDEvent type) {
			bacon_video_widget_dvd_event(Handle, (int) type);
		}

		[DllImport("libcesarplayer.dll")]
		static extern bool bacon_video_widget_has_previous_track(IntPtr raw);

		public bool HasPreviousTrack { 
			get {
				bool raw_ret = bacon_video_widget_has_previous_track(Handle);
				bool ret = raw_ret;
				return ret;
			}
		}

		[DllImport("libcesarplayer.dll")]
		static extern void bacon_video_widget_set_logo_pixbuf(IntPtr raw, IntPtr logo);

		public Gdk.Pixbuf LogoPixbuf { 
			set {
				bacon_video_widget_set_logo_pixbuf(Handle, value == null ? IntPtr.Zero : value.Handle);
			}
		}

		/*[DllImport("libcesarplayer.dll")]
		static extern void bacon_video_widget_set_visuals_quality(IntPtr raw, int quality);

		public GstVisualsQuality VisualsQuality { 
			set {
				bacon_video_widget_set_visuals_quality(Handle, (int) value);
			}
		}*/

		[DllImport("libcesarplayer.dll")]
		static extern int bacon_video_widget_get_connection_speed(IntPtr raw);

		[DllImport("libcesarplayer.dll")]
		static extern void bacon_video_widget_set_connection_speed(IntPtr raw, int speed);

		public int ConnectionSpeed { 
			get {
				int raw_ret = bacon_video_widget_get_connection_speed(Handle);
				int ret = raw_ret;
				return ret;
			}
			set {
				bacon_video_widget_set_connection_speed(Handle, value);
			}
		}

		[DllImport("libcesarplayer.dll")]
		static extern IntPtr bacon_video_widget_get_subtitles(IntPtr raw);

		public GLib.List Subtitles { 
			get {
				IntPtr raw_ret = bacon_video_widget_get_subtitles(Handle);
				GLib.List ret = new GLib.List(raw_ret);
				return ret;
			}
		}

		[DllImport("libcesarplayer.dll")]
		static extern IntPtr bacon_video_widget_get_current_frame(IntPtr raw);
		
		[DllImport("libcesarplayer.dll")]
		static extern IntPtr bacon_video_widget_unref_pixbuf(IntPtr raw);


		public Gdk.Pixbuf GetCurrentFrame(int outwidth, int outheight) { 
			IntPtr raw_ret = bacon_video_widget_get_current_frame(Handle);
			Gdk.Pixbuf unmanaged = GLib.Object.GetObject(raw_ret) as Gdk.Pixbuf;
			Gdk.Pixbuf managed;
			int h = unmanaged.Height;
			int w = unmanaged.Width;
			double rate = (double)w/(double)h;
			if (outwidth == -1 || outheight == -1){
				outwidth = w;
				outheight = h;
			}else if (h>w){
				outwidth = (int)(outheight*rate);
			}else{
				outheight = (int)(outwidth/rate);
			}
			managed = unmanaged.ScaleSimple(outwidth,outheight,Gdk.InterpType.Bilinear);
			unmanaged.Dispose();
			bacon_video_widget_unref_pixbuf(raw_ret);
			return managed;
		}
		
		public Gdk.Pixbuf GetCurrentFrame() { 
			return GetCurrentFrame(-1,-1);
		}

		[DllImport("libcesarplayer.dll")]
		static extern IntPtr bacon_video_widget_get_visuals_list(IntPtr raw);

		public GLib.List VisualsList { 
			get {
				IntPtr raw_ret = bacon_video_widget_get_visuals_list(Handle);
				GLib.List ret = new GLib.List(raw_ret);
				return ret;
			}
		}

		[DllImport("libcesarplayer.dll")]
		static extern bool bacon_video_widget_segment_stop_update(IntPtr raw, long stop, float rate);

		public bool SegmentStopUpdate(long stop, float rate) {
			bool raw_ret = bacon_video_widget_segment_stop_update(Handle, stop, rate);
			bool ret = raw_ret;
			return ret;
		}

		[DllImport("libcesarplayer.dll")]
		static extern void bacon_video_widget_set_subtitle_encoding(IntPtr raw, IntPtr encoding);

		public string SubtitleEncoding { 
			set {
				IntPtr native_value = GLib.Marshaller.StringToPtrGStrdup (value);
				bacon_video_widget_set_subtitle_encoding(Handle, native_value);
				GLib.Marshaller.Free (native_value);
			}
		}

		[DllImport("libcesarplayer.dll")]
		static extern void bacon_video_widget_set_aspect_ratio(IntPtr raw, int ratio);

		public LongoMatch.BvwAspectRatio AspectRatio { 
			set {
				bacon_video_widget_set_aspect_ratio(Handle, (int) value);
			}
		}

		[DllImport("libcesarplayer.dll")]
		static extern void bacon_video_widget_set_video_property(IntPtr raw, int type, int value);

		public void SetVideoProperty(GstVideoProperty type, int value) {
			bacon_video_widget_set_video_property(Handle, (int) type, value);
		}

		[DllImport("libcesarplayer.dll")]
		static extern bool bacon_video_widget_get_deinterlacing(IntPtr raw);

		[DllImport("libcesarplayer.dll")]
		static extern void bacon_video_widget_set_deinterlacing(IntPtr raw, bool deinterlace);

		public bool Deinterlacing { 
			get {
				bool raw_ret = bacon_video_widget_get_deinterlacing(Handle);
				bool ret = raw_ret;
				return ret;
			}
			set {
				bacon_video_widget_set_deinterlacing(Handle, value);
			}
		}

		[DllImport("libcesarplayer.dll")]
		static extern bool bacon_video_widget_set_rate_in_segment(IntPtr raw, float rate, long stop);

		public bool SetRateInSegment(float rate, long stop) {
			bool raw_ret = bacon_video_widget_set_rate_in_segment(Handle, rate, stop);
			bool ret = raw_ret;
			return ret;
		}

		[DllImport("libcesarplayer.dll")]
		static extern void bacon_video_widget_get_metadata(IntPtr raw, int type, IntPtr val);

		public object GetMetadata(GstMetadataType type) {
			GLib.Value val = new GLib.Value();
			IntPtr native_value = GLib.Marshaller.StructureToPtrAlloc (val);
			bacon_video_widget_get_metadata(Handle, (int) type, native_value);
			val = (GLib.Value) Marshal.PtrToStructure (native_value, typeof (GLib.Value));
			Marshal.FreeHGlobal (native_value);
			return val.Val;
		}

		[DllImport("libcesarplayer.dll")]
		static extern bool bacon_video_widget_can_set_volume(IntPtr raw);

		public bool CanSetVolume() {
			bool raw_ret = bacon_video_widget_can_set_volume(Handle);
			bool ret = raw_ret;
			return ret;
		}

		[DllImport("libcesarplayer.dll")]
		static extern bool bacon_video_widget_can_direct_seek(IntPtr raw);

		public bool CanDirectSeek() {
			bool raw_ret = bacon_video_widget_can_direct_seek(Handle);
			bool ret = raw_ret;
			return ret;
		}

		[DllImport("libcesarplayer.dll")]
		static extern void bacon_video_widget_close(IntPtr raw);

		public void Close() {
			bacon_video_widget_close(Handle);
		}

		[DllImport("libcesarplayer.dll")]
		static extern bool bacon_video_widget_play(IntPtr raw);

		public bool Play() {
			bool raw_ret = bacon_video_widget_play(Handle);
			bool ret = raw_ret;
			return ret;
		}

		[DllImport("libcesarplayer.dll")]
		static extern int bacon_video_widget_get_subtitle(IntPtr raw);

		[DllImport("libcesarplayer.dll")]
		static extern void bacon_video_widget_set_subtitle(IntPtr raw, int subtitle);

		public int Subtitle { 
			get {
				int raw_ret = bacon_video_widget_get_subtitle(Handle);
				int ret = raw_ret;
				return ret;
			}
			set {
				bacon_video_widget_set_subtitle(Handle, value);
			}
		}

		[DllImport("libcesarplayer.dll")]
		static extern int bacon_video_widget_error_quark();

		public static int ErrorQuark() {
			int raw_ret = bacon_video_widget_error_quark();
			int ret = raw_ret;
			return ret;
		}

		[DllImport("libcesarplayer.dll")]
		static extern unsafe bool bacon_video_widget_open(IntPtr raw, IntPtr mrl, IntPtr subtitle_uri, out IntPtr error);

		public unsafe bool Open(string mrl, string subtitle_uri) {
			IntPtr native_mrl = GLib.Marshaller.StringToPtrGStrdup (mrl);
			IntPtr native_subtitle_uri = GLib.Marshaller.StringToPtrGStrdup (subtitle_uri);
			IntPtr error = IntPtr.Zero;
			bool raw_ret = bacon_video_widget_open(Handle, native_mrl, native_subtitle_uri, out error);
			bool ret = raw_ret;
			GLib.Marshaller.Free (native_mrl);
			GLib.Marshaller.Free (native_subtitle_uri);
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}
		
		[DllImport("libcesarplayer.dll")]
		static extern bool bacon_video_widget_new_file_seek(IntPtr raw, long start,long stop,float rate);

		public bool NewFileSeek(long start, long stop,float rate) {
			bool raw_ret = bacon_video_widget_new_file_seek(Handle,start,stop,rate);
			bool ret = raw_ret;
			return ret;
		}


		[DllImport("libcesarplayer.dll")]
		static extern bool bacon_video_widget_segment_start_update(IntPtr raw, long start, float rate);

		public bool SegmentStartUpdate(long start, float rate) {
			bool raw_ret = bacon_video_widget_segment_start_update(Handle, start, rate);
			bool ret = raw_ret;
			return ret;
		}

		[DllImport("libcesarplayer.dll")]
		static extern bool bacon_video_widget_can_deinterlace(IntPtr raw);

		public bool CanDeinterlace() {
			bool raw_ret = bacon_video_widget_can_deinterlace(Handle);
			bool ret = raw_ret;
			return ret;
		}

		[DllImport("libcesarplayer.dll")]
		static extern void bacon_video_widget_set_show_visuals(IntPtr raw, bool show_visuals);

		public bool ShowVisuals { 
			set {
				bacon_video_widget_set_show_visuals(Handle, value);
			}
		}

		[DllImport("libcesarplayer.dll")]
		static extern void bacon_video_widget_set_logo(IntPtr raw, IntPtr filename);

		public string Logo { 
			set {
				bacon_video_widget_set_logo(Handle, GLib.Marshaller.StringToPtrGStrdup(value));
			}
		}

		[DllImport("libcesarplayer.dll")]
		static extern bool bacon_video_widget_seek_to_next_frame(IntPtr raw, float rate, bool in_segment);

		public bool SeekToNextFrame(float rate, bool in_segment) {
			bool raw_ret = bacon_video_widget_seek_to_next_frame(Handle, rate, in_segment);
			bool ret = raw_ret;
			return ret;
		}

		[DllImport("libcesarplayer.dll")]
		static extern void bacon_video_widget_set_scale_ratio(IntPtr raw, float ratio);

		public float ScaleRatio { 
			set {
				bacon_video_widget_set_scale_ratio(Handle, value);
			}
		}

		static GstPlayer ()
		{
			LongoMatch.GtkSharp.Video.ObjectManager.Initialize ();
		}
#endregion
		
		public bool SeekTime(long time, bool accurate) {
			return SeekTime(time,1,accurate);
		}
		
			
		public void  TogglePlay(){			
			if(!this.Playing){
				this.Play();
			}
			else{
				 this.Pause();
			}		
		}
		
		public bool Open(string mrl){
			return Open(mrl, null);
		}
		
		public void CancelProgramedStop(){
			this.SegmentSeek(this.CurrentTime,this.StreamLength,1);		
		}
		
	}
}
