//  Copyright (C) 2007-2009 Andoni Morales Alastruey
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
//
//

namespace LongoMatch.Video.Capturer {

	using System;
	using System.Collections;
	using System.Runtime.InteropServices;

#region Autogenerated code
	public  class GstCameraCapturer : Gtk.HBox, LongoMatch.Video.Capturer.ICapturer {

		[Obsolete]
		protected GstCameraCapturer(GLib.GType gtype) : base(gtype) {}
		public GstCameraCapturer(IntPtr raw) : base(raw) {}

		[DllImport("libcesarplayer.dll")]
		static extern unsafe IntPtr gst_camera_capturer_new(IntPtr filename, out IntPtr err);

		public unsafe GstCameraCapturer (string filename) : base (IntPtr.Zero)
		{
			if (GetType () != typeof (GstCameraCapturer)) {
				throw new InvalidOperationException ("Can't override this constructor.");
			}
			IntPtr error = IntPtr.Zero;
			Raw = gst_camera_capturer_new(GLib.Marshaller.StringToPtrGStrdup(filename), out error);
			if (error != IntPtr.Zero) throw new GLib.GException (error);
		}

		[GLib.Property ("encode_height")]
		public uint EncodeHeight {
			get {
				GLib.Value val = GetProperty ("encode_height");
				uint ret = (uint) val;
				val.Dispose ();
				return ret;
			}
			set {
				GLib.Value val = new GLib.Value(value);
				SetProperty("encode_height", val);
				val.Dispose ();
			}
		}

		[GLib.Property ("encode_width")]
		public uint EncodeWidth {
			get {
				GLib.Value val = GetProperty ("encode_width");
				uint ret = (uint) val;
				val.Dispose ();
				return ret;
			}
			set {
				GLib.Value val = new GLib.Value(value);
				SetProperty("encode_width", val);
				val.Dispose ();
			}
		}

		[GLib.Property ("video_bitrate")]
		public uint VideoBitrate {
			get {
				GLib.Value val = GetProperty ("video_bitrate");
				uint ret = (uint) val;
				val.Dispose ();
				return ret;
			}
			set {
				GLib.Value val = new GLib.Value(value);
				SetProperty("video_bitrate", val);
				val.Dispose ();
			}
		}

		[GLib.Property ("output_file")]
		public string OutputFile {
			get {
				GLib.Value val = GetProperty ("output_file");
				string ret = (string) val;
				val.Dispose ();
				return ret;
			}
			set {
				GLib.Value val = new GLib.Value(value);
				SetProperty("output_file", val);
				val.Dispose ();
			}
		}

		[GLib.Property ("audio_bitrate")]
		public uint AudioBitrate {
			get {
				GLib.Value val = GetProperty ("audio_bitrate");
				uint ret = (uint) val;
				val.Dispose ();
				return ret;
			}
			set {
				GLib.Value val = new GLib.Value(value);
				SetProperty("audio_bitrate", val);
				val.Dispose ();
			}
		}

		[GLib.CDeclCallback]
		delegate void ErrorSignalDelegate (IntPtr arg0, IntPtr arg1, IntPtr gch);

		static void ErrorSignalCallback (IntPtr arg0, IntPtr arg1, IntPtr gch)
		{
			LongoMatch.Video.Capturer.ErrorArgs args = new LongoMatch.Video.Capturer.ErrorArgs ();
			try {
				GLib.Signal sig = ((GCHandle) gch).Target as GLib.Signal;
				if (sig == null)
					throw new Exception("Unknown signal GC handle received " + gch);

				args.Args = new object[1];
				args.Args[0] = GLib.Marshaller.Utf8PtrToString (arg1);
				LongoMatch.Video.Capturer.ErrorHandler handler = (LongoMatch.Video.Capturer.ErrorHandler) sig.Handler;
				handler (GLib.Object.GetObject (arg0), args);
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[GLib.CDeclCallback]
		delegate void ErrorVMDelegate (IntPtr gcc, IntPtr message);

		static ErrorVMDelegate ErrorVMCallback;

		static void error_cb (IntPtr gcc, IntPtr message)
		{
			try {
				GstCameraCapturer gcc_managed = GLib.Object.GetObject (gcc, false) as GstCameraCapturer;
				gcc_managed.OnError (GLib.Marshaller.Utf8PtrToString (message));
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		private static void OverrideError (GLib.GType gtype)
		{
			if (ErrorVMCallback == null)
				ErrorVMCallback = new ErrorVMDelegate (error_cb);
			OverrideVirtualMethod (gtype, "error", ErrorVMCallback);
		}

		[GLib.DefaultSignalHandler(Type=typeof(LongoMatch.Video.Capturer.GstCameraCapturer), ConnectionMethod="OverrideError")]
		protected virtual void OnError (string message)
		{
			GLib.Value ret = GLib.Value.Empty;
			GLib.ValueArray inst_and_params = new GLib.ValueArray (2);
			GLib.Value[] vals = new GLib.Value [2];
			vals [0] = new GLib.Value (this);
			inst_and_params.Append (vals [0]);
			vals [1] = new GLib.Value (message);
			inst_and_params.Append (vals [1]);
			g_signal_chain_from_overridden (inst_and_params.ArrayPtr, ref ret);
			foreach (GLib.Value v in vals)
				v.Dispose ();
		}

		[GLib.Signal("error")]
		public event LongoMatch.Video.Capturer.ErrorHandler Error {
			add {
				GLib.Signal sig = GLib.Signal.Lookup (this, "error", new ErrorSignalDelegate(ErrorSignalCallback));
				sig.AddDelegate (value);
			}
			remove {
				GLib.Signal sig = GLib.Signal.Lookup (this, "error", new ErrorSignalDelegate(ErrorSignalCallback));
				sig.RemoveDelegate (value);
			}
		}

		[GLib.CDeclCallback]
		delegate void EosVMDelegate (IntPtr gcc);

		static EosVMDelegate EosVMCallback;

		static void eos_cb (IntPtr gcc)
		{
			try {
				GstCameraCapturer gcc_managed = GLib.Object.GetObject (gcc, false) as GstCameraCapturer;
				gcc_managed.OnEos ();
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		private static void OverrideEos (GLib.GType gtype)
		{
			if (EosVMCallback == null)
				EosVMCallback = new EosVMDelegate (eos_cb);
			OverrideVirtualMethod (gtype, "eos", EosVMCallback);
		}

		[GLib.DefaultSignalHandler(Type=typeof(LongoMatch.Video.Capturer.GstCameraCapturer), ConnectionMethod="OverrideEos")]
		protected virtual void OnEos ()
		{
			GLib.Value ret = GLib.Value.Empty;
			GLib.ValueArray inst_and_params = new GLib.ValueArray (1);
			GLib.Value[] vals = new GLib.Value [1];
			vals [0] = new GLib.Value (this);
			inst_and_params.Append (vals [0]);
			g_signal_chain_from_overridden (inst_and_params.ArrayPtr, ref ret);
			foreach (GLib.Value v in vals)
				v.Dispose ();
		}

		[GLib.Signal("eos")]
		public event System.EventHandler Eos {
			add {
				GLib.Signal sig = GLib.Signal.Lookup (this, "eos");
				sig.AddDelegate (value);
			}
			remove {
				GLib.Signal sig = GLib.Signal.Lookup (this, "eos");
				sig.RemoveDelegate (value);
			}
		}

		[DllImport("libcesarplayer.dll")]
		static extern bool gst_camera_capturer_set_video_muxer(IntPtr raw, int type);

		public bool SetVideoMuxer(LongoMatch.Video.Capturer.GccVideoMuxerType type) {
			bool raw_ret = gst_camera_capturer_set_video_muxer(Handle, (int) type);
			bool ret = raw_ret;
			return ret;
		}

		
		[DllImport("libcesarplayer.dll")]
		static extern bool gst_camera_capturer_set_video_encoder(IntPtr raw, int type);

		public bool SetVideoEncoder(LongoMatch.Video.Capturer.GccVideoEncoderType type) {
			bool raw_ret = gst_camera_capturer_set_video_encoder(Handle, (int) type);
			bool ret = raw_ret;
			return ret;
		}

		[DllImport("libcesarplayer.dll")]
		static extern void gst_camera_capturer_init_backend(out int argc, IntPtr argv);

		public static int InitBackend(string argv) {
			int argc;
			gst_camera_capturer_init_backend(out argc, GLib.Marshaller.StringToPtrGStrdup(argv));
			return argc;
		}

		[DllImport("libcesarplayer.dll")]
		static extern void gst_camera_capturer_stop(IntPtr raw);

		public void Stop() {
			gst_camera_capturer_stop(Handle);
		}

	
		[DllImport("libcesarplayer.dll")]
		static extern void gst_camera_capturer_toggle_pause(IntPtr raw);

		public void TogglePause() {
			gst_camera_capturer_toggle_pause(Handle);
		}
		
		[DllImport("libcesarplayer.dll")]
		static extern void gst_camera_capturer_start(IntPtr raw);

		public void Start	() {
			gst_camera_capturer_start(Handle);
		}


		[DllImport("libcesarplayer.dll")]
		static extern void gst_camera_capturer_run(IntPtr raw);

		public void Run() {
			gst_camera_capturer_run(Handle);
		}

		[DllImport("libcesarplayer.dll")]
		static extern bool gst_camera_capturer_set_audio_encoder(IntPtr raw, int type);

		public bool SetAudioEncoder(LongoMatch.Video.Capturer.GccAudioEncoderType type) {
			bool raw_ret = gst_camera_capturer_set_audio_encoder(Handle, (int) type);
			bool ret = raw_ret;
			return ret;
		}

		[DllImport("libcesarplayer.dll")]
		static extern IntPtr gst_camera_capturer_get_type();

		public static new GLib.GType GType { 
			get {
				IntPtr raw_ret = gst_camera_capturer_get_type();
				GLib.GType ret = new GLib.GType(raw_ret);
				return ret;
			}
		}


		static GstCameraCapturer ()
		{
			LongoMatch.GtkSharp.Capturer.ObjectManager.Initialize ();
		}
#endregion
	}
}
