//  Copyright (C) 2007-2009 Andoni Morales Alastruey
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
//
//

namespace LongoMatch.Video.Capturer {

	using System;
	using System.Collections;
	using System.Collections.Generic;
	using System.Runtime.InteropServices;
	using Mono.Unix;
	
	using LongoMatch.Common;
	using LongoMatch.Multimedia.Interfaces;
	using LongoMatch.Video.Common;
	

	#region Autogenerated code
	public  class GstCameraCapturer : Gtk.HBox, ICapturer {

		public event EllpasedTimeHandler EllapsedTime;

		private LiveSourceTimer timer;

		[Obsolete]
		protected GstCameraCapturer(GLib.GType gtype) : base(gtype) {}
		public GstCameraCapturer(IntPtr raw) : base(raw) {}

		[DllImport("libcesarplayer.dll")]
		static extern unsafe IntPtr gst_camera_capturer_new(IntPtr filename, out IntPtr err);

		public unsafe GstCameraCapturer(string filename) : base(IntPtr.Zero)
		{
			if(GetType() != typeof(GstCameraCapturer)) {
				throw new InvalidOperationException("Can't override this constructor.");
			}
			IntPtr error = IntPtr.Zero;
			Raw = gst_camera_capturer_new(GLib.Marshaller.StringToPtrGStrdup(filename), out error);
			if(error != IntPtr.Zero) throw new GLib.GException(error);

			timer = new LiveSourceTimer();
			timer.EllapsedTime += delegate(int ellapsedTime) {
				if(EllapsedTime!= null)
					EllapsedTime(ellapsedTime);
			};
		}

		[GLib.Property("output_height")]
		public uint OutputHeight {
			get {
				GLib.Value val = GetProperty("output_height");
				uint ret = (uint) val;
				val.Dispose();
				return ret;
			}
			set {
				GLib.Value val = new GLib.Value(value);
				SetProperty("output_height", val);
				val.Dispose();
			}
		}

		[GLib.Property("output_width")]
		public uint OutputWidth {
			get {
				GLib.Value val = GetProperty("output_width");
				uint ret = (uint) val;
				val.Dispose();
				return ret;
			}
			set {
				GLib.Value val = new GLib.Value(value);
				SetProperty("output_width", val);
				val.Dispose();
			}
		}

		[GLib.Property("video_quality")]
		public uint VideoQuality {
			get {
				GLib.Value val = GetProperty("video_quality");
				uint ret = (uint) val;
				val.Dispose();
				return ret;
			}
			set {
				GLib.Value val = new GLib.Value(value);
				SetProperty("video_quality", val);
				val.Dispose();
			}
		}

		[GLib.Property("output_file")]
		public string OutputFile {
			get {
				GLib.Value val = GetProperty("output_file");
				string ret = (string) val;
				val.Dispose();
				return ret;
			}
			set {
				GLib.Value val = new GLib.Value(value);
				SetProperty("output_file", val);
				val.Dispose();
			}
		}

		[GLib.Property("audio_quality")]
		public uint AudioQuality {
			get {
				GLib.Value val = GetProperty("audio_quality");
				uint ret = (uint) val;
				val.Dispose();
				return ret;
			}
			set {
				GLib.Value val = new GLib.Value(value);
				SetProperty("audio_quality", val);
				val.Dispose();
			}
		}

		[GLib.Property("device_id")]
		public string DeviceID {
			get {
				GLib.Value val = GetProperty("device_id");
				string ret = (string) val;
				val.Dispose();
				return ret;
			}
			set {
				GLib.Value val = new GLib.Value(value);
				SetProperty("device_id", val);
				val.Dispose();
			}
		}

#pragma warning disable 0169
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		delegate void ErrorSignalDelegate(IntPtr arg0, IntPtr arg1, IntPtr gch);

		static void ErrorSignalCallback(IntPtr arg0, IntPtr arg1, IntPtr gch)
		{
			ErrorArgs args = new ErrorArgs();
			try {
				GLib.Signal sig = ((GCHandle) gch).Target as GLib.Signal;
				if(sig == null)
					throw new Exception("Unknown signal GC handle received " + gch);

				args.Args = new object[1];
				args.Args[0] = GLib.Marshaller.Utf8PtrToString(arg1);
				ErrorHandler handler = (ErrorHandler) sig.Handler;
				handler(GLib.Object.GetObject(arg0), args);
			} catch(Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException(e, false);
			}
		}

		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		delegate void ErrorVMDelegate(IntPtr gcc, IntPtr message);

		static ErrorVMDelegate ErrorVMCallback;

		static void error_cb(IntPtr gcc, IntPtr message)
		{
			try {
				GstCameraCapturer gcc_managed = GLib.Object.GetObject(gcc, false) as GstCameraCapturer;
				gcc_managed.OnError(GLib.Marshaller.Utf8PtrToString(message));
			} catch(Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException(e, false);
			}
		}

		private static void OverrideError(GLib.GType gtype)
		{
			if(ErrorVMCallback == null)
				ErrorVMCallback = new ErrorVMDelegate(error_cb);
			OverrideVirtualMethod(gtype, "error", ErrorVMCallback);
		}

		[GLib.DefaultSignalHandler(Type=typeof(LongoMatch.Video.Capturer.GstCameraCapturer), ConnectionMethod="OverrideError")]
		protected virtual void OnError(string message)
		{
			GLib.Value ret = GLib.Value.Empty;
			GLib.ValueArray inst_and_params = new GLib.ValueArray(2);
			GLib.Value[] vals = new GLib.Value [2];
			vals [0] = new GLib.Value(this);
			inst_and_params.Append(vals [0]);
			vals [1] = new GLib.Value(message);
			inst_and_params.Append(vals [1]);
			g_signal_chain_from_overridden(inst_and_params.ArrayPtr, ref ret);
			foreach(GLib.Value v in vals)
				v.Dispose();
		}

		[GLib.Signal("error")]
		public event ErrorHandler Error {
			add {
				GLib.Signal sig = GLib.Signal.Lookup(this, "error", new ErrorSignalDelegate(ErrorSignalCallback));
				sig.AddDelegate(value);
			}
			remove {
				GLib.Signal sig = GLib.Signal.Lookup(this, "error", new ErrorSignalDelegate(ErrorSignalCallback));
				sig.RemoveDelegate(value);
			}
		}

		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		delegate void DeviceChangeSignalDelegate(IntPtr arg0, int arg1, IntPtr gch);

		static void DeviceChangeSignalCallback(IntPtr arg0, int arg1, IntPtr gch)
		{
			DeviceChangeArgs args = new DeviceChangeArgs();
			try {
				GLib.Signal sig = ((GCHandle) gch).Target as GLib.Signal;
				if(sig == null)
					throw new Exception("Unknown signal GC handle received " + gch);

				args.Args = new object[1];
				args.Args[0] = arg1;
				DeviceChangeHandler handler = (DeviceChangeHandler) sig.Handler;
				handler(GLib.Object.GetObject(arg0), args);
			} catch(Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException(e, false);
			}
		}

		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		delegate void DeviceChangeVMDelegate(IntPtr gcc, int deviceChange);

		static DeviceChangeVMDelegate DeviceChangeVMCallback;

		static void device_change_cb(IntPtr gcc, int deviceChange)
		{
			try {
				GstCameraCapturer gcc_managed = GLib.Object.GetObject(gcc, false) as GstCameraCapturer;
				gcc_managed.OnDeviceChange(deviceChange);
			} catch(Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException(e, false);
			}
		}

		private static void OverrideDeviceChange(GLib.GType gtype)
		{
			if(DeviceChangeVMCallback == null)
				DeviceChangeVMCallback = new DeviceChangeVMDelegate(device_change_cb);
			OverrideVirtualMethod(gtype, "device_change", DeviceChangeVMCallback);
		}

		[GLib.DefaultSignalHandler(Type=typeof(LongoMatch.Video.Capturer.GstCameraCapturer), ConnectionMethod="OverrideDeviceChange")]
		protected virtual void OnDeviceChange(int deviceChange)
		{
			GLib.Value ret = GLib.Value.Empty;
			GLib.ValueArray inst_and_params = new GLib.ValueArray(2);
			GLib.Value[] vals = new GLib.Value [2];
			vals [0] = new GLib.Value(this);
			inst_and_params.Append(vals [0]);
			vals [1] = new GLib.Value(deviceChange);
			inst_and_params.Append(vals [1]);
			g_signal_chain_from_overridden(inst_and_params.ArrayPtr, ref ret);
			foreach(GLib.Value v in vals)
				v.Dispose();
		}

		[GLib.Signal("device_change")]
		public event DeviceChangeHandler DeviceChange {
			add {
				GLib.Signal sig = GLib.Signal.Lookup(this, "device_change", new DeviceChangeSignalDelegate(DeviceChangeSignalCallback));
				sig.AddDelegate(value);
			}
			remove {
				GLib.Signal sig = GLib.Signal.Lookup(this, "device_change", new DeviceChangeSignalDelegate(DeviceChangeSignalCallback));
				sig.RemoveDelegate(value);
			}
		}

		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		delegate void EosVMDelegate(IntPtr gcc);

		static EosVMDelegate EosVMCallback;

		static void eos_cb(IntPtr gcc)
		{
			try {
				GstCameraCapturer gcc_managed = GLib.Object.GetObject(gcc, false) as GstCameraCapturer;
				gcc_managed.OnEos();
			} catch(Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException(e, false);
			}
		}

		private static void OverrideEos(GLib.GType gtype)
		{
			if(EosVMCallback == null)
				EosVMCallback = new EosVMDelegate(eos_cb);
			OverrideVirtualMethod(gtype, "eos", EosVMCallback);
		}

		[GLib.DefaultSignalHandler(Type=typeof(LongoMatch.Video.Capturer.GstCameraCapturer), ConnectionMethod="OverrideEos")]
		protected virtual void OnEos()
		{
			GLib.Value ret = GLib.Value.Empty;
			GLib.ValueArray inst_and_params = new GLib.ValueArray(1);
			GLib.Value[] vals = new GLib.Value [1];
			vals [0] = new GLib.Value(this);
			inst_and_params.Append(vals [0]);
			g_signal_chain_from_overridden(inst_and_params.ArrayPtr, ref ret);
			foreach(GLib.Value v in vals)
				v.Dispose();
		}

		[GLib.Signal("eos")]
		public event System.EventHandler Eos {
			add {
				GLib.Signal sig = GLib.Signal.Lookup(this, "eos");
				sig.AddDelegate(value);
			}
			remove {
				GLib.Signal sig = GLib.Signal.Lookup(this, "eos");
				sig.RemoveDelegate(value);
			}
		}
#pragma warning restore 0169

		[DllImport("libcesarplayer.dll")]
		static extern void gst_camera_capturer_init_backend(out int argc, IntPtr argv);

		public static int InitBackend(string argv) {
			int argc;
			gst_camera_capturer_init_backend(out argc, GLib.Marshaller.StringToPtrGStrdup(argv));
			return argc;
		}

		[DllImport("libcesarplayer.dll")]
		static extern void gst_camera_capturer_stop(IntPtr raw);

		public void Stop() {
			timer.Stop();
			gst_camera_capturer_stop(Handle);
		}


		[DllImport("libcesarplayer.dll")]
		static extern void gst_camera_capturer_toggle_pause(IntPtr raw);

		public void TogglePause() {
			timer.TogglePause();
			gst_camera_capturer_toggle_pause(Handle);
		}

		public int CurrentTime {
			get {
				return timer.CurrentTime;
			}
		}

		[DllImport("libcesarplayer.dll")]
		static extern void gst_camera_capturer_start(IntPtr raw);

		public void Start() {
			timer.Start();
			gst_camera_capturer_start(Handle);
		}


		[DllImport("libcesarplayer.dll")]
		static extern void gst_camera_capturer_run(IntPtr raw);

		public void Run() {
			gst_camera_capturer_run(Handle);
		}

		[DllImport("libcesarplayer.dll")]
		static extern void gst_camera_capturer_close(IntPtr raw);

		public void Close() {
			gst_camera_capturer_close(Handle);
		}

		[DllImport("libcesarplayer.dll")]
		static extern bool gst_camera_capturer_set_video_muxer(IntPtr raw, int type, out IntPtr error);

		public bool SetVideoMuxer(VideoMuxerType type) {
			IntPtr error = IntPtr.Zero;
			bool raw_ret = gst_camera_capturer_set_video_muxer(Handle, (int) type, out error);
			if(error != IntPtr.Zero) throw new GLib.GException(error);
			bool ret = raw_ret;
			return ret;
		}


		[DllImport("libcesarplayer.dll")]
		static extern bool gst_camera_capturer_set_video_encoder(IntPtr raw, int type, out IntPtr error);

		public bool SetVideoEncoder(VideoEncoderType type) {
			IntPtr error = IntPtr.Zero;
			bool raw_ret = gst_camera_capturer_set_video_encoder(Handle, (int) type, out error);
			if(error != IntPtr.Zero) throw new GLib.GException(error);
			bool ret = raw_ret;
			return ret;
		}

		[DllImport("libcesarplayer.dll")]
		static extern bool gst_camera_capturer_set_audio_encoder(IntPtr raw, int type, out IntPtr error);

		public bool SetAudioEncoder(AudioEncoderType type) {
			IntPtr error = IntPtr.Zero;
			bool raw_ret = gst_camera_capturer_set_audio_encoder(Handle, (int) type, out error);
			if(error != IntPtr.Zero) throw new GLib.GException(error);
			bool ret = raw_ret;
			return ret;
		}

		[DllImport("libcesarplayer.dll")]
		static extern bool gst_camera_capturer_set_source(IntPtr raw, int type, out IntPtr error);

		public bool SetSource(CaptureSourceType type) {
			IntPtr error = IntPtr.Zero;
			bool raw_ret = gst_camera_capturer_set_source(Handle, (int) type, out error);
			if(error != IntPtr.Zero) throw new GLib.GException(error);
			bool ret = raw_ret;
			return ret;
		}

		[DllImport("libcesarplayer.dll")]
		static extern IntPtr gst_camera_capturer_get_type();

		public static new GLib.GType GType {
			get {
				IntPtr raw_ret = gst_camera_capturer_get_type();
				GLib.GType ret = new GLib.GType(raw_ret);
				return ret;
			}
		}

		[DllImport("libcesarplayer.dll")]
		static extern IntPtr gst_camera_capturer_enum_audio_devices();

		public static string[] AudioDevices {
			get {
				IntPtr raw_ret = gst_camera_capturer_enum_audio_devices();
				return (string[])GLib.Marshaller.ListPtrToArray(raw_ret, typeof(GLib.List),  true, false, typeof(String));
			}
		}

		[DllImport("libcesarplayer.dll")]
		static extern IntPtr gst_camera_capturer_enum_video_devices();

		public static string[] VideoDevices {
			get {
				IntPtr raw_ret = gst_camera_capturer_enum_video_devices();
				return (string[])GLib.Marshaller.ListPtrToArray(raw_ret, typeof(GLib.List),  true, false, typeof(String));
			}
		}


		[DllImport("libcesarplayer.dll")]
		static extern IntPtr gst_camera_capturer_get_current_frame(IntPtr raw);
		[DllImport("libcesarplayer.dll")]
		static extern IntPtr gst_camera_capturer_unref_pixbuf(IntPtr raw);

		public Gdk.Pixbuf CurrentFrame {
			get {
				IntPtr raw_ret = gst_camera_capturer_get_current_frame(Handle);
				Gdk.Pixbuf p = GLib.Object.GetObject(raw_ret) as Gdk.Pixbuf;
				/* The refcount for p is now 2. We need to decrease the counter to 1
				 * so that p.Dipose() sets it to 0 and triggers the pixbuf destroy function
				 * that frees the associated data*/
				gst_camera_capturer_unref_pixbuf(raw_ret);
				return p;
			}
		}

		static GstCameraCapturer()
		{
			LongoMatch.GtkSharp.Capturer.ObjectManager.Initialize();
		}
		#endregion
		
	}
}
