'''
Defines L{AccAdapt.Adapter}s for AT-SPI tree accessibles. Trees implement both
the Table and the Selection interfaces.

@author: Peter Parente
@organization: IBM Corporation
@copyright: Copyright (c) 2006 IBM Corporation
@license: Common Public License 1.0

All rights reserved. This program and the accompanying materials are made
available under the terms of the Common Public License v1.0 which accompanies
this distribution, and is available at
U{http://www.opensource.org/licenses/cpl1.0.php}
'''

import pyLinAcc
from ContainerAdapter import *
from ListAdapter import *
from DefaultNav import *
from LSRInterfaces import *
from pyLinAcc import Interfaces, Constants

class TreeEventHandlerAdapter(ListEventHandlerAdapter):
  '''
  Overrides L{DefaultEventHandlerAdapter} to generate selector events on focus
  and on selection. Expects the subject to be a L{pyLinAcc.Accessible}.
  
  Adapts subject accessibles that provide the L{pyLinAcc.Interfaces.ISelection},
  L{pyLinAcc.Interfaces.ITable} interface and have ROLE_TREE_TABLE.
  '''  
  provides = [IEventHandler]

  @staticmethod
  def when(subject):
    '''
    Tests if the given subject can be adapted by this class.
    
    @param subject: Accessible to test
    @type subject: L{pyLinAcc.Accessible}
    @return: True when the subject meets the condition named in the docstring
      for this class, False otherwise
    @rtype: boolean
    '''
    r = subject.getRole()
    c = pyLinAcc.Constants
    return (r == c.ROLE_TREE_TABLE and
            Interfaces.ISelection(subject) and Interfaces.ITable(subject))

class TreeNavAdapter(DefaultNavAdapter):
  '''
  Overrides L{DefaultNavAdapter} to provide navigation over tree cells as items.
  Expects the subject to be a L{POR}.
  
  Adapts subject accessibles that provide the L{pyLinAcc.Interfaces.ISelection},
  L{pyLinAcc.Interfaces.ITable} interfaces and have ROLE_TREE_TABLE.
  '''
  provides = [IAccessibleNav, IItemNav]

  @staticmethod
  def when(subject):
    '''
    Tests if the given subject can be adapted by this class.
    
    @param subject: L{POR} containing an accessible to test
    @type subject: L{POR}
    @return: True when the subject meets the condition named in the docstring
    for this class, False otherwise
    @rtype: boolean
    '''
    acc = subject.accessible
    r = acc.getRole()
    c = pyLinAcc.Constants
    return (r == c.ROLE_TREE_TABLE and 
            Interfaces.ISelection(acc) and
            Interfaces.ITable(acc))
  
  @pyLinAcc.errorToLookupError 
  def getFirstAccChild(self):
    '''
    Always raises LookupError. Tables have items but no children.
    
    @raise LookupError: Always
    '''
    raise LookupError

  @pyLinAcc.errorToLookupError 
  def getLastAccChild(self):
    '''
    Always raises LookupError. Tables have items but no children.
    
    @raise LookupError: Always
    '''
    raise LookupError

  @pyLinAcc.errorToLookupError
  def getChildAcc(self, index):
    '''
    Always raises LookupError. Tables have items but no children.
    
    @raise LookupError: Always
    '''
    raise LookupError