'''
Very basic demonstration for building a customized perk.  Skeleton code shows 
basic Perk functionality to help beginning Perk writer learn basics of LSR Perk
event and keybinding framework.

@author: Brett Clippingdale
@organization: IBM Corporation
@copyright: Copyright (c) 2005 IBM Corporation
@license: Common Public License 1.0

All rights reserved. This program and the accompanying materials are made 
available under the terms of the Common Public License v1.0 which accompanies
this distribution, and is available at
U{http://www.opensource.org/licenses/cpl1.0.php}
'''
import Perk, Task
from POR import POR
from i18n import _

class TemplatePerk(Perk.Perk):
  '''
  Creates and registers L{Task}s as a boilerplate customized user interface.
  '''
  def init(self):
    '''   
    Registers keybinding: ALT(R)-SHIFT(R)-S: triggers a simple task.
    '''
    # register event handlers
    # events here are app-level, DefaultPerk will handle gnome-level events,
    # so only register events of interest here. 
    self.registerEventTask(HandleViewChange(self))
    self.registerEventTask(HandleFocusChange(self))
    # to handle caret/selector changes, see DefaultPerk.py for examples
    
    # register named tasks.  Specify the task class name (see below) and a 
    # description.  These descriptions are dictionary keys and therefore
    # must be unique.  Here, Template is a prefix to help ensure uniqueness.
    self.registerNamedTask(SimpleTask(self), 'Template simple task')

    # get the Keyboard device and register modifiers.  Note that these reflect
    # UNIX bindings: the left and right alt/shift keys must be registered
    # independently.  Here, we only register right side modifiers.
    kbd = self.getInputDevice('Keyboard')
    kbd.addModifier(kbd.AEK_ALT_R) # right alt key, per Larry
    kbd.addModifier(kbd.AEK_SHIFT_R) #right shift key, per Larry
    
    # register the keys and their associated commands, binding them using the
    # unique key we registered above.
    # Pass 3 element tuple.  Need to capture keys as pressed though we only
    # handle them if all both modifiers pressed before the non-modifier.
    self.registerCommandTask(kbd, [[kbd.AEK_ALT_R,
                                    kbd.AEK_SHIFT_R,
                                    kbd.AEK_S]], 
                             'Template simple task')
#
# Tasks executed by keys
#
            
class SimpleTask(Task.InputTask):
  '''
  Skeleton task.
  '''
  # each task class must implement an execute method which is called when
  # the associated key bindings (registered in init method, above) are pressed
  def execute(self, **kwargs):
    print "Simple Task executing"
    return True # allow triggering keystrokes to propagate (default)

#
# Tasks executed by events
#

class HandleViewChange(Task.ViewTask):
  '''
  Task that handles a L{AEEvent.ViewChange}.
  '''
  def executeGained(self, por, title, **kwargs):
    print "Template Perk handling a view change"
    
    
class HandleFocusChange(Task.FocusTask):
  '''  
  Task that handles a L{AEEvent.FocusChange}.
  '''   
  def executeGained(self, por, **kwargs):
    print "Template Perk handling a focus change"
    