'''
Defines a L{Task} to execute when a L{AEEvent.InputGesture} occurs.

@author: Peter Parente
@organization: IBM Corporation
@copyright: Copyright (c) 2005 IBM Corporation
@license: Common Public License 1.0

All rights reserved. This program and the accompanying materials are made 
available under the terms of the Common Public License v1.0 which accompanies
this distribution, and is available at
U{http://www.opensource.org/licenses/cpl1.0.php}
'''
import Base, Constants

class InputTask(Base.Task):
  '''
  Executes when an input gesture occurs.

  This class registers its name and whether it should be monitored by default in
  an L{AEMonitor.EventMonitor} using the L{Constants.registerTaskType} function
  when this module is first imported. The L{AEMonitor.EventMonitor} can use this
  information to build its menus.
  '''
  Constants.registerTaskType('InputTask', True)
  
  def execute(self, **kwargs):
    '''
    Executes this L{Task} in response to input on some L{AEInput} device. Called 
    by L{Tier.Tier._executeTask}.
    
    @return: Should processing continue? Always returns True by default.
    @rtype: boolean
    '''
    return True
