'''
Provides support for the internationalization of LSR using the python gettext
module. Configures gettext to use the translation associated with the locale
set by the user's environment at runtime. If no appropriate translation is 
found, the default language is used: the one in which the strings in the
code are written (i.e. English).

The gettext function in the gettext module is alised as _ to match the name of 
the equivalent C function provided by GNU gettext tools.

See the Python documentation on the gettext module at 
U{http://docs.python.org/lib/module-gettext.html}. A brief tutorial on 
i18n and Python is available at 
U{http://www.async.com.br/faq/pygtk/index.py?req=show&file=faq22.002.htp}

@author: Peter Parente
@organization: IBM Corporation
@copyright: Copyright (c) 2005 IBM Corporation
@license: Common Public License 1.0

All rights reserved. This program and the accompanying materials are made 
available under the terms of the Common Public License v1.0 which accompanies
this distribution, and is available at 
U{http://www.opensource.org/licenses/cpl1.0.php}
'''
import locale, gettext, os.path

# the path to where translation files are installed is filled in by autotools
path = os.path.join('/usr/local', 'share', 'locale')
app = 'lsr'

# assign the gettext function in the gettext module to the variable _
_ = gettext.gettext
locale.setlocale(locale.LC_ALL, '')
gettext.bindtextdomain(app, path)
gettext.textdomain(app)
gettext.install(app, path, unicode=1)