'''
Defines the constants used by all devices and monitors.

@var DEVICE_INIT: The command to initialize the device
@type DEVICE_INIT: int
@var DEVICE_STOP: The command to clear buffers and stop output
@type DEVICE_STOP: int
@var DEVICE_TALK: The command to output content previously buffered
@type DEVICE_TALK: int
@var DEVICE_INDEX: The command to send a progress marker to output (usually
  speech). When this command is specified, the value is unbounded.
@type DEVICE_INDEX: int
@var CONTEXT_VOICE: The speech output command to set a voice. There should be
  at least one defined that matches the initial voice.
@type CONTEXT_VOICE: int
@var CONTEXT_RATE: The speech output command to set the rate of the current
  voice
@type CONTEXT_RATE: int
@var CONTEXT_VOLUME: The speech output command to set the volume of the
  current voice
@type CONTEXT_VOLUME: int
@var CONTEXT_PITCH: The speech output command to set the pitch of the current
  voice
@type CONTEXT_PITCH: int
@var CONTEXT_INTONATION: The speech output command to set the intonation
  (monotone/excited) of the current voice
@type CONTEXT_INTONATION: int
@var CONTEXT_GENDER: The speech output command to set the gender of the
  current voice
@type CONTEXT_GENDER: int
@var CONTEXT_HEADSIZE: The speech output command to set the head size of the
  current voice
@type CONTEXT_HEADSIZE: int
@var CONTEXT_VOICED: The speech output command to set the voiced gain (the
  "ee" in "see") of the current voice
@type CONTEXT_VOICED: int
@var CONTEXT_ASPIRATION: The speech output command to set the aspiration gain
  (the "s" in "see") of the current voice
@type CONTEXT_ASPIRATION: int
@var CONTEXT_FRICATION: The speech output command to set the fricative gain
  (the "t" in "tea") of the current voice
@type CONTEXT_FRICATION: int
@var CONTEXT_WORD_PAUSE: The speech output command to set the pause between
  words for the current voice
@type CONTEXT_WORD_PAUSE: int
@var CONTEXT_PHRASE_PAUSE: The speech output command to set the pause between
  phrases for the current voice
@type CONTEXT_PHRASE_PAUSE: int
@var CONTEXT_SENTENCE_PAUSE: The speech output command to set the pause
  between sentences for the current voice
@type CONTEXT_SENTENCE_PAUSE: int
@var BUFFER_OBJECT: A default buffer element
@type BUFFER_OBJECT: int
@var BUFFER_CHAR: A buffer element containing a character
@type BUFFER_CHAR: int
@var BUFFER_COMMAND: A buffer element containing a command
@type BUFFER_COMMAND: int
@var BUFFER_CONTEXT: A buffer element containing a context
@type BUFFER_CONTEXT: 
@var BUFFER_PUSH_CONTEXT: A context buffer element to save the voice context
@type BUFFER_PUSH_CONTEXT: int
@var BUFFER_POP_CONTEXT: A context buffer element to restore the voice context
@type BUFFER_POP_CONTEXT: int

@author: Larry Weiss
@organization: IBM Corporation
@copyright: Copyright (c) 2005 IBM Corporation
@license: Common Public License 1.0

All rights reserved. This program and the accompanying materials are made
available under the terms of the Common Public License v1.0 which accompanies
this distribution, and is available at
U{http://www.opensource.org/licenses/cpl1.0.php}
'''
from i18n import _

# constants used by all devices
DEVICE_INIT = 0
DEVICE_STOP = 1
DEVICE_TALK = 2

# constant for indexing devices
DEVICE_INDEX = 3

# constants for speech devices
CONTEXT_VOICE = 4
CONTEXT_RATE = 5
CONTEXT_VOLUME = 6
CONTEXT_PITCH = 7
CONTEXT_INTONATION = 8
CONTEXT_GENDER = 9
CONTEXT_HEADSIZE = 10
CONTEXT_VOICED = 11
CONTEXT_ASPIRATION = 12
CONTEXT_FRICATION = 13
CONTEXT_WORD_PAUSE = 14
CONTEXT_PHRASE_PAUSE = 15
CONTEXT_SENTENCE_PAUSE = 16

# default strings describing the various device parameters
cmd_name_map = {CONTEXT_VOICE : _('voice'),
                CONTEXT_RATE : _('rate (WPM)'),
                CONTEXT_VOLUME : _('volume'),
                CONTEXT_PITCH : _('pitch'),
                CONTEXT_INTONATION : _('intonation'),
                CONTEXT_GENDER : _('gender'),
                CONTEXT_HEADSIZE : _('head size'),
                CONTEXT_VOICED : _('voiced'),
                CONTEXT_ASPIRATION : _('aspiration'),
                CONTEXT_FRICATION : _('frication'),
                CONTEXT_WORD_PAUSE : _('word pause (s)'),
                CONTEXT_PHRASE_PAUSE : _('phrase pause (s)'),
                CONTEXT_SENTENCE_PAUSE : _('sentence pause (s)')
                }

# constants for Speech buffer management
BUFFER_OBJECT = 32
BUFFER_STRING = 33
BUFFER_COMMAND = 34
BUFFER_CONTEXT = 35
BUFFER_PUSH_CONTEXT = 36
BUFFER_POP_CONTEXT = 37
