'''
Defines an abstract base class acting as an interface for all walkers. Defines
the methods to be provided.

@author: Peter Parente
@organization: IBM Corporation
@copyright: Copyright (c) 2006 IBM Corporation
@license: Common Public License 1.0

All rights reserved. This program and the accompanying materials are made
available under the terms of the Common Public License v1.0 which accompanies
this distribution, and is available at
U{http://www.opensource.org/licenses/cpl1.0.php}
'''

class Walker(object):
  def getCurrPOR(self):
    '''
    @return: Point of regard to the current object
    @rtype: L{POR}
    @raise NotImplementedError: When not overriden in a subclass
    '''
    raise NotImplementedError
  
  def getParentPOR(self):
    '''
    @return: Point of regard to the parent of the current object
    @rtype: L{POR}
    @raise NotImplementedError: When not overriden in a subclass
    '''
    raise NotImplementedError
  
  def getNextPOR(self):
    '''
    @return: Point of regard to the next peer of the current object
    @rtype: L{POR}
    @raise NotImplementedError: When not overriden in a subclass
    '''
    raise NotImplementedError
  
  def getPrevPOR(self):
    '''
    @return: Point of regard to the previous peer of the current object
    @rtype: L{POR}
    @raise NotImplementedError: When not overriden in a subclass
    '''
    raise NotImplementedError
  
  def getFirstPOR(self):
    '''
    @return: Point of regard to the first of all objects
    @rtype: L{POR}
    @raise NotImplementedError: When not overriden in a subclass
    '''
    raise NotImplementedError

  def getLastPOR(self):
    '''
    @return: Point of regard to the last of all objects
    @rtype: L{POR}
    @raise NotImplementedError: When not overriden in a subclass
    '''
    raise NotImplementedError
  