'''
Defines abstract classes representing the interfaces that must be implemented
by an output device for LSR. All output devices derive from the base class in
L{AEOutput}. Devices that provide audio output should derive from the
L{Audio} subclass. Devices that provide Braille output should derive from
the Braille subclass.

Concrete classes implementing the methods of L{AEOutput} and it's subclasses
that ship with LSR are not located in this package. Rather, they are stored in
the Devices folder and referenced by the L{UIRegistrar} when they need to be
loaded.

@var DEVICE_TYPES: All subinterfaces that distinguish devices of different 
  capabilities
@type DEVICE_TYPES: list of class

@author: Larry Weiss
@author: Peter Parente
@author: Brett Clippingdale
@organization: IBM Corporation
@copyright: Copyright (c) 2005, 2006 IBM Corporation
@license: Common Public License 1.0

All rights reserved. This program and the accompanying materials are made
available under the terms of the Common Public License v1.0 which accompanies
this distribution, and is available at
U{http://www.opensource.org/licenses/cpl1.0.php}
'''
from Base import AEOutput
from Audio import Audio
from Style import *
from Error import *

DEVICE_TYPES = [Audio]
